/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ReadOnlyModificationException;
import com.intellij.configurationStore.SaveResult;
import com.intellij.configurationStore.SaveSession;
import com.intellij.openapi.components.impl.stores.SaveSessionAndFile;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u001e\u0010\u0006\u001a\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\b"}, d2={"executeSave", "", "session", "Lcom/intellij/configurationStore/SaveSession;", "result", "Lcom/intellij/configurationStore/SaveResult;", "saveSessions", "", "intellij.platform.configurationStore.impl"})
public final class SaveExecutorKt {
    public static final void saveSessions(@NotNull List<? extends SaveSession> saveSessions, @NotNull SaveResult result) {
        Intrinsics.checkNotNullParameter(saveSessions, (String)"saveSessions");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        for (SaveSession saveSession : saveSessions) {
            SaveExecutorKt.executeSave(saveSession, result);
        }
    }

    public static final void executeSave(@NotNull SaveSession session, @NotNull SaveResult result) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        try {
            session.save();
        }
        catch (ReadOnlyModificationException e) {
            ComponentStoreImplKt.getLOG().warn((Throwable)e);
            SaveSession saveSession = e.getSession();
            if (saveSession == null) {
                saveSession = session;
            }
            result.addReadOnlyFile(new SaveSessionAndFile(saveSession, e.getFile()));
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            result.addError(e);
        }
    }
}

