/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmCompilerResult;
import org.jetbrains.kotlin.backend.wasm.ast.WasmAstToWatKt;
import org.jetbrains.kotlin.backend.wasm.ast.WasmExport;
import org.jetbrains.kotlin.backend.wasm.ast.WasmModule;
import org.jetbrains.kotlin.backend.wasm.ast.WasmModuleField;
import org.jetbrains.kotlin.backend.wasm.codegen.DeclarationTransformer;
import org.jetbrains.kotlin.backend.wasm.codegen.ModuleTransformerKt;
import org.jetbrains.kotlin.backend.wasm.codegen.NameTableKt;
import org.jetbrains.kotlin.backend.wasm.codegen.WasmCodegenContext;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/codegen/IrModuleToWasm;", "", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "generateExport", "Lorg/jetbrains/kotlin/backend/wasm/ast/WasmExport;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "context", "Lorg/jetbrains/kotlin/backend/wasm/codegen/WasmCodegenContext;", "generateExports", "", "module", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "generateModule", "Lorg/jetbrains/kotlin/backend/wasm/WasmCompilerResult;", "generateStringLiteralsSupport", "", "literals", "backend.wasm"})
public final class IrModuleToWasm {
    private final WasmBackendContext backendContext;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final WasmCompilerResult generateModule(@NotNull IrModuleFragment module2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(module2, "module");
        Map<IrDeclarationWithName, String> nameTable = NameTableKt.generateWatTopLevelNames(module2.getFiles());
        WasmCodegenContext context2 = new WasmCodegenContext(nameTable, this.backendContext);
        Iterable $this$flatMap$iv = module2.getFiles();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IrFile it = (IrFile)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getDeclarations();
            kotlin.collections.CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List irDeclarations2 = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv = irDeclarations2;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            WasmModuleField wasmModuleField;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrDeclaration it = (IrDeclaration)element$iv$iv;
            boolean bl2 = false;
            if ((WasmModuleField)it.accept(new DeclarationTransformer(), context2) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            WasmModuleField it$iv$iv = wasmModuleField;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List wasmDeclarations = (List)destination$iv$iv2;
        List<WasmExport> exports = this.generateExports(module2, context2);
        WasmModule wasmModule = new WasmModule(kotlin.collections.CollectionsKt.plus((Collection)kotlin.collections.CollectionsKt.plus((Collection)context2.getImports(), (Iterable)wasmDeclarations), (Iterable)exports));
        String wat = WasmAstToWatKt.wasmModuleToWat(wasmModule);
        return new WasmCompilerResult(wat, this.generateStringLiteralsSupport(context2.getStringLiterals()));
    }

    /*
     * WARNING - void declaration
     */
    private final String generateStringLiteralsSupport(List<String> literals) {
        Collection<JsStringLiteral> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = literals;
        JsExpression jsExpression = new JsNameRef("stringLiterals", "runtime");
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JsStringLiteral jsStringLiteral = new JsStringLiteral((String)it);
            collection.add(jsStringLiteral);
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        JsStatement jsStatement = JsAstUtilsKt.jsAssignment(jsExpression, new JsArrayLiteral(list2)).makeStmt();
        String string3 = new JsBlock(jsStatement).toString();
        Intrinsics.checkNotNullExpressionValue(string3, "JsBlock(\n            jsA\u2026mt()\n        ).toString()");
        return string3;
    }

    private final List<WasmExport> generateExports(IrModuleFragment module2, WasmCodegenContext context2) {
        boolean bl = false;
        List exports = new ArrayList();
        for (IrFile file2 : module2.getFiles()) {
            for (IrDeclaration declaration2 : file2.getDeclarations()) {
                CollectionsKt.addIfNotNull(exports, this.generateExport(declaration2, context2));
            }
        }
        return exports;
    }

    private final WasmExport generateExport(IrDeclaration declaration2, WasmCodegenContext context2) {
        if (!(declaration2 instanceof IrDeclarationWithVisibility) || !(declaration2 instanceof IrDeclarationWithName) || !(declaration2 instanceof IrSimpleFunction) || Intrinsics.areEqual(((IrDeclarationWithVisibility)declaration2).getVisibility(), Visibilities.PUBLIC) ^ true) {
            return null;
        }
        if (!ModuleTransformerKt.isExported((IrFunction)declaration2, context2)) {
            return null;
        }
        String internalName = context2.getGlobalName((IrDeclarationWithName)declaration2);
        String string2 = ((IrDeclarationWithName)declaration2).getName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue(string2, "declaration.name.identifier");
        String exportedName = NameTablesKt.sanitizeName(string2);
        return new WasmExport(internalName, exportedName, WasmExport.Kind.FUNCTION);
    }

    public IrModuleToWasm(@NotNull WasmBackendContext backendContext) {
        Intrinsics.checkNotNullParameter(backendContext, "backendContext");
        this.backendContext = backendContext;
    }
}

