/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers.diagnostics;

import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.checkers.diagnostics.AbstractTestDiagnostic;
import org.jetbrains.kotlin.checkers.diagnostics.TextDiagnostic;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0001H\u0096\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0013\u0010\u001e\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\b\u0010 \u001a\u00020\u001aH\u0016J\b\u0010!\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/checkers/diagnostics/ActualDiagnostic;", "Lorg/jetbrains/kotlin/checkers/diagnostics/AbstractTestDiagnostic;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "platform", "", "withNewInference", "", "(Lorg/jetbrains/kotlin/diagnostics/Diagnostic;Ljava/lang/String;Z)V", "getDiagnostic", "()Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "file", "Lcom/intellij/psi/PsiFile;", "getFile", "()Lcom/intellij/psi/PsiFile;", "inferenceCompatibility", "Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;", "getInferenceCompatibility", "()Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;", "setInferenceCompatibility", "(Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;)V", "name", "getName", "()Ljava/lang/String;", "getPlatform", "compareTo", "", "other", "enhanceInferenceCompatibility", "", "equals", "", "hashCode", "toString", "frontend"})
public final class ActualDiagnostic
implements AbstractTestDiagnostic {
    @NotNull
    private TextDiagnostic.InferenceCompatibility inferenceCompatibility;
    @NotNull
    private final Diagnostic diagnostic;
    @Nullable
    private final String platform;

    @Override
    @NotNull
    public TextDiagnostic.InferenceCompatibility getInferenceCompatibility() {
        return this.inferenceCompatibility;
    }

    public void setInferenceCompatibility(@NotNull TextDiagnostic.InferenceCompatibility inferenceCompatibility) {
        Intrinsics.checkNotNullParameter((Object)inferenceCompatibility, "<set-?>");
        this.inferenceCompatibility = inferenceCompatibility;
    }

    @Override
    @NotNull
    public String getName() {
        DiagnosticFactory<?> diagnosticFactory = this.diagnostic.getFactory();
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory, "diagnostic.factory");
        String string2 = diagnosticFactory.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "diagnostic.factory.name");
        return string2;
    }

    @NotNull
    public final PsiFile getFile() {
        PsiFile psiFile = this.diagnostic.getPsiFile();
        Intrinsics.checkNotNullExpressionValue(psiFile, "diagnostic.psiFile");
        return psiFile;
    }

    @Override
    public int compareTo(@NotNull AbstractTestDiagnostic other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.diagnostic instanceof DiagnosticWithParameters1 && other instanceof ActualDiagnostic && ((ActualDiagnostic)other).diagnostic instanceof DiagnosticWithParameters1 ? (this.getName() + ((DiagnosticWithParameters1)this.diagnostic).getA()).compareTo(other.getName() + ((DiagnosticWithParameters1)((ActualDiagnostic)other).diagnostic).getA()) : (this.diagnostic instanceof DiagnosticWithParameters1 ? (this.getName() + ((DiagnosticWithParameters1)this.diagnostic).getA()).compareTo(other.getName()) : (other instanceof ActualDiagnostic && ((ActualDiagnostic)other).diagnostic instanceof DiagnosticWithParameters1 ? this.getName().compareTo(other.getName() + ((DiagnosticWithParameters1)((ActualDiagnostic)other).diagnostic).getA()) : this.getName().compareTo(other.getName())));
    }

    @Override
    public void enhanceInferenceCompatibility(@NotNull TextDiagnostic.InferenceCompatibility inferenceCompatibility) {
        Intrinsics.checkNotNullParameter((Object)inferenceCompatibility, "inferenceCompatibility");
        this.setInferenceCompatibility(inferenceCompatibility);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        boolean bl;
        if (!(other instanceof ActualDiagnostic)) {
            return false;
        }
        if (((ActualDiagnostic)other).diagnostic != this.diagnostic) return false;
        if (((ActualDiagnostic)other).getPlatform() == null) {
            if (this.getPlatform() != null) return false;
            bl = true;
        } else {
            bl = Intrinsics.areEqual(((ActualDiagnostic)other).getPlatform(), this.getPlatform());
        }
        if (!bl) return false;
        if (((ActualDiagnostic)other).getInferenceCompatibility() != this.getInferenceCompatibility()) return false;
        return true;
    }

    public int hashCode() {
        int result2 = System.identityHashCode(this.diagnostic);
        String string2 = this.getPlatform();
        result2 = 31 * result2 + (string2 != null ? string2.hashCode() : 0);
        result2 = 31 * result2 + this.getInferenceCompatibility().hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        String inferenceAbbreviation = this.getInferenceCompatibility().getAbbreviation$frontend();
        return (inferenceAbbreviation != null ? inferenceAbbreviation + ";" : "") + (this.getPlatform() != null ? this.getPlatform() + ':' : "") + this.diagnostic.toString();
    }

    @NotNull
    public final Diagnostic getDiagnostic() {
        return this.diagnostic;
    }

    @Override
    @Nullable
    public String getPlatform() {
        return this.platform;
    }

    public ActualDiagnostic(@NotNull Diagnostic diagnostic, @Nullable String platform, boolean withNewInference) {
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        this.diagnostic = diagnostic;
        this.platform = platform;
        this.inferenceCompatibility = withNewInference ? TextDiagnostic.InferenceCompatibility.NEW : TextDiagnostic.InferenceCompatibility.OLD;
    }
}

