/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.kotlin.FileBasedKotlinClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryPackageSourceElement;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/InlinePlatformCompatibilityChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/config/JvmTarget;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "doCheck", "", "getJvmTarget", "()Lorg/jetbrains/kotlin/config/JvmTarget;", "properError", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "Companion", "frontend.java"})
public final class InlinePlatformCompatibilityChecker
implements CallChecker {
    private final boolean properError;
    private final boolean doCheck;
    @NotNull
    private final JvmTarget jvmTarget;
    public static final Companion Companion = new Companion(null);

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Integer inliningBytecodeVersion;
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!this.doCheck) {
            return;
        }
        Object obj = resolvedCall2.getResultingDescriptor();
        if (!(obj instanceof CallableMemberDescriptor)) {
            obj = null;
        }
        CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)obj;
        if (callableMemberDescriptor == null) {
            return;
        }
        CallableMemberDescriptor resultingDescriptor = callableMemberDescriptor;
        if (!(InlineUtil.isInline(resultingDescriptor) || resultingDescriptor instanceof PropertyDescriptor && InlineUtil.isInline(((PropertyDescriptor)resultingDescriptor).getGetter()))) {
            return;
        }
        CallableMemberDescriptor callableMemberDescriptor2 = DescriptorUtils.getDirectMember(resultingDescriptor);
        Intrinsics.checkNotNullExpressionValue(callableMemberDescriptor2, "DescriptorUtils.getDirec\u2026mber(resultingDescriptor)");
        CallableMemberDescriptor propertyOrFun = callableMemberDescriptor2;
        int compilingBytecodeVersion = this.jvmTarget.getBytecodeVersion();
        if (!this.properError && (inliningBytecodeVersion = Companion.getBytecodeVersionIfDeserializedDescriptor(propertyOrFun, false)) != null && compilingBytecodeVersion < inliningBytecodeVersion) {
            context2.getTrace().report(ErrorsJvm.INLINE_FROM_HIGHER_PLATFORM.on(reportOn, JvmTarget.Companion.getDescription(inliningBytecodeVersion), JvmTarget.Companion.getDescription(compilingBytecodeVersion)));
            return;
        }
        Integer n = Companion.getBytecodeVersionIfDeserializedDescriptor(propertyOrFun, true);
        if (n == null) {
            return;
        }
        int inliningBytecodeVersionProper = n;
        if (compilingBytecodeVersion < inliningBytecodeVersionProper) {
            if (this.properError) {
                context2.getTrace().report(ErrorsJvm.INLINE_FROM_HIGHER_PLATFORM.on(reportOn, JvmTarget.Companion.getDescription(inliningBytecodeVersionProper), JvmTarget.Companion.getDescription(compilingBytecodeVersion)));
            } else {
                context2.getTrace().report(ErrorsJvm.INLINE_FROM_HIGHER_PLATFORM_WARNING.on(reportOn, JvmTarget.Companion.getDescription(inliningBytecodeVersionProper), JvmTarget.Companion.getDescription(compilingBytecodeVersion)));
            }
        }
    }

    @NotNull
    public final JvmTarget getJvmTarget() {
        return this.jvmTarget;
    }

    public InlinePlatformCompatibilityChecker(@NotNull JvmTarget jvmTarget, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(jvmTarget, "jvmTarget");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        this.jvmTarget = jvmTarget;
        this.properError = languageVersionSettings.supportsFeature(LanguageFeature.ProperInlineFromHigherPlatformDiagnostic);
        this.doCheck = Companion.doCheck();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u001d\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\nJ\f\u0010\u000b\u001a\u00020\f*\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/InlinePlatformCompatibilityChecker$Companion;", "", "()V", "doCheck", "", "getBytecodeVersionIfDeserializedDescriptor", "", "funOrProperty", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "useConcreteSuperImplementation", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Z)Ljava/lang/Integer;", "getConcreteDeclarationForInline", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "frontend.java"})
    public static final class Companion {
        public final boolean doCheck() {
            return Intrinsics.areEqual("true", System.getProperty("kotlin.skip.bytecode.version.check")) ^ true;
        }

        @Nullable
        public final Integer getBytecodeVersionIfDeserializedDescriptor(@NotNull DeclarationDescriptor funOrProperty, boolean useConcreteSuperImplementation) {
            KotlinJvmBinaryClass kotlinJvmBinaryClass2;
            SourceElement source;
            Intrinsics.checkNotNullParameter(funOrProperty, "funOrProperty");
            if (!(funOrProperty instanceof DeserializedCallableMemberDescriptor)) {
                return null;
            }
            CallableMemberDescriptor realDeclarationIfFound = useConcreteSuperImplementation ? this.getConcreteDeclarationForInline((CallableMemberDescriptor)funOrProperty) : (CallableMemberDescriptor)funOrProperty;
            DeclarationDescriptor declarationDescriptor = realDeclarationIfFound.getContainingDeclaration();
            if (declarationDescriptor == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor");
            }
            ClassOrPackageFragmentDescriptor containingDeclaration = (ClassOrPackageFragmentDescriptor)declarationDescriptor;
            SourceElement sourceElement = containingDeclaration.getSource();
            Intrinsics.checkNotNullExpressionValue(sourceElement, "containingDeclaration.source");
            SourceElement sourceElement2 = source = sourceElement;
            if (!((sourceElement2 instanceof KotlinJvmBinarySourceElement ? ((KotlinJvmBinarySourceElement)source).getBinaryClass() : (kotlinJvmBinaryClass2 = sourceElement2 instanceof KotlinJvmBinaryPackageSourceElement ? ((KotlinJvmBinaryPackageSourceElement)source).getContainingBinaryClass((DeserializedMemberDescriptor)funOrProperty) : null)) instanceof FileBasedKotlinClass)) {
                kotlinJvmBinaryClass2 = null;
            }
            FileBasedKotlinClass fileBasedKotlinClass = (FileBasedKotlinClass)kotlinJvmBinaryClass2;
            if (fileBasedKotlinClass == null) {
                return null;
            }
            FileBasedKotlinClass binaryClass = fileBasedKotlinClass;
            return binaryClass.getClassVersion();
        }

        private final CallableMemberDescriptor getConcreteDeclarationForInline(CallableMemberDescriptor $this$getConcreteDeclarationForInline) {
            CallableMemberDescriptor.Kind kind = $this$getConcreteDeclarationForInline.getKind();
            Intrinsics.checkNotNullExpressionValue((Object)kind, "this.kind");
            if (!kind.isReal()) {
                CallableMemberDescriptor superImplementation;
                Object v4;
                block3: {
                    Collection<? extends CallableMemberDescriptor> collection = $this$getConcreteDeclarationForInline.getOverriddenDescriptors();
                    Intrinsics.checkNotNullExpressionValue(collection, "overriddenDescriptors");
                    Iterable $this$firstOrNull$iv = collection;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        DeclarationDescriptor containingDeclaration;
                        CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                        boolean bl = false;
                        CallableMemberDescriptor callableMemberDescriptor = it;
                        Intrinsics.checkNotNullExpressionValue(callableMemberDescriptor, "it");
                        Intrinsics.checkNotNullExpressionValue(callableMemberDescriptor.getContainingDeclaration(), "it.containingDeclaration");
                        boolean bl2 = !DescriptorUtils.isInterface(containingDeclaration) && !DescriptorUtils.isAnnotationClass(containingDeclaration);
                        if (!bl2) continue;
                        v4 = element$iv;
                        break block3;
                    }
                    v4 = null;
                }
                CallableMemberDescriptor callableMemberDescriptor = superImplementation = (CallableMemberDescriptor)v4;
                if (callableMemberDescriptor != null) {
                    CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor;
                    boolean bl = false;
                    boolean bl3 = false;
                    CallableMemberDescriptor it = callableMemberDescriptor2;
                    boolean bl4 = false;
                    return Companion.getConcreteDeclarationForInline(it);
                }
            }
            return $this$getConcreteDeclarationForInline;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

