/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.remote;

import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.GrazieDynamic;
import com.intellij.grazie.GraziePlugin;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.remote.LangDownloader;
import com.intellij.openapi.project.Project;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/grazie/remote/GrazieRemote;", "", "()V", "allAvailableLocally", "", "Lcom/intellij/grazie/jlanguage/Lang;", "download", "", "lang", "project", "Lcom/intellij/openapi/project/Project;", "downloadMissing", "", "isAvailableLocally", "isLibExists", "lib", "", "intellij.grazie"})
public final class GrazieRemote {
    public static final GrazieRemote INSTANCE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLibExists(String lib) {
        Path path = GrazieDynamic.INSTANCE.getDynamicFolder().resolve(lib);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"GrazieDynamic.dynamicFolder.resolve(lib)");
        if (PathKt.exists((Path)path)) return true;
        Path path2 = GraziePlugin.INSTANCE.getLibFolder().resolve(lib);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"GraziePlugin.libFolder.resolve(lib)");
        if (!PathKt.exists((Path)path2)) return false;
        return true;
    }

    public final boolean isAvailableLocally(@NotNull Lang lang) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        return lang.isEnglish() || this.isLibExists(lang.getRemote().getFileName());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Lang> allAvailableLocally() {
        void $this$filterTo$iv$iv;
        Lang[] $this$filter$iv = Lang.values();
        boolean $i$f$filter = false;
        Lang[] langArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var6_6 = $this$filterTo$iv$iv;
        int n = ((void)var6_6).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var6_6[i];
            boolean bl = false;
            if (!INSTANCE.isAvailableLocally((Lang)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean download(@NotNull Lang lang, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        if (this.isAvailableLocally(lang)) {
            return true;
        }
        return LangDownloader.INSTANCE.download(lang, project);
    }

    public static /* synthetic */ boolean download$default(GrazieRemote grazieRemote, Lang lang, Project project, int n, Object object) {
        if ((n & 2) != 0) {
            project = null;
        }
        return grazieRemote.download(lang, project);
    }

    public final void downloadMissing(@Nullable Project project) {
        Iterable $this$forEach$iv = GrazieConfig.Companion.get().getMissedLanguages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Lang it = (Lang)((Object)element$iv);
            boolean bl = false;
            LangDownloader.INSTANCE.download(it, project);
        }
    }

    private GrazieRemote() {
    }

    static {
        GrazieRemote grazieRemote;
        INSTANCE = grazieRemote = new GrazieRemote();
    }
}

