/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.Normalizer;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.StringTokenizer;
import javax.net.ssl.SNIHostName;
import javax.security.auth.x500.X500Principal;
import sun.net.util.IPAddressUtil;
import sun.security.ssl.Krb5Helper;
import sun.security.ssl.SSLLogger;
import sun.security.util.DerValue;
import sun.security.util.RegisteredDomain;
import sun.security.x509.X500Name;

public class HostnameChecker {
    public static final byte TYPE_TLS = 1;
    private static final HostnameChecker INSTANCE_TLS = new HostnameChecker(1);
    public static final byte TYPE_LDAP = 2;
    private static final HostnameChecker INSTANCE_LDAP = new HostnameChecker(2);
    private static final int ALTNAME_DNS = 2;
    private static final int ALTNAME_IP = 7;
    private final byte checkType;

    private HostnameChecker(byte by) {
        this.checkType = by;
    }

    public static HostnameChecker getInstance(byte by) {
        if (by == 1) {
            return INSTANCE_TLS;
        }
        if (by == 2) {
            return INSTANCE_LDAP;
        }
        throw new IllegalArgumentException("Unknown check type: " + by);
    }

    public void match(String string, X509Certificate x509Certificate, boolean bl) throws CertificateException {
        if (HostnameChecker.isIpAddress(string)) {
            HostnameChecker.matchIP(string, x509Certificate);
        } else {
            this.matchDNS(string, x509Certificate, bl);
        }
    }

    public void match(String string, X509Certificate x509Certificate) throws CertificateException {
        this.match(string, x509Certificate, false);
    }

    public static boolean match(String string, Principal principal) {
        String string2 = HostnameChecker.getServerName(principal);
        return string.equalsIgnoreCase(string2);
    }

    public static String getServerName(Principal principal) {
        return Krb5Helper.getPrincipalHostName((Principal)principal);
    }

    private static boolean isIpAddress(String string) {
        return IPAddressUtil.isIPv4LiteralAddress(string) || IPAddressUtil.isIPv6LiteralAddress(string);
    }

    private static void matchIP(String string, X509Certificate x509Certificate) throws CertificateException {
        Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
        if (collection == null) {
            throw new CertificateException("No subject alternative names present");
        }
        for (List<?> list : collection) {
            if ((Integer)list.get(0) != 7) continue;
            String string2 = (String)list.get(1);
            if (string.equalsIgnoreCase(string2)) {
                return;
            }
            try {
                if (!InetAddress.getByName(string).equals(InetAddress.getByName(string2))) continue;
                return;
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (SecurityException securityException) {
            }
        }
        throw new CertificateException("No subject alternative names matching IP address " + string + " found");
    }

    private void matchDNS(String string, X509Certificate x509Certificate, boolean bl) throws CertificateException {
        X500Name x500Name;
        Object object;
        Object object2;
        Object object3;
        try {
            object3 = new SNIHostName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertificateException("Illegal given domain name: " + string, illegalArgumentException);
        }
        object3 = x509Certificate.getSubjectAlternativeNames();
        if (object3 != null) {
            boolean bl2 = false;
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (List)object2.next();
                if ((Integer)object.get(0) != 2) continue;
                bl2 = true;
                String string2 = (String)object.get(1);
                if (!this.isMatched(string, string2, bl)) continue;
                return;
            }
            if (bl2) {
                throw new CertificateException("No subject alternative DNS name matching " + string + " found.");
            }
        }
        if ((object2 = (x500Name = HostnameChecker.getSubjectX500Name(x509Certificate)).findMostSpecificAttribute(X500Name.commonName_oid)) != null) {
            try {
                object = ((DerValue)object2).getAsString();
                if (!Normalizer.isNormalized((CharSequence)object, Normalizer.Form.NFKC)) {
                    throw new CertificateException("Not a formal name " + (String)object);
                }
                if (this.isMatched(string, (String)object, bl)) {
                    return;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = "No name matching " + string + " found";
        throw new CertificateException((String)object);
    }

    public static X500Name getSubjectX500Name(X509Certificate x509Certificate) throws CertificateParsingException {
        try {
            Principal principal = x509Certificate.getSubjectDN();
            if (principal instanceof X500Name) {
                return (X500Name)principal;
            }
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            return new X500Name(x500Principal.getEncoded());
        }
        catch (IOException iOException) {
            throw (CertificateParsingException)new CertificateParsingException().initCause(iOException);
        }
    }

    private boolean isMatched(String string, String string2, boolean bl) {
        if (HostnameChecker.hasIllegalWildcard(string, string2, bl)) {
            return false;
        }
        try {
            SNIHostName sNIHostName = new SNIHostName(string2.replace('*', 'z'));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        if (this.checkType == 1) {
            return HostnameChecker.matchAllWildcards(string, string2);
        }
        if (this.checkType == 2) {
            return HostnameChecker.matchLeftmostWildcard(string, string2);
        }
        return false;
    }

    private static boolean hasIllegalWildcard(String string, String string2, boolean bl) {
        if (string2.equals("*") || string2.equals("*.")) {
            if (SSLLogger.isOn) {
                SSLLogger.fine("Certificate domain name has illegal single wildcard character: " + string2, new Object[0]);
            }
            return true;
        }
        int n = string2.lastIndexOf("*");
        if (n == -1) {
            return false;
        }
        String string3 = string2.substring(n);
        int n2 = string3.indexOf(".");
        if (n2 == -1) {
            if (SSLLogger.isOn) {
                SSLLogger.fine("Certificate domain name has illegal wildcard, no dot after wildcard character: " + string2, new Object[0]);
            }
            return true;
        }
        if (!bl) {
            return false;
        }
        Optional<RegisteredDomain> optional = RegisteredDomain.from(string).filter(registeredDomain -> registeredDomain.type() == RegisteredDomain.Type.ICANN);
        if (optional.isPresent()) {
            String string4 = string3.substring(n2 + 1);
            if (optional.get().publicSuffix().equalsIgnoreCase(string4)) {
                if (SSLLogger.isOn) {
                    SSLLogger.fine("Certificate domain name has illegal wildcard for public suffix: " + string2, new Object[0]);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean matchAllWildcards(String string, String string2) {
        string = string.toLowerCase(Locale.ENGLISH);
        string2 = string2.toLowerCase(Locale.ENGLISH);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        if (stringTokenizer.countTokens() != stringTokenizer2.countTokens()) {
            return false;
        }
        while (stringTokenizer.hasMoreTokens()) {
            if (HostnameChecker.matchWildCards(stringTokenizer.nextToken(), stringTokenizer2.nextToken())) continue;
            return false;
        }
        return true;
    }

    private static boolean matchLeftmostWildcard(String string, String string2) {
        string = string.toLowerCase(Locale.ENGLISH);
        string2 = string2.toLowerCase(Locale.ENGLISH);
        int n = string2.indexOf(".");
        int n2 = string.indexOf(".");
        if (n == -1) {
            n = string2.length();
        }
        if (n2 == -1) {
            n2 = string.length();
        }
        if (HostnameChecker.matchWildCards(string.substring(0, n2), string2.substring(0, n))) {
            return string2.substring(n).equals(string.substring(n2));
        }
        return false;
    }

    private static boolean matchWildCards(String string, String string2) {
        int n = string2.indexOf("*");
        if (n == -1) {
            return string.equals(string2);
        }
        boolean bl = true;
        String string3 = "";
        String string4 = string2;
        while (n != -1) {
            string3 = string4.substring(0, n);
            string4 = string4.substring(n + 1);
            int n2 = string.indexOf(string3);
            if (n2 == -1 || bl && n2 != 0) {
                return false;
            }
            bl = false;
            string = string.substring(n2 + string3.length());
            n = string4.indexOf("*");
        }
        return string.endsWith(string4);
    }
}

