"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var specs_1 = require("../../../../specs");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_chart_rotation_1 = require("../../../../state/selectors/get_chart_rotation");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var getMouseDownPosition = function (state) { return state.interactions.pointer.down; };
var getIsDragging = function (state) { return state.interactions.pointer.dragging; };
var getCurrentPointerPosition = function (state) { return state.interactions.pointer.current.position; };
exports.getBrushAreaSelector = re_reselect_1.default([
    getIsDragging,
    getMouseDownPosition,
    getCurrentPointerPosition,
    get_chart_rotation_1.getChartRotationSelector,
    get_settings_specs_1.getSettingsSpecSelector,
    compute_chart_dimensions_1.computeChartDimensionsSelector,
], function (isDragging, mouseDownPosition, end, chartRotation, _a, chartDimensions) {
    var brushAxis = _a.brushAxis;
    if (!isDragging || !mouseDownPosition) {
        return null;
    }
    var start = {
        x: mouseDownPosition.position.x - chartDimensions.left,
        y: mouseDownPosition.position.y,
    };
    switch (brushAxis) {
        case specs_1.BrushAxis.Both:
        default:
            return { top: start.y, left: start.x, width: end.x - start.x - chartDimensions.left, height: end.y - start.y };
    }
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=get_brush_area.js.map