"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var errors_1 = require("./errors");
var ErrorBoundary = (function (_super) {
    __extends(ErrorBoundary, _super);
    function ErrorBoundary() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.hasError = false;
        return _this;
    }
    ErrorBoundary.prototype.componentDidUpdate = function () {
        if (this.hasError) {
            this.hasError = false;
        }
    };
    ErrorBoundary.prototype.componentDidCatch = function (error) {
        if (errors_1.isGracefulError(error)) {
            this.hasError = true;
            this.forceUpdate();
        }
    };
    ErrorBoundary.prototype.render = function () {
        if (this.hasError) {
            return (react_1.default.createElement("div", { className: "echReactiveChart_unavailable" },
                react_1.default.createElement("p", null, "No data to display")));
        }
        return this.props.children;
    };
    return ErrorBoundary;
}(react_1.Component));
exports.ErrorBoundary = ErrorBoundary;
//# sourceMappingURL=error_boundary.js.map