/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsfapi.spi;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.web.jsfapi.api.JsfSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public abstract class JsfSupportProvider {
    private static final Logger LOGGER = Logger.getLogger(JsfSupportProvider.class.getName());
    static final Map<Project, Reference<JsfSupport>> CACHE = new WeakHashMap<Project, Reference<JsfSupport>>();

    public static JsfSupport get(Source source) {
        FileObject fo = source.getFileObject();
        if (fo == null) {
            return null;
        }
        return JsfSupportProvider.get(fo);
    }

    public static JsfSupport get(FileObject file) {
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        if (project == null) {
            return null;
        }
        return JsfSupportProvider.get(project);
    }

    public static synchronized JsfSupport get(Project project) {
        JsfSupport support;
        Reference<JsfSupport> support_ref = CACHE.get(project);
        if (support_ref != null && (support = support_ref.get()) != null) {
            return support;
        }
        JsfSupportProvider provider = (JsfSupportProvider)Lookup.getDefault().lookup(JsfSupportProvider.class);
        if (provider == null) {
            LOGGER.warning("There's no instance of JsfSupportProvider registered in the global lookup!");
            return null;
        }
        JsfSupport support2 = provider.getSupport(project);
        if (support2 == null) {
            LOGGER.fine(String.format("The implementation %s of JsfSupportProvider returned no JsfSupport instance for project %s", provider.getClass().getName(), JsfSupportProvider.getProjectDisplayName(project)));
            return null;
        }
        CACHE.put(project, new WeakReference<JsfSupport>(support2));
        return support2;
    }

    private static String getProjectDisplayName(Project project) {
        return FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory());
    }

    public abstract JsfSupport getSupport(Project var1);
}

