/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.nodes;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.ActionProviderImpl;
import org.netbeans.modules.gradle.FavoriteTaskManager;
import org.netbeans.modules.gradle.api.GradleTask;
import org.netbeans.modules.gradle.customizer.CustomActionMapping;
import org.netbeans.modules.gradle.nodes.Bundle;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.lookup.Lookups;

public final class TaskNode
extends AbstractNode {
    private static final String TASK_ICON = "org/netbeans/modules/gradle/resources/gradle-task.gif";
    final Project project;
    final GradleTask task;

    public TaskNode(Project project, GradleTask task) {
        super(Children.LEAF, Lookups.fixed((Object[])new Object[]{project, task}));
        this.project = project;
        this.task = task;
        this.setIconBaseWithExtension(TASK_ICON);
        this.setName(task.getPath());
        this.setDisplayName(task.getName());
        this.setShortDescription(task.getDescription());
    }

    public Action[] getActions(boolean context) {
        CustomActionMapping mapping = new CustomActionMapping("custom-");
        mapping.setArgs(this.task.getName());
        ArrayList<Action> actions = new ArrayList<Action>(3);
        actions.add(ActionProviderImpl.createCustomGradleAction(this.project, Bundle.LBL_ExecTask(), mapping, Lookups.singleton((Object)this.project), false));
        actions.add(ActionProviderImpl.createCustomGradleAction(this.project, Bundle.LBL_ExecCust(), mapping, Lookups.singleton((Object)this.project), true));
        FavoriteTaskManager fvmgr = (FavoriteTaskManager)this.project.getLookup().lookup(FavoriteTaskManager.class);
        if (fvmgr != null) {
            actions.add(new FavoriteAction(this.task));
        }
        return actions.toArray(new Action[actions.size()]);
    }

    public GradleTask getTask() {
        return this.task;
    }

    public Action getPreferredAction() {
        return this.getActions(false)[0];
    }

    private class FavoriteAction
    extends AbstractAction {
        private final GradleTask task;

        public FavoriteAction(GradleTask task) {
            this.task = task;
            this.putValue("Name", this.getName());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FavoriteTaskManager fvmgr;
            boolean favorite = (fvmgr = (FavoriteTaskManager)TaskNode.this.project.getLookup().lookup(FavoriteTaskManager.class)).isFavorite(this.task);
            fvmgr.setFavorite(this.task, !favorite);
            this.putValue("Name", this.getName());
        }

        private String getName() {
            FavoriteTaskManager fvmgr = (FavoriteTaskManager)TaskNode.this.project.getLookup().lookup(FavoriteTaskManager.class);
            return fvmgr.isFavorite(this.task) ? Bundle.LBL_RemoveFromFavorites() : Bundle.LBL_AddToFavorites();
        }
    }
}

