/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.websvc.rest.codegen.AbstractGenerator;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.codegen.model.GenericResourceBean;
import org.netbeans.modules.websvc.rest.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.rest.support.AbstractTask;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GenericResourceGenerator
extends AbstractGenerator {
    public static final String RESOURCE_TEMPLATE = "Templates/WebServices/GenericResource.java";
    public static final String RESOURCE_ITEM_TEMPLATE = "Templates/WebServices/GenericItemResource.java";
    public static final String COMMENT_END_OF_GET = "TODO return proper representation object";
    private static final String FIELD_LIST = "field_list";
    private static final String PARAM_LIST = "param_list";
    private static final String ASSIGNMENT_LIST = "assignment_list";
    private static final String ARGUMENT_LIST = "argument_list";
    private final FileObject destDir;
    private final GenericResourceBean bean;
    private String template;

    public GenericResourceGenerator(FileObject destDir, GenericResourceBean bean) {
        this.destDir = destDir;
        this.bean = bean;
        this.template = bean.isRootResource() ? RESOURCE_TEMPLATE : RESOURCE_ITEM_TEMPLATE;
    }

    public FileObject getDestDir() {
        return this.destDir;
    }

    public GenericResourceBean getBean() {
        return this.bean;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String templatePath) {
        this.template = templatePath;
    }

    @Override
    public Set<FileObject> generate(ProgressHandle pHandle) throws IOException {
        JavaSource source;
        this.initProgressReporting(pHandle, false);
        this.reportProgress(NbBundle.getMessage(GenericResourceGenerator.class, (String)"MSG_GeneratingClass", (Object)(this.bean.getPackageName() + "." + this.bean.getName())));
        if (this.bean.isRootResource()) {
            source = JavaSourceHelper.createJavaSource(this.getTemplate(), this.getDestDir(), this.bean.getPackageName(), this.bean.getName());
        } else {
            HashMap<String, String> params = new HashMap<String, String>();
            String[] uriParams = this.bean.getUriParams();
            StringBuilder fieldList = new StringBuilder();
            StringBuilder paramList = new StringBuilder();
            StringBuilder assignmentList = new StringBuilder();
            StringBuilder argumentList = new StringBuilder();
            for (int i = 0; i < uriParams.length; ++i) {
                String param = uriParams[i];
                if (i == 0) {
                    fieldList.append("private String ");
                } else {
                    fieldList.append(", ");
                    paramList.append(", ");
                    argumentList.append(", ");
                    assignmentList.append(" ");
                }
                fieldList.append(param);
                argumentList.append(param);
                paramList.append("String ").append(param);
                assignmentList.append("this.").append(param).append("=").append(param).append(";");
            }
            if (fieldList.length() > 0) {
                fieldList.append(";");
            }
            params.put(FIELD_LIST, fieldList.toString());
            params.put(PARAM_LIST, paramList.toString());
            params.put(ASSIGNMENT_LIST, assignmentList.toString());
            params.put(ARGUMENT_LIST, argumentList.toString());
            source = JavaSourceHelper.createJavaSource(this.getTemplate(), params, this.getDestDir(), this.bean.getPackageName(), this.bean.getName());
        }
        if (this.bean.getInputParameters().size() > 0) {
            this.addInputParamFields(source);
            this.addConstructorWithInputParams(source);
        }
        this.modifyResourceClass(source);
        return new HashSet<FileObject>(source.getFileObjects());
    }

    private void addInputParamFields(JavaSource source) throws IOException {
        ModificationResult result = source.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

            public void run(WorkingCopy copy) throws IOException {
                copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                List<ParameterInfo> params = GenericResourceGenerator.this.bean.getInputParameters();
                JavaSourceHelper.addFields(copy, GenericResourceGenerator.this.getParamNames(params), GenericResourceGenerator.this.getParamTypeNames(params), GenericResourceGenerator.this.getParamValues(params));
            }
        });
        result.commit();
    }

    private void addConstructorWithInputParams(JavaSource source) throws IOException {
        ModificationResult result = source.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

            public void run(WorkingCopy copy) throws IOException {
                copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ClassTree tree = JavaSourceHelper.getTopLevelClassTree((CompilationController)copy);
                List<ParameterInfo> params = GenericResourceGenerator.this.bean.getInputParameters();
                StringBuilder body = new StringBuilder("{");
                for (ParameterInfo param : params) {
                    String name = param.getName();
                    body.append("if (");
                    body.append(name);
                    body.append(" != null) { this.");
                    body.append(name);
                    body.append(" = ");
                    body.append(name);
                    body.append("; }\n");
                }
                body.append("}\n");
                ClassTree modifiedTree = JavaSourceHelper.addConstructor(copy, tree, Constants.PUBLIC, GenericResourceGenerator.this.getParamNames(params), GenericResourceGenerator.this.getParamTypeNames(params), body.toString(), null);
                copy.rewrite((Tree)tree, (Tree)modifiedTree);
            }
        });
        result.commit();
    }

    private void modifyResourceClass(JavaSource source) {
        try {
            ModificationResult result = source.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

                public void run(WorkingCopy copy) throws IOException {
                    String[] jsr311Imports;
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    String[] imports = jsr311Imports = GenericResourceGenerator.getJsr311AnnotationImports(GenericResourceGenerator.this.bean);
                    boolean cdiEnabled = Util.isCDIEnabled(GenericResourceGenerator.this.getDestDir());
                    if (cdiEnabled) {
                        imports = new String[jsr311Imports.length + 1];
                        System.arraycopy(jsr311Imports, 0, imports, 0, jsr311Imports.length);
                        imports[jsr311Imports.length] = "javax.enterprise.context.RequestScoped";
                    }
                    JavaSourceHelper.addImports(copy, imports);
                    ArrayList<String> annotations = new ArrayList<String>(2);
                    ArrayList<String> annotationAttributes = new ArrayList<String>(2);
                    if (GenericResourceGenerator.this.bean.isGenerateUriTemplate()) {
                        annotations.add("Path");
                        annotationAttributes.add(GenericResourceGenerator.this.bean.getUriTemplate());
                    }
                    if (cdiEnabled) {
                        annotations.add("RequestScoped");
                        annotationAttributes.add(null);
                    }
                    if (annotations.size() > 0) {
                        JavaSourceHelper.addClassAnnotation(copy, annotations.toArray(new String[annotations.size()]), annotationAttributes.toArray(new Object[annotationAttributes.size()]));
                    }
                    ClassTree initial = JavaSourceHelper.getTopLevelClassTree((CompilationController)copy);
                    ClassTree tree = GenericResourceGenerator.this.addMethods(copy, initial);
                    for (GenericResourceBean subBean : GenericResourceGenerator.this.bean.getSubResources()) {
                        tree = GenericResourceGenerator.this.addSubResourceLocatorMethod(copy, tree, subBean);
                    }
                    copy.rewrite((Tree)initial, (Tree)tree);
                }
            });
            result.commit();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static String[] getJsr311AnnotationImports(GenericResourceBean rbean) {
        HashSet<String> result = new HashSet<String>();
        if (rbean.isGenerateUriTemplate()) {
            result.add("javax.ws.rs.Path");
        }
        if (rbean.isRootResource() && !rbean.getSubResources().isEmpty()) {
            result.add("javax.ws.rs.PathParam");
        }
        for (Constants.HttpMethodType m : rbean.getMethodTypes()) {
            result.add(m.getAnnotationType());
            if (m == Constants.HttpMethodType.GET) {
                result.add("javax.ws.rs.Produces");
            }
            if (m != Constants.HttpMethodType.POST && m != Constants.HttpMethodType.PUT) continue;
            result.add("javax.ws.rs.Consumes");
        }
        if (rbean.getQueryParameters().size() > 0) {
            result.add("javax.ws.rs.QueryParam");
        }
        return result.toArray(new String[result.size()]);
    }

    protected ClassTree addMethods(WorkingCopy copy, ClassTree tree) {
        Constants.MimeType[] mimes = this.bean.getMimeTypes();
        String[] types = this.bean.getRepresentationTypes();
        for (int i = 0; i < mimes.length; ++i) {
            Constants.MimeType mime = mimes[i];
            String type = types[i];
            tree = this.addGetMethod(mime, type, copy, tree);
            if (this.bean.getMethodTypes().contains((Object)Constants.HttpMethodType.POST)) {
                String[] subBeanTypes;
                GenericResourceBean subBean = this.getSubresourceBean();
                tree = subBean == null ? this.addPostMethod(mime, type, copy, tree) : ((subBeanTypes = subBean.getRepresentationTypes()) != null && subBeanTypes.length > 0 ? this.addPostMethod(mime, subBeanTypes[0], copy, tree) : this.addPostMethod(mime, "String", copy, tree));
            }
            if (!this.bean.getMethodTypes().contains((Object)Constants.HttpMethodType.PUT)) continue;
            tree = this.addPutMethod(mime, type, copy, tree);
        }
        if (this.bean.getMethodTypes().contains((Object)Constants.HttpMethodType.DELETE)) {
            tree = this.addDeleteMethod(copy, tree);
        }
        return tree;
    }

    private ClassTree addGetMethod(Constants.MimeType mime, String type, WorkingCopy copy, ClassTree tree) {
        Modifier[] modifiers = Constants.PUBLIC;
        String[] annotations = new String[]{"GET", "Produces"};
        Object[] annotationAttrs = new Object[]{null, mime.expressionTree(copy.getTreeMaker())};
        if (type == null) {
            type = String.class.getName();
        }
        String bodyText = "{ //TODO return proper representation object\n";
        bodyText = bodyText + "throw new UnsupportedOperationException(); }";
        List<ParameterInfo> queryParams = this.bean.getQueryParameters();
        String[] parameters = this.getGetParamNames(queryParams);
        Object[] paramTypes = this.getGetParamTypes(queryParams);
        String[][] paramAnnotations = this.getGetParamAnnotations(queryParams);
        Object[][] paramAnnotationAttrs = this.getGetParamAnnotationAttrs(queryParams);
        StringBuilder comment = new StringBuilder("Retrieves representation of an instance of ");
        comment.append(this.bean.getQualifiedClassName());
        comment.append("\n");
        for (String param : parameters) {
            comment.append("@param ");
            comment.append(param);
            comment.append(" resource URI parameter\n");
        }
        comment.append("@return an instance of ");
        comment.append(type);
        return JavaSourceHelper.addMethod(copy, tree, modifiers, annotations, annotationAttrs, this.getMethodName(Constants.HttpMethodType.GET, mime), type, parameters, paramTypes, (Object[])paramAnnotations, (Object[])paramAnnotationAttrs, bodyText, comment.toString());
    }

    private ClassTree addPostMethod(Constants.MimeType mime, String type, WorkingCopy copy, ClassTree tree) {
        Modifier[] modifiers = Constants.PUBLIC;
        String[] annotations = new String[]{"POST", "Consumes", "Produces"};
        ExpressionTree mimeTree = mime.expressionTree(copy.getTreeMaker());
        Object[] annotationAttrs = new Object[]{null, mimeTree, mimeTree};
        String bodyText = "{ //TODO\n return Response.created(context.getAbsolutePath()).build(); }";
        String[] parameters = this.getPostPutParams();
        Object[] paramTypes = this.getPostPutParamTypes(type);
        if (type != null) {
            paramTypes[paramTypes.length - 1] = type;
        }
        Object[] paramAnnotations = this.getParamAnnotations(parameters.length);
        Object[] paramAnnotationAttrs = this.getParamAnnotationAttributes(parameters.length);
        GenericResourceBean subBean = this.getSubresourceBean();
        StringBuilder comment = new StringBuilder("POST method for creating an instance of ");
        comment.append(subBean == null ? this.bean.getName() : subBean.getName());
        comment.append("\n");
        for (int i = 0; i < parameters.length - 1; ++i) {
            comment.append("@param ");
            comment.append(parameters[i]);
            comment.append(" resource URI parameter\n");
        }
        comment.append("@param ");
        comment.append(parameters[parameters.length - 1]);
        comment.append(" representation for the new resource\n");
        comment.append("@return an HTTP response with content of the created resource");
        return JavaSourceHelper.addMethod(copy, tree, modifiers, annotations, annotationAttrs, this.getMethodName(Constants.HttpMethodType.POST, mime), "javax.ws.rs.core.Response", parameters, paramTypes, paramAnnotations, paramAnnotationAttrs, bodyText, comment.toString());
    }

    private ClassTree addPutMethod(Constants.MimeType mime, String type, WorkingCopy copy, ClassTree tree) {
        Modifier[] modifiers = Constants.PUBLIC;
        String[] annotations = new String[]{"PUT", "Consumes"};
        ExpressionTree mimeTree = mime.expressionTree(copy.getTreeMaker());
        Object[] annotationAttrs = new Object[]{null, mimeTree, mimeTree};
        String returnType = "void";
        String bodyText = "{ //TODO }";
        String[] parameters = this.getPostPutParams();
        Object[] paramTypes = this.getPostPutParamTypes(type);
        if (type != null) {
            paramTypes[paramTypes.length - 1] = type;
        }
        Object[] paramAnnotations = this.getParamAnnotations(parameters.length);
        Object[] paramAnnotationAttrs = this.getParamAnnotationAttributes(parameters.length);
        StringBuilder comment = new StringBuilder("PUT method for updating or creating an instance of ");
        comment.append(this.bean.getName());
        comment.append("\n");
        for (int i = 0; i < parameters.length - 1; ++i) {
            comment.append("@param ");
            comment.append(parameters[i]);
            comment.append(" resource URI parameter\n");
        }
        comment.append("@param ");
        comment.append(parameters[parameters.length - 1]);
        comment.append(" representation for the resource");
        return JavaSourceHelper.addMethod(copy, tree, modifiers, annotations, annotationAttrs, this.getMethodName(Constants.HttpMethodType.PUT, mime), returnType, parameters, paramTypes, paramAnnotations, paramAnnotationAttrs, bodyText, comment.toString());
    }

    private ClassTree addDeleteMethod(WorkingCopy copy, ClassTree tree) {
        Modifier[] modifiers = Constants.PUBLIC;
        String[] annotations = new String[]{"DELETE"};
        Object[] annotationAttrs = new Object[]{null};
        String returnType = "void";
        String bodyText = "{ //TODO implement }";
        String comment = "DELETE method for resource " + this.bean.getName() + "\n";
        return JavaSourceHelper.addMethod(copy, tree, modifiers, annotations, annotationAttrs, "delete", returnType, null, null, null, null, bodyText, comment);
    }

    private ClassTree addSubResourceLocatorMethod(WorkingCopy copy, ClassTree tree, GenericResourceBean subBean) {
        Modifier[] modifiers = Constants.PUBLIC;
        String methodName = "get" + subBean.getName();
        String[] annotations = new String[]{"Path"};
        String uriTemplate = subBean.getUriTemplate();
        Object[] annotationAttrs = new Object[]{uriTemplate};
        String returnType = subBean.getName();
        String[] parameters = subBean.getUriParams();
        Object[] paramTypes = null;
        Object[] paramAnnotations = null;
        Object[] paramAnnotationAttrs = null;
        StringBuilder params = new StringBuilder();
        if (parameters != null && parameters.length >= 1) {
            paramTypes = GenericResourceGenerator.getUriParamTypes(subBean);
            paramAnnotations = new String[parameters.length];
            paramAnnotationAttrs = new Object[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                if (i != 0) {
                    params.append(",");
                }
                params.append(parameters[i]);
                paramAnnotations[i] = "PathParam";
                paramAnnotationAttrs[i] = parameters[i];
            }
        }
        String bodyText = "{ return " + returnType + ".getInstance(" + params.toString() + "); }";
        String comment = "Sub-resource locator method for " + uriTemplate + "\n";
        return JavaSourceHelper.addMethod(copy, tree, modifiers, annotations, annotationAttrs, methodName, returnType, parameters, paramTypes, paramAnnotations, paramAnnotationAttrs, bodyText, comment);
    }

    public String getPostPutMethodBodyText(Constants.MimeType mimeType) {
        return "{//TODO \n return new HttpResponse(201, new Representation(content, \"" + mimeType.value() + "\"); }";
    }

    private String[] getUriParamTypes() {
        return GenericResourceGenerator.getUriParamTypes(this.bean);
    }

    public static String[] getUriParamTypes(GenericResourceBean bean) {
        String defaultType = String.class.getName();
        String[] types = new String[bean.getUriParams().length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = defaultType;
        }
        return types;
    }

    private String[] getGetParamNames(List<ParameterInfo> queryParams) {
        ArrayList<String> params = new ArrayList<String>();
        if (this.bean.isRootResource()) {
            params.addAll(Arrays.asList(this.bean.getUriParams()));
        }
        params.addAll(Arrays.asList(this.getParamNames(queryParams)));
        return params.toArray(new String[params.size()]);
    }

    private String[] getGetParamTypes(List<ParameterInfo> queryParams) {
        ArrayList<String> types = new ArrayList<String>();
        if (this.bean.isRootResource()) {
            types.addAll(Arrays.asList(this.getUriParamTypes()));
        }
        types.addAll(Arrays.asList(this.getParamTypeNames(queryParams)));
        return types.toArray(new String[types.size()]);
    }

    private Object[] getParamAnnotationAttributes(int allParamCount) {
        int uriParamCount;
        String[] uriParams = this.bean.getUriParams();
        int n = uriParamCount = this.bean.isRootResource() ? uriParams.length : 0;
        if (allParamCount < uriParamCount) {
            throw new IllegalArgumentException("allParamCount=" + allParamCount);
        }
        Object[] attrs = new String[allParamCount];
        System.arraycopy(uriParams, 0, attrs, 0, uriParamCount);
        return attrs;
    }

    private String[] getParamAnnotations(int allParamCount) {
        int i;
        int uriParamCount;
        int n = uriParamCount = this.bean.isRootResource() ? this.bean.getUriParams().length : 0;
        if (allParamCount < uriParamCount) {
            throw new IllegalArgumentException("allParamCount=" + allParamCount);
        }
        String[] annos = new String[allParamCount];
        for (i = 0; i < uriParamCount; ++i) {
            annos[i] = "PathParam";
        }
        for (i = uriParamCount; i < allParamCount; ++i) {
            annos[i] = null;
        }
        return annos;
    }

    private String[][] getGetParamAnnotations(List<ParameterInfo> queryParams) {
        ArrayList<String[]> annos = new ArrayList<String[]>();
        if (this.bean.isRootResource()) {
            for (String uriParam : this.bean.getUriParams()) {
                annos.add(new String[]{"PathParam"});
            }
        }
        for (ParameterInfo param : queryParams) {
            String[] annotations = param.getDefaultValue() != null ? new String[]{"QueryParam", "DefaultValue"} : new String[]{"QueryParam"};
            annos.add(annotations);
        }
        return (String[][])annos.toArray((T[])new String[annos.size()][]);
    }

    private Object[][] getGetParamAnnotationAttrs(List<ParameterInfo> queryParams) {
        ArrayList<Object[]> attrs = new ArrayList<Object[]>();
        if (this.bean.isRootResource()) {
            for (String uriParam : this.bean.getUriParams()) {
                attrs.add(new Object[]{uriParam});
            }
        }
        for (ParameterInfo param : queryParams) {
            Object[] annotationAttrs = param.getDefaultValue() != null ? new Object[]{param.getName(), param.getDefaultValue().toString()} : new Object[]{param.getName()};
            attrs.add(annotationAttrs);
        }
        return (Object[][])attrs.toArray((T[])new Object[attrs.size()][]);
    }

    private String[] getPostPutParams() {
        if (this.bean.isRootResource()) {
            ArrayList<String> params = new ArrayList<String>(Arrays.asList(this.bean.getUriParams()));
            params.add("content");
            return params.toArray(new String[params.size()]);
        }
        return new String[]{"content"};
    }

    private String[] getPostPutParamTypes(String representatinType) {
        String defaultType = String.class.getName();
        int typesLength = 1;
        if (this.bean.isRootResource()) {
            typesLength = this.bean.getUriParams().length + 1;
        }
        String[] types = new String[typesLength];
        for (int i = 0; i < types.length - 1; ++i) {
            types[i] = defaultType;
        }
        types[types.length - 1] = representatinType;
        return types;
    }

    private String getMethodName(Constants.HttpMethodType methodType, Constants.MimeType mime) {
        return methodType.prefix() + mime.suffix();
    }

    public static String getNounForMethodName(Constants.HttpMethodType type) {
        String name = type.toString().toLowerCase();
        StringBuilder sb = new StringBuilder(name);
        sb.setCharAt(0, Character.toUpperCase(name.charAt(0)));
        return sb.toString();
    }

    private String[] getParamNames(List<ParameterInfo> params) {
        ArrayList<String> results = new ArrayList<String>();
        for (ParameterInfo param : params) {
            results.add(param.getName());
        }
        return results.toArray(new String[results.size()]);
    }

    private String[] getParamTypeNames(List<ParameterInfo> params) {
        ArrayList<String> results = new ArrayList<String>();
        for (ParameterInfo param : params) {
            results.add(param.getTypeName());
        }
        return results.toArray(new String[results.size()]);
    }

    private Object[] getParamValues(List<ParameterInfo> params) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (ParameterInfo param : params) {
            Object defaultValue = null;
            if (!param.isQueryParam()) {
                defaultValue = param.getDefaultValue();
            }
            results.add(defaultValue);
        }
        return results.toArray(new Object[results.size()]);
    }

    private GenericResourceBean getSubresourceBean() {
        List<GenericResourceBean> subResources = this.bean.getSubResources();
        if (subResources.size() > 0) {
            return subResources.get(0);
        }
        return null;
    }
}

