/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.util.zip;

import java.io.File;
import java.io.IOException;
import org.apache.maven.index.util.zip.JavaZipFileHandle;
import org.apache.maven.index.util.zip.TrueZipZipFileHandle;
import org.apache.maven.index.util.zip.ZipHandle;

public class ZipFacade {
    public static final long MEGABYTE = 0x100000L;
    public static final long JAVA_ZIPFILE_SIZE_THRESHOLD;
    private static final boolean TRUEZIP_AVAILABLE;

    public static ZipHandle getZipHandle(File targetFile) throws IOException {
        if (targetFile.isFile()) {
            if (TRUEZIP_AVAILABLE && targetFile.length() > JAVA_ZIPFILE_SIZE_THRESHOLD) {
                return new TrueZipZipFileHandle(targetFile);
            }
            return new JavaZipFileHandle(targetFile);
        }
        throw new IOException("The targetFile should point to an existing ZIP file:" + targetFile);
    }

    public static void close(ZipHandle handle) throws IOException {
        if (handle != null) {
            handle.close();
        }
    }

    static {
        Class<?> clazz;
        JAVA_ZIPFILE_SIZE_THRESHOLD = Long.getLong("org.apache.maven.index.util.zip.ZipFacade.javaZipFileSizeThreshold", 0x6400000L);
        try {
            clazz = Class.forName("de.schlichtherle.truezip.zip.ZipFile");
        }
        catch (ClassNotFoundException e) {
            clazz = null;
        }
        TRUEZIP_AVAILABLE = clazz != null;
    }
}

