/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.util.function.Function;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

@FunctionalInterface
public interface ExchangeFilterFunction {
    public Mono<ClientResponse> filter(ClientRequest var1, ExchangeFunction var2);

    default public ExchangeFilterFunction andThen(ExchangeFilterFunction afterFilter) {
        Assert.notNull((Object)afterFilter, (String)"ExchangeFilterFunction must not be null");
        return (request, next) -> this.filter(request, afterRequest -> afterFilter.filter(afterRequest, next));
    }

    default public ExchangeFunction apply(ExchangeFunction exchange) {
        Assert.notNull((Object)exchange, (String)"ExchangeFunction must not be null");
        return request -> this.filter(request, exchange);
    }

    public static ExchangeFilterFunction ofRequestProcessor(Function<ClientRequest, Mono<ClientRequest>> processor) {
        Assert.notNull(processor, (String)"ClientRequest Function must not be null");
        return (request, next) -> ((Mono)processor.apply(request)).flatMap(next::exchange);
    }

    public static ExchangeFilterFunction ofResponseProcessor(Function<ClientResponse, Mono<ClientResponse>> processor) {
        Assert.notNull(processor, (String)"ClientResponse Function must not be null");
        return (request, next) -> next.exchange(request).flatMap(processor);
    }
}

