/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.server;

import java.awt.Image;
import javax.swing.Action;
import org.netbeans.modules.selenium2.server.Bundle;
import org.netbeans.modules.selenium2.server.Selenium2ServerSupport;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;

public class Selenium2ServicesNode
extends AbstractNode {
    private static final String RUNNING_BADGE = "org/netbeans/modules/selenium2/server/resources/running.png";
    private static final String WAITING_BADGE = "org/netbeans/modules/selenium2/server/resources/waiting.png";
    private static final String SELENIUM_ICON = "org/netbeans/modules/selenium2/server/resources/selenium16.png";
    private static Selenium2ServicesNode INSTANCE;
    private static final String NODE_NAME = "seleniumserver";

    static synchronized Selenium2ServicesNode getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Selenium2ServicesNode();
        }
        return INSTANCE;
    }

    private Selenium2ServicesNode() {
        super(Children.LEAF);
        this.setName(NODE_NAME);
        this.setDisplayName(NbBundle.getMessage(Selenium2ServicesNode.class, (String)"Selenium2_Server_Node_DisplayName"));
        this.setIconBaseWithExtension(SELENIUM_ICON);
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(StartServerAction.class), SystemAction.get(StopServerAction.class), SystemAction.get(RestartServerAction.class), null, SystemAction.get(ConfigureServerAction.class)};
    }

    public Image getIcon(int type) {
        return this.badgeIcon(super.getIcon(type));
    }

    public Image getOpenedIcon(int type) {
        return this.badgeIcon(super.getOpenedIcon(type));
    }

    private Image badgeIcon(Image origImg) {
        Image badge = null;
        if (Selenium2ServerSupport.getInstance().isStarting()) {
            badge = ImageUtilities.loadImage((String)WAITING_BADGE);
        } else if (Selenium2ServerSupport.getInstance().isRunning()) {
            badge = ImageUtilities.loadImage((String)RUNNING_BADGE);
        }
        return badge != null ? ImageUtilities.mergeImages((Image)origImg, (Image)badge, (int)15, (int)8) : origImg;
    }

    public void refresh() {
        this.fireIconChange();
        this.fireOpenedIconChange();
    }

    public static class ConfigureServerAction
    extends NodeAction {
        protected void performAction(Node[] activatedNodes) {
            Selenium2ServerSupport.getInstance().configureServer();
        }

        public String getName() {
            return Bundle.Selenium2_Server_Configure_Action_Name();
        }

        protected boolean enable(Node[] activatedNodes) {
            return true;
        }

        protected boolean asynchronous() {
            return false;
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }
    }

    public static class StopServerAction
    extends NodeAction {
        protected void performAction(Node[] activatedNodes) {
            Task serverTask = Selenium2ServerSupport.getInstance().stopServer();
        }

        public String getName() {
            return Bundle.Selenium2_Server_Stop_Action_Name();
        }

        protected boolean enable(Node[] activatedNodes) {
            return Selenium2ServerSupport.getInstance().isRunning();
        }

        protected boolean asynchronous() {
            return true;
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }
    }

    public static class StartServerAction
    extends NodeAction {
        protected void performAction(Node[] activatedNodes) {
            Task serverTask = Selenium2ServerSupport.getInstance().startServer();
        }

        public String getName() {
            return Bundle.Selenium2_Server_Start_Action_Name();
        }

        protected boolean enable(Node[] activatedNodes) {
            return !Selenium2ServerSupport.getInstance().isRunning();
        }

        protected boolean asynchronous() {
            return true;
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }
    }

    public static class RestartServerAction
    extends NodeAction {
        protected void performAction(Node[] activatedNodes) {
            Task serverTask = Selenium2ServerSupport.getInstance().restartServer();
        }

        public String getName() {
            return Bundle.Selenium2_Server_Restart_Action_Name();
        }

        protected boolean enable(Node[] activatedNodes) {
            return Selenium2ServerSupport.getInstance().isRunning();
        }

        protected boolean asynchronous() {
            return true;
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }
    }
}

