/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.client;

import java.util.Arrays;
import org.netbeans.libs.git.GitClientCallback;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.ui.repository.remote.ConnectionSettings;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class CredentialsCallback
extends GitClientCallback {
    private String username;
    private char[] password;
    private String identityFile;
    private char[] passphrase;
    private boolean credentialsReady;
    private String lastUri = null;

    public String askQuestion(String uri, String prompt) {
        String retval = null;
        if (prompt.toLowerCase().startsWith("password:")) {
            char[] pwd = this.getPassword(uri, prompt);
            if (pwd != null) {
                retval = new String(pwd);
                Arrays.fill(pwd, '\u0000');
            }
        } else {
            NotifyDescriptor.InputLine desc = new NotifyDescriptor.InputLine(prompt, NbBundle.getMessage(CredentialsCallback.class, (String)"LBL_CredentialsCallback.question.title", (Object)uri));
            Object dlgResult = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            retval = NotifyDescriptor.OK_OPTION == dlgResult ? desc.getInputText() : null;
        }
        return retval;
    }

    public String getUsername(String uri, String prompt) {
        this.getCredentials(uri);
        return this.username;
    }

    private void getCredentials(String uri) {
        if (!this.credentialsReady || !uri.equals(this.lastUri)) {
            this.fetchCredentials(uri);
        }
    }

    public char[] getPassword(String uri, String prompt) {
        this.getCredentials(uri);
        char[] pwd = null;
        if (this.password != null) {
            pwd = (char[])this.password.clone();
            Arrays.fill(this.password, '\u0000');
            this.credentialsReady = false;
        }
        return pwd;
    }

    public char[] getPassphrase(String uri, String prompt) {
        this.getCredentials(uri);
        char[] pwd = null;
        if (this.passphrase != null) {
            pwd = (char[])this.passphrase.clone();
            Arrays.fill(this.passphrase, '\u0000');
            this.credentialsReady = false;
        }
        return pwd;
    }

    public String getIdentityFile(String uri, String prompt) {
        this.getCredentials(uri);
        return this.identityFile;
    }

    public Boolean askYesNoQuestion(String uri, String prompt) {
        return NotifyDescriptor.YES_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)prompt, NbBundle.getMessage(CredentialsCallback.class, (String)"LBL_CredentialsCallback.question.title", (Object)uri), 1, 3));
    }

    private void fetchCredentials(String uri) {
        this.lastUri = uri;
        ConnectionSettings settings = GitModuleConfig.getDefault().getConnectionSettings(uri);
        if (settings == null) {
            uri = uri.endsWith("/") ? uri.substring(0, uri.length() - 1) : uri + "/";
            settings = GitModuleConfig.getDefault().getConnectionSettings(uri);
        }
        if (settings != null) {
            this.username = settings.getUser();
            if (settings.isPrivateKeyAuth()) {
                this.identityFile = settings.getIdentityFile();
                this.passphrase = settings.getPassphrase();
                this.password = null;
            } else {
                this.password = settings.getPassword();
                this.identityFile = null;
                this.passphrase = null;
            }
            this.credentialsReady = true;
        }
    }
}

