/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.webmvc;

import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.spring.spi.beans.SpringConfigFileLocationProvider;
import org.netbeans.modules.spring.spi.beans.SpringConfigFileProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebModuleProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbCollections;

public class WebProjectSpringConfigFileProvider
implements SpringConfigFileProvider,
SpringConfigFileLocationProvider {
    private final Project project;

    public WebProjectSpringConfigFileProvider(Project project) {
        this.project = project;
    }

    public Set<File> getConfigFiles() {
        FileObject webInf = this.getWebInf();
        if (webInf == null) {
            return Collections.emptySet();
        }
        HashSet<File> result = new HashSet<File>();
        WebProjectSpringConfigFileProvider.addFilesInWebInf(webInf, result);
        return Collections.unmodifiableSet(result);
    }

    private static void addFilesInWebInf(FileObject webInf, Set<File> result) {
        for (FileObject fo : NbCollections.iterable((Enumeration)webInf.getChildren(true))) {
            File file;
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (!"text/x-springconfig+xml".equals(fo.getMIMEType()) || (file = FileUtil.toFile((FileObject)fo)) == null) continue;
            result.add(file);
        }
    }

    public FileObject getLocation() {
        return this.getWebInf();
    }

    private FileObject getWebInf() {
        WebModuleProvider provider = (WebModuleProvider)this.project.getLookup().lookup(WebModuleProvider.class);
        if (provider == null) {
            return null;
        }
        WebModule webModule = provider.findWebModule(this.project.getProjectDirectory());
        if (webModule == null) {
            return null;
        }
        return webModule.getWebInf();
    }
}

