/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SimpleClassLoader
extends ClassLoader {
    private static final int debug = 0;
    protected URL[] urls;
    protected ClassLoader parent;
    protected String[] reserved;
    SecurityManager sm;

    public SimpleClassLoader(URL[] urls) {
        this.urls = urls;
        this.sm = System.getSecurityManager();
        this.checkURLs();
    }

    public SimpleClassLoader(URL[] urls, ClassLoader parent) {
        this.urls = urls;
        this.parent = parent;
        this.sm = System.getSecurityManager();
        this.checkURLs();
    }

    public SimpleClassLoader(URL[] urls, ClassLoader parent, String[] reserved) {
        this.urls = urls;
        this.parent = parent;
        this.reserved = reserved;
        this.sm = System.getSecurityManager();
        this.checkURLs();
    }

    public ClassLoader getParentLoader() {
        return this.parent;
    }

    private void checkURLs() {
        boolean cnt = false;
        int i = 0;
        while (i < this.urls.length) {
            URL cp = this.urls[i];
            String fileN = cp.getFile();
            File file = new File(fileN);
            if (!file.exists()) {
                this.urls[i] = null;
            }
            if (file.isDirectory() && !fileN.endsWith("/")) {
                try {
                    this.urls[i] = new URL("file", null, fileN + "/");
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    void log(String s) {
        System.out.println("SimpleClassLoader: " + s);
    }

    /*
     * Loose catch block
     */
    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        byte[] classData;
        Class<?> c;
        block41: {
            Resource r;
            block44: {
                int i;
                c = null;
                c = this.findLoadedClass(name);
                if (c != null) {
                    if (resolve) {
                        this.resolveClass(c);
                    }
                    return c;
                }
                if (this.parent != null) {
                    try {
                        c = this.parent.loadClass(name);
                        if (c != null) {
                            if (resolve) {
                                this.resolveClass(c);
                            }
                            return c;
                        }
                    }
                    catch (Exception e) {
                        c = null;
                    }
                }
                try {
                    c = this.findSystemClass(name);
                    if (c != null) {
                        if (resolve) {
                            this.resolveClass(c);
                        }
                        return c;
                    }
                }
                catch (Exception e) {
                    c = null;
                }
                if (this.sm != null && (i = name.lastIndexOf(46)) >= 0) {
                    this.sm.checkPackageAccess(name.substring(0, i));
                    this.sm.checkPackageDefinition(name.substring(0, i));
                }
                if (this.reserved != null) {
                    i = 0;
                    while (i < this.reserved.length) {
                        if (name.startsWith(this.reserved[i])) {
                            throw new ClassNotFoundException(name);
                        }
                        ++i;
                    }
                }
                if (this.urls == null) {
                    throw new ClassNotFoundException(name);
                }
                String classFileName = name.replace('.', '/') + ".class";
                r = this.doFindResource(classFileName);
                if (r == null) {
                    throw new ClassNotFoundException(name);
                }
                classData = null;
                if (r.file == null) break block44;
                FileInputStream in = null;
                in = new FileInputStream(r.file);
                classData = this.loadBytesFromStream(in, (int)r.file.length());
                Object var11_15 = null;
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    break block41;
                }
                catch (IOException ex) {}
                break block41;
                {
                    catch (IOException ioex) {
                        Class clazz = null;
                        Object var11_16 = null;
                        try {
                            if (in != null) {
                                ((InputStream)in).close();
                            }
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                        return clazz;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_17 = null;
                    try {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (r.zipEntry != null) {
                classData = this.loadBytesFromStream(r.zipFile.getInputStream(r.zipEntry), (int)r.zipEntry.getSize());
                Object var14_25 = null;
                try {
                    r.zipFile.close();
                }
                catch (IOException ignored) {}
                break block41;
                {
                    catch (IOException ioex) {
                        Class clazz = null;
                        Object var14_26 = null;
                        try {
                            r.zipFile.close();
                        }
                        catch (IOException ignored) {
                            // empty catch block
                        }
                        return clazz;
                    }
                }
                catch (Throwable throwable) {
                    Object var14_27 = null;
                    try {
                        r.zipFile.close();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        if (classData != null) {
            try {
                c = this.defineClass(name, classData, 0, classData.length);
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        throw new ClassNotFoundException(name);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL getResource(String name) {
        u = null;
        if (this.parent != null && (u = this.parent.getResource(name)) != null) {
            return u;
        }
        u = ClassLoader.getSystemResource(name);
        if (u != null) {
            return u;
        }
        r = this.doFindResource(name);
        if (r == null) {
            return null;
        }
        if (r.file != null) {
            try {
                return new URL("file", null, r.file.getAbsolutePath());
            }
            catch (MalformedURLException badurl) {
                badurl.printStackTrace();
                return null;
            }
        }
        if (r.zipEntry == null) return null;
        try {
            try {
                badurl = new URL("jar:file:" + r.repository.getPath() + "!/" + name);
                var7_7 = null;
            }
            catch (MalformedURLException badurl) {
                badurl.printStackTrace();
                var5_13 = null;
                var7_8 = null;
                try {
                    r.zipFile.close();
                    return var5_13;
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                return var5_13;
            }
        }
        catch (Throwable var6_14) {
            var7_9 = null;
            ** try [egrp 3[TRYBLOCK] [3 : 163->173)] { 
lbl38:
            // 1 sources

            r.zipFile.close();
            throw var6_14;
lbl40:
            // 1 sources

            catch (IOException ignored) {
                // empty catch block
            }
            throw var6_14;
        }
        ** try [egrp 3[TRYBLOCK] [3 : 163->173)] { 
lbl45:
        // 1 sources

        r.zipFile.close();
        return badurl;
lbl47:
        // 1 sources

        catch (IOException ignored) {
            // empty catch block
        }
        return badurl;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getResourceAsStream(String name) {
        block16: {
            s = null;
            if (this.parent != null && (s = this.parent.getResourceAsStream(name)) != null) {
                return s;
            }
            s = ClassLoader.getSystemResourceAsStream(name);
            if (s != null) {
                return s;
            }
            r = this.doFindResource(name);
            if (r == null) {
                return null;
            }
            if (r.file != null) {
                try {
                    return new FileInputStream(r.file);
                }
                catch (IOException shouldnothappen) {
                    shouldnothappen.printStackTrace();
                    return null;
                }
            }
            if (r.zipEntry == null) return s;
            try {
                try {
                    data = this.loadBytesFromStream(r.zipFile.getInputStream(r.zipEntry), (int)r.zipEntry.getSize());
                    if (data == null) break block16;
                    var6_9 = istream = new ByteArrayInputStream(data);
                    var8_10 = null;
                    if (r.zipFile == null) return var6_9;
                }
                catch (IOException e) {
                    var8_12 = null;
                    if (r.zipFile == null) return s;
                    try {
                        r.zipFile.close();
                        return s;
                    }
                    catch (IOException ignored) {
                        return s;
                    }
                }
            }
            catch (Throwable var7_18) {
                var8_13 = null;
                if (r.zipFile == null) throw var7_18;
                ** try [egrp 3[TRYBLOCK] [3 : 168->178)] { 
lbl40:
                // 1 sources

                r.zipFile.close();
                throw var7_18;
lbl42:
                // 1 sources

                catch (IOException ignored) {
                    // empty catch block
                }
                throw var7_18;
            }
            ** try [egrp 3[TRYBLOCK] [3 : 168->178)] { 
lbl47:
            // 1 sources

            r.zipFile.close();
            return var6_9;
lbl49:
            // 1 sources

            catch (IOException ignored) {
                // empty catch block
            }
            return var6_9;
        }
        var8_11 = null;
        if (r.zipFile == null) return s;
        try {}
        catch (IOException ignored) {}
        r.zipFile.close();
        return s;
        return s;
    }

    private Resource doFindResource(String name) {
        Resource r = new Resource();
        int i = 0;
        while (i < this.urls.length) {
            URL cp = this.urls[i];
            if (cp != null) {
                String fileN = cp.getFile();
                File file = new File(fileN);
                if (fileN.endsWith("/")) {
                    String fileName = name.replace('/', File.separatorChar);
                    File resFile = new File(file, fileName);
                    if (resFile.exists()) {
                        r.file = resFile;
                        r.repository = file;
                        return r;
                    }
                } else {
                    try {
                        ZipFile zf = new ZipFile(file.getAbsolutePath());
                        ZipEntry ze = zf.getEntry(name);
                        if (ze != null) {
                            r.zipEntry = ze;
                            r.zipFile = zf;
                            r.repository = file;
                            return r;
                        }
                        zf.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        System.out.println("Name= " + name + " " + file);
                        return null;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] loadBytesFromStream(InputStream in, int length) throws IOException {
        int nRead;
        byte[] buf = new byte[length];
        int count = 0;
        while (length > 0 && (nRead = in.read(buf, count, length)) != -1) {
            void var4_5;
            count += var4_5;
            length -= var4_5;
        }
        return buf;
    }

    public URL[] getURLs() {
        return this.urls;
    }

    private class Resource {
        File repository;
        File file;
        ZipEntry zipEntry;
        ZipFile zipFile;

        private Resource() {
        }
    }
}

