/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.sync;

import java.awt.Color;
import java.awt.Dialog;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.php.project.connections.sync.Bundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SummaryPanel
extends JPanel {
    private static final long serialVersionUID = 176831576846546L;
    private static final Logger LOGGER = Logger.getLogger(SummaryPanel.class.getName());
    private JLabel deleteLabel;
    private JLabel deleteNumberLabel;
    private JLabel downloadLabel;
    private JLabel downloadNumberLabel;
    private JLabel noopLabel;
    private JLabel noopNumberLabel;
    private JLabel uploadLabel;
    private JLabel uploadNumberLabel;

    public SummaryPanel(int uploadNumber, int downloadNumber, int deleteNumber, int noopNumber) {
        this.initComponents();
        this.setNumber(this.uploadNumberLabel, uploadNumber);
        this.setNumber(this.downloadNumberLabel, downloadNumber);
        this.setNumber(this.deleteNumberLabel, deleteNumber);
        this.setNumber(this.noopNumberLabel, noopNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        assert (SwingUtilities.isEventDispatchThread());
        JButton okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)okButton, (String)Bundle.SummaryPanel_button_titleWithMnemonics());
        DialogDescriptor descriptor = new DialogDescriptor((Object)this, Bundle.SummaryPanel_title(), true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        try {
            dialog.setVisible(true);
        }
        finally {
            dialog.dispose();
        }
        return descriptor.getValue() == okButton;
    }

    public void uploadError() {
        this.setErrorComponents(this.uploadLabel, this.uploadNumberLabel);
    }

    public void downloadError() {
        this.setErrorComponents(this.downloadLabel, this.downloadNumberLabel);
    }

    public void deleteError() {
        this.setErrorComponents(this.deleteLabel, this.deleteNumberLabel);
    }

    public void decreaseUploadNumber() {
        this.decreaseNumber(this.uploadNumberLabel);
    }

    public void decreaseDownloadNumber() {
        this.decreaseNumber(this.downloadNumberLabel);
    }

    public void decreaseNoopNumber() {
        this.decreaseNumber(this.noopNumberLabel);
    }

    public void setDeleteNumber(int number) {
        this.setNumber(this.deleteNumberLabel, number);
    }

    private void setNumber(JLabel numberLabel, int number) {
        numberLabel.setText(String.valueOf(number));
    }

    private void decreaseNumber(JLabel numberLabel) {
        try {
            int number = Integer.parseInt(numberLabel.getText());
            numberLabel.setText(String.valueOf(--number));
        }
        catch (NumberFormatException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            numberLabel.setText(Bundle.SummaryPanel_na());
        }
    }

    private void setErrorComponents(JComponent ... components) {
        for (JComponent component : components) {
            component.setForeground(this.getErrorColor());
        }
    }

    private Color getErrorColor() {
        return UIManager.getColor("nb.errorForeground");
    }

    private void initComponents() {
        this.uploadLabel = new JLabel();
        this.downloadLabel = new JLabel();
        this.deleteLabel = new JLabel();
        this.noopLabel = new JLabel();
        this.uploadNumberLabel = new JLabel();
        this.downloadNumberLabel = new JLabel();
        this.deleteNumberLabel = new JLabel();
        this.noopNumberLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.uploadLabel, (String)NbBundle.getMessage(SummaryPanel.class, (String)"SummaryPanel.uploadLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.downloadLabel, (String)NbBundle.getMessage(SummaryPanel.class, (String)"SummaryPanel.downloadLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.deleteLabel, (String)NbBundle.getMessage(SummaryPanel.class, (String)"SummaryPanel.deleteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.noopLabel, (String)NbBundle.getMessage(SummaryPanel.class, (String)"SummaryPanel.noopLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.uploadNumberLabel, (String)"0");
        Mnemonics.setLocalizedText((JLabel)this.downloadNumberLabel, (String)"0");
        Mnemonics.setLocalizedText((JLabel)this.deleteNumberLabel, (String)"0");
        Mnemonics.setLocalizedText((JLabel)this.noopNumberLabel, (String)"0");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.downloadLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.downloadNumberLabel)).addGroup(layout.createSequentialGroup().addComponent(this.uploadLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.uploadNumberLabel)).addGroup(layout.createSequentialGroup().addComponent(this.deleteLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.deleteNumberLabel)).addGroup(layout.createSequentialGroup().addComponent(this.noopLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.noopNumberLabel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.uploadLabel).addComponent(this.uploadNumberLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.downloadLabel).addComponent(this.downloadNumberLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deleteLabel).addComponent(this.deleteNumberLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.noopLabel).addComponent(this.noopNumberLabel)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

