/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.util;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.xml.sax.InputSource;

public final class Convertors {
    public static String documentToString(final Document doc) {
        if (doc == null) {
            throw new NullPointerException();
        }
        final String[] str = new String[1];
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    str[0] = doc.getText(0, doc.getLength());
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        };
        doc.render(run);
        return str[0];
    }

    public static InputSource documentToInputSource(Document doc) {
        if (doc == null) {
            throw new NullPointerException();
        }
        String text = Convertors.documentToString(doc);
        StringReader reader = new StringReader(text);
        String system = (String)doc.getProperty("doc-url");
        if (system == null) {
            Object obj = doc.getProperty("stream");
            if (obj instanceof DataObject) {
                try {
                    DataObject dobj = (DataObject)obj;
                    FileObject fo = dobj.getPrimaryFile();
                    URL url = fo.getURL();
                    system = url.toExternalForm();
                }
                catch (IOException io) {
                    ErrorManager emgr = (ErrorManager)Lookup.getDefault().lookup(ErrorManager.class);
                    emgr.notify((Throwable)io);
                }
            } else {
                ErrorManager emgr = (ErrorManager)Lookup.getDefault().lookup(ErrorManager.class);
                emgr.log("XML:Convertors:Unknown stream description:" + obj);
            }
        }
        if (system == null) {
            system = "XML/Convertors/documentToInputSource()";
        }
        InputSource in = new InputSource(system);
        in.setCharacterStream(reader);
        return in;
    }

    public static String readerToString(Reader reader) throws IOException {
        BufferedReader fastReader = new BufferedReader(reader);
        StringBuffer buf = new StringBuffer(1024);
        try {
            int i = fastReader.read();
            while (i >= 0) {
                buf.append((char)i);
                i = fastReader.read();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return buf.toString();
    }
}

