/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.api;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Locale;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.netbeans.modules.apisupport.project.api.Bundle;
import org.openide.awt.Mnemonics;

public final class UIUtil {
    public static final String TEMPLATE_CATEGORY = "nbm-specific";
    public static final String TEMPLATE_FOLDER = "NetBeansModuleDevelopment";
    public static final String TEMPLATE_ACTION_ID = "newAction";
    public static final String TEMPLATE_WINDOW_ID = "newWindow";
    private static Reference<JFileChooser> iconChooser;
    public static final String WAIT_VALUE;
    public static final String LIBRARIES_ICON = "org/netbeans/modules/apisupport/project/api/libraries.gif";

    private UIUtil() {
    }

    public static JFileChooser getIconFileChooser() {
        JFileChooser choose;
        if (iconChooser != null && (choose = iconChooser.get()) != null) {
            return choose;
        }
        IconFileChooser chooser = new IconFileChooser();
        iconChooser = new WeakReference<IconFileChooser>(chooser);
        return chooser;
    }

    public static ComboBoxModel createComboWaitModel() {
        return new DefaultComboBoxModel<Object>(new Object[]{WAIT_VALUE});
    }

    public static boolean isWaitModel(ListModel model) {
        if (model instanceof WaitingModel) {
            return ((WaitingModel)model).isWaiting();
        }
        return UIUtil.hasOnlyValue(model, WAIT_VALUE);
    }

    public static boolean hasOnlyValue(ListModel model, Object value) {
        return model != null && model.getSize() == 1 && model.getElementAt(0) == value;
    }

    public static ListModel createListWaitModel() {
        DefaultListModel<String> listWaitModel = new DefaultListModel<String>();
        listWaitModel.addElement(WAIT_VALUE);
        return listWaitModel;
    }

    static {
        WAIT_VALUE = Bundle.please_wait();
    }

    public static interface WaitingModel
    extends ListModel {
        public boolean isWaiting();
    }

    private static class IconFileChooser
    extends JFileChooser {
        private final JTextField iconInfo = new JTextField();

        private IconFileChooser() {
            JPanel accessoryPanel = IconFileChooser.getAccesoryPanel(this.iconInfo);
            this.setDialogTitle(Bundle.TITLE_IconDialog());
            this.setAccessory(accessoryPanel);
            this.setAcceptAllFileFilterUsed(false);
            this.setFileSelectionMode(0);
            this.setMultiSelectionEnabled(false);
            this.addChoosableFileFilter(new IconFilter());
            this.setFileView(new FileView(){

                @Override
                public Icon getIcon(File f) {
                    ImageIcon icon;
                    if ((f.getName().endsWith(".gif") || f.getName().endsWith(".png")) && (icon = new ImageIcon(f.getAbsolutePath())).getIconWidth() == 16 && icon.getIconHeight() == 16) {
                        return icon;
                    }
                    return null;
                }

                @Override
                public String getName(File f) {
                    File f2 = this.getSelectedFile();
                    if (f2 != null && (f2.getName().endsWith(".gif") || f2.getName().endsWith(".png"))) {
                        ImageIcon icon = new ImageIcon(f2.getAbsolutePath());
                        StringBuffer sb = new StringBuffer();
                        sb.append(f2.getName()).append(" [");
                        sb.append(icon.getIconWidth()).append('x').append(icon.getIconHeight());
                        sb.append(']');
                        this.setApproveButtonToolTipText(sb.toString());
                        iconInfo.setText(sb.toString());
                    } else {
                        iconInfo.setText("");
                    }
                    return super.getName(f);
                }
            });
        }

        private static JPanel getAccesoryPanel(JTextField iconInfo) {
            iconInfo.setColumns(15);
            iconInfo.setEditable(false);
            JPanel accessoryPanel = new JPanel();
            JPanel inner = new JPanel();
            JLabel iconInfoLabel = new JLabel();
            accessoryPanel.setLayout(new FlowLayout(0, 6, 0));
            inner.setLayout(new GridLayout(2, 1, 0, 6));
            iconInfoLabel.setLabelFor(iconInfo);
            Mnemonics.setLocalizedText((JLabel)iconInfoLabel, (String)Bundle.LBL_IconInfo());
            inner.add(iconInfoLabel);
            inner.add(iconInfo);
            accessoryPanel.add(inner);
            return accessoryPanel;
        }
    }

    private static final class IconFilter
    extends FileFilter {
        private IconFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().toLowerCase(Locale.ENGLISH).endsWith("gif") || pathname.getName().toLowerCase(Locale.ENGLISH).endsWith("png");
        }

        @Override
        public String getDescription() {
            return "*.gif, *.png";
        }
    }

    public static abstract class DocumentAdapter
    implements DocumentListener {
        @Override
        public void removeUpdate(DocumentEvent e) {
            this.insertUpdate(null);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.insertUpdate(null);
        }
    }
}

