/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.hyperlink;

import java.awt.Toolkit;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Exceptions;

public class ApisupportHyperlinkProvider
implements HyperlinkProviderExt {
    private static final Set<JavaTokenId> USABLE_TOKEN_IDS = EnumSet.of(JavaTokenId.STRING_LITERAL);

    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION);
    }

    public boolean isHyperlinkPoint(Document doc, int offset, HyperlinkType type) {
        return this.getHyperlinkSpan(doc, offset, type) != null;
    }

    public int[] getHyperlinkSpan(Document doc, int offset, HyperlinkType type) {
        return ApisupportHyperlinkProvider.getIdentifierSpan(doc, offset, null);
    }

    public void performClickAction(Document doc, int offset, HyperlinkType type) {
        Line ln = this.getLine(doc, offset);
        if (ln != null) {
            ln.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public String getTooltipText(Document doc, int offset, HyperlinkType type) {
        Line ln = this.getLine(doc, offset);
        if (ln != null) {
            return ln.getText();
        }
        return null;
    }

    private Line getLine(Document doc, int offset) {
        FileObject props;
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = SourceUtils.getJavaTokenSequence((TokenHierarchy)th, (int)offset);
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        if (!ts.moveNext()) {
            return null;
        }
        Token t = ts.token();
        FileObject fo = ApisupportHyperlinkProvider.getFileObject(doc);
        String name = t.text().toString();
        if (name.startsWith("\"")) {
            name = name.substring(1);
        }
        if (name.endsWith("\"")) {
            name = name.substring(0, name.length() - 1);
        }
        if ((props = this.findBundle(fo)) != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)props);
                EditorCookie ec = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
                try {
                    ec.openDocument();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                LineCookie lc = (LineCookie)dobj.getLookup().lookup(LineCookie.class);
                if (lc != null) {
                    Line.Set ls = lc.getLineSet();
                    for (Line line : ls.getLines()) {
                        if (!line.getText().contains(name + "=")) continue;
                        return line;
                    }
                }
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    @CheckForNull
    private FileObject findBundle(FileObject javaFile) {
        ClassPath cp = ClassPath.getClassPath((FileObject)javaFile, (String)"classpath/source");
        if (cp == null) {
            return null;
        }
        String name = cp.getResourceName(javaFile);
        if (name != null) {
            int index = name.lastIndexOf(47);
            name = name.substring(0, index) + "/Bundle.properties";
            return cp.findResource(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getIdentifierSpan(Document doc, int offset, Token<JavaTokenId>[] token) {
        FileObject fo = ApisupportHyperlinkProvider.getFileObject(doc);
        if (fo == null) {
            return null;
        }
        Project prj = FileOwnerQuery.getOwner((FileObject)fo);
        if (prj == null) {
            return null;
        }
        NbModuleProvider module = (NbModuleProvider)prj.getLookup().lookup(NbModuleProvider.class);
        if (module == null) {
            return null;
        }
        ((AbstractDocument)doc).readLock();
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = null;
        try {
            ts = SourceUtils.getJavaTokenSequence((TokenHierarchy)th, (int)offset);
        }
        finally {
            ((AbstractDocument)doc).readUnlock();
        }
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        if (!ts.moveNext()) {
            return null;
        }
        Token t = ts.token();
        boolean hasMessage = false;
        boolean hasNbBundle = false;
        if (USABLE_TOKEN_IDS.contains(t.id())) {
            for (int i = 0; i < 10 && ts.movePrevious(); ++i) {
                Token tk = ts.token();
                if (TokenUtilities.equals((CharSequence)"getMessage", (Object)tk.text())) {
                    hasMessage = true;
                    continue;
                }
                if (!TokenUtilities.equals((CharSequence)"NbBundle", (Object)tk.text())) continue;
                hasNbBundle = true;
            }
            if (hasNbBundle && hasMessage) {
                ts.move(offset);
                ts.moveNext();
                return new int[]{ts.offset(), ts.offset() + t.length()};
            }
        }
        return null;
    }

    private static FileObject getFileObject(Document doc) {
        DataObject od = (DataObject)doc.getProperty("stream");
        return od != null ? od.getPrimaryFile() : null;
    }
}

