/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.testng.ITestMethodFinder;
import org.testng.ITestNGMethod;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.Lists;
import org.testng.internal.ClassHelper;
import org.testng.internal.ConfigurationMethod;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.MethodHelper;
import org.testng.internal.RunInfo;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlTest;

public class TestNGMethodFinder
implements ITestMethodFinder {
    private static final Comparator<ITestNGMethod> NO_COMPARISON = new Comparator<ITestNGMethod>(){

        @Override
        public int compare(ITestNGMethod iTestNGMethod, ITestNGMethod iTestNGMethod2) {
            return 0;
        }
    };
    private RunInfo runInfo = null;
    private IAnnotationFinder annotationFinder = null;
    private final Comparator<ITestNGMethod> comparator;

    public TestNGMethodFinder(RunInfo runInfo, IAnnotationFinder iAnnotationFinder) {
        this(runInfo, iAnnotationFinder, NO_COMPARISON);
    }

    public TestNGMethodFinder(RunInfo runInfo, IAnnotationFinder iAnnotationFinder, Comparator<ITestNGMethod> comparator) {
        this.runInfo = runInfo;
        this.annotationFinder = iAnnotationFinder;
        this.comparator = comparator;
    }

    @Override
    public ITestNGMethod[] getTestMethods(Class<?> clazz, XmlTest xmlTest) {
        return AnnotationHelper.findMethodsWithAnnotation(clazz, ITestAnnotation.class, this.annotationFinder, xmlTest);
    }

    public ITestNGMethod[] getBeforeClassMethods(Class clazz) {
        return this.findConfiguration(clazz, MethodType.BEFORE_CLASS);
    }

    public ITestNGMethod[] getAfterClassMethods(Class clazz) {
        return this.findConfiguration(clazz, MethodType.AFTER_CLASS);
    }

    public ITestNGMethod[] getBeforeTestMethods(Class clazz) {
        return this.findConfiguration(clazz, MethodType.BEFORE_TEST_METHOD);
    }

    public ITestNGMethod[] getAfterTestMethods(Class clazz) {
        return this.findConfiguration(clazz, MethodType.AFTER_TEST_METHOD);
    }

    public ITestNGMethod[] getBeforeSuiteMethods(Class clazz) {
        return this.findConfiguration(clazz, MethodType.BEFORE_SUITE);
    }

    public ITestNGMethod[] getAfterSuiteMethods(Class clazz) {
        return this.findConfiguration(clazz, MethodType.AFTER_SUITE);
    }

    public ITestNGMethod[] getBeforeTestConfigurationMethods(Class clazz) {
        return this.findConfiguration(clazz, MethodType.BEFORE_TEST);
    }

    public ITestNGMethod[] getAfterTestConfigurationMethods(Class clazz) {
        return this.findConfiguration(clazz, MethodType.AFTER_TEST);
    }

    public ITestNGMethod[] getBeforeGroupsConfigurationMethods(Class clazz) {
        return this.findConfiguration(clazz, MethodType.BEFORE_GROUPS);
    }

    public ITestNGMethod[] getAfterGroupsConfigurationMethods(Class clazz) {
        return this.findConfiguration(clazz, MethodType.AFTER_GROUPS);
    }

    private ITestNGMethod[] findConfiguration(Class clazz, MethodType methodType) {
        List<ITestNGMethod> list = Lists.newArrayList();
        Set<Method> set = ClassHelper.getAvailableMethods(clazz);
        for (Method method : set) {
            boolean bl;
            IConfigurationAnnotation iConfigurationAnnotation = AnnotationHelper.findConfiguration(this.annotationFinder, method);
            if (null == iConfigurationAnnotation) continue;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            String[] stringArray = null;
            String[] stringArray2 = null;
            switch (methodType) {
                case BEFORE_SUITE: {
                    bl = iConfigurationAnnotation.getBeforeSuite();
                    bl2 = true;
                    break;
                }
                case AFTER_SUITE: {
                    bl = iConfigurationAnnotation.getAfterSuite();
                    bl3 = true;
                    break;
                }
                case BEFORE_TEST: {
                    bl = iConfigurationAnnotation.getBeforeTest();
                    bl4 = true;
                    break;
                }
                case AFTER_TEST: {
                    bl = iConfigurationAnnotation.getAfterTest();
                    bl5 = true;
                    break;
                }
                case BEFORE_CLASS: {
                    bl = iConfigurationAnnotation.getBeforeTestClass();
                    bl6 = true;
                    break;
                }
                case AFTER_CLASS: {
                    bl = iConfigurationAnnotation.getAfterTestClass();
                    bl7 = true;
                    break;
                }
                case BEFORE_TEST_METHOD: {
                    bl = iConfigurationAnnotation.getBeforeTestMethod();
                    bl8 = true;
                    break;
                }
                case AFTER_TEST_METHOD: {
                    bl = iConfigurationAnnotation.getAfterTestMethod();
                    bl9 = true;
                    break;
                }
                case BEFORE_GROUPS: {
                    stringArray = iConfigurationAnnotation.getBeforeGroups();
                    bl = stringArray.length > 0;
                    bl8 = true;
                    break;
                }
                case AFTER_GROUPS: {
                    stringArray2 = iConfigurationAnnotation.getAfterGroups();
                    bl = stringArray2.length > 0;
                    bl8 = true;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected value: " + (Object)((Object)methodType)));
                }
            }
            if (!bl) continue;
            this.addConfigurationMethod(clazz, list, method, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, stringArray, stringArray2, null);
        }
        List list2 = Lists.newArrayList();
        boolean bl = methodType == MethodType.BEFORE_SUITE || methodType == MethodType.AFTER_SUITE;
        return MethodHelper.collectAndOrderMethods(Lists.newArrayList(list), false, this.runInfo, this.annotationFinder, bl, list2, this.comparator);
    }

    private void addConfigurationMethod(Class<?> clazz, List<ITestNGMethod> list, Method method, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, String[] stringArray, String[] stringArray2, Object object) {
        if (method.getDeclaringClass().isAssignableFrom(clazz)) {
            ConfigurationMethod configurationMethod = new ConfigurationMethod(new ConstructorOrMethod(method), this.annotationFinder, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, stringArray, stringArray2, object);
            list.add(configurationMethod);
        }
    }

    static enum MethodType {
        BEFORE_SUITE,
        AFTER_SUITE,
        BEFORE_TEST,
        AFTER_TEST,
        BEFORE_CLASS,
        AFTER_CLASS,
        BEFORE_TEST_METHOD,
        AFTER_TEST_METHOD,
        BEFORE_GROUPS,
        AFTER_GROUPS;

    }
}

