/**
 * Objects implementing the NamedNodeMap interface are used to represent collections of nodes that can be accessed by name. Note that NamedNodeMap does not inherit from NodeList; NamedNodeMaps are not maintained in any particular order. Objects contained in an object implementing NamedNodeMap may also be accessed by an ordinal index, but this is simply to allow convenient enumeration of the contents of a NamedNodeMap, and does not imply that the DOM specifies an order to these Nodes.NamedNodeMap objects in the DOM are live.
 */
var NamedNodeMap = {
}
/**
 * Retrieves a node specified by name
 * @syntax namedNodeMap.getNamedItem(name)
 * @param {String} name The nodeName of a node to retrieve.
 * @returns {Node} A Node (of any type) with the specified nodeName, or null if it does not identify any node in this map.
 */
NamedNodeMap.prototype.getNamedItem = function(name) {};

/**
 * Adds a node using its namespaceURI and localName. If a node with that namespace URI and that local name is already present in this map, it is replaced by the new one. Replacing a node by itself has no effect. Per [XML Namespaces], applications must use the value null as the namespaceURI parameter for methods if they wish to have no namespace
 * @syntax namedNodeMap.setNamedItemNS(arg)
 * @param {Node} arg A node to store in this map. The node will later be accessible using the value of its namespaceURI and localName attributes.
 * @returns {Node} If the new Node replaces an existing node the replaced Node is returned, otherwise null is returned.
 */
NamedNodeMap.prototype.setNamedItemNS = function(arg) {};

/**
 * Removes a node specified by local name and namespace URI. A removed attribute may be known to have a default value when this map contains the attributes attached to an element, as returned by the attributes attribute of the Node interface. If so, an attribute immediately appears containing the default value as well as the corresponding namespace URI, local name, and prefix when applicable. Per [XML Namespaces], applications must use the value null as the namespaceURI parameter for methods if they wish to have no namespace
 * @syntax namedNodeMap.removeNamedItemNS(namespaceURI, localName)
 * @param {String} namespaceURI The namespace URI of the node to remove.
 * @param {String} localName The local name of the node to remove.
 * @returns {Node} The node removed from this map if a node with such a local name and namespace URI exists.
 */
NamedNodeMap.prototype.removeNamedItemNS = function(namespaceURI,  localName) {};

/**
 * Retrieves a node specified by local name and namespace URI. Per [XML Namespaces], applications must use the value null as the namespaceURI parameter for methods if they wish to have no namespace
 * @syntax namedNodeMap.getNamedItemNS(namespaceURI, localName)
 * @param {String} namespaceURI The namespace URI of the node to retrieve.
 * @param {String} localName The local name of the node to retrieve.
 * @returns {Node} A Node (of any type) with the specified local name and namespace URI, or null if they do not identify any node in this map.
 */
NamedNodeMap.prototype.getNamedItemNS = function(namespaceURI,  localName) {};

/**
 * Returns the indexth item in the map. If index is greater than or equal to the number of nodes in this map, this returns null.
 * @syntax namedNodeMap.item(index)
 * @param {Number} index Index into this map.
 * @returns {Node} The node at the indexth position in the map, or null if that is not a valid index.
 */
NamedNodeMap.prototype.item = function(index) {};

/**
 * The number of nodes in this map. The range of valid child node indices is 0 to length-1 inclusive.
 * @syntax namedNodeMap.length
 * @returns {Number} 
 */
NamedNodeMap.prototype.length = new Number();

/**
 * Adds a node using its nodeName attribute. If a node with that name is already present in this map, it is replaced by the new one. Replacing a node by itself has no effect. As the nodeName attribute is used to derive the name which the node must be stored under, multiple nodes of certain types (those that have a "special" string value) cannot be stored as the names would clash. This is seen as preferable to allowing nodes to be aliased
 * @syntax namedNodeMap.setNamedItem(arg)
 * @param {Node} arg A node to store in this map. The node will later be accessible using the value of its nodeName attribute.
 * @returns {Node} If the new Node replaces an existing node the replaced Node is returned, otherwise null is returned.
 */
NamedNodeMap.prototype.setNamedItem = function(arg) {};

/**
 * Removes a node specified by name. When this map contains the attributes attached to an element, if the removed attribute is known to have a default value, an attribute immediately appears containing the default value as well as the corresponding namespace URI, local name, and prefix when applicable
 * @syntax namedNodeMap.removeNamedItem(name)
 * @param {String} name The nodeName of the node to remove.
 * @returns {Node} The node removed from this map if a node with such a name exists.
 */
NamedNodeMap.prototype.removeNamedItem = function(name) {};

/**
 * Represents the NamedNodeMap prototype object.
 * @syntax NamedNodeMap.prototype
 * @static
 */
NamedNodeMap.prototype;

