# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2020 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx.model.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class ALGTypeNSService(VapiStruct):
    """
    An NSService element that represents an ALG protocol

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ALGTypeNSService"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    ALG_ORACLE_TNS = "ORACLE_TNS"
    """


    """
    ALG_FTP = "FTP"
    """


    """
    ALG_SUN_RPC_TCP = "SUN_RPC_TCP"
    """


    """
    ALG_SUN_RPC_UDP = "SUN_RPC_UDP"
    """


    """
    ALG_MS_RPC_TCP = "MS_RPC_TCP"
    """


    """
    ALG_MS_RPC_UDP = "MS_RPC_UDP"
    """


    """
    ALG_NBNS_BROADCAST = "NBNS_BROADCAST"
    """


    """
    ALG_NBDG_BROADCAST = "NBDG_BROADCAST"
    """


    """
    ALG_TFTP = "TFTP"
    """


    """



    _canonical_to_pep_names = {
                            'alg': 'alg',
                            'destination_ports': 'destination_ports',
                            'source_ports': 'source_ports',
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 alg=None,
                 destination_ports=None,
                 source_ports=None,
                 resource_type='ALGTypeNSService',
                ):
        """
        :type  alg: :class:`str` or ``None``
        :param alg: Possible values are: 
            
            * :attr:`ALGTypeNSService.ALG_ORACLE_TNS`
            * :attr:`ALGTypeNSService.ALG_FTP`
            * :attr:`ALGTypeNSService.ALG_SUN_RPC_TCP`
            * :attr:`ALGTypeNSService.ALG_SUN_RPC_UDP`
            * :attr:`ALGTypeNSService.ALG_MS_RPC_TCP`
            * :attr:`ALGTypeNSService.ALG_MS_RPC_UDP`
            * :attr:`ALGTypeNSService.ALG_NBNS_BROADCAST`
            * :attr:`ALGTypeNSService.ALG_NBDG_BROADCAST`
            * :attr:`ALGTypeNSService.ALG_TFTP`
            
            The Application Layer Gateway (ALG) protocol. Please note, protocol
            NBNS_BROADCAST and NBDG_BROADCAST are deprecated. Please use UDP
            protocol and create L4 Port Set type of service instead.
        :type  destination_ports: :class:`list` of :class:`str` or ``None``
        :param destination_ports: The destination_port cannot be empty and must be a single value.
            format: port-or-range
        :type  source_ports: :class:`list` of :class:`str` or ``None``
        :param source_ports: Source ports format: port-or-range
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`NSServiceElement.RESOURCE_TYPE_ETHERTYPENSSERVICE`
            * :attr:`NSServiceElement.RESOURCE_TYPE_IPPROTOCOLNSSERVICE`
            * :attr:`NSServiceElement.RESOURCE_TYPE_IGMPTYPENSSERVICE`
            * :attr:`NSServiceElement.RESOURCE_TYPE_ICMPTYPENSSERVICE`
            * :attr:`NSServiceElement.RESOURCE_TYPE_ALGTYPENSSERVICE`
            * :attr:`NSServiceElement.RESOURCE_TYPE_L4PORTSETNSSERVICE`
            
             The specific type of NSServiceElement
        """
        self.alg = alg
        self.destination_ports = destination_ports
        self.source_ports = source_ports
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ALGTypeNSService._set_binding_type(type.StructType(
    'com.vmware.nsx.model.ALG_type_NS_service', {
        'alg': type.OptionalType(type.StringType()),
        'destination_ports': type.OptionalType(type.ListType(type.StringType())),
        'source_ports': type.OptionalType(type.ListType(type.StringType())),
        'resource_type': type.StringType(),
    },
    ALGTypeNSService,
    False,
    None))



class AcceptableComponentVersion(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    COMPONENT_TYPE_HOST = "HOST"
    """


    """
    COMPONENT_TYPE_EDGE = "EDGE"
    """


    """
    COMPONENT_TYPE_CCP = "CCP"
    """


    """
    COMPONENT_TYPE_MP = "MP"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'acceptable_versions': 'acceptable_versions',
                            'component_type': 'component_type',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 acceptable_versions=None,
                 component_type=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  acceptable_versions: :class:`list` of :class:`str` or ``None``
        :param acceptable_versions: List of component versions
        :type  component_type: :class:`str` or ``None``
        :param component_type: Possible values are: 
            
            * :attr:`AcceptableComponentVersion.COMPONENT_TYPE_HOST`
            * :attr:`AcceptableComponentVersion.COMPONENT_TYPE_EDGE`
            * :attr:`AcceptableComponentVersion.COMPONENT_TYPE_CCP`
            * :attr:`AcceptableComponentVersion.COMPONENT_TYPE_MP`
            
             Node type
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.acceptable_versions = acceptable_versions
        self.component_type = component_type
        VapiStruct.__init__(self)


AcceptableComponentVersion._set_binding_type(type.StructType(
    'com.vmware.nsx.model.acceptable_component_version', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'acceptable_versions': type.OptionalType(type.ListType(type.StringType())),
        'component_type': type.OptionalType(type.StringType()),
    },
    AcceptableComponentVersion,
    False,
    None))



class AcceptableComponentVersionList(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'results': 'results',
                            }

    def __init__(self,
                 results=None,
                ):
        """
        :type  results: :class:`list` of :class:`AcceptableComponentVersion` or ``None``
        :param results: Acceptable version whitelist for different components
        """
        self.results = results
        VapiStruct.__init__(self)


AcceptableComponentVersionList._set_binding_type(type.StructType(
    'com.vmware.nsx.model.acceptable_component_version_list', {
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AcceptableComponentVersion'))),
    },
    AcceptableComponentVersionList,
    False,
    None))



class ActionableResource(VapiStruct):
    """
    Resources managed during restore process

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'ip_address': 'ip_address',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 ip_address=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  ip_address: :class:`str` or ``None``
        :param ip_address: A resource reference on which actions can be performed format:
            hostname-or-ip
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.ip_address = ip_address
        VapiStruct.__init__(self)


ActionableResource._set_binding_type(type.StructType(
    'com.vmware.nsx.model.actionable_resource', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'ip_address': type.OptionalType(type.StringType()),
    },
    ActionableResource,
    False,
    None))



class ActionableResourceListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ActionableResource` or ``None``
        :param results: List results
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ActionableResourceListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.actionable_resource_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ActionableResource'))),
    },
    ActionableResourceListResult,
    False,
    None))



class AddClusterNodeSpec(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'controller_role_config': 'controller_role_config',
                            'display_name': 'display_name',
                            'external_id': 'external_id',
                            'mgr_role_config': 'mgr_role_config',
                            }

    def __init__(self,
                 controller_role_config=None,
                 display_name=None,
                 external_id=None,
                 mgr_role_config=None,
                ):
        """
        :type  controller_role_config: :class:`AddControllerNodeSpec` or ``None``
        :param controller_role_config: 
        :type  display_name: :class:`str` or ``None``
        :param display_name: Display name for the node
        :type  external_id: :class:`str` or ``None``
        :param external_id: External identifier of the node
        :type  mgr_role_config: :class:`AddManagementNodeSpec` or ``None``
        :param mgr_role_config: 
        """
        self.controller_role_config = controller_role_config
        self.display_name = display_name
        self.external_id = external_id
        self.mgr_role_config = mgr_role_config
        VapiStruct.__init__(self)


AddClusterNodeSpec._set_binding_type(type.StructType(
    'com.vmware.nsx.model.add_cluster_node_spec', {
        'controller_role_config': type.OptionalType(type.ReferenceType(__name__, 'AddControllerNodeSpec')),
        'display_name': type.OptionalType(type.StringType()),
        'external_id': type.OptionalType(type.StringType()),
        'mgr_role_config': type.OptionalType(type.ReferenceType(__name__, 'AddManagementNodeSpec')),
    },
    AddClusterNodeSpec,
    False,
    None))



class AddClusterNodeVMInfo(VapiStruct):
    """
    Contains a list of cluster node VM deployment requests and optionally a
    clustering configuration.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'clustering_config': 'clustering_config',
                            'deployment_requests': 'deployment_requests',
                            }

    def __init__(self,
                 clustering_config=None,
                 deployment_requests=None,
                ):
        """
        :type  clustering_config: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param clustering_config: This property is deprecated since ClusteringConfig is no longer
            needed for auto-installation and will be ignored if provided.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ClusteringConfig`. When methods return a value of this
            class as a return value, the attribute will contain all the
            attributes defined in :class:`ClusteringConfig`.
        :type  deployment_requests: :class:`list` of :class:`ClusterNodeVMDeploymentRequest` or ``None``
        :param deployment_requests: Cluster node VM deployment requests to be deployed by the Manager.
        """
        self.clustering_config = clustering_config
        self.deployment_requests = deployment_requests
        VapiStruct.__init__(self)


AddClusterNodeVMInfo._set_binding_type(type.StructType(
    'com.vmware.nsx.model.add_cluster_node_VM_info', {
        'clustering_config': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ClusteringConfig')])),
        'deployment_requests': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ClusterNodeVMDeploymentRequest'))),
    },
    AddClusterNodeVMInfo,
    False,
    None))



class AddControllerNodeSpec(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_ADDCONTROLLERNODESPEC = "AddControllerNodeSpec"
    """


    """



    _canonical_to_pep_names = {
                            'clustering_params': 'clustering_params',
                            'control_plane_server_certificate': 'control_plane_server_certificate',
                            'host_msg_client_info': 'host_msg_client_info',
                            'mpa_msg_client_info': 'mpa_msg_client_info',
                            'node_id': 'node_id',
                            'type': 'type',
                            }

    def __init__(self,
                 clustering_params=None,
                 control_plane_server_certificate=None,
                 host_msg_client_info=None,
                 mpa_msg_client_info=None,
                 node_id=None,
                 type=None,
                ):
        """
        :type  clustering_params: :class:`ClusteringInfo` or ``None``
        :param clustering_params: The details of the controller node required for cluster
            initialization or joining to an existing cluster. If this property
            is set, the node will be added to an existing cluster or used to
            create a new cluster. Otherwise no clustering operation/s will be
            performed.
        :type  control_plane_server_certificate: :class:`str` or ``None``
        :param control_plane_server_certificate: Deprecated. Do not supply a value for this property.
        :type  host_msg_client_info: :class:`MsgClientInfo` or ``None``
        :param host_msg_client_info: 
        :type  mpa_msg_client_info: :class:`MsgClientInfo` or ``None``
        :param mpa_msg_client_info: 
        :type  node_id: :class:`str` or ``None``
        :param node_id: Only use this if an id for the node already exists with MP. If not
            specified, then the node_id will be set to a random id.
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`AddControllerNodeSpec.TYPE_ADDCONTROLLERNODESPEC`
            
             must be set to AddControllerNodeSpec
        """
        self.clustering_params = clustering_params
        self.control_plane_server_certificate = control_plane_server_certificate
        self.host_msg_client_info = host_msg_client_info
        self.mpa_msg_client_info = mpa_msg_client_info
        self.node_id = node_id
        self.type = type
        VapiStruct.__init__(self)


AddControllerNodeSpec._set_binding_type(type.StructType(
    'com.vmware.nsx.model.add_controller_node_spec', {
        'clustering_params': type.OptionalType(type.ReferenceType(__name__, 'ClusteringInfo')),
        'control_plane_server_certificate': type.OptionalType(type.StringType()),
        'host_msg_client_info': type.OptionalType(type.ReferenceType(__name__, 'MsgClientInfo')),
        'mpa_msg_client_info': type.OptionalType(type.ReferenceType(__name__, 'MsgClientInfo')),
        'node_id': type.OptionalType(type.StringType()),
        'type': type.OptionalType(type.StringType()),
    },
    AddControllerNodeSpec,
    False,
    None))



class AddIntelligenceClusterNodeVMInfo(VapiStruct):
    """
    Contains a list of NSX-Intelligence cluster node VM deployment requests and
    optionally a clustering configuration.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'deployment_requests': 'deployment_requests',
                            }

    def __init__(self,
                 deployment_requests=None,
                ):
        """
        :type  deployment_requests: :class:`list` of :class:`IntelligenceClusterNodeVMDeploymentRequest` or ``None``
        :param deployment_requests: Intelligence Cluster node VM deployment requests to be deployed by
            NSX.
        """
        self.deployment_requests = deployment_requests
        VapiStruct.__init__(self)


AddIntelligenceClusterNodeVMInfo._set_binding_type(type.StructType(
    'com.vmware.nsx.model.add_intelligence_cluster_node_VM_info', {
        'deployment_requests': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'IntelligenceClusterNodeVMDeploymentRequest'))),
    },
    AddIntelligenceClusterNodeVMInfo,
    False,
    None))



class AddManagementNodeSpec(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_ADDMANAGEMENTNODESPEC = "AddManagementNodeSpec"
    """


    """



    _canonical_to_pep_names = {
                            'cert_thumbprint': 'cert_thumbprint',
                            'mpa_msg_client_info': 'mpa_msg_client_info',
                            'password': 'password',
                            'remote_address': 'remote_address',
                            'type': 'type',
                            'user_name': 'user_name',
                            }

    def __init__(self,
                 cert_thumbprint=None,
                 mpa_msg_client_info=None,
                 password=None,
                 remote_address=None,
                 type=None,
                 user_name=None,
                ):
        """
        :type  cert_thumbprint: :class:`str` or ``None``
        :param cert_thumbprint: The certificate thumbprint of the remote node.
        :type  mpa_msg_client_info: :class:`MsgClientInfo` or ``None``
        :param mpa_msg_client_info: 
        :type  password: :class:`str` or ``None``
        :param password: The password to be used to authenticate with the remote node.
        :type  remote_address: :class:`str` or ``None``
        :param remote_address: The host address of the remote node to which to send this join
            request. format: ip
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`AddManagementNodeSpec.TYPE_ADDMANAGEMENTNODESPEC`
            
             must be set to AddManagementNodeSpec
        :type  user_name: :class:`str` or ``None``
        :param user_name: The username to be used to authenticate with the remote node.
        """
        self.cert_thumbprint = cert_thumbprint
        self.mpa_msg_client_info = mpa_msg_client_info
        self.password = password
        self.remote_address = remote_address
        self.type = type
        self.user_name = user_name
        VapiStruct.__init__(self)


AddManagementNodeSpec._set_binding_type(type.StructType(
    'com.vmware.nsx.model.add_management_node_spec', {
        'cert_thumbprint': type.OptionalType(type.StringType()),
        'mpa_msg_client_info': type.OptionalType(type.ReferenceType(__name__, 'MsgClientInfo')),
        'password': type.OptionalType(type.StringType()),
        'remote_address': type.OptionalType(type.StringType()),
        'type': type.OptionalType(type.StringType()),
        'user_name': type.OptionalType(type.StringType()),
    },
    AddManagementNodeSpec,
    False,
    None))



class AddressBindingEntry(VapiStruct):
    """
    An address binding entry is a combination of the IP-MAC-VLAN binding for a
    logical port. The address bindings can be obtained via various methods like
    ARP snooping, DHCP snooping etc. or by user configuration.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    SOURCE_INVALID = "INVALID"
    """


    """
    SOURCE_UNKNOWN = "UNKNOWN"
    """


    """
    SOURCE_USER_DEFINED = "USER_DEFINED"
    """


    """
    SOURCE_ARP_SNOOPING = "ARP_SNOOPING"
    """


    """
    SOURCE_DHCP_SNOOPING = "DHCP_SNOOPING"
    """


    """
    SOURCE_VM_TOOLS = "VM_TOOLS"
    """


    """
    SOURCE_ND_SNOOPING = "ND_SNOOPING"
    """


    """
    SOURCE_DHCPV6_SNOOPING = "DHCPV6_SNOOPING"
    """


    """
    SOURCE_VM_TOOLS_V6 = "VM_TOOLS_V6"
    """


    """



    _canonical_to_pep_names = {
                            'binding': 'binding',
                            'binding_timestamp': 'binding_timestamp',
                            'source': 'source',
                            }

    def __init__(self,
                 binding=None,
                 binding_timestamp=None,
                 source=None,
                ):
        """
        :type  binding: :class:`PacketAddressClassifier` or ``None``
        :param binding: Combination of IP-MAC-VLAN binding
        :type  binding_timestamp: :class:`long` or ``None``
        :param binding_timestamp: Timestamp at which the binding was discovered via snooping or
            manually specified by the user format: int64
        :type  source: :class:`str` or ``None``
        :param source: Possible values are: 
            
            * :attr:`AddressBindingEntry.SOURCE_INVALID`
            * :attr:`AddressBindingEntry.SOURCE_UNKNOWN`
            * :attr:`AddressBindingEntry.SOURCE_USER_DEFINED`
            * :attr:`AddressBindingEntry.SOURCE_ARP_SNOOPING`
            * :attr:`AddressBindingEntry.SOURCE_DHCP_SNOOPING`
            * :attr:`AddressBindingEntry.SOURCE_VM_TOOLS`
            * :attr:`AddressBindingEntry.SOURCE_ND_SNOOPING`
            * :attr:`AddressBindingEntry.SOURCE_DHCPV6_SNOOPING`
            * :attr:`AddressBindingEntry.SOURCE_VM_TOOLS_V6`
            
             Source from which the address binding entry was obtained
        """
        self.binding = binding
        self.binding_timestamp = binding_timestamp
        self.source = source
        VapiStruct.__init__(self)


AddressBindingEntry._set_binding_type(type.StructType(
    'com.vmware.nsx.model.address_binding_entry', {
        'binding': type.OptionalType(type.ReferenceType(__name__, 'PacketAddressClassifier')),
        'binding_timestamp': type.OptionalType(type.IntegerType()),
        'source': type.OptionalType(type.StringType()),
    },
    AddressBindingEntry,
    False,
    None))



class AdvanceClusterRestoreInput(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'id': 'id',
                            'resources': 'resources',
                            }

    def __init__(self,
                 id=None,
                 resources=None,
                ):
        """
        :type  id: :class:`str` or ``None``
        :param id: Unique id of an instruction (as returned by the GET /restore/status
            call) for which input is to be provided
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  resources: :class:`list` of :class:`SelectableResourceReference` or ``None``
        :param resources: List of resources for which the instruction is applicable.
        """
        self.id = id
        self.resources = resources
        VapiStruct.__init__(self)


AdvanceClusterRestoreInput._set_binding_type(type.StructType(
    'com.vmware.nsx.model.advance_cluster_restore_input', {
        'id': type.OptionalType(type.StringType()),
        'resources': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'SelectableResourceReference'))),
    },
    AdvanceClusterRestoreInput,
    False,
    None))



class AdvanceClusterRestoreRequest(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'data': 'data',
                            }

    def __init__(self,
                 data=None,
                ):
        """
        :type  data: :class:`list` of :class:`AdvanceClusterRestoreInput` or ``None``
        :param data: List of instructions and their associated data
        """
        self.data = data
        VapiStruct.__init__(self)


AdvanceClusterRestoreRequest._set_binding_type(type.StructType(
    'com.vmware.nsx.model.advance_cluster_restore_request', {
        'data': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AdvanceClusterRestoreInput'))),
    },
    AdvanceClusterRestoreRequest,
    False,
    None))



class AdvertiseRule(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ACTION_DENY = "DENY"
    """


    """
    ACTION_ALLOW = "ALLOW"
    """


    """



    _canonical_to_pep_names = {
                            'action': 'action',
                            'description': 'description',
                            'display_name': 'display_name',
                            'networks': 'networks',
                            'rule_filter': 'rule_filter',
                            }

    def __init__(self,
                 action=None,
                 description=None,
                 display_name=None,
                 networks=None,
                 rule_filter=None,
                ):
        """
        :type  action: :class:`str` or ``None``
        :param action: Possible values are: 
            
            * :attr:`AdvertiseRule.ACTION_DENY`
            * :attr:`AdvertiseRule.ACTION_ALLOW`
            
            ALLOW action enables the advertisment and DENY action disables the
            advertisement of a filtered routes to the connected TIER0 router.
        :type  description: :class:`str` or ``None``
        :param description: Description
        :type  display_name: :class:`str` or ``None``
        :param display_name: Display name
        :type  networks: :class:`list` of :class:`str` or ``None``
        :param networks: network(CIDR) to be routed format: ip-cidr-block
        :type  rule_filter: :class:`AdvertisementRuleFilter` or ``None``
        :param rule_filter: Rule filter for the advertise rule
        """
        self.action = action
        self.description = description
        self.display_name = display_name
        self.networks = networks
        self.rule_filter = rule_filter
        VapiStruct.__init__(self)


AdvertiseRule._set_binding_type(type.StructType(
    'com.vmware.nsx.model.advertise_rule', {
        'action': type.OptionalType(type.StringType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'networks': type.OptionalType(type.ListType(type.StringType())),
        'rule_filter': type.OptionalType(type.ReferenceType(__name__, 'AdvertisementRuleFilter')),
    },
    AdvertiseRule,
    False,
    None))



class AdvertiseRuleList(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'logical_router_id': 'logical_router_id',
                            'rules': 'rules',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 logical_router_id=None,
                 rules=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  logical_router_id: :class:`str` or ``None``
        :param logical_router_id: Logical router id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  rules: :class:`list` of :class:`AdvertiseRule` or ``None``
        :param rules: List of advertisement rules
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.logical_router_id = logical_router_id
        self.rules = rules
        VapiStruct.__init__(self)


AdvertiseRuleList._set_binding_type(type.StructType(
    'com.vmware.nsx.model.advertise_rule_list', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'logical_router_id': type.OptionalType(type.StringType()),
        'rules': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AdvertiseRule'))),
    },
    AdvertiseRuleList,
    False,
    None))



class AdvertisementConfig(VapiStruct):
    """
    Advertisement config for different types of routes which need to be
    advertised from TIER1 logical router to the linked TIER0 logical router

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'advertise_dns_forwarder': 'advertise_dns_forwarder',
                            'advertise_ipsec_local_ip': 'advertise_ipsec_local_ip',
                            'advertise_lb_snat_ip': 'advertise_lb_snat_ip',
                            'advertise_lb_vip': 'advertise_lb_vip',
                            'advertise_nat_routes': 'advertise_nat_routes',
                            'advertise_nsx_connected_routes': 'advertise_nsx_connected_routes',
                            'advertise_static_routes': 'advertise_static_routes',
                            'enabled': 'enabled',
                            'logical_router_id': 'logical_router_id',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 advertise_dns_forwarder=None,
                 advertise_ipsec_local_ip=None,
                 advertise_lb_snat_ip=None,
                 advertise_lb_vip=None,
                 advertise_nat_routes=None,
                 advertise_nsx_connected_routes=None,
                 advertise_static_routes=None,
                 enabled=None,
                 logical_router_id=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  advertise_dns_forwarder: :class:`bool` or ``None``
        :param advertise_dns_forwarder: Flag to advertise all routes of dns forwarder listener ips and
            source ips
        :type  advertise_ipsec_local_ip: :class:`bool` or ``None``
        :param advertise_ipsec_local_ip: Flag to advertise all IPSec VPN local endpoint ips to linked TIER0
            logical router
        :type  advertise_lb_snat_ip: :class:`bool` or ``None``
        :param advertise_lb_snat_ip: Flag to advertise all lb SNAT ips
        :type  advertise_lb_vip: :class:`bool` or ``None``
        :param advertise_lb_vip: Flag to advertise lb vip ips
        :type  advertise_nat_routes: :class:`bool` or ``None``
        :param advertise_nat_routes: Flag to advertise all routes of nat
        :type  advertise_nsx_connected_routes: :class:`bool` or ``None``
        :param advertise_nsx_connected_routes: Flag to advertise all connected routes
        :type  advertise_static_routes: :class:`bool` or ``None``
        :param advertise_static_routes: Flag to advertise all static routes
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Flag to enable this configuration
        :type  logical_router_id: :class:`str` or ``None``
        :param logical_router_id: TIER1 logical router id on which to enable this configuration
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.advertise_dns_forwarder = advertise_dns_forwarder
        self.advertise_ipsec_local_ip = advertise_ipsec_local_ip
        self.advertise_lb_snat_ip = advertise_lb_snat_ip
        self.advertise_lb_vip = advertise_lb_vip
        self.advertise_nat_routes = advertise_nat_routes
        self.advertise_nsx_connected_routes = advertise_nsx_connected_routes
        self.advertise_static_routes = advertise_static_routes
        self.enabled = enabled
        self.logical_router_id = logical_router_id
        VapiStruct.__init__(self)


AdvertisementConfig._set_binding_type(type.StructType(
    'com.vmware.nsx.model.advertisement_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'advertise_dns_forwarder': type.OptionalType(type.BooleanType()),
        'advertise_ipsec_local_ip': type.OptionalType(type.BooleanType()),
        'advertise_lb_snat_ip': type.OptionalType(type.BooleanType()),
        'advertise_lb_vip': type.OptionalType(type.BooleanType()),
        'advertise_nat_routes': type.OptionalType(type.BooleanType()),
        'advertise_nsx_connected_routes': type.OptionalType(type.BooleanType()),
        'advertise_static_routes': type.OptionalType(type.BooleanType()),
        'enabled': type.OptionalType(type.BooleanType()),
        'logical_router_id': type.OptionalType(type.StringType()),
    },
    AdvertisementConfig,
    False,
    None))



class AdvertisementRuleFilter(VapiStruct):
    """
    To filter the routes advertised by the TIER1 LR to TIER0 LR. Filtering will
    be based on the type of route and the prefix operator configured.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MATCH_ROUTE_TYPES_ANY = "ANY"
    """


    """
    MATCH_ROUTE_TYPES_STATIC = "STATIC"
    """


    """
    MATCH_ROUTE_TYPES_T1_STATIC = "T1_STATIC"
    """


    """
    MATCH_ROUTE_TYPES_NSX_CONNECTED = "NSX_CONNECTED"
    """


    """
    MATCH_ROUTE_TYPES_T1_CONNECTED = "T1_CONNECTED"
    """


    """
    MATCH_ROUTE_TYPES_T1_NAT = "T1_NAT"
    """


    """
    MATCH_ROUTE_TYPES_T1_LB_VIP = "T1_LB_VIP"
    """


    """
    MATCH_ROUTE_TYPES_T1_LB_SNAT = "T1_LB_SNAT"
    """


    """
    MATCH_ROUTE_TYPES_T1_DNSFORWARDER = "T1_DNSFORWARDER"
    """


    """
    MATCH_ROUTE_TYPES_T1_IPSEC_LOCAL_IP = "T1_IPSEC_LOCAL_IP"
    """


    """
    PREFIX_OPERATOR_GE = "GE"
    """


    """
    PREFIX_OPERATOR_EQ = "EQ"
    """


    """



    _canonical_to_pep_names = {
                            'match_route_types': 'match_route_types',
                            'prefix_operator': 'prefix_operator',
                            }

    def __init__(self,
                 match_route_types=None,
                 prefix_operator=None,
                ):
        """
        :type  match_route_types: :class:`list` of :class:`str` or ``None``
        :param match_route_types: Possible values are: 
            
            * :attr:`AdvertisementRuleFilter.MATCH_ROUTE_TYPES_ANY`
            * :attr:`AdvertisementRuleFilter.MATCH_ROUTE_TYPES_STATIC`
            * :attr:`AdvertisementRuleFilter.MATCH_ROUTE_TYPES_T1_STATIC`
            * :attr:`AdvertisementRuleFilter.MATCH_ROUTE_TYPES_NSX_CONNECTED`
            * :attr:`AdvertisementRuleFilter.MATCH_ROUTE_TYPES_T1_CONNECTED`
            * :attr:`AdvertisementRuleFilter.MATCH_ROUTE_TYPES_T1_NAT`
            * :attr:`AdvertisementRuleFilter.MATCH_ROUTE_TYPES_T1_LB_VIP`
            * :attr:`AdvertisementRuleFilter.MATCH_ROUTE_TYPES_T1_LB_SNAT`
            * :attr:`AdvertisementRuleFilter.MATCH_ROUTE_TYPES_T1_DNSFORWARDER`
            *
              :attr:`AdvertisementRuleFilter.MATCH_ROUTE_TYPES_T1_IPSEC_LOCAL_IP`
            
             Array of route types to filter routes
        :type  prefix_operator: :class:`str` or ``None``
        :param prefix_operator: Possible values are: 
            
            * :attr:`AdvertisementRuleFilter.PREFIX_OPERATOR_GE`
            * :attr:`AdvertisementRuleFilter.PREFIX_OPERATOR_EQ`
            
            GE prefix operator filters all the routes having network subset of
            any of the networks configured in Advertise rule. EQ prefix
            operator filter all the routes having network equal to any of the
            network configured in Advertise rule.
        """
        self.match_route_types = match_route_types
        self.prefix_operator = prefix_operator
        VapiStruct.__init__(self)


AdvertisementRuleFilter._set_binding_type(type.StructType(
    'com.vmware.nsx.model.advertisement_rule_filter', {
        'match_route_types': type.OptionalType(type.ListType(type.StringType())),
        'prefix_operator': type.OptionalType(type.StringType()),
    },
    AdvertisementRuleFilter,
    False,
    None))



class AgentStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    NAME_AGENT = "NSX_AGENT"
    """


    """
    NAME_OPSAGENT = "NSX_OPSAGENT"
    """


    """
    NAME_CFGAGENT = "NSX_CFGAGENT"
    """


    """
    NAME_NESTDB = "NSX_NESTDB"
    """


    """
    STATUS_UP = "UP"
    """


    """
    STATUS_DOWN = "DOWN"
    """


    """
    STATUS_UNKNOWN = "UNKNOWN"
    """


    """



    _canonical_to_pep_names = {
                            'name': 'name',
                            'status': 'status',
                            }

    def __init__(self,
                 name=None,
                 status=None,
                ):
        """
        :type  name: :class:`str` or ``None``
        :param name: Possible values are: 
            
            * :attr:`AgentStatus.NAME_AGENT`
            * :attr:`AgentStatus.NAME_OPSAGENT`
            * :attr:`AgentStatus.NAME_CFGAGENT`
            * :attr:`AgentStatus.NAME_NESTDB`
            
             Agent name
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`AgentStatus.STATUS_UP`
            * :attr:`AgentStatus.STATUS_DOWN`
            * :attr:`AgentStatus.STATUS_UNKNOWN`
            
             Agent status
        """
        self.name = name
        self.status = status
        VapiStruct.__init__(self)


AgentStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.agent_status', {
        'name': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
    },
    AgentStatus,
    False,
    None))



class AgentStatusCount(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_UP = "UP"
    """


    """
    STATUS_DOWN = "DOWN"
    """


    """
    STATUS_UNKNOWN = "UNKNOWN"
    """


    """



    _canonical_to_pep_names = {
                            'agents': 'agents',
                            'down_count': 'down_count',
                            'status': 'status',
                            'up_count': 'up_count',
                            }

    def __init__(self,
                 agents=None,
                 down_count=None,
                 status=None,
                 up_count=None,
                ):
        """
        :type  agents: :class:`list` of :class:`AgentStatus` or ``None``
        :param agents: List of agent statuses belonging to the transport node
        :type  down_count: :class:`long` or ``None``
        :param down_count: Down count format: int32
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`AgentStatusCount.STATUS_UP`
            * :attr:`AgentStatusCount.STATUS_DOWN`
            * :attr:`AgentStatusCount.STATUS_UNKNOWN`
            
             Roll-up agent status
        :type  up_count: :class:`long` or ``None``
        :param up_count: Up count format: int32
        """
        self.agents = agents
        self.down_count = down_count
        self.status = status
        self.up_count = up_count
        VapiStruct.__init__(self)


AgentStatusCount._set_binding_type(type.StructType(
    'com.vmware.nsx.model.agent_status_count', {
        'agents': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AgentStatus'))),
        'down_count': type.OptionalType(type.IntegerType()),
        'status': type.OptionalType(type.StringType()),
        'up_count': type.OptionalType(type.IntegerType()),
    },
    AgentStatusCount,
    False,
    None))



class AggregatedDataCounter(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'rx_bytes': 'rx_bytes',
                            'rx_packets': 'rx_packets',
                            'tx_bytes': 'tx_bytes',
                            'tx_packets': 'tx_packets',
                            }

    def __init__(self,
                 rx_bytes=None,
                 rx_packets=None,
                 tx_bytes=None,
                 tx_packets=None,
                ):
        """
        :type  rx_bytes: :class:`DataCounter` or ``None``
        :param rx_bytes: 
        :type  rx_packets: :class:`DataCounter` or ``None``
        :param rx_packets: 
        :type  tx_bytes: :class:`DataCounter` or ``None``
        :param tx_bytes: 
        :type  tx_packets: :class:`DataCounter` or ``None``
        :param tx_packets: 
        """
        self.rx_bytes = rx_bytes
        self.rx_packets = rx_packets
        self.tx_bytes = tx_bytes
        self.tx_packets = tx_packets
        VapiStruct.__init__(self)


AggregatedDataCounter._set_binding_type(type.StructType(
    'com.vmware.nsx.model.aggregated_data_counter', {
        'rx_bytes': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'rx_packets': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'tx_bytes': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'tx_packets': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
    },
    AggregatedDataCounter,
    False,
    None))



class AggregatedDataCounterEx(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'rx_bytes': 'rx_bytes',
                            'rx_packets': 'rx_packets',
                            'tx_bytes': 'tx_bytes',
                            'tx_packets': 'tx_packets',
                            'dropped_by_security_packets': 'dropped_by_security_packets',
                            'mac_learning': 'mac_learning',
                            }

    def __init__(self,
                 rx_bytes=None,
                 rx_packets=None,
                 tx_bytes=None,
                 tx_packets=None,
                 dropped_by_security_packets=None,
                 mac_learning=None,
                ):
        """
        :type  rx_bytes: :class:`DataCounter` or ``None``
        :param rx_bytes: 
        :type  rx_packets: :class:`DataCounter` or ``None``
        :param rx_packets: 
        :type  tx_bytes: :class:`DataCounter` or ``None``
        :param tx_bytes: 
        :type  tx_packets: :class:`DataCounter` or ``None``
        :param tx_packets: 
        :type  dropped_by_security_packets: :class:`PacketsDroppedBySecurity` or ``None``
        :param dropped_by_security_packets: 
        :type  mac_learning: :class:`MacLearningCounters` or ``None``
        :param mac_learning: 
        """
        self.rx_bytes = rx_bytes
        self.rx_packets = rx_packets
        self.tx_bytes = tx_bytes
        self.tx_packets = tx_packets
        self.dropped_by_security_packets = dropped_by_security_packets
        self.mac_learning = mac_learning
        VapiStruct.__init__(self)


AggregatedDataCounterEx._set_binding_type(type.StructType(
    'com.vmware.nsx.model.aggregated_data_counter_ex', {
        'rx_bytes': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'rx_packets': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'tx_bytes': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'tx_packets': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'dropped_by_security_packets': type.OptionalType(type.ReferenceType(__name__, 'PacketsDroppedBySecurity')),
        'mac_learning': type.OptionalType(type.ReferenceType(__name__, 'MacLearningCounters')),
    },
    AggregatedDataCounterEx,
    False,
    None))



class AggregatedLogicalRouterPortCounters(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'last_update_timestamp': 'last_update_timestamp',
                            'rx': 'rx',
                            'tx': 'tx',
                            }

    def __init__(self,
                 last_update_timestamp=None,
                 rx=None,
                 tx=None,
                ):
        """
        :type  last_update_timestamp: :class:`long` or ``None``
        :param last_update_timestamp: Timestamp when the data was last updated; unset if data source has
            never updated the data. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  rx: :class:`LogicalRouterPortCounters` or ``None``
        :param rx: 
        :type  tx: :class:`LogicalRouterPortCounters` or ``None``
        :param tx: 
        """
        self.last_update_timestamp = last_update_timestamp
        self.rx = rx
        self.tx = tx
        VapiStruct.__init__(self)


AggregatedLogicalRouterPortCounters._set_binding_type(type.StructType(
    'com.vmware.nsx.model.aggregated_logical_router_port_counters', {
        'last_update_timestamp': type.OptionalType(type.IntegerType()),
        'rx': type.OptionalType(type.ReferenceType(__name__, 'LogicalRouterPortCounters')),
        'tx': type.OptionalType(type.ReferenceType(__name__, 'LogicalRouterPortCounters')),
    },
    AggregatedLogicalRouterPortCounters,
    False,
    None))



class Alarm(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ALARM_SOURCE_TYPE_INTENT_PATH = "INTENT_PATH"
    """


    """
    ALARM_SOURCE_TYPE_ENTITY_ID = "ENTITY_ID"
    """


    """
    SEVERITY_CRITICAL = "CRITICAL"
    """


    """
    SEVERITY_HIGH = "HIGH"
    """


    """
    SEVERITY_MEDIUM = "MEDIUM"
    """


    """
    SEVERITY_LOW = "LOW"
    """


    """
    STATUS_OPEN = "OPEN"
    """


    """
    STATUS_ACKNOWLEDGED = "ACKNOWLEDGED"
    """


    """
    STATUS_SUPPRESSED = "SUPPRESSED"
    """


    """
    STATUS_RESOLVED = "RESOLVED"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'alarm_source': 'alarm_source',
                            'alarm_source_type': 'alarm_source_type',
                            'entity_id': 'entity_id',
                            'entity_resource_type': 'entity_resource_type',
                            'event_type': 'event_type',
                            'event_type_display_name': 'event_type_display_name',
                            'feature_display_name': 'feature_display_name',
                            'feature_name': 'feature_name',
                            'last_reported_time': 'last_reported_time',
                            'node_display_name': 'node_display_name',
                            'node_id': 'node_id',
                            'node_ip_addresses': 'node_ip_addresses',
                            'node_resource_type': 'node_resource_type',
                            'recommended_action': 'recommended_action',
                            'reoccurrences_while_suppressed': 'reoccurrences_while_suppressed',
                            'resolved_by': 'resolved_by',
                            'resolved_time': 'resolved_time',
                            'severity': 'severity',
                            'status': 'status',
                            'summary': 'summary',
                            'suppress_duration': 'suppress_duration',
                            'suppress_start_time': 'suppress_start_time',
                            'suppressed_by': 'suppressed_by',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 alarm_source=None,
                 alarm_source_type=None,
                 entity_id=None,
                 entity_resource_type=None,
                 event_type=None,
                 event_type_display_name=None,
                 feature_display_name=None,
                 feature_name=None,
                 last_reported_time=None,
                 node_display_name=None,
                 node_id=None,
                 node_ip_addresses=None,
                 node_resource_type=None,
                 recommended_action=None,
                 reoccurrences_while_suppressed=None,
                 resolved_by=None,
                 resolved_time=None,
                 severity=None,
                 status=None,
                 summary=None,
                 suppress_duration=None,
                 suppress_start_time=None,
                 suppressed_by=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Detailed description of Alarm. This is the same detailed
            description as the corresponding Event identified by
            feature_name.event_type.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: ID that uniquely identifies an Alarm.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  alarm_source: :class:`list` of :class:`str` or ``None``
        :param alarm_source: If alarm_source_type = INTENT_PATH, this field will contain a list
            of intent paths for the entity that the event instance applies to.
            If alarm_source_type = ENTITY_ID, this field will contain a list
            with a single item identifying the entity id that the event
            instance applies to.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  alarm_source_type: :class:`str` or ``None``
        :param alarm_source_type: Possible values are: 
            
            * :attr:`Alarm.ALARM_SOURCE_TYPE_INTENT_PATH`
            * :attr:`Alarm.ALARM_SOURCE_TYPE_ENTITY_ID`
            
            Type of alarm source of the Event instance. Can be one of -
            INTENT_PATH, ENTITY_ID.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  entity_id: :class:`str` or ``None``
        :param entity_id: The entity that the Event instance applies to. Note entity_id may
            not be included in a response body. For example, the cpu_high Event
            may not return an entity_id.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  entity_resource_type: :class:`str` or ``None``
        :param entity_resource_type: The entity type that the Event instance applies to.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  event_type: :class:`str` or ``None``
        :param event_type: Name of Event, e.g. manager_cpu_usage_high, certificate_expired.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  event_type_display_name: :class:`str` or ``None``
        :param event_type_display_name: Display name of Event type.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  feature_display_name: :class:`str` or ``None``
        :param feature_display_name: Display name of feature defining this Event.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  feature_name: :class:`str` or ``None``
        :param feature_name: Feature defining this Event, e.g. manager_health, certificates.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_reported_time: :class:`long` or ``None``
        :param last_reported_time: Indicates when the corresponding Event instance was last reported
            in milliseconds since epoch. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_display_name: :class:`str` or ``None``
        :param node_display_name: Display name of node that the event instance applies to.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_id: :class:`str` or ``None``
        :param node_id: The UUID of the node that the Event instance applies to.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_ip_addresses: :class:`list` of :class:`str` or ``None``
        :param node_ip_addresses: IP addresses of node that the event instance applies to.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_resource_type: :class:`str` or ``None``
        :param node_resource_type: The resource type of node that the Event instance applies to eg.
            ClusterNodeConfig, HostNode, EdgeNode.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  recommended_action: :class:`str` or ``None``
        :param recommended_action: Recommended action for Alarm. This is the same action as the
            corresponding Event identified by feature_name.event_type.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  reoccurrences_while_suppressed: :class:`long` or ``None``
        :param reoccurrences_while_suppressed: The number of reoccurrences since this alarm has been SUPPRESSED.
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  resolved_by: :class:`str` or ``None``
        :param resolved_by: User ID of the user that set the status value to RESOLVED. This
            value can be SYSTEM to indicate that the system resolved the Alarm,
            for example when the system determines CPU usage is no longer high
            and the cpu_high Alarm is no longer applicable. This property is
            only returned when the status value is RESOLVED.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  resolved_time: :class:`long` or ``None``
        :param resolved_time: Indicates when the Alarm was resolved in milliseconds since epoch.
            This property is only returned when the status value is RESOLVED.
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  severity: :class:`str` or ``None``
        :param severity: Possible values are: 
            
            * :attr:`Alarm.SEVERITY_CRITICAL`
            * :attr:`Alarm.SEVERITY_HIGH`
            * :attr:`Alarm.SEVERITY_MEDIUM`
            * :attr:`Alarm.SEVERITY_LOW`
            
             Severity of the Alarm.Can be one of - CRITICAL, HIGH, MEDIUM, LOW.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`Alarm.STATUS_OPEN`
            * :attr:`Alarm.STATUS_ACKNOWLEDGED`
            * :attr:`Alarm.STATUS_SUPPRESSED`
            * :attr:`Alarm.STATUS_RESOLVED`
            
             Indicate the status which the Alarm is in.
        :type  summary: :class:`str` or ``None``
        :param summary: Summary description of Alarm. This is the same summary description
            as the corresponding Event identified by feature_name.event_type.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  suppress_duration: :class:`long` or ``None``
        :param suppress_duration: The time period between suppress_start_time and suppress_start_time
            + suppress_duration (specified in hours) an Alarm is SUPPRESSED.
            This property is only returned when the status value is SUPPRESSED.
            format: int64
        :type  suppress_start_time: :class:`long` or ``None``
        :param suppress_start_time: Indicates when the Alarm was suppressed in milliseconds since
            epoch. This property is only returned when the status value is
            SUPPRESSED. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  suppressed_by: :class:`str` or ``None``
        :param suppressed_by: User ID of the user that set the status value to SUPPRESSED. This
            property is only returned when the status value is SUPPRESSED.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.alarm_source = alarm_source
        self.alarm_source_type = alarm_source_type
        self.entity_id = entity_id
        self.entity_resource_type = entity_resource_type
        self.event_type = event_type
        self.event_type_display_name = event_type_display_name
        self.feature_display_name = feature_display_name
        self.feature_name = feature_name
        self.last_reported_time = last_reported_time
        self.node_display_name = node_display_name
        self.node_id = node_id
        self.node_ip_addresses = node_ip_addresses
        self.node_resource_type = node_resource_type
        self.recommended_action = recommended_action
        self.reoccurrences_while_suppressed = reoccurrences_while_suppressed
        self.resolved_by = resolved_by
        self.resolved_time = resolved_time
        self.severity = severity
        self.status = status
        self.summary = summary
        self.suppress_duration = suppress_duration
        self.suppress_start_time = suppress_start_time
        self.suppressed_by = suppressed_by
        VapiStruct.__init__(self)


Alarm._set_binding_type(type.StructType(
    'com.vmware.nsx.model.alarm', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'alarm_source': type.OptionalType(type.ListType(type.StringType())),
        'alarm_source_type': type.OptionalType(type.StringType()),
        'entity_id': type.OptionalType(type.StringType()),
        'entity_resource_type': type.OptionalType(type.StringType()),
        'event_type': type.OptionalType(type.StringType()),
        'event_type_display_name': type.OptionalType(type.StringType()),
        'feature_display_name': type.OptionalType(type.StringType()),
        'feature_name': type.OptionalType(type.StringType()),
        'last_reported_time': type.OptionalType(type.IntegerType()),
        'node_display_name': type.OptionalType(type.StringType()),
        'node_id': type.OptionalType(type.StringType()),
        'node_ip_addresses': type.OptionalType(type.ListType(type.StringType())),
        'node_resource_type': type.OptionalType(type.StringType()),
        'recommended_action': type.OptionalType(type.StringType()),
        'reoccurrences_while_suppressed': type.OptionalType(type.IntegerType()),
        'resolved_by': type.OptionalType(type.StringType()),
        'resolved_time': type.OptionalType(type.IntegerType()),
        'severity': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
        'summary': type.OptionalType(type.StringType()),
        'suppress_duration': type.OptionalType(type.IntegerType()),
        'suppress_start_time': type.OptionalType(type.IntegerType()),
        'suppressed_by': type.OptionalType(type.StringType()),
    },
    Alarm,
    False,
    None))



class AlarmListResult(VapiStruct):
    """
    Alarm collection results

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`Alarm` or ``None``
        :param results: Alarm results
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


AlarmListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.alarm_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Alarm'))),
    },
    AlarmListResult,
    False,
    None))



class AlarmsListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`Alarm` or ``None``
        :param results: List of alarms known to the system
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


AlarmsListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.alarms_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Alarm'))),
    },
    AlarmsListResult,
    False,
    None))



class AllClusterGroupStatus(VapiStruct):
    """
    A list of the statuses of all the groups in the cluster.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    OVERALL_STATUS_STABLE = "STABLE"
    """


    """
    OVERALL_STATUS_DEGRADED = "DEGRADED"
    """


    """
    OVERALL_STATUS_UNAVAILABLE = "UNAVAILABLE"
    """


    """



    _canonical_to_pep_names = {
                            'cluster_id': 'cluster_id',
                            'groups': 'groups',
                            'overall_status': 'overall_status',
                            }

    def __init__(self,
                 cluster_id=None,
                 groups=None,
                 overall_status=None,
                ):
        """
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: UUID of the cluster
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  groups: :class:`list` of :class:`ClusterGroupStatus` or ``None``
        :param groups: Array of groups and their statuses
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overall_status: :class:`str` or ``None``
        :param overall_status: Possible values are: 
            
            * :attr:`AllClusterGroupStatus.OVERALL_STATUS_STABLE`
            * :attr:`AllClusterGroupStatus.OVERALL_STATUS_DEGRADED`
            * :attr:`AllClusterGroupStatus.OVERALL_STATUS_UNAVAILABLE`
            
             Overall status of the cluster
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.cluster_id = cluster_id
        self.groups = groups
        self.overall_status = overall_status
        VapiStruct.__init__(self)


AllClusterGroupStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.all_cluster_group_status', {
        'cluster_id': type.OptionalType(type.StringType()),
        'groups': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ClusterGroupStatus'))),
        'overall_status': type.OptionalType(type.StringType()),
    },
    AllClusterGroupStatus,
    False,
    None))



class AllocatedService(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    HIGH_AVAILABILITY_STATUS_ACTIVE = "ACTIVE"
    """


    """
    HIGH_AVAILABILITY_STATUS_STANDBY = "STANDBY"
    """


    """
    HIGH_AVAILABILITY_STATUS_DOWN = "DOWN"
    """


    """
    HIGH_AVAILABILITY_STATUS_SYNC = "SYNC"
    """


    """
    HIGH_AVAILABILITY_STATUS_UNKNOWN = "UNKNOWN"
    """


    """



    _canonical_to_pep_names = {
                            'allocation_details': 'allocation_details',
                            'high_availability_status': 'high_availability_status',
                            'service_reference': 'service_reference',
                            }

    def __init__(self,
                 allocation_details=None,
                 high_availability_status=None,
                 service_reference=None,
                ):
        """
        :type  allocation_details: :class:`list` of :class:`KeyValuePair` or ``None``
        :param allocation_details: Additional properties of a service, say the sub_pool_size and
            sub_pool_type for a LoadBalancer.
        :type  high_availability_status: :class:`str` or ``None``
        :param high_availability_status: Possible values are: 
            
            * :attr:`AllocatedService.HIGH_AVAILABILITY_STATUS_ACTIVE`
            * :attr:`AllocatedService.HIGH_AVAILABILITY_STATUS_STANDBY`
            * :attr:`AllocatedService.HIGH_AVAILABILITY_STATUS_DOWN`
            * :attr:`AllocatedService.HIGH_AVAILABILITY_STATUS_SYNC`
            * :attr:`AllocatedService.HIGH_AVAILABILITY_STATUS_UNKNOWN`
            
             Represents the active or the standby state of the service.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  service_reference: :class:`ResourceReference` or ``None``
        :param service_reference: Id and Name of the service context configured on edge node.
        """
        self.allocation_details = allocation_details
        self.high_availability_status = high_availability_status
        self.service_reference = service_reference
        VapiStruct.__init__(self)


AllocatedService._set_binding_type(type.StructType(
    'com.vmware.nsx.model.allocated_service', {
        'allocation_details': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'KeyValuePair'))),
        'high_availability_status': type.OptionalType(type.StringType()),
        'service_reference': type.OptionalType(type.ReferenceType(__name__, 'ResourceReference')),
    },
    AllocatedService,
    False,
    None))



class AllocationBasedOnFailureDomain(VapiStruct):
    """
    Auto place TIER1 logical routers, DHCP and MDProxy contexts on two edge
    nodes (active and standby) from different failure domains.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AllocationBasedOnFailureDomain"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'enabled': 'enabled',
                            'action_type': 'action_type',
                            }

    def __init__(self,
                 enabled=None,
                 action_type='AllocationBasedOnFailureDomain',
                ):
        """
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Enable placement algorithm to consider failure domain of edge
            transport nodes and place active and standby contexts in different
            failure domains.
        :type  action_type: :class:`str`
        :param action_type: Possible values are: 
            
            *
              :attr:`AllocationRuleAction.ACTION_TYPE_ALLOCATIONBASEDONFAILUREDOMAIN`
            
            Set action for each allocation rule on edge cluster which will help
            in auto placement.
        """
        self.enabled = enabled
        self._action_type = action_type
        VapiStruct.__init__(self)

    @property
    def action_type(self):
        """
        Return the discriminator value
        """
        return self._action_type

AllocationBasedOnFailureDomain._set_binding_type(type.StructType(
    'com.vmware.nsx.model.allocation_based_on_failure_domain', {
        'enabled': type.OptionalType(type.BooleanType()),
        'action_type': type.StringType(),
    },
    AllocationBasedOnFailureDomain,
    False,
    None))



class AllocationIpAddress(VapiStruct):
    """
    Allocation parameters for the IP address (e.g. specific IP address) can be
    specified. Tags, display_name and description attributes are not supported
    in this release.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'allocation_id': 'allocation_id',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 allocation_id=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  allocation_id: :class:`str` or ``None``
        :param allocation_id: Address that is allocated from pool format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.allocation_id = allocation_id
        VapiStruct.__init__(self)


AllocationIpAddress._set_binding_type(type.StructType(
    'com.vmware.nsx.model.allocation_ip_address', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'allocation_id': type.OptionalType(type.StringType()),
    },
    AllocationIpAddress,
    False,
    None))



class AllocationIpAddressListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`AllocationIpAddress` or ``None``
        :param results: Pool allocation list results
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


AllocationIpAddressListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.allocation_ip_address_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AllocationIpAddress'))),
    },
    AllocationIpAddressListResult,
    False,
    None))



class AllocationPool(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'active_service_count': 'active_service_count',
                            'standby_service_count': 'standby_service_count',
                            'sub_pools': 'sub_pools',
                            }

    def __init__(self,
                 active_service_count=None,
                 standby_service_count=None,
                 sub_pools=None,
                ):
        """
        :type  active_service_count: :class:`long` or ``None``
        :param active_service_count: Represents the number of acitve services running on the edge node.
            format: int32
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  standby_service_count: :class:`long` or ``None``
        :param standby_service_count: Represents the number of standby services running on the edge node.
            format: int32
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sub_pools: :class:`list` of :class:`SubPool` or ``None``
        :param sub_pools: Allocation details of sub-pools configured on edge node.
        """
        self.active_service_count = active_service_count
        self.standby_service_count = standby_service_count
        self.sub_pools = sub_pools
        VapiStruct.__init__(self)


AllocationPool._set_binding_type(type.StructType(
    'com.vmware.nsx.model.allocation_pool', {
        'active_service_count': type.OptionalType(type.IntegerType()),
        'standby_service_count': type.OptionalType(type.IntegerType()),
        'sub_pools': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'SubPool'))),
    },
    AllocationPool,
    False,
    None))



class AllocationRule(VapiStruct):
    """
    Allocation rule on edge cluster which will be considered in auto placement
    of TIER1 logical routers, DHCP and MDProxy.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'action': 'action',
                            }

    def __init__(self,
                 action=None,
                ):
        """
        :type  action: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param action: Set action for each allocation rule
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`AllocationRuleAction`. When methods return a value of this
            class as a return value, the attribute will contain all the
            attributes defined in :class:`AllocationRuleAction`.
        """
        self.action = action
        VapiStruct.__init__(self)


AllocationRule._set_binding_type(type.StructType(
    'com.vmware.nsx.model.allocation_rule', {
        'action': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'AllocationRuleAction')])),
    },
    AllocationRule,
    False,
    None))



class AllocationRuleAction(VapiStruct):
    """
    Define action for each allocation rule which added on edge cluster.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AllocationRuleAction"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    ACTION_TYPE_ALLOCATIONBASEDONFAILUREDOMAIN = "AllocationBasedOnFailureDomain"
    """


    """



    _canonical_to_pep_names = {
                            'action_type': 'action_type',
                            }

    def __init__(self,
                 action_type='AllocationRuleAction',
                ):
        """
        :type  action_type: :class:`str`
        :param action_type: Possible values are: 
            
            *
              :attr:`AllocationRuleAction.ACTION_TYPE_ALLOCATIONBASEDONFAILUREDOMAIN`
            
            Set action for each allocation rule on edge cluster which will help
            in auto placement.
        """
        self._action_type = action_type
        VapiStruct.__init__(self)

    @property
    def action_type(self):
        """
        Return the discriminator value
        """
        return self._action_type

AllocationRuleAction._set_binding_type(type.StructType(
    'com.vmware.nsx.model.allocation_rule_action', {
        'action_type': type.StringType(),
    },
    AllocationRuleAction,
    False,
    None))



class ApiError(VapiStruct):
    """
    Detailed information about an API Error

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'details': 'details',
                            'error_code': 'error_code',
                            'error_data': 'error_data',
                            'error_message': 'error_message',
                            'module_name': 'module_name',
                            'related_errors': 'related_errors',
                            }

    def __init__(self,
                 details=None,
                 error_code=None,
                 error_data=None,
                 error_message=None,
                 module_name=None,
                 related_errors=None,
                ):
        """
        :type  details: :class:`str` or ``None``
        :param details: Further details about the error
        :type  error_code: :class:`long` or ``None``
        :param error_code: A numeric error code format: int64
        :type  error_data: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param error_data: Additional data about the error
        :type  error_message: :class:`str` or ``None``
        :param error_message: A description of the error
        :type  module_name: :class:`str` or ``None``
        :param module_name: The module name where the error occurred
        :type  related_errors: :class:`list` of :class:`RelatedApiError` or ``None``
        :param related_errors: Other errors related to this error
        """
        self.details = details
        self.error_code = error_code
        self.error_data = error_data
        self.error_message = error_message
        self.module_name = module_name
        self.related_errors = related_errors
        VapiStruct.__init__(self)


ApiError._set_binding_type(type.StructType(
    'com.vmware.nsx.model.api_error', {
        'details': type.OptionalType(type.StringType()),
        'error_code': type.OptionalType(type.IntegerType()),
        'error_data': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
        'error_message': type.OptionalType(type.StringType()),
        'module_name': type.OptionalType(type.StringType()),
        'related_errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'RelatedApiError'))),
    },
    ApiError,
    False,
    None))



class ApiServiceConfig(VapiStruct):
    """
    Properties that affect the configuration of the NSX API service.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'basic_authentication_enabled': 'basic_authentication_enabled',
                            'cipher_suites': 'cipher_suites',
                            'client_api_concurrency_limit': 'client_api_concurrency_limit',
                            'client_api_rate_limit': 'client_api_rate_limit',
                            'connection_timeout': 'connection_timeout',
                            'cookie_based_authentication_enabled': 'cookie_based_authentication_enabled',
                            'global_api_concurrency_limit': 'global_api_concurrency_limit',
                            'lockout_immune_addresses': 'lockout_immune_addresses',
                            'protocol_versions': 'protocol_versions',
                            'redirect_host': 'redirect_host',
                            'session_timeout': 'session_timeout',
                            }

    def __init__(self,
                 basic_authentication_enabled=None,
                 cipher_suites=None,
                 client_api_concurrency_limit=None,
                 client_api_rate_limit=None,
                 connection_timeout=None,
                 cookie_based_authentication_enabled=None,
                 global_api_concurrency_limit=None,
                 lockout_immune_addresses=None,
                 protocol_versions=None,
                 redirect_host=None,
                 session_timeout=None,
                ):
        """
        :type  basic_authentication_enabled: :class:`bool` or ``None``
        :param basic_authentication_enabled: Identifies whether basic authentication is enabled or disabled in
            API calls.
        :type  cipher_suites: :class:`list` of :class:`CipherSuite` or ``None``
        :param cipher_suites: The TLS cipher suites that the API service will negotiate.
        :type  client_api_concurrency_limit: :class:`long` or ``None``
        :param client_api_concurrency_limit: The maximum number of concurrent API requests that will be serviced
            for a given authenticated client. If the number of API requests
            being processed exceeds this limit, new API requests will be
            refused and a 503 Service Unavailable response will be returned to
            the client. To disable API concurrency limiting, set this value to
            0. format: int64
        :type  client_api_rate_limit: :class:`long` or ``None``
        :param client_api_rate_limit: The maximum number of API requests that will be serviced per second
            for a given authenticated client. If more API requests are received
            than can be serviced, a 429 Too Many Requests HTTP response will be
            returned. To disable API rate limiting, set this value to 0.
            format: int64
        :type  connection_timeout: :class:`long` or ``None``
        :param connection_timeout: NSX connection timeout, in seconds. To disable timeout, set to 0.
            format: int64
        :type  cookie_based_authentication_enabled: :class:`bool` or ``None``
        :param cookie_based_authentication_enabled: Identifies whether cookie-based authentication is enabled or
            disabled in API calls. When cookie-based authentication is
            disabled, new sessions cannot be created via /api/session/create.
        :type  global_api_concurrency_limit: :class:`long` or ``None``
        :param global_api_concurrency_limit: The maximum number of concurrent API requests that will be
            serviced. If the number of API requests being processed exceeds
            this limit, new API requests will be refused and a 503 Service
            Unavailable response will be returned to the client. To disable API
            concurrency limiting, set this value to 0. format: int64
        :type  lockout_immune_addresses: :class:`list` of :class:`str` or ``None``
        :param lockout_immune_addresses: The list of IP addresses which are not subjected to a lockout on
            failed login attempts. format: ip
        :type  protocol_versions: :class:`list` of :class:`ProtocolVersion` or ``None``
        :param protocol_versions: The TLS protocol versions that the API service will negotiate.
        :type  redirect_host: :class:`str` or ``None``
        :param redirect_host: Host name or IP address to use for redirect location headers, or
            empty string to derive from current request. To disable, set
            redirect_host to the empty string (\"\").
        :type  session_timeout: :class:`long` or ``None``
        :param session_timeout: NSX session inactivity timeout format: int64
        """
        self.basic_authentication_enabled = basic_authentication_enabled
        self.cipher_suites = cipher_suites
        self.client_api_concurrency_limit = client_api_concurrency_limit
        self.client_api_rate_limit = client_api_rate_limit
        self.connection_timeout = connection_timeout
        self.cookie_based_authentication_enabled = cookie_based_authentication_enabled
        self.global_api_concurrency_limit = global_api_concurrency_limit
        self.lockout_immune_addresses = lockout_immune_addresses
        self.protocol_versions = protocol_versions
        self.redirect_host = redirect_host
        self.session_timeout = session_timeout
        VapiStruct.__init__(self)


ApiServiceConfig._set_binding_type(type.StructType(
    'com.vmware.nsx.model.api_service_config', {
        'basic_authentication_enabled': type.OptionalType(type.BooleanType()),
        'cipher_suites': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CipherSuite'))),
        'client_api_concurrency_limit': type.OptionalType(type.IntegerType()),
        'client_api_rate_limit': type.OptionalType(type.IntegerType()),
        'connection_timeout': type.OptionalType(type.IntegerType()),
        'cookie_based_authentication_enabled': type.OptionalType(type.BooleanType()),
        'global_api_concurrency_limit': type.OptionalType(type.IntegerType()),
        'lockout_immune_addresses': type.OptionalType(type.ListType(type.StringType())),
        'protocol_versions': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ProtocolVersion'))),
        'redirect_host': type.OptionalType(type.StringType()),
        'session_timeout': type.OptionalType(type.IntegerType()),
    },
    ApiServiceConfig,
    False,
    None))



class ApplianceManagementTaskListResult(VapiStruct):
    """
    Appliance management task query results

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ApplianceManagementTaskProperties` or ``None``
        :param results: Task property results
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ApplianceManagementTaskListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.appliance_management_task_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ApplianceManagementTaskProperties'))),
    },
    ApplianceManagementTaskListResult,
    False,
    None))



class ApplianceManagementTaskProperties(VapiStruct):
    """
    Appliance management task properties

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_RUNNING = "running"
    """


    """
    STATUS_ERROR = "error"
    """


    """
    STATUS_SUCCESS = "success"
    """


    """
    STATUS_CANCELING = "canceling"
    """


    """
    STATUS_CANCELED = "canceled"
    """


    """
    STATUS_KILLED = "killed"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'async_response_available': 'async_response_available',
                            'cancelable': 'cancelable',
                            'description': 'description',
                            'details': 'details',
                            'end_time': 'end_time',
                            'id': 'id',
                            'message': 'message',
                            'progress': 'progress',
                            'request_method': 'request_method',
                            'request_uri': 'request_uri',
                            'start_time': 'start_time',
                            'status': 'status',
                            'user': 'user',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 async_response_available=None,
                 cancelable=None,
                 description=None,
                 details=None,
                 end_time=None,
                 id=None,
                 message=None,
                 progress=None,
                 request_method=None,
                 request_uri=None,
                 start_time=None,
                 status=None,
                 user=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  async_response_available: :class:`bool` or ``None``
        :param async_response_available: True if response for asynchronous request is available
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  cancelable: :class:`bool` or ``None``
        :param cancelable: True if this task can be canceled
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of the task
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  details: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param details: Details about the task if known
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  end_time: :class:`long` or ``None``
        :param end_time: The end time of the task in epoch milliseconds format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  id: :class:`str` or ``None``
        :param id: Identifier for this task
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  message: :class:`str` or ``None``
        :param message: A message describing the disposition of the task
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  progress: :class:`long` or ``None``
        :param progress: Task progress if known, from 0 to 100 format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  request_method: :class:`str` or ``None``
        :param request_method: HTTP request method
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  request_uri: :class:`str` or ``None``
        :param request_uri: URI of the method invocation that spawned this task
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  start_time: :class:`long` or ``None``
        :param start_time: The start time of the task in epoch milliseconds format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ApplianceManagementTaskProperties.STATUS_RUNNING`
            * :attr:`ApplianceManagementTaskProperties.STATUS_ERROR`
            * :attr:`ApplianceManagementTaskProperties.STATUS_SUCCESS`
            * :attr:`ApplianceManagementTaskProperties.STATUS_CANCELING`
            * :attr:`ApplianceManagementTaskProperties.STATUS_CANCELED`
            * :attr:`ApplianceManagementTaskProperties.STATUS_KILLED`
            
             Current status of the task
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  user: :class:`str` or ``None``
        :param user: Name of the user who created this task
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.async_response_available = async_response_available
        self.cancelable = cancelable
        self.description = description
        self.details = details
        self.end_time = end_time
        self.id = id
        self.message = message
        self.progress = progress
        self.request_method = request_method
        self.request_uri = request_uri
        self.start_time = start_time
        self.status = status
        self.user = user
        VapiStruct.__init__(self)


ApplianceManagementTaskProperties._set_binding_type(type.StructType(
    'com.vmware.nsx.model.appliance_management_task_properties', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'async_response_available': type.OptionalType(type.BooleanType()),
        'cancelable': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'details': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
        'end_time': type.OptionalType(type.IntegerType()),
        'id': type.OptionalType(type.StringType()),
        'message': type.OptionalType(type.StringType()),
        'progress': type.OptionalType(type.IntegerType()),
        'request_method': type.OptionalType(type.StringType()),
        'request_uri': type.OptionalType(type.StringType()),
        'start_time': type.OptionalType(type.IntegerType()),
        'status': type.OptionalType(type.StringType()),
        'user': type.OptionalType(type.StringType()),
    },
    ApplianceManagementTaskProperties,
    False,
    None))



class AppliedTos(VapiStruct):
    """
    Entity lists where the profile will be enabled on.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'logical_ports': 'logical_ports',
                            'logical_switches': 'logical_switches',
                            'nsgroups': 'nsgroups',
                            }

    def __init__(self,
                 logical_ports=None,
                 logical_switches=None,
                 nsgroups=None,
                ):
        """
        :type  logical_ports: :class:`list` of :class:`ResourceReference` or ``None``
        :param logical_ports: Logical Port List
        :type  logical_switches: :class:`list` of :class:`ResourceReference` or ``None``
        :param logical_switches: Logical Switch List
        :type  nsgroups: :class:`list` of :class:`ResourceReference` or ``None``
        :param nsgroups: NSGroup List
        """
        self.logical_ports = logical_ports
        self.logical_switches = logical_switches
        self.nsgroups = nsgroups
        VapiStruct.__init__(self)


AppliedTos._set_binding_type(type.StructType(
    'com.vmware.nsx.model.applied_tos', {
        'logical_ports': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceReference'))),
        'logical_switches': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceReference'))),
        'nsgroups': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceReference'))),
    },
    AppliedTos,
    False,
    None))



class ArpHeader(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    OP_CODE_REQUEST = "ARP_REQUEST"
    """


    """
    OP_CODE_REPLY = "ARP_REPLY"
    """


    """



    _canonical_to_pep_names = {
                            'dst_ip': 'dst_ip',
                            'op_code': 'op_code',
                            'src_ip': 'src_ip',
                            }

    def __init__(self,
                 dst_ip=None,
                 op_code=None,
                 src_ip=None,
                ):
        """
        :type  dst_ip: :class:`str` or ``None``
        :param dst_ip: The destination IP address format: ipv4
        :type  op_code: :class:`str` or ``None``
        :param op_code: Possible values are: 
            
            * :attr:`ArpHeader.OP_CODE_REQUEST`
            * :attr:`ArpHeader.OP_CODE_REPLY`
            
             This field specifies the nature of the Arp message being sent.
        :type  src_ip: :class:`str` or ``None``
        :param src_ip: This field specifies the IP address of the sender. If omitted, the
            src_ip is set to 0.0.0.0. format: ipv4
        """
        self.dst_ip = dst_ip
        self.op_code = op_code
        self.src_ip = src_ip
        VapiStruct.__init__(self)


ArpHeader._set_binding_type(type.StructType(
    'com.vmware.nsx.model.arp_header', {
        'dst_ip': type.OptionalType(type.StringType()),
        'op_code': type.OptionalType(type.StringType()),
        'src_ip': type.OptionalType(type.StringType()),
    },
    ArpHeader,
    False,
    None))



class AssignedByDhcp(VapiStruct):
    """
    This type can be specified in ip assignment spec of host switch if DHCP
    based IP assignment is desired for host switch virtual tunnel endpoints.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AssignedByDhcp"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 resource_type='AssignedByDhcp',
                ):
        """
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`IpAssignmentSpec.RESOURCE_TYPE_STATICIPPOOLSPEC`
            * :attr:`IpAssignmentSpec.RESOURCE_TYPE_STATICIPLISTSPEC`
            * :attr:`IpAssignmentSpec.RESOURCE_TYPE_ASSIGNEDBYDHCP`
            * :attr:`IpAssignmentSpec.RESOURCE_TYPE_STATICIPMACLISTSPEC`
        """
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

AssignedByDhcp._set_binding_type(type.StructType(
    'com.vmware.nsx.model.assigned_by_dhcp', {
        'resource_type': type.StringType(),
    },
    AssignedByDhcp,
    False,
    None))



class AssociationListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ResourceReference` or ``None``
        :param results: Paged Collection of ResourceReference
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


AssociationListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.association_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceReference'))),
    },
    AssociationListResult,
    False,
    None))



class AttachmentContext(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AttachmentContext"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    ALLOCATE_ADDRESSES_IPPOOL = "IpPool"
    """


    """
    ALLOCATE_ADDRESSES_MACPOOL = "MacPool"
    """


    """
    ALLOCATE_ADDRESSES_BOTH = "Both"
    """


    """
    ALLOCATE_ADDRESSES_NONE = "None"
    """


    """



    _canonical_to_pep_names = {
                            'allocate_addresses': 'allocate_addresses',
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 allocate_addresses=None,
                 resource_type='AttachmentContext',
                ):
        """
        :type  allocate_addresses: :class:`str` or ``None``
        :param allocate_addresses: Possible values are: 
            
            * :attr:`AttachmentContext.ALLOCATE_ADDRESSES_IPPOOL`
            * :attr:`AttachmentContext.ALLOCATE_ADDRESSES_MACPOOL`
            * :attr:`AttachmentContext.ALLOCATE_ADDRESSES_BOTH`
            * :attr:`AttachmentContext.ALLOCATE_ADDRESSES_NONE`
            
            A flag to indicate whether to allocate addresses from allocation
            pools bound to the parent logical switch.
        :type  resource_type: :class:`str`
        :param resource_type: Used to identify which concrete class it is
        """
        self.allocate_addresses = allocate_addresses
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

AttachmentContext._set_binding_type(type.StructType(
    'com.vmware.nsx.model.attachment_context', {
        'allocate_addresses': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
    },
    AttachmentContext,
    False,
    None))



class Attribute(VapiStruct):
    """
    Attribute specific to a partner. There attributes are passed on to the
    partner appliance and is opaque to the NSX Manager. The Attributes used by
    the partner applicance.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ATTRIBUTE_TYPE_IP_ADDRESS = "IP_ADDRESS"
    """


    """
    ATTRIBUTE_TYPE_PORT = "PORT"
    """


    """
    ATTRIBUTE_TYPE_PASSWORD = "PASSWORD"
    """


    """
    ATTRIBUTE_TYPE_STRING = "STRING"
    """


    """
    ATTRIBUTE_TYPE_LONG = "LONG"
    """


    """
    ATTRIBUTE_TYPE_BOOLEAN = "BOOLEAN"
    """


    """



    _canonical_to_pep_names = {
                            'attribute_type': 'attribute_type',
                            'display_name': 'display_name',
                            'key': 'key',
                            'read_only': 'read_only',
                            'value': 'value',
                            }

    def __init__(self,
                 attribute_type=None,
                 display_name=None,
                 key=None,
                 read_only=None,
                 value=None,
                ):
        """
        :type  attribute_type: :class:`str` or ``None``
        :param attribute_type: Possible values are: 
            
            * :attr:`Attribute.ATTRIBUTE_TYPE_IP_ADDRESS`
            * :attr:`Attribute.ATTRIBUTE_TYPE_PORT`
            * :attr:`Attribute.ATTRIBUTE_TYPE_PASSWORD`
            * :attr:`Attribute.ATTRIBUTE_TYPE_STRING`
            * :attr:`Attribute.ATTRIBUTE_TYPE_LONG`
            * :attr:`Attribute.ATTRIBUTE_TYPE_BOOLEAN`
            
             Attribute Type can be of any of the allowed enum type.
        :type  display_name: :class:`str` or ``None``
        :param display_name: Attribute display name string value.
        :type  key: :class:`str` or ``None``
        :param key: Attribute key string value.
        :type  read_only: :class:`bool` or ``None``
        :param read_only: Read only Attribute cannot be overdidden by service
            instance/deployment.
        :type  value: :class:`str` or ``None``
        :param value: Attribute value string value.
        """
        self.attribute_type = attribute_type
        self.display_name = display_name
        self.key = key
        self.read_only = read_only
        self.value = value
        VapiStruct.__init__(self)


Attribute._set_binding_type(type.StructType(
    'com.vmware.nsx.model.attribute', {
        'attribute_type': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'key': type.OptionalType(type.StringType()),
        'read_only': type.OptionalType(type.BooleanType()),
        'value': type.OptionalType(type.StringType()),
    },
    Attribute,
    False,
    None))



class AuditLog(VapiStruct):
    """
    Audit log in RFC5424 format

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'appname': 'appname',
                            'facility': 'facility',
                            'full_log': 'full_log',
                            'hostname': 'hostname',
                            'message': 'message',
                            'msgid': 'msgid',
                            'priority': 'priority',
                            'procid': 'procid',
                            'struct_data': 'struct_data',
                            'timestamp': 'timestamp',
                            }

    def __init__(self,
                 appname=None,
                 facility=None,
                 full_log=None,
                 hostname=None,
                 message=None,
                 msgid=None,
                 priority=None,
                 procid=None,
                 struct_data=None,
                 timestamp=None,
                ):
        """
        :type  appname: :class:`str` or ``None``
        :param appname: Application name field of the log
        :type  facility: :class:`long` or ``None``
        :param facility: Facility field of the log format: int64
        :type  full_log: :class:`str` or ``None``
        :param full_log: Full log with both header and message
        :type  hostname: :class:`str` or ``None``
        :param hostname: Hostname field of the log
        :type  message: :class:`str` or ``None``
        :param message: Message field of the log
        :type  msgid: :class:`str` or ``None``
        :param msgid: Message ID field of the log
        :type  priority: :class:`long` or ``None``
        :param priority: Priority field of the log format: int64
        :type  procid: :class:`long` or ``None``
        :param procid: Process ID field of the log format: int64
        :type  struct_data: :class:`StructuredData` or ``None``
        :param struct_data: Structured data field of the log
        :type  timestamp: :class:`str` or ``None``
        :param timestamp: Date and time in UTC of the log
        """
        self.appname = appname
        self.facility = facility
        self.full_log = full_log
        self.hostname = hostname
        self.message = message
        self.msgid = msgid
        self.priority = priority
        self.procid = procid
        self.struct_data = struct_data
        self.timestamp = timestamp
        VapiStruct.__init__(self)


AuditLog._set_binding_type(type.StructType(
    'com.vmware.nsx.model.audit_log', {
        'appname': type.OptionalType(type.StringType()),
        'facility': type.OptionalType(type.IntegerType()),
        'full_log': type.OptionalType(type.StringType()),
        'hostname': type.OptionalType(type.StringType()),
        'message': type.OptionalType(type.StringType()),
        'msgid': type.OptionalType(type.StringType()),
        'priority': type.OptionalType(type.IntegerType()),
        'procid': type.OptionalType(type.IntegerType()),
        'struct_data': type.OptionalType(type.ReferenceType(__name__, 'StructuredData')),
        'timestamp': type.OptionalType(type.StringType()),
    },
    AuditLog,
    False,
    None))



class AuditLogListResult(VapiStruct):
    """
    Audit log collection results

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'last_full_sync_timestamp': 'last_full_sync_timestamp',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 last_full_sync_timestamp=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_full_sync_timestamp: :class:`str` or ``None``
        :param last_full_sync_timestamp: Timestamp of the last full audit log collection
        :type  results: :class:`list` of :class:`AuditLog` or ``None``
        :param results: Audit log results
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.last_full_sync_timestamp = last_full_sync_timestamp
        self.results = results
        VapiStruct.__init__(self)


AuditLogListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.audit_log_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'last_full_sync_timestamp': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AuditLog'))),
    },
    AuditLogListResult,
    False,
    None))



class AuditLogRequest(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    LOG_FILTER_TYPE_TEXT = "TEXT"
    """


    """
    LOG_FILTER_TYPE_REGEX = "REGEX"
    """


    """



    _canonical_to_pep_names = {
                            'log_age_limit': 'log_age_limit',
                            'log_filter': 'log_filter',
                            'log_filter_type': 'log_filter_type',
                            }

    def __init__(self,
                 log_age_limit=None,
                 log_filter=None,
                 log_filter_type=None,
                ):
        """
        :type  log_age_limit: :class:`long` or ``None``
        :param log_age_limit: Include logs with timstamps not past the age limit in days format:
            int64
        :type  log_filter: :class:`str` or ``None``
        :param log_filter: Audit logs should meet the filter condition
        :type  log_filter_type: :class:`str` or ``None``
        :param log_filter_type: Possible values are: 
            
            * :attr:`AuditLogRequest.LOG_FILTER_TYPE_TEXT`
            * :attr:`AuditLogRequest.LOG_FILTER_TYPE_REGEX`
            
             Type of log filter
        """
        self.log_age_limit = log_age_limit
        self.log_filter = log_filter
        self.log_filter_type = log_filter_type
        VapiStruct.__init__(self)


AuditLogRequest._set_binding_type(type.StructType(
    'com.vmware.nsx.model.audit_log_request', {
        'log_age_limit': type.OptionalType(type.IntegerType()),
        'log_filter': type.OptionalType(type.StringType()),
        'log_filter_type': type.OptionalType(type.StringType()),
    },
    AuditLogRequest,
    False,
    None))



class AuthenticationPolicyProperties(VapiStruct):
    """
    Configuration of authentication policies for the NSX node

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'api_failed_auth_lockout_period': 'api_failed_auth_lockout_period',
                            'api_failed_auth_reset_period': 'api_failed_auth_reset_period',
                            'api_max_auth_failures': 'api_max_auth_failures',
                            'cli_failed_auth_lockout_period': 'cli_failed_auth_lockout_period',
                            'cli_max_auth_failures': 'cli_max_auth_failures',
                            'minimum_password_length': 'minimum_password_length',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 api_failed_auth_lockout_period=None,
                 api_failed_auth_reset_period=None,
                 api_max_auth_failures=None,
                 cli_failed_auth_lockout_period=None,
                 cli_max_auth_failures=None,
                 minimum_password_length=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  api_failed_auth_lockout_period: :class:`long` or ``None``
        :param api_failed_auth_lockout_period: Once a lockout occurs, the account remains locked out of the API
            for this time period. Only applies to NSX Manager nodes. Ignored on
            other node types. format: int64
        :type  api_failed_auth_reset_period: :class:`long` or ``None``
        :param api_failed_auth_reset_period: In order to trigger an account lockout, all authentication failures
            must occur in this time window. If the reset period expires, the
            failed login count is reset to zero. Only applies to NSX Manager
            nodes. Ignored on other node types. format: int64
        :type  api_max_auth_failures: :class:`long` or ``None``
        :param api_max_auth_failures: Only applies to NSX Manager nodes. Ignored on other node types.
            format: int64
        :type  cli_failed_auth_lockout_period: :class:`long` or ``None``
        :param cli_failed_auth_lockout_period: Once a lockout occurs, the account remains locked out of the CLI
            for this time period. While the lockout period is in effect,
            additional authentication attempts restart the lockout period, even
            if a valid password is specified. format: int64
        :type  cli_max_auth_failures: :class:`long` or ``None``
        :param cli_max_auth_failures: Number of authentication failures that trigger CLI lockout format:
            int64
        :type  minimum_password_length: :class:`long` or ``None``
        :param minimum_password_length: Minimum number of characters required in account passwords format:
            int64
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.api_failed_auth_lockout_period = api_failed_auth_lockout_period
        self.api_failed_auth_reset_period = api_failed_auth_reset_period
        self.api_max_auth_failures = api_max_auth_failures
        self.cli_failed_auth_lockout_period = cli_failed_auth_lockout_period
        self.cli_max_auth_failures = cli_max_auth_failures
        self.minimum_password_length = minimum_password_length
        VapiStruct.__init__(self)


AuthenticationPolicyProperties._set_binding_type(type.StructType(
    'com.vmware.nsx.model.authentication_policy_properties', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'api_failed_auth_lockout_period': type.OptionalType(type.IntegerType()),
        'api_failed_auth_reset_period': type.OptionalType(type.IntegerType()),
        'api_max_auth_failures': type.OptionalType(type.IntegerType()),
        'cli_failed_auth_lockout_period': type.OptionalType(type.IntegerType()),
        'cli_max_auth_failures': type.OptionalType(type.IntegerType()),
        'minimum_password_length': type.OptionalType(type.IntegerType()),
    },
    AuthenticationPolicyProperties,
    False,
    None))



class AuthenticationScheme(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'scheme_name': 'scheme_name',
                            }

    def __init__(self,
                 scheme_name=None,
                ):
        """
        :type  scheme_name: :class:`str` or ``None``
        :param scheme_name: Authentication scheme name
        """
        self.scheme_name = scheme_name
        VapiStruct.__init__(self)


AuthenticationScheme._set_binding_type(type.StructType(
    'com.vmware.nsx.model.authentication_scheme', {
        'scheme_name': type.OptionalType(type.StringType()),
    },
    AuthenticationScheme,
    False,
    None))



class AutomaticHealthCheck(VapiStruct):
    """
    Health check performed by system automatically on a specific transport
    zone. For overlay based zone, health check is performed on corresponding
    N-VDS of each transport node with the VLAN and MTU specified by uplink
    profile of N-VDS for the node. For VLAN based zone, health check is
    performed on corresponding N-VDS of each transport node with MTU specified
    by uplink profile of N-VDS for the node and VLAN specified by all logical
    switches in this zone.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'result': 'result',
                            'transport_zone_id': 'transport_zone_id',
                            }

    def __init__(self,
                 result=None,
                 transport_zone_id=None,
                ):
        """
        :type  result: :class:`HealthCheckResult` or ``None``
        :param result: 
        :type  transport_zone_id: :class:`str` or ``None``
        :param transport_zone_id: ID of the transport zone where this automatic health check is
            performed.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.result = result
        self.transport_zone_id = transport_zone_id
        VapiStruct.__init__(self)


AutomaticHealthCheck._set_binding_type(type.StructType(
    'com.vmware.nsx.model.automatic_health_check', {
        'result': type.OptionalType(type.ReferenceType(__name__, 'HealthCheckResult')),
        'transport_zone_id': type.OptionalType(type.StringType()),
    },
    AutomaticHealthCheck,
    False,
    None))



class AutomaticHealthCheckListResult(VapiStruct):
    """
    Automatic health check list result for query with list parameters.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`AutomaticHealthCheck` or ``None``
        :param results: Automatic Health Check List
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


AutomaticHealthCheckListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.automatic_health_check_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AutomaticHealthCheck'))),
    },
    AutomaticHealthCheckListResult,
    False,
    None))



class AutomaticHealthCheckToggle(VapiStruct):
    """
    Toggle to enable/disable automatic health check.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'enabled': 'enabled',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 enabled=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Status of automatic health check
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.enabled = enabled
        VapiStruct.__init__(self)


AutomaticHealthCheckToggle._set_binding_type(type.StructType(
    'com.vmware.nsx.model.automatic_health_check_toggle', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'enabled': type.OptionalType(type.BooleanType()),
    },
    AutomaticHealthCheckToggle,
    False,
    None))



class Axes(VapiStruct):
    """
    Represents X and Y axes of a graph. For a multi-graph, the same axes are
    shared by all the graphs.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'x_label': 'x_label',
                            'y_label': 'y_label',
                            }

    def __init__(self,
                 x_label=None,
                 y_label=None,
                ):
        """
        :type  x_label: :class:`Label` or ``None``
        :param x_label: Label for X axis of a graph
        :type  y_label: :class:`Label` or ``None``
        :param y_label: Label for Y axis of a graph
        """
        self.x_label = x_label
        self.y_label = y_label
        VapiStruct.__init__(self)


Axes._set_binding_type(type.StructType(
    'com.vmware.nsx.model.axes', {
        'x_label': type.OptionalType(type.ReferenceType(__name__, 'Label')),
        'y_label': type.OptionalType(type.ReferenceType(__name__, 'Label')),
    },
    Axes,
    False,
    None))



class BFDDiagnosticCount(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'administratively_down_count': 'administratively_down_count',
                            'concatenated_path_down_count': 'concatenated_path_down_count',
                            'control_detection_time_expired_count': 'control_detection_time_expired_count',
                            'echo_function_failed_count': 'echo_function_failed_count',
                            'forwarding_plane_reset_count': 'forwarding_plane_reset_count',
                            'neighbor_signaled_session_down_count': 'neighbor_signaled_session_down_count',
                            'no_diagnostic_count': 'no_diagnostic_count',
                            'path_down_count': 'path_down_count',
                            'reverse_concatenated_path_down_count': 'reverse_concatenated_path_down_count',
                            }

    def __init__(self,
                 administratively_down_count=None,
                 concatenated_path_down_count=None,
                 control_detection_time_expired_count=None,
                 echo_function_failed_count=None,
                 forwarding_plane_reset_count=None,
                 neighbor_signaled_session_down_count=None,
                 no_diagnostic_count=None,
                 path_down_count=None,
                 reverse_concatenated_path_down_count=None,
                ):
        """
        :type  administratively_down_count: :class:`long` or ``None``
        :param administratively_down_count: Number of tunnels with administratively down diagnostic message
            format: int64
        :type  concatenated_path_down_count: :class:`long` or ``None``
        :param concatenated_path_down_count: Number of tunnels with concatenated path down diagnostic message
            format: int64
        :type  control_detection_time_expired_count: :class:`long` or ``None``
        :param control_detection_time_expired_count: Number of tunnels with control detection time expired diagnostic
            message format: int64
        :type  echo_function_failed_count: :class:`long` or ``None``
        :param echo_function_failed_count: Number of tunnels with echo function failed diagnostic message
            format: int64
        :type  forwarding_plane_reset_count: :class:`long` or ``None``
        :param forwarding_plane_reset_count: Number of tunnels with forwarding plane reset diagnostic message
            format: int64
        :type  neighbor_signaled_session_down_count: :class:`long` or ``None``
        :param neighbor_signaled_session_down_count: Number of tunnels neighbor signaled session down format: int64
        :type  no_diagnostic_count: :class:`long` or ``None``
        :param no_diagnostic_count: Number of tunnels with no diagnostic format: int64
        :type  path_down_count: :class:`long` or ``None``
        :param path_down_count: Number of tunnels with path down diagnostic message format: int64
        :type  reverse_concatenated_path_down_count: :class:`long` or ``None``
        :param reverse_concatenated_path_down_count: Number of tunnels with reverse concatenated path down diagnostic
            message format: int64
        """
        self.administratively_down_count = administratively_down_count
        self.concatenated_path_down_count = concatenated_path_down_count
        self.control_detection_time_expired_count = control_detection_time_expired_count
        self.echo_function_failed_count = echo_function_failed_count
        self.forwarding_plane_reset_count = forwarding_plane_reset_count
        self.neighbor_signaled_session_down_count = neighbor_signaled_session_down_count
        self.no_diagnostic_count = no_diagnostic_count
        self.path_down_count = path_down_count
        self.reverse_concatenated_path_down_count = reverse_concatenated_path_down_count
        VapiStruct.__init__(self)


BFDDiagnosticCount._set_binding_type(type.StructType(
    'com.vmware.nsx.model.BFD_diagnostic_count', {
        'administratively_down_count': type.OptionalType(type.IntegerType()),
        'concatenated_path_down_count': type.OptionalType(type.IntegerType()),
        'control_detection_time_expired_count': type.OptionalType(type.IntegerType()),
        'echo_function_failed_count': type.OptionalType(type.IntegerType()),
        'forwarding_plane_reset_count': type.OptionalType(type.IntegerType()),
        'neighbor_signaled_session_down_count': type.OptionalType(type.IntegerType()),
        'no_diagnostic_count': type.OptionalType(type.IntegerType()),
        'path_down_count': type.OptionalType(type.IntegerType()),
        'reverse_concatenated_path_down_count': type.OptionalType(type.IntegerType()),
    },
    BFDDiagnosticCount,
    False,
    None))



class BFDProperties(VapiStruct):
    """
    BFD information

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    REMOTE_STATE_UNKNOWN_STATE = "UNKNOWN_STATE"
    """


    """
    REMOTE_STATE_ADMIN_DOWN = "ADMIN_DOWN"
    """


    """
    REMOTE_STATE_DOWN = "DOWN"
    """


    """
    REMOTE_STATE_INIT = "INIT"
    """


    """
    REMOTE_STATE_UP = "UP"
    """


    """
    STATE_UNKNOWN_STATE = "UNKNOWN_STATE"
    """


    """
    STATE_ADMIN_DOWN = "ADMIN_DOWN"
    """


    """
    STATE_DOWN = "DOWN"
    """


    """
    STATE_INIT = "INIT"
    """


    """
    STATE_UP = "UP"
    """


    """



    _canonical_to_pep_names = {
                            'active': 'active',
                            'diagnostic': 'diagnostic',
                            'forwarding': 'forwarding',
                            'remote_diagnostic': 'remote_diagnostic',
                            'remote_state': 'remote_state',
                            'state': 'state',
                            }

    def __init__(self,
                 active=None,
                 diagnostic=None,
                 forwarding=None,
                 remote_diagnostic=None,
                 remote_state=None,
                 state=None,
                ):
        """
        :type  active: :class:`bool` or ``None``
        :param active: True if tunnel is active in a gateway HA setup
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  diagnostic: :class:`str` or ``None``
        :param diagnostic: A short message indicating what the BFD session thinks is wrong in
            case of a problem
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  forwarding: :class:`bool` or ``None``
        :param forwarding: True if the BFD session believes this interface may be used to
            forward traffic
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_diagnostic: :class:`str` or ``None``
        :param remote_diagnostic: A short message indicating what the remote interface's BFD session
            thinks is wrong in case of a problem
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_state: :class:`str` or ``None``
        :param remote_state: Possible values are: 
            
            * :attr:`BFDProperties.REMOTE_STATE_UNKNOWN_STATE`
            * :attr:`BFDProperties.REMOTE_STATE_ADMIN_DOWN`
            * :attr:`BFDProperties.REMOTE_STATE_DOWN`
            * :attr:`BFDProperties.REMOTE_STATE_INIT`
            * :attr:`BFDProperties.REMOTE_STATE_UP`
            
             State of the remote interface's BFD session
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  state: :class:`str` or ``None``
        :param state: Possible values are: 
            
            * :attr:`BFDProperties.STATE_UNKNOWN_STATE`
            * :attr:`BFDProperties.STATE_ADMIN_DOWN`
            * :attr:`BFDProperties.STATE_DOWN`
            * :attr:`BFDProperties.STATE_INIT`
            * :attr:`BFDProperties.STATE_UP`
            
             State of the BFD session
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.active = active
        self.diagnostic = diagnostic
        self.forwarding = forwarding
        self.remote_diagnostic = remote_diagnostic
        self.remote_state = remote_state
        self.state = state
        VapiStruct.__init__(self)


BFDProperties._set_binding_type(type.StructType(
    'com.vmware.nsx.model.BFD_properties', {
        'active': type.OptionalType(type.BooleanType()),
        'diagnostic': type.OptionalType(type.StringType()),
        'forwarding': type.OptionalType(type.BooleanType()),
        'remote_diagnostic': type.OptionalType(type.StringType()),
        'remote_state': type.OptionalType(type.StringType()),
        'state': type.OptionalType(type.StringType()),
    },
    BFDProperties,
    False,
    None))



class BFDStatusCount(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'bfd_admin_down_count': 'bfd_admin_down_count',
                            'bfd_down_count': 'bfd_down_count',
                            'bfd_init_count': 'bfd_init_count',
                            'bfd_up_count': 'bfd_up_count',
                            }

    def __init__(self,
                 bfd_admin_down_count=None,
                 bfd_down_count=None,
                 bfd_init_count=None,
                 bfd_up_count=None,
                ):
        """
        :type  bfd_admin_down_count: :class:`long` or ``None``
        :param bfd_admin_down_count: Number of tunnels in BFD admin down state format: int32
        :type  bfd_down_count: :class:`long` or ``None``
        :param bfd_down_count: Number of tunnels in BFD down state format: int32
        :type  bfd_init_count: :class:`long` or ``None``
        :param bfd_init_count: Number of tunnels in BFD init state format: int32
        :type  bfd_up_count: :class:`long` or ``None``
        :param bfd_up_count: Number of tunnels in BFD up state format: int32
        """
        self.bfd_admin_down_count = bfd_admin_down_count
        self.bfd_down_count = bfd_down_count
        self.bfd_init_count = bfd_init_count
        self.bfd_up_count = bfd_up_count
        VapiStruct.__init__(self)


BFDStatusCount._set_binding_type(type.StructType(
    'com.vmware.nsx.model.BFD_status_count', {
        'bfd_admin_down_count': type.OptionalType(type.IntegerType()),
        'bfd_down_count': type.OptionalType(type.IntegerType()),
        'bfd_init_count': type.OptionalType(type.IntegerType()),
        'bfd_up_count': type.OptionalType(type.IntegerType()),
    },
    BFDStatusCount,
    False,
    None))



class BGPCommunityList(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    COMMUNITY_TYPE_NORMALBGPCOMMUNITY = "NormalBGPCommunity"
    """


    """
    COMMUNITY_TYPE_LARGEBGPCOMMUNITY = "LargeBGPCommunity"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'communities': 'communities',
                            'community_type': 'community_type',
                            'logical_router_id': 'logical_router_id',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 communities=None,
                 community_type=None,
                 logical_router_id=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  communities: :class:`list` of :class:`str` or ``None``
        :param communities: Array of BGP communities
        :type  community_type: :class:`str` or ``None``
        :param community_type: Possible values are: 
            
            * :attr:`BGPCommunityList.COMMUNITY_TYPE_NORMALBGPCOMMUNITY`
            * :attr:`BGPCommunityList.COMMUNITY_TYPE_LARGEBGPCOMMUNITY`
            
            BGP community type. It has two types as NormalBGPCommunity BGP
            normal community which includes well-known community name as well
            as community value in range from [1-4294967295] or value in aa:nn
            format(aa/nn range from 1-65535). LargeBGPCommunity BGP large
            community which includes community value in aa:bb:nn format where
            aa, bb, nn are unsigned integers in the range [1-4294967295].
        :type  logical_router_id: :class:`str` or ``None``
        :param logical_router_id: Logical router id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.communities = communities
        self.community_type = community_type
        self.logical_router_id = logical_router_id
        VapiStruct.__init__(self)


BGPCommunityList._set_binding_type(type.StructType(
    'com.vmware.nsx.model.BGP_community_list', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'communities': type.OptionalType(type.ListType(type.StringType())),
        'community_type': type.OptionalType(type.StringType()),
        'logical_router_id': type.OptionalType(type.StringType()),
    },
    BGPCommunityList,
    False,
    None))



class BGPCommunityListListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`BGPCommunityList` or ``None``
        :param results: Paginated list of bgp community lists
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


BGPCommunityListListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.BGP_community_list_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BGPCommunityList'))),
    },
    BGPCommunityListListResult,
    False,
    None))



class BackupConfiguration(VapiStruct):
    """
    Configuration for taking manual/automated backup

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'after_inventory_update_interval': 'after_inventory_update_interval',
                            'backup_enabled': 'backup_enabled',
                            'backup_schedule': 'backup_schedule',
                            'inventory_summary_interval': 'inventory_summary_interval',
                            'passphrase': 'passphrase',
                            'remote_file_server': 'remote_file_server',
                            }

    def __init__(self,
                 after_inventory_update_interval=None,
                 backup_enabled=None,
                 backup_schedule=None,
                 inventory_summary_interval=None,
                 passphrase=None,
                 remote_file_server=None,
                ):
        """
        :type  after_inventory_update_interval: :class:`long` or ``None``
        :param after_inventory_update_interval: A number of seconds after a last backup, that needs to pass, before
            a topology change will trigger a generation of a new cluster/node
            backups. If parameter is not provided, then changes in a topology
            will not trigger a generation of cluster/node backups. format:
            int64
        :type  backup_enabled: :class:`bool` or ``None``
        :param backup_enabled: true if automated backup is enabled
        :type  backup_schedule: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param backup_schedule: Set when backups should be taken - on a weekly schedule or at
            regular intervals.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`BackupSchedule`. When methods return a value of this class
            as a return value, the attribute will contain all the attributes
            defined in :class:`BackupSchedule`.
        :type  inventory_summary_interval: :class:`long` or ``None``
        :param inventory_summary_interval: The minimum number of seconds between each upload of the inventory
            summary to backup server. format: int64
        :type  passphrase: :class:`str` or ``None``
        :param passphrase: Passphrase used to encrypt backup files. The passphrase specified
            must be at least 8 characters in length and must contain at least
            one lowercase, one uppercase, one numeric character and one special
            character (any other non-space character).
        :type  remote_file_server: :class:`RemoteFileServer` or ``None``
        :param remote_file_server: The server to which backups will be sent.
        """
        self.after_inventory_update_interval = after_inventory_update_interval
        self.backup_enabled = backup_enabled
        self.backup_schedule = backup_schedule
        self.inventory_summary_interval = inventory_summary_interval
        self.passphrase = passphrase
        self.remote_file_server = remote_file_server
        VapiStruct.__init__(self)


BackupConfiguration._set_binding_type(type.StructType(
    'com.vmware.nsx.model.backup_configuration', {
        'after_inventory_update_interval': type.OptionalType(type.IntegerType()),
        'backup_enabled': type.OptionalType(type.BooleanType()),
        'backup_schedule': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'BackupSchedule')])),
        'inventory_summary_interval': type.OptionalType(type.IntegerType()),
        'passphrase': type.OptionalType(type.StringType()),
        'remote_file_server': type.OptionalType(type.ReferenceType(__name__, 'RemoteFileServer')),
    },
    BackupConfiguration,
    False,
    None))



class BackupOperationHistory(VapiStruct):
    """
    Past backup operation details

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'cluster_backup_statuses': 'cluster_backup_statuses',
                            'inventory_backup_statuses': 'inventory_backup_statuses',
                            'node_backup_statuses': 'node_backup_statuses',
                            }

    def __init__(self,
                 cluster_backup_statuses=None,
                 inventory_backup_statuses=None,
                 node_backup_statuses=None,
                ):
        """
        :type  cluster_backup_statuses: :class:`list` of :class:`BackupOperationStatus` or ``None``
        :param cluster_backup_statuses: Statuses of previous cluser backups
        :type  inventory_backup_statuses: :class:`list` of :class:`BackupOperationStatus` or ``None``
        :param inventory_backup_statuses: Statuses of previous inventory backups
        :type  node_backup_statuses: :class:`list` of :class:`BackupOperationStatus` or ``None``
        :param node_backup_statuses: Statuses of previous node backups
        """
        self.cluster_backup_statuses = cluster_backup_statuses
        self.inventory_backup_statuses = inventory_backup_statuses
        self.node_backup_statuses = node_backup_statuses
        VapiStruct.__init__(self)


BackupOperationHistory._set_binding_type(type.StructType(
    'com.vmware.nsx.model.backup_operation_history', {
        'cluster_backup_statuses': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BackupOperationStatus'))),
        'inventory_backup_statuses': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BackupOperationStatus'))),
        'node_backup_statuses': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BackupOperationStatus'))),
    },
    BackupOperationHistory,
    False,
    None))



class BackupOperationStatus(VapiStruct):
    """
    Backup operation status

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ERROR_CODE_NOT_RUN_ON_MASTER = "BACKUP_NOT_RUN_ON_MASTER"
    """


    """
    ERROR_CODE_SERVER_UNREACHABLE = "BACKUP_SERVER_UNREACHABLE"
    """


    """
    ERROR_CODE_AUTHENTICATION_FAILURE = "BACKUP_AUTHENTICATION_FAILURE"
    """


    """
    ERROR_CODE_PERMISSION_ERROR = "BACKUP_PERMISSION_ERROR"
    """


    """
    ERROR_CODE_TIMEOUT = "BACKUP_TIMEOUT"
    """


    """
    ERROR_CODE_BAD_FINGERPRINT = "BACKUP_BAD_FINGERPRINT"
    """


    """
    ERROR_CODE_GENERIC_ERROR = "BACKUP_GENERIC_ERROR"
    """


    """



    _canonical_to_pep_names = {
                            'backup_id': 'backup_id',
                            'end_time': 'end_time',
                            'error_code': 'error_code',
                            'error_message': 'error_message',
                            'start_time': 'start_time',
                            'success': 'success',
                            }

    def __init__(self,
                 backup_id=None,
                 end_time=None,
                 error_code=None,
                 error_message=None,
                 start_time=None,
                 success=None,
                ):
        """
        :type  backup_id: :class:`str` or ``None``
        :param backup_id: Unique identifier of a backup
        :type  end_time: :class:`long` or ``None``
        :param end_time: Time when operation was ended format: int64
        :type  error_code: :class:`str` or ``None``
        :param error_code: Possible values are: 
            
            * :attr:`BackupOperationStatus.ERROR_CODE_NOT_RUN_ON_MASTER`
            * :attr:`BackupOperationStatus.ERROR_CODE_SERVER_UNREACHABLE`
            * :attr:`BackupOperationStatus.ERROR_CODE_AUTHENTICATION_FAILURE`
            * :attr:`BackupOperationStatus.ERROR_CODE_PERMISSION_ERROR`
            * :attr:`BackupOperationStatus.ERROR_CODE_TIMEOUT`
            * :attr:`BackupOperationStatus.ERROR_CODE_BAD_FINGERPRINT`
            * :attr:`BackupOperationStatus.ERROR_CODE_GENERIC_ERROR`
            
             Error code
        :type  error_message: :class:`str` or ``None``
        :param error_message: Error code details
        :type  start_time: :class:`long` or ``None``
        :param start_time: Time when operation was started format: int64
        :type  success: :class:`bool` or ``None``
        :param success: True if backup is successfully completed, else false
        """
        self.backup_id = backup_id
        self.end_time = end_time
        self.error_code = error_code
        self.error_message = error_message
        self.start_time = start_time
        self.success = success
        VapiStruct.__init__(self)


BackupOperationStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.backup_operation_status', {
        'backup_id': type.OptionalType(type.StringType()),
        'end_time': type.OptionalType(type.IntegerType()),
        'error_code': type.OptionalType(type.StringType()),
        'error_message': type.OptionalType(type.StringType()),
        'start_time': type.OptionalType(type.IntegerType()),
        'success': type.OptionalType(type.BooleanType()),
    },
    BackupOperationStatus,
    False,
    None))



class BackupOverview(VapiStruct):
    """
    Data for a single backup/restore card

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            'backup_config': 'backup_config',
                            'backup_operation_history': 'backup_operation_history',
                            'current_backup_operation_status': 'current_backup_operation_status',
                            'restore_status': 'restore_status',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                 backup_config=None,
                 backup_operation_history=None,
                 current_backup_operation_status=None,
                 restore_status=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ClusterBackupInfo` or ``None``
        :param results: List of timestamps of backed-up cluster files
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  backup_config: :class:`BackupConfiguration` or ``None``
        :param backup_config: Configuration to generate a manual/automated backup
        :type  backup_operation_history: :class:`BackupOperationHistory` or ``None``
        :param backup_operation_history: Status of the last backup execution per component
        :type  current_backup_operation_status: :class:`CurrentBackupOperationStatus` or ``None``
        :param current_backup_operation_status: Backup status decribes type, phase, success/failure and time of a |
            latest backup execution
        :type  restore_status: :class:`ClusterRestoreStatus` or ``None``
        :param restore_status: Status of restore process executing/executed on appliance
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        self.backup_config = backup_config
        self.backup_operation_history = backup_operation_history
        self.current_backup_operation_status = current_backup_operation_status
        self.restore_status = restore_status
        VapiStruct.__init__(self)


BackupOverview._set_binding_type(type.StructType(
    'com.vmware.nsx.model.backup_overview', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ClusterBackupInfo'))),
        'backup_config': type.OptionalType(type.ReferenceType(__name__, 'BackupConfiguration')),
        'backup_operation_history': type.OptionalType(type.ReferenceType(__name__, 'BackupOperationHistory')),
        'current_backup_operation_status': type.OptionalType(type.ReferenceType(__name__, 'CurrentBackupOperationStatus')),
        'restore_status': type.OptionalType(type.ReferenceType(__name__, 'ClusterRestoreStatus')),
    },
    BackupOverview,
    False,
    None))



class BackupSchedule(VapiStruct):
    """
    Abstract base type for Weekly or Interval Backup Schedule

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BackupSchedule"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    RESOURCE_TYPE_WEEKLYBACKUPSCHEDULE = "WeeklyBackupSchedule"
    """


    """
    RESOURCE_TYPE_INTERVALBACKUPSCHEDULE = "IntervalBackupSchedule"
    """


    """



    _canonical_to_pep_names = {
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 resource_type='BackupSchedule',
                ):
        """
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`BackupSchedule.RESOURCE_TYPE_WEEKLYBACKUPSCHEDULE`
            * :attr:`BackupSchedule.RESOURCE_TYPE_INTERVALBACKUPSCHEDULE`
            
             Schedule type
        """
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BackupSchedule._set_binding_type(type.StructType(
    'com.vmware.nsx.model.backup_schedule', {
        'resource_type': type.StringType(),
    },
    BackupSchedule,
    False,
    None))



class BackupUiFramesInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    API_ENDPOINT_GLOBAL_MANAGER = "global-manager"
    """


    """
    API_ENDPOINT_NSXAPI = "nsxapi"
    """


    """
    API_ENDPOINT_ICA = "ica"
    """


    """
    FRAME_TYPE_GLOBAL_MANAGER = "GLOBAL_MANAGER"
    """


    """
    FRAME_TYPE_LOCAL_MANAGER = "LOCAL_MANAGER"
    """


    """
    FRAME_TYPE_LOCAL_LOCAL_MANAGER = "LOCAL_LOCAL_MANAGER"
    """


    """
    FRAME_TYPE_NSX_INTELLIGENCE = "NSX_INTELLIGENCE"
    """


    """



    _canonical_to_pep_names = {
                            'api_endpoint': 'api_endpoint',
                            'frame_type': 'frame_type',
                            'site_id': 'site_id',
                            'site_version': 'site_version',
                            }

    def __init__(self,
                 api_endpoint=None,
                 frame_type=None,
                 site_id=None,
                 site_version=None,
                ):
        """
        :type  api_endpoint: :class:`str` or ``None``
        :param api_endpoint: Possible values are: 
            
            * :attr:`BackupUiFramesInfo.API_ENDPOINT_GLOBAL_MANAGER`
            * :attr:`BackupUiFramesInfo.API_ENDPOINT_NSXAPI`
            * :attr:`BackupUiFramesInfo.API_ENDPOINT_ICA`
            
             prefix to be used for api call
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  frame_type: :class:`str` or ``None``
        :param frame_type: Possible values are: 
            
            * :attr:`BackupUiFramesInfo.FRAME_TYPE_GLOBAL_MANAGER`
            * :attr:`BackupUiFramesInfo.FRAME_TYPE_LOCAL_MANAGER`
            * :attr:`BackupUiFramesInfo.FRAME_TYPE_LOCAL_LOCAL_MANAGER`
            * :attr:`BackupUiFramesInfo.FRAME_TYPE_NSX_INTELLIGENCE`
            
             Type of service, for which backup is handled
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  site_id: :class:`str` or ``None``
        :param site_id: Id of the site
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  site_version: :class:`str` or ``None``
        :param site_version: Version of the site
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.api_endpoint = api_endpoint
        self.frame_type = frame_type
        self.site_id = site_id
        self.site_version = site_version
        VapiStruct.__init__(self)


BackupUiFramesInfo._set_binding_type(type.StructType(
    'com.vmware.nsx.model.backup_ui_frames_info', {
        'api_endpoint': type.OptionalType(type.StringType()),
        'frame_type': type.OptionalType(type.StringType()),
        'site_id': type.OptionalType(type.StringType()),
        'site_version': type.OptionalType(type.StringType()),
    },
    BackupUiFramesInfo,
    False,
    None))



class BackupUiFramesInfoList(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'backup_frames_list': 'backup_frames_list',
                            }

    def __init__(self,
                 backup_frames_list=None,
                ):
        """
        :type  backup_frames_list: :class:`list` of :class:`BackupUiFramesInfo` or ``None``
        :param backup_frames_list: List of backup frames(and metadata) to be displayed in UI
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.backup_frames_list = backup_frames_list
        VapiStruct.__init__(self)


BackupUiFramesInfoList._set_binding_type(type.StructType(
    'com.vmware.nsx.model.backup_ui_frames_info_list', {
        'backup_frames_list': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BackupUiFramesInfo'))),
    },
    BackupUiFramesInfoList,
    False,
    None))



class BaseFirewallProfile(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BaseFirewallProfile"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    RESOURCE_TYPE_FIREWALLSESSIONTIMERPROFILE = "FirewallSessionTimerProfile"
    """


    """
    RESOURCE_TYPE_FIREWALLCPUMEMTHRESHOLDSPROFILE = "FirewallCpuMemThresholdsProfile"
    """


    """
    RESOURCE_TYPE_FIREWALLFLOODPROTECTIONPROFILE = "FirewallFloodProtectionProfile"
    """


    """
    RESOURCE_TYPE_FIREWALLDNSPROFILE = "FirewallDnsProfile"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='BaseFirewallProfile',
                 tags=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            *
              :attr:`BaseFirewallProfile.RESOURCE_TYPE_FIREWALLSESSIONTIMERPROFILE`
            *
              :attr:`BaseFirewallProfile.RESOURCE_TYPE_FIREWALLCPUMEMTHRESHOLDSPROFILE`
            *
              :attr:`BaseFirewallProfile.RESOURCE_TYPE_FIREWALLFLOODPROTECTIONPROFILE`
            * :attr:`BaseFirewallProfile.RESOURCE_TYPE_FIREWALLDNSPROFILE`
            
             Resource type to use as profile type
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BaseFirewallProfile._set_binding_type(type.StructType(
    'com.vmware.nsx.model.base_firewall_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
    },
    BaseFirewallProfile,
    False,
    None))



class BaseHostSwitchProfile(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BaseHostSwitchProfile"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    RESOURCE_TYPE_UPLINKHOSTSWITCHPROFILE = "UplinkHostSwitchProfile"
    """


    """
    RESOURCE_TYPE_LLDPHOSTSWITCHPROFILE = "LldpHostSwitchProfile"
    """


    """
    RESOURCE_TYPE_NIOCPROFILE = "NiocProfile"
    """


    """
    RESOURCE_TYPE_EXTRACONFIGHOSTSWITCHPROFILE = "ExtraConfigHostSwitchProfile"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'required_capabilities': 'required_capabilities',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='BaseHostSwitchProfile',
                 tags=None,
                 required_capabilities=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            *
              :attr:`BaseHostSwitchProfile.RESOURCE_TYPE_UPLINKHOSTSWITCHPROFILE`
            * :attr:`BaseHostSwitchProfile.RESOURCE_TYPE_LLDPHOSTSWITCHPROFILE`
            * :attr:`BaseHostSwitchProfile.RESOURCE_TYPE_NIOCPROFILE`
            *
              :attr:`BaseHostSwitchProfile.RESOURCE_TYPE_EXTRACONFIGHOSTSWITCHPROFILE`
            
             Supported HostSwitch profiles.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  required_capabilities: :class:`list` of :class:`str` or ``None``
        :param required_capabilities: 
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.required_capabilities = required_capabilities
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BaseHostSwitchProfile._set_binding_type(type.StructType(
    'com.vmware.nsx.model.base_host_switch_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'required_capabilities': type.OptionalType(type.ListType(type.StringType())),
    },
    BaseHostSwitchProfile,
    False,
    None))



class BaseNodeAggregateInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'display_name': 'display_name',
                            'id': 'id',
                            'node_interface_properties': 'node_interface_properties',
                            'node_interface_statistics': 'node_interface_statistics',
                            'node_status': 'node_status',
                            'node_status_properties': 'node_status_properties',
                            }

    def __init__(self,
                 display_name=None,
                 id=None,
                 node_interface_properties=None,
                 node_interface_statistics=None,
                 node_status=None,
                 node_status_properties=None,
                ):
        """
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_interface_properties: :class:`list` of :class:`NodeInterfaceProperties` or ``None``
        :param node_interface_properties: Array of Node interface statistic properties
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_interface_statistics: :class:`list` of :class:`NodeInterfaceStatisticsProperties` or ``None``
        :param node_interface_statistics: Array of Node network interface statistic properties
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_status: :class:`ClusterNodeStatus` or ``None``
        :param node_status: 
        :type  node_status_properties: :class:`list` of :class:`NodeStatusProperties` or ``None``
        :param node_status_properties: Time series of the node's system properties
        """
        self.display_name = display_name
        self.id = id
        self.node_interface_properties = node_interface_properties
        self.node_interface_statistics = node_interface_statistics
        self.node_status = node_status
        self.node_status_properties = node_status_properties
        VapiStruct.__init__(self)


BaseNodeAggregateInfo._set_binding_type(type.StructType(
    'com.vmware.nsx.model.base_node_aggregate_info', {
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'node_interface_properties': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NodeInterfaceProperties'))),
        'node_interface_statistics': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NodeInterfaceStatisticsProperties'))),
        'node_status': type.OptionalType(type.ReferenceType(__name__, 'ClusterNodeStatus')),
        'node_status_properties': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NodeStatusProperties'))),
    },
    BaseNodeAggregateInfo,
    False,
    None))



class BaseServiceInstance(VapiStruct):
    """
    The deployment of a registered service. service instance is instantiation
    of service.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BaseServiceInstance"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    RESOURCE_TYPE_SERVICEINSTANCE = "ServiceInstance"
    """


    """
    RESOURCE_TYPE_BYODSERVICEINSTANCE = "ByodServiceInstance"
    """


    """
    RESOURCE_TYPE_VIRTUALSERVICEINSTANCE = "VirtualServiceInstance"
    """


    """
    ON_FAILURE_POLICY_ALLOW = "ALLOW"
    """


    """
    ON_FAILURE_POLICY_BLOCK = "BLOCK"
    """


    """
    TRANSPORT_TYPE_L2_BRIDGE = "L2_BRIDGE"
    """


    """
    TRANSPORT_TYPE_L3_ROUTED = "L3_ROUTED"
    """


    """
    TRANSPORT_TYPE_NSH = "NSH"
    """


    """
    TRANSPORT_TYPE_NA = "NA"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'on_failure_policy': 'on_failure_policy',
                            'service_id': 'service_id',
                            'transport_type': 'transport_type',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='BaseServiceInstance',
                 tags=None,
                 on_failure_policy=None,
                 service_id=None,
                 transport_type=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`BaseServiceInstance.RESOURCE_TYPE_SERVICEINSTANCE`
            * :attr:`BaseServiceInstance.RESOURCE_TYPE_BYODSERVICEINSTANCE`
            * :attr:`BaseServiceInstance.RESOURCE_TYPE_VIRTUALSERVICEINSTANCE`
            
            ServiceInstance is used when NSX handles the lifecyle of appliance.
            Deployment and appliance related all the information is necessary.
            ByodServiceInstance is a custom instance to be used when NSX is not
            handling the lifecycles of appliance/s. User will manage their own
            appliance (BYOD) to connect with NSX. VirtualServiceInstance is a a
            custom instance to be used when NSX is not handling the lifecycle
            of an appliance and when the user is not bringing their own
            appliance.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  on_failure_policy: :class:`str` or ``None``
        :param on_failure_policy: Possible values are: 
            
            * :attr:`BaseServiceInstance.ON_FAILURE_POLICY_ALLOW`
            * :attr:`BaseServiceInstance.ON_FAILURE_POLICY_BLOCK`
            
            Failure policy of the service instance - if it has to be different
            from the service. By default the service instance inherits the
            FailurePolicy of the service it belongs to.
        :type  service_id: :class:`str` or ``None``
        :param service_id: The Service to which the service instance is associated.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  transport_type: :class:`str` or ``None``
        :param transport_type: Possible values are: 
            
            * :attr:`BaseServiceInstance.TRANSPORT_TYPE_L2_BRIDGE`
            * :attr:`BaseServiceInstance.TRANSPORT_TYPE_L3_ROUTED`
            * :attr:`BaseServiceInstance.TRANSPORT_TYPE_NSH`
            * :attr:`BaseServiceInstance.TRANSPORT_TYPE_NA`
            
            Transport to be used by this service instance for deploying the
            Service-VM. This field is to be set Not Applicable(NA) if the
            service only caters to functionality EPP(Endpoint Protection).
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.on_failure_policy = on_failure_policy
        self.service_id = service_id
        self.transport_type = transport_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BaseServiceInstance._set_binding_type(type.StructType(
    'com.vmware.nsx.model.base_service_instance', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'on_failure_policy': type.OptionalType(type.StringType()),
        'service_id': type.OptionalType(type.StringType()),
        'transport_type': type.OptionalType(type.StringType()),
    },
    BaseServiceInstance,
    False,
    None))



class BaseServiceProfile(VapiStruct):
    """
    Base Service Profile

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BaseServiceProfile"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='BaseServiceProfile',
                 tags=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Service Profile type, for example 'GiServiceProfile',
            'ServiceInsertionServiceProfile'
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BaseServiceProfile._set_binding_type(type.StructType(
    'com.vmware.nsx.model.base_service_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
    },
    BaseServiceProfile,
    False,
    None))



class BaseSwitchingProfile(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BaseSwitchingProfile"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'required_capabilities': 'required_capabilities',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='BaseSwitchingProfile',
                 tags=None,
                 required_capabilities=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  required_capabilities: :class:`list` of :class:`str` or ``None``
        :param required_capabilities: 
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.required_capabilities = required_capabilities
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BaseSwitchingProfile._set_binding_type(type.StructType(
    'com.vmware.nsx.model.base_switching_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'required_capabilities': type.OptionalType(type.ListType(type.StringType())),
    },
    BaseSwitchingProfile,
    False,
    None))



class BasicAuthenticationScheme(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    SCHEME_NAME_BASIC = "basic"
    """


    """



    _canonical_to_pep_names = {
                            'scheme_name': 'scheme_name',
                            'password': 'password',
                            'username': 'username',
                            }

    def __init__(self,
                 scheme_name=None,
                 password=None,
                 username=None,
                ):
        """
        :type  scheme_name: :class:`str` or ``None``
        :param scheme_name: Possible values are: 
            
            * :attr:`BasicAuthenticationScheme.SCHEME_NAME_BASIC`
            
             Authentication scheme name
        :type  password: :class:`str` or ``None``
        :param password: Password to authenticate with
        :type  username: :class:`str` or ``None``
        :param username: User name to authenticate with
        """
        self.scheme_name = scheme_name
        self.password = password
        self.username = username
        VapiStruct.__init__(self)


BasicAuthenticationScheme._set_binding_type(type.StructType(
    'com.vmware.nsx.model.basic_authentication_scheme', {
        'scheme_name': type.OptionalType(type.StringType()),
        'password': type.OptionalType(type.StringType()),
        'username': type.OptionalType(type.StringType()),
    },
    BasicAuthenticationScheme,
    False,
    None))



class BatchRequest(VapiStruct):
    """
    A set of operations to be performed in a single batch

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'continue_on_error': 'continue_on_error',
                            'requests': 'requests',
                            }

    def __init__(self,
                 continue_on_error=None,
                 requests=None,
                ):
        """
        :type  continue_on_error: :class:`bool` or ``None``
        :param continue_on_error: Flag to decide if we will continue processing subsequent requests
            in case of current error for atomic = false.
        :type  requests: :class:`list` of :class:`BatchRequestItem` or ``None``
        :param requests: 
        """
        self.continue_on_error = continue_on_error
        self.requests = requests
        VapiStruct.__init__(self)


BatchRequest._set_binding_type(type.StructType(
    'com.vmware.nsx.model.batch_request', {
        'continue_on_error': type.OptionalType(type.BooleanType()),
        'requests': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BatchRequestItem'))),
    },
    BatchRequest,
    False,
    None))



class BatchRequestItem(VapiStruct):
    """
    A single request within a batch of operations

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    METHOD_GET = "GET"
    """


    """
    METHOD_POST = "POST"
    """


    """
    METHOD_PUT = "PUT"
    """


    """
    METHOD_DELETE = "DELETE"
    """


    """
    METHOD_PATCH = "PATCH"
    """


    """



    _canonical_to_pep_names = {
                            'body': 'body',
                            'method': 'method',
                            'uri': 'uri',
                            }

    def __init__(self,
                 body=None,
                 method=None,
                 uri=None,
                ):
        """
        :type  body: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param body: 
        :type  method: :class:`str` or ``None``
        :param method: Possible values are: 
            
            * :attr:`BatchRequestItem.METHOD_GET`
            * :attr:`BatchRequestItem.METHOD_POST`
            * :attr:`BatchRequestItem.METHOD_PUT`
            * :attr:`BatchRequestItem.METHOD_DELETE`
            * :attr:`BatchRequestItem.METHOD_PATCH`
            
             http method type
        :type  uri: :class:`str` or ``None``
        :param uri: relative uri (path and args), of the call including resource id (if
            this is a POST/DELETE), exclude hostname and port and prefix,
            exploded form of parameters
        """
        self.body = body
        self.method = method
        self.uri = uri
        VapiStruct.__init__(self)


BatchRequestItem._set_binding_type(type.StructType(
    'com.vmware.nsx.model.batch_request_item', {
        'body': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
        'method': type.OptionalType(type.StringType()),
        'uri': type.OptionalType(type.StringType()),
    },
    BatchRequestItem,
    False,
    None))



class BatchResponse(VapiStruct):
    """
    The reponse to a batch operation

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'has_errors': 'has_errors',
                            'results': 'results',
                            'rolled_back': 'rolled_back',
                            }

    def __init__(self,
                 has_errors=None,
                 results=None,
                 rolled_back=None,
                ):
        """
        :type  has_errors: :class:`bool` or ``None``
        :param has_errors: Indicates if any of the APIs failed
        :type  results: :class:`list` of :class:`BatchResponseItem` or ``None``
        :param results: Bulk list results
        :type  rolled_back: :class:`bool` or ``None``
        :param rolled_back: Optional flag indicating that all items were rolled back even if
            succeeded initially
        """
        self.has_errors = has_errors
        self.results = results
        self.rolled_back = rolled_back
        VapiStruct.__init__(self)


BatchResponse._set_binding_type(type.StructType(
    'com.vmware.nsx.model.batch_response', {
        'has_errors': type.OptionalType(type.BooleanType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BatchResponseItem'))),
        'rolled_back': type.OptionalType(type.BooleanType()),
    },
    BatchResponse,
    False,
    None))



class BatchResponseItem(VapiStruct):
    """
    A single respose in a list of batched responses

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'body': 'body',
                            'code': 'code',
                            'headers': 'headers',
                            }

    def __init__(self,
                 body=None,
                 code=None,
                 headers=None,
                ):
        """
        :type  body: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param body: object returned by api
        :type  code: :class:`long` or ``None``
        :param code: http status code format: int64
        :type  headers: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param headers: The headers returned by the API call
        """
        self.body = body
        self.code = code
        self.headers = headers
        VapiStruct.__init__(self)


BatchResponseItem._set_binding_type(type.StructType(
    'com.vmware.nsx.model.batch_response_item', {
        'body': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
        'code': type.OptionalType(type.IntegerType()),
        'headers': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
    },
    BatchResponseItem,
    False,
    None))



class BfdConfig(VapiStruct):
    """
    BFD configuration for LogicalRouter

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'declare_dead_multiple': 'declare_dead_multiple',
                            'enabled': 'enabled',
                            'logical_router_id': 'logical_router_id',
                            'receive_interval': 'receive_interval',
                            'transmit_interval': 'transmit_interval',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 declare_dead_multiple=None,
                 enabled=None,
                 logical_router_id=None,
                 receive_interval=None,
                 transmit_interval=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  declare_dead_multiple: :class:`long` or ``None``
        :param declare_dead_multiple: Number of times a packet is missed before BFD declares the neighbor
            down. format: int64
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Flag to enable BFD for this LogicalRouter
        :type  logical_router_id: :class:`str` or ``None``
        :param logical_router_id: Logical router id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  receive_interval: :class:`long` or ``None``
        :param receive_interval: the time interval (in milliseconds) between heartbeat packets for
            BFD when receiving heartbeats. format: int64
        :type  transmit_interval: :class:`long` or ``None``
        :param transmit_interval: the time interval (in milliseconds) between heartbeat packets for
            BFD when sending heartbeats. format: int64
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.declare_dead_multiple = declare_dead_multiple
        self.enabled = enabled
        self.logical_router_id = logical_router_id
        self.receive_interval = receive_interval
        self.transmit_interval = transmit_interval
        VapiStruct.__init__(self)


BfdConfig._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bfd_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'declare_dead_multiple': type.OptionalType(type.IntegerType()),
        'enabled': type.OptionalType(type.BooleanType()),
        'logical_router_id': type.OptionalType(type.StringType()),
        'receive_interval': type.OptionalType(type.IntegerType()),
        'transmit_interval': type.OptionalType(type.IntegerType()),
    },
    BfdConfig,
    False,
    None))



class BfdConfigParameters(VapiStruct):
    """
    BFD configuration for the given Peer.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'declare_dead_multiple': 'declare_dead_multiple',
                            'receive_interval': 'receive_interval',
                            'transmit_interval': 'transmit_interval',
                            }

    def __init__(self,
                 declare_dead_multiple=None,
                 receive_interval=None,
                 transmit_interval=None,
                ):
        """
        :type  declare_dead_multiple: :class:`long` or ``None``
        :param declare_dead_multiple: Number of times a packet is missed before BFD declares the neighbor
            down. format: int64
        :type  receive_interval: :class:`long` or ``None``
        :param receive_interval: The time interval (in milliseconds) between heartbeat packets for
            BFD when receiving heartbeats.| For edge cluster type of bare
            metal, this value should be >= 50ms.| For edge cluster type of
            virtual machine or hybrid, this value should be >= 500ms. format:
            int64
        :type  transmit_interval: :class:`long` or ``None``
        :param transmit_interval: The time interval (in milliseconds) between heartbeat packets for
            BFD when sending heartbeats.| For edge cluster type of bare metal,
            this value should be >= 300ms.| For edge cluster type of virtual
            machine or hybrid, this value should be >= 1000ms. format: int64
        """
        self.declare_dead_multiple = declare_dead_multiple
        self.receive_interval = receive_interval
        self.transmit_interval = transmit_interval
        VapiStruct.__init__(self)


BfdConfigParameters._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bfd_config_parameters', {
        'declare_dead_multiple': type.OptionalType(type.IntegerType()),
        'receive_interval': type.OptionalType(type.IntegerType()),
        'transmit_interval': type.OptionalType(type.IntegerType()),
    },
    BfdConfigParameters,
    False,
    None))



class BfdHealthMonitoringProfile(VapiStruct):
    """
    Profile for BFD health monitoring

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BfdHealthMonitoringProfile"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'enabled': 'enabled',
                            'latency_enabled': 'latency_enabled',
                            'probe_interval': 'probe_interval',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            }

    def __init__(self,
                 enabled=None,
                 latency_enabled=None,
                 probe_interval=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='BfdHealthMonitoringProfile',
                 tags=None,
                ):
        """
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Whether the heartbeat is enabled. A POST or PUT request with
            \"enabled\" false (with no probe intervals) will set (POST) or
            reset (PUT) the probe_interval to their default value.
        :type  latency_enabled: :class:`bool` or ``None``
        :param latency_enabled: The flag is to turn on/off latency. A POST or PUT request with
            \"latency_enabled\" true will enable NSX to send the networking
            latency data to thrid-party monitoring tools like vRNI.
        :type  probe_interval: :class:`long` or ``None``
        :param probe_interval: The time interval (in millisec) between probe packets for tunnels
            between transport nodes. format: int64
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            *
              :attr:`TransportZoneProfile.RESOURCE_TYPE_BFDHEALTHMONITORINGPROFILE`
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        """
        self.enabled = enabled
        self.latency_enabled = latency_enabled
        self.probe_interval = probe_interval
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BfdHealthMonitoringProfile._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bfd_health_monitoring_profile', {
        'enabled': type.OptionalType(type.BooleanType()),
        'latency_enabled': type.OptionalType(type.BooleanType()),
        'probe_interval': type.OptionalType(type.IntegerType()),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
    },
    BfdHealthMonitoringProfile,
    False,
    None))



class BgpAddressFamily(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_IPV4_UNICAST = "IPV4_UNICAST"
    """


    """
    TYPE_VPNV4_UNICAST = "VPNV4_UNICAST"
    """


    """
    TYPE_IPV6_UNICAST = "IPV6_UNICAST"
    """


    """
    TYPE_L2VPN_EVPN = "L2VPN_EVPN"
    """


    """



    _canonical_to_pep_names = {
                            'in_prefix_count': 'in_prefix_count',
                            'out_prefix_count': 'out_prefix_count',
                            'type': 'type',
                            }

    def __init__(self,
                 in_prefix_count=None,
                 out_prefix_count=None,
                 type=None,
                ):
        """
        :type  in_prefix_count: :class:`long` or ``None``
        :param in_prefix_count: Count of in prefixes format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  out_prefix_count: :class:`long` or ``None``
        :param out_prefix_count: Count of out prefixes format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`BgpAddressFamily.TYPE_IPV4_UNICAST`
            * :attr:`BgpAddressFamily.TYPE_VPNV4_UNICAST`
            * :attr:`BgpAddressFamily.TYPE_IPV6_UNICAST`
            * :attr:`BgpAddressFamily.TYPE_L2VPN_EVPN`
            
             BGP address family type
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.in_prefix_count = in_prefix_count
        self.out_prefix_count = out_prefix_count
        self.type = type
        VapiStruct.__init__(self)


BgpAddressFamily._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bgp_address_family', {
        'in_prefix_count': type.OptionalType(type.IntegerType()),
        'out_prefix_count': type.OptionalType(type.IntegerType()),
        'type': type.OptionalType(type.StringType()),
    },
    BgpAddressFamily,
    False,
    None))



class BgpConfig(VapiStruct):
    """
    BGP configuration for Tier0 logical router. We create BGP configuration
    while creation of Tier0 logical router.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'as_num': 'as_num',
                            'as_number': 'as_number',
                            'ecmp': 'ecmp',
                            'enabled': 'enabled',
                            'graceful_restart': 'graceful_restart',
                            'graceful_restart_config': 'graceful_restart_config',
                            'inter_sr_ibgp': 'inter_sr_ibgp',
                            'logical_router_id': 'logical_router_id',
                            'multipath_relax': 'multipath_relax',
                            'route_aggregation': 'route_aggregation',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 as_num=None,
                 as_number=None,
                 ecmp=None,
                 enabled=None,
                 graceful_restart=None,
                 graceful_restart_config=None,
                 inter_sr_ibgp=None,
                 logical_router_id=None,
                 multipath_relax=None,
                 route_aggregation=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  as_num: :class:`str` or ``None``
        :param as_num: For VRF logical router, the as_num from parent logical router will
            be effective.
        :type  as_number: :class:`long` or ``None``
        :param as_number: This is a deprecated property, Please use 'as_num' instead. For VRF
            logical router, the as_number from parent logical router will be
            effective. format: int64
        :type  ecmp: :class:`bool` or ``None``
        :param ecmp: While creation of BGP config this flag will be set to true User can
            change this value while updating BGP config. If this property is
            not specified in the payload, the default value will be considered
            as true.
        :type  enabled: :class:`bool` or ``None``
        :param enabled: While creation of BGP config this flag will be set to - true for
            Tier0 logical router with Active-Active high-availability mode -
            false for Tier0 logical router with Active-Standby
            high-availanility mode. User can change this value while updating
            the config. If this property is not specified in the payload, the
            default value will be considered as false irrespective of the
            high-availability mode.
        :type  graceful_restart: :class:`bool` or ``None``
        :param graceful_restart: Flag to enable graceful restart. This field is deprecated, kindly
            use graceful_restart_config parameter for graceful restart
            configuration. If both parameters are set and consistent with each
            other [i.e. graceful_restart=false and
            graceful_restart_mode=HELPER_ONLY OR graceful_restart=true and
            graceful_restart_mode=GR_AND_HELPER] then this is allowed, but if
            inconsistent with each other then this is not allowed and
            validation error will be thrown. For VRF logical router, the
            settings from parent logical router will be effective.
        :type  graceful_restart_config: :class:`GracefulRestartConfig` or ``None``
        :param graceful_restart_config: Configuration parameters for BGP Graceful Restart functionality. It
            has graceful_restart_mode and graceful_restart_timer parameters.
            For VRF logical router, the settings from parent logical router
            will be effective.
        :type  inter_sr_ibgp: :class:`InterSRRoutingConfig` or ``None``
        :param inter_sr_ibgp: Inter SR IBGP configuration
        :type  logical_router_id: :class:`str` or ``None``
        :param logical_router_id: Logical router id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  multipath_relax: :class:`bool` or ``None``
        :param multipath_relax: For TIER0 logical router, default is true. For VRF logical router,
            the settings from parent logical router will be effective.
        :type  route_aggregation: :class:`list` of :class:`BgpRouteAggregation` or ``None``
        :param route_aggregation: List of routes to be aggregated
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.as_num = as_num
        self.as_number = as_number
        self.ecmp = ecmp
        self.enabled = enabled
        self.graceful_restart = graceful_restart
        self.graceful_restart_config = graceful_restart_config
        self.inter_sr_ibgp = inter_sr_ibgp
        self.logical_router_id = logical_router_id
        self.multipath_relax = multipath_relax
        self.route_aggregation = route_aggregation
        VapiStruct.__init__(self)


BgpConfig._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bgp_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'as_num': type.OptionalType(type.StringType()),
        'as_number': type.OptionalType(type.IntegerType()),
        'ecmp': type.OptionalType(type.BooleanType()),
        'enabled': type.OptionalType(type.BooleanType()),
        'graceful_restart': type.OptionalType(type.BooleanType()),
        'graceful_restart_config': type.OptionalType(type.ReferenceType(__name__, 'GracefulRestartConfig')),
        'inter_sr_ibgp': type.OptionalType(type.ReferenceType(__name__, 'InterSRRoutingConfig')),
        'logical_router_id': type.OptionalType(type.StringType()),
        'multipath_relax': type.OptionalType(type.BooleanType()),
        'route_aggregation': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BgpRouteAggregation'))),
    },
    BgpConfig,
    False,
    None))



class BgpNeighbor(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    GRACEFUL_RESTART_MODE_DISABLE = "DISABLE"
    """


    """
    GRACEFUL_RESTART_MODE_HELPER_ONLY = "HELPER_ONLY"
    """


    """
    GRACEFUL_RESTART_MODE_GR_AND_HELPER = "GR_AND_HELPER"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'address_families': 'address_families',
                            'allow_as_in': 'allow_as_in',
                            'bfd_config': 'bfd_config',
                            'enable_bfd': 'enable_bfd',
                            'enabled': 'enabled',
                            'filter_in_ipprefixlist_id': 'filter_in_ipprefixlist_id',
                            'filter_in_routemap_id': 'filter_in_routemap_id',
                            'filter_out_ipprefixlist_id': 'filter_out_ipprefixlist_id',
                            'filter_out_routemap_id': 'filter_out_routemap_id',
                            'graceful_restart_mode': 'graceful_restart_mode',
                            'hold_down_timer': 'hold_down_timer',
                            'keep_alive_timer': 'keep_alive_timer',
                            'logical_router_id': 'logical_router_id',
                            'maximum_hop_limit': 'maximum_hop_limit',
                            'neighbor_address': 'neighbor_address',
                            'password': 'password',
                            'remote_as': 'remote_as',
                            'remote_as_num': 'remote_as_num',
                            'source_address': 'source_address',
                            'source_addresses': 'source_addresses',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 address_families=None,
                 allow_as_in=None,
                 bfd_config=None,
                 enable_bfd=None,
                 enabled=None,
                 filter_in_ipprefixlist_id=None,
                 filter_in_routemap_id=None,
                 filter_out_ipprefixlist_id=None,
                 filter_out_routemap_id=None,
                 graceful_restart_mode=None,
                 hold_down_timer=None,
                 keep_alive_timer=None,
                 logical_router_id=None,
                 maximum_hop_limit=None,
                 neighbor_address=None,
                 password=None,
                 remote_as=None,
                 remote_as_num=None,
                 source_address=None,
                 source_addresses=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  address_families: :class:`list` of :class:`BgpNeighborAddressFamily` or ``None``
        :param address_families: User can enable the neighbor for the specific address families and
            also define filters per address family. When the neighbor is
            created, it is default enabled for IPV4_UNICAST address family for
            backward compatibility reasons. User can change that if required,
            by defining the address family configuration.
        :type  allow_as_in: :class:`bool` or ``None``
        :param allow_as_in: Flag to enable allowas_in option for BGP neighbor
        :type  bfd_config: :class:`BfdConfigParameters` or ``None``
        :param bfd_config: By specifying these paramaters BFD config for this given peer can
            be overriden | (the globally configured values will not apply for
            this peer)
        :type  enable_bfd: :class:`bool` or ``None``
        :param enable_bfd: Flag to enable BFD for this BGP Neighbor. Enable this if the
            neighbor supports BFD as this will lead to faster convergence.
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Flag to enable this BGP Neighbor
        :type  filter_in_ipprefixlist_id: :class:`str` or ``None``
        :param filter_in_ipprefixlist_id: This is a deprecated property, Please use 'address_family' instead.
        :type  filter_in_routemap_id: :class:`str` or ``None``
        :param filter_in_routemap_id: This is a deprecated property, Please use 'address_family' instead.
        :type  filter_out_ipprefixlist_id: :class:`str` or ``None``
        :param filter_out_ipprefixlist_id: This is a deprecated property, Please use 'address_family' instead.
        :type  filter_out_routemap_id: :class:`str` or ``None``
        :param filter_out_routemap_id: This is a deprecated property, Please use 'address_family' instead.
        :type  graceful_restart_mode: :class:`str` or ``None``
        :param graceful_restart_mode: Possible values are: 
            
            * :attr:`BgpNeighbor.GRACEFUL_RESTART_MODE_DISABLE`
            * :attr:`BgpNeighbor.GRACEFUL_RESTART_MODE_HELPER_ONLY`
            * :attr:`BgpNeighbor.GRACEFUL_RESTART_MODE_GR_AND_HELPER`
            
            BGP Graceful Restart mode. If specified, then it will take
            precedence over global Graceful Restart mode configured in logical
            router BgpConfig otherwise BgpConfig level Graceful Restart mode
            will be applicable for peer.
        :type  hold_down_timer: :class:`long` or ``None``
        :param hold_down_timer: Wait period (seconds) before declaring peer dead format: int64
        :type  keep_alive_timer: :class:`long` or ``None``
        :param keep_alive_timer: Frequency (seconds) with which keep alive messages are sent to
            peers format: int64
        :type  logical_router_id: :class:`str` or ``None``
        :param logical_router_id: Logical router id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  maximum_hop_limit: :class:`long` or ``None``
        :param maximum_hop_limit: This value is set on TTL(time to live) of BGP header. When router
            receives the BGP packet, it decrements the TTL. The default value
            of TTL is one when BPG request is initiated.So in the case of a BGP
            peer multiple hops away and and value of TTL is one, then next
            router in the path will decrement the TTL to 0, realize it cant
            forward the packet and will drop it. If the hop count value to
            reach neighbor is equal to or less than the maximum_hop_limit value
            then intermediate router decrements the TTL count by one and
            forwards the request to BGP neighour. If the hop count value is
            greater than the maximum_hop_limit value then intermediate router
            discards the request when TTL becomes 0. format: int32
        :type  neighbor_address: :class:`str` or ``None``
        :param neighbor_address: Neighbor IP Address format: ip
        :type  password: :class:`str` or ``None``
        :param password: User can create (POST) the neighbor with or without the password.
            The view (GET) on the neighbor, would never reveal if the password
            is set or not. The password can be set later using edit neighbor
            workFlow (PUT) On the edit neighbor (PUT), if the user does not
            specify the password property, the older value is retained. Maximum
            length of this field is 20 characters.
        :type  remote_as: :class:`long` or ``None``
        :param remote_as: This is a deprecated property, Please use 'remote_as_num' instead.
            format: int64
        :type  remote_as_num: :class:`str` or ``None``
        :param remote_as_num: 4 Byte ASN of the neighbor in ASPLAIN/ASDOT Format
        :type  source_address: :class:`str` or ``None``
        :param source_address: Deprecated - do not provide a value for this field. Use
            source_addresses instead. format: ip
        :type  source_addresses: :class:`list` of :class:`str` or ``None``
        :param source_addresses: BGP neighborship will be formed from all these source addresses to
            this neighbour. format: ip
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.address_families = address_families
        self.allow_as_in = allow_as_in
        self.bfd_config = bfd_config
        self.enable_bfd = enable_bfd
        self.enabled = enabled
        self.filter_in_ipprefixlist_id = filter_in_ipprefixlist_id
        self.filter_in_routemap_id = filter_in_routemap_id
        self.filter_out_ipprefixlist_id = filter_out_ipprefixlist_id
        self.filter_out_routemap_id = filter_out_routemap_id
        self.graceful_restart_mode = graceful_restart_mode
        self.hold_down_timer = hold_down_timer
        self.keep_alive_timer = keep_alive_timer
        self.logical_router_id = logical_router_id
        self.maximum_hop_limit = maximum_hop_limit
        self.neighbor_address = neighbor_address
        self.password = password
        self.remote_as = remote_as
        self.remote_as_num = remote_as_num
        self.source_address = source_address
        self.source_addresses = source_addresses
        VapiStruct.__init__(self)


BgpNeighbor._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bgp_neighbor', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'address_families': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BgpNeighborAddressFamily'))),
        'allow_as_in': type.OptionalType(type.BooleanType()),
        'bfd_config': type.OptionalType(type.ReferenceType(__name__, 'BfdConfigParameters')),
        'enable_bfd': type.OptionalType(type.BooleanType()),
        'enabled': type.OptionalType(type.BooleanType()),
        'filter_in_ipprefixlist_id': type.OptionalType(type.StringType()),
        'filter_in_routemap_id': type.OptionalType(type.StringType()),
        'filter_out_ipprefixlist_id': type.OptionalType(type.StringType()),
        'filter_out_routemap_id': type.OptionalType(type.StringType()),
        'graceful_restart_mode': type.OptionalType(type.StringType()),
        'hold_down_timer': type.OptionalType(type.IntegerType()),
        'keep_alive_timer': type.OptionalType(type.IntegerType()),
        'logical_router_id': type.OptionalType(type.StringType()),
        'maximum_hop_limit': type.OptionalType(type.IntegerType()),
        'neighbor_address': type.OptionalType(type.StringType()),
        'password': type.OptionalType(type.StringType()),
        'remote_as': type.OptionalType(type.IntegerType()),
        'remote_as_num': type.OptionalType(type.StringType()),
        'source_address': type.OptionalType(type.StringType()),
        'source_addresses': type.OptionalType(type.ListType(type.StringType())),
    },
    BgpNeighbor,
    False,
    None))



class BgpNeighborAddressFamily(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_IPV4_UNICAST = "IPV4_UNICAST"
    """


    """
    TYPE_VPNV4_UNICAST = "VPNV4_UNICAST"
    """


    """
    TYPE_IPV6_UNICAST = "IPV6_UNICAST"
    """


    """
    TYPE_L2VPN_EVPN = "L2VPN_EVPN"
    """


    """



    _canonical_to_pep_names = {
                            'enabled': 'enabled',
                            'in_filter_ipprefixlist_id': 'in_filter_ipprefixlist_id',
                            'in_filter_routemap_id': 'in_filter_routemap_id',
                            'maximum_routes': 'maximum_routes',
                            'out_filter_ipprefixlist_id': 'out_filter_ipprefixlist_id',
                            'out_filter_routemap_id': 'out_filter_routemap_id',
                            'type': 'type',
                            }

    def __init__(self,
                 enabled=None,
                 in_filter_ipprefixlist_id=None,
                 in_filter_routemap_id=None,
                 maximum_routes=None,
                 out_filter_ipprefixlist_id=None,
                 out_filter_routemap_id=None,
                 type=None,
                ):
        """
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Enable this address family
        :type  in_filter_ipprefixlist_id: :class:`str` or ``None``
        :param in_filter_ipprefixlist_id: Id of the IPPrefix List to be used for IN direction filter
        :type  in_filter_routemap_id: :class:`str` or ``None``
        :param in_filter_routemap_id: Id of the RouteMap to be used for IN direction filter
        :type  maximum_routes: :class:`long` or ``None``
        :param maximum_routes: Maximum number of routes supported on the address family format:
            int64
        :type  out_filter_ipprefixlist_id: :class:`str` or ``None``
        :param out_filter_ipprefixlist_id: Id of the IPPrefixList to be used for OUT direction filter
        :type  out_filter_routemap_id: :class:`str` or ``None``
        :param out_filter_routemap_id: Id of the RouteMap to be used for OUT direction filter
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`BgpNeighborAddressFamily.TYPE_IPV4_UNICAST`
            * :attr:`BgpNeighborAddressFamily.TYPE_VPNV4_UNICAST`
            * :attr:`BgpNeighborAddressFamily.TYPE_IPV6_UNICAST`
            * :attr:`BgpNeighborAddressFamily.TYPE_L2VPN_EVPN`
            
             Address family type
        """
        self.enabled = enabled
        self.in_filter_ipprefixlist_id = in_filter_ipprefixlist_id
        self.in_filter_routemap_id = in_filter_routemap_id
        self.maximum_routes = maximum_routes
        self.out_filter_ipprefixlist_id = out_filter_ipprefixlist_id
        self.out_filter_routemap_id = out_filter_routemap_id
        self.type = type
        VapiStruct.__init__(self)


BgpNeighborAddressFamily._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bgp_neighbor_address_family', {
        'enabled': type.OptionalType(type.BooleanType()),
        'in_filter_ipprefixlist_id': type.OptionalType(type.StringType()),
        'in_filter_routemap_id': type.OptionalType(type.StringType()),
        'maximum_routes': type.OptionalType(type.IntegerType()),
        'out_filter_ipprefixlist_id': type.OptionalType(type.StringType()),
        'out_filter_routemap_id': type.OptionalType(type.StringType()),
        'type': type.OptionalType(type.StringType()),
    },
    BgpNeighborAddressFamily,
    False,
    None))



class BgpNeighborListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`BgpNeighbor` or ``None``
        :param results: Paginated list of bgp neighbors
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


BgpNeighborListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bgp_neighbor_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BgpNeighbor'))),
    },
    BgpNeighborListResult,
    False,
    None))



class BgpNeighborRouteDetails(VapiStruct):
    """
    BGP neighbor learned/advertised route details.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'logical_router_id': 'logical_router_id',
                            'neighbor_address': 'neighbor_address',
                            'neighbor_id': 'neighbor_id',
                            'per_transport_node_routes': 'per_transport_node_routes',
                            }

    def __init__(self,
                 logical_router_id=None,
                 neighbor_address=None,
                 neighbor_id=None,
                 per_transport_node_routes=None,
                ):
        """
        :type  logical_router_id: :class:`str` or ``None``
        :param logical_router_id: Logical router id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  neighbor_address: :class:`str` or ``None``
        :param neighbor_address: BGP neighbor peer IP address. format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  neighbor_id: :class:`str` or ``None``
        :param neighbor_id: BGP neighbor id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  per_transport_node_routes: :class:`list` of :class:`RoutesPerTransportNode` or ``None``
        :param per_transport_node_routes: Array of BGP neighbor route details per transport node.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.logical_router_id = logical_router_id
        self.neighbor_address = neighbor_address
        self.neighbor_id = neighbor_id
        self.per_transport_node_routes = per_transport_node_routes
        VapiStruct.__init__(self)


BgpNeighborRouteDetails._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bgp_neighbor_route_details', {
        'logical_router_id': type.OptionalType(type.StringType()),
        'neighbor_address': type.OptionalType(type.StringType()),
        'neighbor_id': type.OptionalType(type.StringType()),
        'per_transport_node_routes': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'RoutesPerTransportNode'))),
    },
    BgpNeighborRouteDetails,
    False,
    None))



class BgpNeighborRouteDetailsCsvRecord(VapiStruct):
    """
    BGP neighbor learned/advertised route details.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'as_path': 'as_path',
                            'local_pref': 'local_pref',
                            'logical_router_id': 'logical_router_id',
                            'med': 'med',
                            'neighbor_address': 'neighbor_address',
                            'neighbor_id': 'neighbor_id',
                            'network': 'network',
                            'next_hop': 'next_hop',
                            'source_address': 'source_address',
                            'transport_node_id': 'transport_node_id',
                            'weight': 'weight',
                            }

    def __init__(self,
                 as_path=None,
                 local_pref=None,
                 logical_router_id=None,
                 med=None,
                 neighbor_address=None,
                 neighbor_id=None,
                 network=None,
                 next_hop=None,
                 source_address=None,
                 transport_node_id=None,
                 weight=None,
                ):
        """
        :type  as_path: :class:`str` or ``None``
        :param as_path: BGP AS path attribute.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  local_pref: :class:`long` or ``None``
        :param local_pref: BGP Local Preference attribute. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  logical_router_id: :class:`str` or ``None``
        :param logical_router_id: Logical router id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  med: :class:`long` or ``None``
        :param med: BGP Multi Exit Discriminator attribute. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  neighbor_address: :class:`str` or ``None``
        :param neighbor_address: BGP neighbor peer IP address. format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  neighbor_id: :class:`str` or ``None``
        :param neighbor_id: BGP neighbor id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  network: :class:`str` or ``None``
        :param network: CIDR network address. format: ip-cidr-block
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  next_hop: :class:`str` or ``None``
        :param next_hop: Next hop IP address. format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  source_address: :class:`str` or ``None``
        :param source_address: BGP neighbor source address. format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  transport_node_id: :class:`str` or ``None``
        :param transport_node_id: Transport node id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  weight: :class:`long` or ``None``
        :param weight: BGP Weight attribute. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.as_path = as_path
        self.local_pref = local_pref
        self.logical_router_id = logical_router_id
        self.med = med
        self.neighbor_address = neighbor_address
        self.neighbor_id = neighbor_id
        self.network = network
        self.next_hop = next_hop
        self.source_address = source_address
        self.transport_node_id = transport_node_id
        self.weight = weight
        VapiStruct.__init__(self)


BgpNeighborRouteDetailsCsvRecord._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bgp_neighbor_route_details_csv_record', {
        'as_path': type.OptionalType(type.StringType()),
        'local_pref': type.OptionalType(type.IntegerType()),
        'logical_router_id': type.OptionalType(type.StringType()),
        'med': type.OptionalType(type.IntegerType()),
        'neighbor_address': type.OptionalType(type.StringType()),
        'neighbor_id': type.OptionalType(type.StringType()),
        'network': type.OptionalType(type.StringType()),
        'next_hop': type.OptionalType(type.StringType()),
        'source_address': type.OptionalType(type.StringType()),
        'transport_node_id': type.OptionalType(type.StringType()),
        'weight': type.OptionalType(type.IntegerType()),
    },
    BgpNeighborRouteDetailsCsvRecord,
    False,
    None))



class BgpNeighborRouteDetailsInCsvFormat(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'file_name': 'file_name',
                            'results': 'results',
                            }

    def __init__(self,
                 file_name=None,
                 results=None,
                ):
        """
        :type  file_name: :class:`str` or ``None``
        :param file_name: File name set by HTTP server if API returns CSV result as a file.
        :type  results: :class:`list` of :class:`BgpNeighborRouteDetailsCsvRecord` or ``None``
        :param results: 
        """
        self.file_name = file_name
        self.results = results
        VapiStruct.__init__(self)


BgpNeighborRouteDetailsInCsvFormat._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bgp_neighbor_route_details_in_csv_format', {
        'file_name': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BgpNeighborRouteDetailsCsvRecord'))),
    },
    BgpNeighborRouteDetailsInCsvFormat,
    False,
    None))



class BgpNeighborStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    CONNECTION_STATE_INVALID = "INVALID"
    """


    """
    CONNECTION_STATE_IDLE = "IDLE"
    """


    """
    CONNECTION_STATE_CONNECT = "CONNECT"
    """


    """
    CONNECTION_STATE_ACTIVE = "ACTIVE"
    """


    """
    CONNECTION_STATE_OPEN_SENT = "OPEN_SENT"
    """


    """
    CONNECTION_STATE_OPEN_CONFIRM = "OPEN_CONFIRM"
    """


    """
    CONNECTION_STATE_ESTABLISHED = "ESTABLISHED"
    """


    """
    CONNECTION_STATE_UNKNOWN = "UNKNOWN"
    """


    """



    _canonical_to_pep_names = {
                            'address_families': 'address_families',
                            'announced_capabilities': 'announced_capabilities',
                            'connection_drop_count': 'connection_drop_count',
                            'connection_state': 'connection_state',
                            'established_connection_count': 'established_connection_count',
                            'graceful_restart': 'graceful_restart',
                            'graceful_restart_mode': 'graceful_restart_mode',
                            'hold_time': 'hold_time',
                            'keep_alive_interval': 'keep_alive_interval',
                            'local_port': 'local_port',
                            'lr_component_id': 'lr_component_id',
                            'messages_received': 'messages_received',
                            'messages_sent': 'messages_sent',
                            'negotiated_capability': 'negotiated_capability',
                            'neighbor_address': 'neighbor_address',
                            'neighbor_router_id': 'neighbor_router_id',
                            'remote_as_number': 'remote_as_number',
                            'remote_port': 'remote_port',
                            'remote_site': 'remote_site',
                            'source_address': 'source_address',
                            'time_since_established': 'time_since_established',
                            'total_in_prefix_count': 'total_in_prefix_count',
                            'total_out_prefix_count': 'total_out_prefix_count',
                            'transport_node': 'transport_node',
                            }

    def __init__(self,
                 address_families=None,
                 announced_capabilities=None,
                 connection_drop_count=None,
                 connection_state=None,
                 established_connection_count=None,
                 graceful_restart=None,
                 graceful_restart_mode=None,
                 hold_time=None,
                 keep_alive_interval=None,
                 local_port=None,
                 lr_component_id=None,
                 messages_received=None,
                 messages_sent=None,
                 negotiated_capability=None,
                 neighbor_address=None,
                 neighbor_router_id=None,
                 remote_as_number=None,
                 remote_port=None,
                 remote_site=None,
                 source_address=None,
                 time_since_established=None,
                 total_in_prefix_count=None,
                 total_out_prefix_count=None,
                 transport_node=None,
                ):
        """
        :type  address_families: :class:`list` of :class:`BgpAddressFamily` or ``None``
        :param address_families: Address families of BGP neighbor
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  announced_capabilities: :class:`list` of :class:`str` or ``None``
        :param announced_capabilities: BGP capabilities sent to BGP neighbor.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  connection_drop_count: :class:`long` or ``None``
        :param connection_drop_count: Count of connection drop format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  connection_state: :class:`str` or ``None``
        :param connection_state: Possible values are: 
            
            * :attr:`BgpNeighborStatus.CONNECTION_STATE_INVALID`
            * :attr:`BgpNeighborStatus.CONNECTION_STATE_IDLE`
            * :attr:`BgpNeighborStatus.CONNECTION_STATE_CONNECT`
            * :attr:`BgpNeighborStatus.CONNECTION_STATE_ACTIVE`
            * :attr:`BgpNeighborStatus.CONNECTION_STATE_OPEN_SENT`
            * :attr:`BgpNeighborStatus.CONNECTION_STATE_OPEN_CONFIRM`
            * :attr:`BgpNeighborStatus.CONNECTION_STATE_ESTABLISHED`
            * :attr:`BgpNeighborStatus.CONNECTION_STATE_UNKNOWN`
            
             Current state of the BGP session.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  established_connection_count: :class:`long` or ``None``
        :param established_connection_count: Count of connections established format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  graceful_restart: :class:`bool` or ``None``
        :param graceful_restart: Current state of graceful restart where graceful_restart = true
            indicates graceful restart is enabled and graceful_restart = false
            indicates graceful restart is disabled. This is deprecated field,
            use graceful_restart_mode instead.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  graceful_restart_mode: :class:`str` or ``None``
        :param graceful_restart_mode: Current state of graceful restart of BGP neighbor. Possible values
            are - 1. GR_AND_HELPER - Graceful restart with Helper 2.
            HELPER_ONLY - Helper only 3. DISABLE - Disabled
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  hold_time: :class:`long` or ``None``
        :param hold_time: Time in ms to wait for HELLO from BGP peer. If a HELLO packet is
            not seen from BGP Peer withing hold_time then BGP neighbor will be
            marked as down. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  keep_alive_interval: :class:`long` or ``None``
        :param keep_alive_interval: Time in ms to wait for HELLO packet from BGP peer format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  local_port: :class:`long` or ``None``
        :param local_port: TCP port number of Local BGP connection format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  lr_component_id: :class:`str` or ``None``
        :param lr_component_id: Logical router component(Service Router/Distributed Router) id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  messages_received: :class:`long` or ``None``
        :param messages_received: Count of messages received from the neighbor format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  messages_sent: :class:`long` or ``None``
        :param messages_sent: Count of messages sent to the neighbor format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  negotiated_capability: :class:`list` of :class:`str` or ``None``
        :param negotiated_capability: BGP capabilities negotiated with BGP neighbor.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  neighbor_address: :class:`str` or ``None``
        :param neighbor_address: The IP of the BGP neighbor format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  neighbor_router_id: :class:`str` or ``None``
        :param neighbor_router_id: Router ID of the BGP neighbor. format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_as_number: :class:`str` or ``None``
        :param remote_as_number: AS number of the BGP neighbor
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_port: :class:`long` or ``None``
        :param remote_port: TCP port number of remote BGP Connection format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_site: :class:`ResourceReference` or ``None``
        :param remote_site: Remote site details.
        :type  source_address: :class:`str` or ``None``
        :param source_address: The Ip address of logical port format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  time_since_established: :class:`long` or ``None``
        :param time_since_established: Time(in milliseconds) since connection was established. format:
            int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  total_in_prefix_count: :class:`long` or ``None``
        :param total_in_prefix_count: Sum of in prefixes counts across all address families. format:
            int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  total_out_prefix_count: :class:`long` or ``None``
        :param total_out_prefix_count: Sum of out prefixes counts across all address families. format:
            int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  transport_node: :class:`ResourceReference` or ``None``
        :param transport_node: Transport node id and name
        """
        self.address_families = address_families
        self.announced_capabilities = announced_capabilities
        self.connection_drop_count = connection_drop_count
        self.connection_state = connection_state
        self.established_connection_count = established_connection_count
        self.graceful_restart = graceful_restart
        self.graceful_restart_mode = graceful_restart_mode
        self.hold_time = hold_time
        self.keep_alive_interval = keep_alive_interval
        self.local_port = local_port
        self.lr_component_id = lr_component_id
        self.messages_received = messages_received
        self.messages_sent = messages_sent
        self.negotiated_capability = negotiated_capability
        self.neighbor_address = neighbor_address
        self.neighbor_router_id = neighbor_router_id
        self.remote_as_number = remote_as_number
        self.remote_port = remote_port
        self.remote_site = remote_site
        self.source_address = source_address
        self.time_since_established = time_since_established
        self.total_in_prefix_count = total_in_prefix_count
        self.total_out_prefix_count = total_out_prefix_count
        self.transport_node = transport_node
        VapiStruct.__init__(self)


BgpNeighborStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bgp_neighbor_status', {
        'address_families': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BgpAddressFamily'))),
        'announced_capabilities': type.OptionalType(type.ListType(type.StringType())),
        'connection_drop_count': type.OptionalType(type.IntegerType()),
        'connection_state': type.OptionalType(type.StringType()),
        'established_connection_count': type.OptionalType(type.IntegerType()),
        'graceful_restart': type.OptionalType(type.BooleanType()),
        'graceful_restart_mode': type.OptionalType(type.StringType()),
        'hold_time': type.OptionalType(type.IntegerType()),
        'keep_alive_interval': type.OptionalType(type.IntegerType()),
        'local_port': type.OptionalType(type.IntegerType()),
        'lr_component_id': type.OptionalType(type.StringType()),
        'messages_received': type.OptionalType(type.IntegerType()),
        'messages_sent': type.OptionalType(type.IntegerType()),
        'negotiated_capability': type.OptionalType(type.ListType(type.StringType())),
        'neighbor_address': type.OptionalType(type.StringType()),
        'neighbor_router_id': type.OptionalType(type.StringType()),
        'remote_as_number': type.OptionalType(type.StringType()),
        'remote_port': type.OptionalType(type.IntegerType()),
        'remote_site': type.OptionalType(type.ReferenceType(__name__, 'ResourceReference')),
        'source_address': type.OptionalType(type.StringType()),
        'time_since_established': type.OptionalType(type.IntegerType()),
        'total_in_prefix_count': type.OptionalType(type.IntegerType()),
        'total_out_prefix_count': type.OptionalType(type.IntegerType()),
        'transport_node': type.OptionalType(type.ReferenceType(__name__, 'ResourceReference')),
    },
    BgpNeighborStatus,
    False,
    None))



class BgpNeighborStatusLiteDto(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    CONNECTION_STATE_INVALID = "INVALID"
    """


    """
    CONNECTION_STATE_IDLE = "IDLE"
    """


    """
    CONNECTION_STATE_CONNECT = "CONNECT"
    """


    """
    CONNECTION_STATE_ACTIVE = "ACTIVE"
    """


    """
    CONNECTION_STATE_OPEN_SENT = "OPEN_SENT"
    """


    """
    CONNECTION_STATE_OPEN_CONFIRM = "OPEN_CONFIRM"
    """


    """
    CONNECTION_STATE_ESTABLISHED = "ESTABLISHED"
    """


    """
    CONNECTION_STATE_UNKNOWN = "UNKNOWN"
    """


    """



    _canonical_to_pep_names = {
                            'connection_state': 'connection_state',
                            'neighbor_address': 'neighbor_address',
                            'remote_site': 'remote_site',
                            'source_address': 'source_address',
                            }

    def __init__(self,
                 connection_state=None,
                 neighbor_address=None,
                 remote_site=None,
                 source_address=None,
                ):
        """
        :type  connection_state: :class:`str` or ``None``
        :param connection_state: Possible values are: 
            
            * :attr:`BgpNeighborStatusLiteDto.CONNECTION_STATE_INVALID`
            * :attr:`BgpNeighborStatusLiteDto.CONNECTION_STATE_IDLE`
            * :attr:`BgpNeighborStatusLiteDto.CONNECTION_STATE_CONNECT`
            * :attr:`BgpNeighborStatusLiteDto.CONNECTION_STATE_ACTIVE`
            * :attr:`BgpNeighborStatusLiteDto.CONNECTION_STATE_OPEN_SENT`
            * :attr:`BgpNeighborStatusLiteDto.CONNECTION_STATE_OPEN_CONFIRM`
            * :attr:`BgpNeighborStatusLiteDto.CONNECTION_STATE_ESTABLISHED`
            * :attr:`BgpNeighborStatusLiteDto.CONNECTION_STATE_UNKNOWN`
            
             Current state of the BGP session.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  neighbor_address: :class:`str` or ``None``
        :param neighbor_address: Ip address of BGP neighbor. format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_site: :class:`ResourceReference` or ``None``
        :param remote_site: Remote site details.
        :type  source_address: :class:`str` or ``None``
        :param source_address: Source Ip address. format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.connection_state = connection_state
        self.neighbor_address = neighbor_address
        self.remote_site = remote_site
        self.source_address = source_address
        VapiStruct.__init__(self)


BgpNeighborStatusLiteDto._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bgp_neighbor_status_lite_dto', {
        'connection_state': type.OptionalType(type.StringType()),
        'neighbor_address': type.OptionalType(type.StringType()),
        'remote_site': type.OptionalType(type.ReferenceType(__name__, 'ResourceReference')),
        'source_address': type.OptionalType(type.StringType()),
    },
    BgpNeighborStatusLiteDto,
    False,
    None))



class BgpNeighborsStatusListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'last_update_timestamp': 'last_update_timestamp',
                            'logical_router_id': 'logical_router_id',
                            'logical_router_name': 'logical_router_name',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 last_update_timestamp=None,
                 logical_router_id=None,
                 logical_router_name=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_update_timestamp: :class:`long` or ``None``
        :param last_update_timestamp: Timestamp when the data was last updated, unset if data source has
            never updated the data. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  logical_router_id: :class:`str` or ``None``
        :param logical_router_id: Logical router id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  logical_router_name: :class:`str` or ``None``
        :param logical_router_name: Name of the logical router
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`BgpNeighborStatus` or ``None``
        :param results: Status of BGP neighbors of the logical router
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.last_update_timestamp = last_update_timestamp
        self.logical_router_id = logical_router_id
        self.logical_router_name = logical_router_name
        self.results = results
        VapiStruct.__init__(self)


BgpNeighborsStatusListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bgp_neighbors_status_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'last_update_timestamp': type.OptionalType(type.IntegerType()),
        'logical_router_id': type.OptionalType(type.StringType()),
        'logical_router_name': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BgpNeighborStatus'))),
    },
    BgpNeighborsStatusListResult,
    False,
    None))



class BgpRouteAggregation(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'prefix': 'prefix',
                            'summary_only': 'summary_only',
                            }

    def __init__(self,
                 prefix=None,
                 summary_only=None,
                ):
        """
        :type  prefix: :class:`str` or ``None``
        :param prefix: cidr of the aggregate address format: ip-cidr-block
        :type  summary_only: :class:`bool` or ``None``
        :param summary_only: Flag to send only summarized route
        """
        self.prefix = prefix
        self.summary_only = summary_only
        VapiStruct.__init__(self)


BgpRouteAggregation._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bgp_route_aggregation', {
        'prefix': type.OptionalType(type.StringType()),
        'summary_only': type.OptionalType(type.BooleanType()),
    },
    BgpRouteAggregation,
    False,
    None))



class BinaryPacketData(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BinaryPacketData"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'payload': 'payload',
                            'frame_size': 'frame_size',
                            'resource_type': 'resource_type',
                            'routed': 'routed',
                            'transport_type': 'transport_type',
                            }

    def __init__(self,
                 payload=None,
                 frame_size=None,
                 resource_type='BinaryPacketData',
                 routed=None,
                 transport_type=None,
                ):
        """
        :type  payload: :class:`str` or ``None``
        :param payload: Up to 1000 bytes of payload may be supplied (with a base64-encoded
            length of 1336 bytes.) Additional bytes of traceflow metadata will
            be appended to the payload. The payload must contain all headers
            (Ethernet, IP, etc). Note that VLAN is not supported in the logical
            space. Hence, payload must not contain 802.1Q headers.
        :type  frame_size: :class:`long` or ``None``
        :param frame_size: If the requested frame_size is too small (given the payload and
            traceflow metadata requirement of 16 bytes), the traceflow request
            will fail with an appropriate message. The frame will be zero
            padded to the requested size. format: int64
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`PacketData.RESOURCE_TYPE_BINARYPACKETDATA`
            * :attr:`PacketData.RESOURCE_TYPE_FIELDSPACKETDATA`
            
             Packet configuration
        :type  routed: :class:`bool` or ``None``
        :param routed: A flag, when set true, indicates that the traceflow packet is of L3
            routing.
        :type  transport_type: :class:`str` or ``None``
        :param transport_type: Possible values are: 
            
            * :attr:`PacketData.TRANSPORT_TYPE_BROADCAST`
            * :attr:`PacketData.TRANSPORT_TYPE_UNICAST`
            * :attr:`PacketData.TRANSPORT_TYPE_MULTICAST`
            * :attr:`PacketData.TRANSPORT_TYPE_UNKNOWN`
            
             transport type of the traceflow packet
        """
        self.payload = payload
        self.frame_size = frame_size
        self._resource_type = resource_type
        self.routed = routed
        self.transport_type = transport_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BinaryPacketData._set_binding_type(type.StructType(
    'com.vmware.nsx.model.binary_packet_data', {
        'payload': type.OptionalType(type.StringType()),
        'frame_size': type.OptionalType(type.IntegerType()),
        'resource_type': type.StringType(),
        'routed': type.OptionalType(type.BooleanType()),
        'transport_type': type.OptionalType(type.StringType()),
    },
    BinaryPacketData,
    False,
    None))



class BpduFilter(VapiStruct):
    """
    BPDU filter configuration

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'enabled': 'enabled',
                            'white_list': 'white_list',
                            }

    def __init__(self,
                 enabled=None,
                 white_list=None,
                ):
        """
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Indicates whether BPDU filter is enabled
        :type  white_list: :class:`list` of :class:`str` or ``None``
        :param white_list: Pre-defined list of allowed MAC addresses to be excluded from BPDU
            filtering
        """
        self.enabled = enabled
        self.white_list = white_list
        VapiStruct.__init__(self)


BpduFilter._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bpdu_filter', {
        'enabled': type.OptionalType(type.BooleanType()),
        'white_list': type.OptionalType(type.ListType(type.StringType())),
    },
    BpduFilter,
    False,
    None))



class BridgeCluster(VapiStruct):
    """
    Bridge Cluster

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'bridge_nodes': 'bridge_nodes',
                            'cluster_profile_bindings': 'cluster_profile_bindings',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 bridge_nodes=None,
                 cluster_profile_bindings=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  bridge_nodes: :class:`list` of :class:`BridgeClusterNode` or ``None``
        :param bridge_nodes: Nodes used in bridging
        :type  cluster_profile_bindings: :class:`list` of :class:`ClusterProfileTypeIdEntry` or ``None``
        :param cluster_profile_bindings: Bridge cluster profile bindings
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.bridge_nodes = bridge_nodes
        self.cluster_profile_bindings = cluster_profile_bindings
        VapiStruct.__init__(self)


BridgeCluster._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bridge_cluster', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'bridge_nodes': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BridgeClusterNode'))),
        'cluster_profile_bindings': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ClusterProfileTypeIdEntry'))),
    },
    BridgeCluster,
    False,
    None))



class BridgeClusterListResult(VapiStruct):
    """
    Bridge cluster queries result

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`BridgeCluster` or ``None``
        :param results: BridgeCluster Results
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


BridgeClusterListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bridge_cluster_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BridgeCluster'))),
    },
    BridgeClusterListResult,
    False,
    None))



class BridgeClusterNode(VapiStruct):
    """
    Bridge transport node

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'ha_mac': 'ha_mac',
                            'transport_node_id': 'transport_node_id',
                            }

    def __init__(self,
                 ha_mac=None,
                 transport_node_id=None,
                ):
        """
        :type  ha_mac: :class:`str` or ``None``
        :param ha_mac: MAC address used for HA protocol format: mac-address
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  transport_node_id: :class:`str` or ``None``
        :param transport_node_id: UUID of the transport node
        """
        self.ha_mac = ha_mac
        self.transport_node_id = transport_node_id
        VapiStruct.__init__(self)


BridgeClusterNode._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bridge_cluster_node', {
        'ha_mac': type.OptionalType(type.StringType()),
        'transport_node_id': type.OptionalType(type.StringType()),
    },
    BridgeClusterNode,
    False,
    None))



class BridgeClusterStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    HEALTH_UP = "UP"
    """


    """
    HEALTH_DOWN = "DOWN"
    """


    """
    HEALTH_DEGRADED = "DEGRADED"
    """


    """
    HEALTH_UNKNOWN = "UNKNOWN"
    """


    """



    _canonical_to_pep_names = {
                            'cluster_id': 'cluster_id',
                            'health': 'health',
                            'last_update_timestamp': 'last_update_timestamp',
                            }

    def __init__(self,
                 cluster_id=None,
                 health=None,
                 last_update_timestamp=None,
                ):
        """
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: The id of the cluster
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  health: :class:`str` or ``None``
        :param health: Possible values are: 
            
            * :attr:`BridgeClusterStatus.HEALTH_UP`
            * :attr:`BridgeClusterStatus.HEALTH_DOWN`
            * :attr:`BridgeClusterStatus.HEALTH_DEGRADED`
            * :attr:`BridgeClusterStatus.HEALTH_UNKNOWN`
            
             The health status of the cluster
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_update_timestamp: :class:`long` or ``None``
        :param last_update_timestamp: Timestamp when the data was last updated; unset if data source has
            never updated the data. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.cluster_id = cluster_id
        self.health = health
        self.last_update_timestamp = last_update_timestamp
        VapiStruct.__init__(self)


BridgeClusterStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bridge_cluster_status', {
        'cluster_id': type.OptionalType(type.StringType()),
        'health': type.OptionalType(type.StringType()),
        'last_update_timestamp': type.OptionalType(type.IntegerType()),
    },
    BridgeClusterStatus,
    False,
    None))



class BridgeEndpoint(VapiStruct):
    """
    A bridge endpoint can be created on a bridge cluster or on an edge cluster.
    Few of the properties of this class will not be used depending on the type
    of bridge endpoint being created. When creating a bridge endpoint on a
    bridge cluster, following propeties will be used: vlan, bridge_cluster_id
    and ha_enable. Similarly, for creating a bridge endpoint on an edge cluster
    following properties will be used: vlan, bridge_endpoint_profile_id and
    vlan_transport_zone_id.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'bridge_cluster_id': 'bridge_cluster_id',
                            'bridge_endpoint_profile_id': 'bridge_endpoint_profile_id',
                            'ha_enable': 'ha_enable',
                            'uplink_teaming_policy_name': 'uplink_teaming_policy_name',
                            'vlan': 'vlan',
                            'vlan_transport_zone_id': 'vlan_transport_zone_id',
                            'vlan_trunk_spec': 'vlan_trunk_spec',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 bridge_cluster_id=None,
                 bridge_endpoint_profile_id=None,
                 ha_enable=None,
                 uplink_teaming_policy_name=None,
                 vlan=None,
                 vlan_transport_zone_id=None,
                 vlan_trunk_spec=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  bridge_cluster_id: :class:`str` or ``None``
        :param bridge_cluster_id: This field will not be used if an edge cluster is being used for
            the bridge endpoint
        :type  bridge_endpoint_profile_id: :class:`str` or ``None``
        :param bridge_endpoint_profile_id: This field will not be used if a bridge cluster is being used for
            the bridge endpoint
        :type  ha_enable: :class:`bool` or ``None``
        :param ha_enable: This field will not be used if an edge cluster is being used for
            the bridge endpoint
        :type  uplink_teaming_policy_name: :class:`str` or ``None``
        :param uplink_teaming_policy_name: This name has to be one of the switching uplink teaming policy
            names listed inside the TransportZone. If this field is not
            specified, bridge will use the first pnic in host-switch config.
            This field will not be used if a bridge cluster is being used for
            the bridge endpoint
        :type  vlan: :class:`long` or ``None``
        :param vlan: This property is used for VLAN specification of bridge endpoint.
            It's mutually exclusive with 'vlan_trunk_spec', either 'vlan' or
            'vlan_trunk_spec' should be specified. format: int64
        :type  vlan_transport_zone_id: :class:`str` or ``None``
        :param vlan_transport_zone_id: This field will not be used if a bridge cluster is being used for
            the bridge endpoint
        :type  vlan_trunk_spec: :class:`VlanTrunkSpec` or ``None``
        :param vlan_trunk_spec: This property is used for VLAN trunk specification of edge bridge
            endpoint. It's mutually exclusive with 'vlan', either 'vlan' or
            'vlan_trunk_spec' should be specified.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.bridge_cluster_id = bridge_cluster_id
        self.bridge_endpoint_profile_id = bridge_endpoint_profile_id
        self.ha_enable = ha_enable
        self.uplink_teaming_policy_name = uplink_teaming_policy_name
        self.vlan = vlan
        self.vlan_transport_zone_id = vlan_transport_zone_id
        self.vlan_trunk_spec = vlan_trunk_spec
        VapiStruct.__init__(self)


BridgeEndpoint._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bridge_endpoint', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'bridge_cluster_id': type.OptionalType(type.StringType()),
        'bridge_endpoint_profile_id': type.OptionalType(type.StringType()),
        'ha_enable': type.OptionalType(type.BooleanType()),
        'uplink_teaming_policy_name': type.OptionalType(type.StringType()),
        'vlan': type.OptionalType(type.IntegerType()),
        'vlan_transport_zone_id': type.OptionalType(type.StringType()),
        'vlan_trunk_spec': type.OptionalType(type.ReferenceType(__name__, 'VlanTrunkSpec')),
    },
    BridgeEndpoint,
    False,
    None))



class BridgeEndpointListResult(VapiStruct):
    """
    Bridge Endpoint queries result

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`BridgeEndpoint` or ``None``
        :param results: BridgeEndpoint Results
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


BridgeEndpointListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bridge_endpoint_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BridgeEndpoint'))),
    },
    BridgeEndpointListResult,
    False,
    None))



class BridgeEndpointProfile(VapiStruct):
    """
    Bridge Endpoint Profile

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    FAILOVER_MODE_PREEMPTIVE = "PREEMPTIVE"
    """


    """
    FAILOVER_MODE_NON_PREEMPTIVE = "NON_PREEMPTIVE"
    """


    """
    HIGH_AVAILABILITY_MODE_STANDBY = "ACTIVE_STANDBY"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'edge_cluster_id': 'edge_cluster_id',
                            'edge_cluster_member_indexes': 'edge_cluster_member_indexes',
                            'failover_mode': 'failover_mode',
                            'high_availability_mode': 'high_availability_mode',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 edge_cluster_id=None,
                 edge_cluster_member_indexes=None,
                 failover_mode=None,
                 high_availability_mode=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  edge_cluster_id: :class:`str` or ``None``
        :param edge_cluster_id: UUID of the edge cluster for this bridge endpoint
        :type  edge_cluster_member_indexes: :class:`list` of :class:`long` or ``None``
        :param edge_cluster_member_indexes: First index will be used as the preferred member format: int32
        :type  failover_mode: :class:`str` or ``None``
        :param failover_mode: Possible values are: 
            
            * :attr:`BridgeEndpointProfile.FAILOVER_MODE_PREEMPTIVE`
            * :attr:`BridgeEndpointProfile.FAILOVER_MODE_NON_PREEMPTIVE`
            
             Faileover mode can be preemmptive or non-preemptive
        :type  high_availability_mode: :class:`str` or ``None``
        :param high_availability_mode: Possible values are: 
            
            * :attr:`BridgeEndpointProfile.HIGH_AVAILABILITY_MODE_STANDBY`
            
             High avaialability mode can be active-active or active-standby
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.edge_cluster_id = edge_cluster_id
        self.edge_cluster_member_indexes = edge_cluster_member_indexes
        self.failover_mode = failover_mode
        self.high_availability_mode = high_availability_mode
        VapiStruct.__init__(self)


BridgeEndpointProfile._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bridge_endpoint_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'edge_cluster_id': type.OptionalType(type.StringType()),
        'edge_cluster_member_indexes': type.OptionalType(type.ListType(type.IntegerType())),
        'failover_mode': type.OptionalType(type.StringType()),
        'high_availability_mode': type.OptionalType(type.StringType()),
    },
    BridgeEndpointProfile,
    False,
    None))



class BridgeEndpointProfileListResult(VapiStruct):
    """
    Bridge Endpoint Profile queries result

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`BridgeEndpointProfile` or ``None``
        :param results: BridgeEndpointProfile Results
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


BridgeEndpointProfileListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bridge_endpoint_profile_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BridgeEndpointProfile'))),
    },
    BridgeEndpointProfileListResult,
    False,
    None))



class BridgeEndpointStatistics(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'rx_bytes': 'rx_bytes',
                            'rx_packets': 'rx_packets',
                            'tx_bytes': 'tx_bytes',
                            'tx_packets': 'tx_packets',
                            'endpoint_id': 'endpoint_id',
                            'last_update_timestamp': 'last_update_timestamp',
                            }

    def __init__(self,
                 rx_bytes=None,
                 rx_packets=None,
                 tx_bytes=None,
                 tx_packets=None,
                 endpoint_id=None,
                 last_update_timestamp=None,
                ):
        """
        :type  rx_bytes: :class:`DataCounter` or ``None``
        :param rx_bytes: 
        :type  rx_packets: :class:`DataCounter` or ``None``
        :param rx_packets: 
        :type  tx_bytes: :class:`DataCounter` or ``None``
        :param tx_bytes: 
        :type  tx_packets: :class:`DataCounter` or ``None``
        :param tx_packets: 
        :type  endpoint_id: :class:`str` or ``None``
        :param endpoint_id: The id of the bridge endpoint
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_update_timestamp: :class:`long` or ``None``
        :param last_update_timestamp: Timestamp when the data was last updated; unset if data source has
            never updated the data. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.rx_bytes = rx_bytes
        self.rx_packets = rx_packets
        self.tx_bytes = tx_bytes
        self.tx_packets = tx_packets
        self.endpoint_id = endpoint_id
        self.last_update_timestamp = last_update_timestamp
        VapiStruct.__init__(self)


BridgeEndpointStatistics._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bridge_endpoint_statistics', {
        'rx_bytes': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'rx_packets': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'tx_bytes': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'tx_packets': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'endpoint_id': type.OptionalType(type.StringType()),
        'last_update_timestamp': type.OptionalType(type.IntegerType()),
    },
    BridgeEndpointStatistics,
    False,
    None))



class BridgeEndpointStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'active_nodes': 'active_nodes',
                            'endpoint_id': 'endpoint_id',
                            'last_update_timestamp': 'last_update_timestamp',
                            }

    def __init__(self,
                 active_nodes=None,
                 endpoint_id=None,
                 last_update_timestamp=None,
                ):
        """
        :type  active_nodes: :class:`list` of :class:`str` or ``None``
        :param active_nodes: The Ids of the transport nodes which actively serve the endpoint.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  endpoint_id: :class:`str` or ``None``
        :param endpoint_id: The id of the bridge endpoint
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_update_timestamp: :class:`long` or ``None``
        :param last_update_timestamp: Timestamp when the data was last updated; unset if data source has
            never updated the data. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.active_nodes = active_nodes
        self.endpoint_id = endpoint_id
        self.last_update_timestamp = last_update_timestamp
        VapiStruct.__init__(self)


BridgeEndpointStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bridge_endpoint_status', {
        'active_nodes': type.OptionalType(type.ListType(type.StringType())),
        'endpoint_id': type.OptionalType(type.StringType()),
        'last_update_timestamp': type.OptionalType(type.IntegerType()),
    },
    BridgeEndpointStatus,
    False,
    None))



class BridgeHighAvailabilityClusterProfile(VapiStruct):
    """
    Profile for BFD HA cluster setting

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BridgeHighAvailabilityClusterProfile"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'bfd_probe_interval': 'bfd_probe_interval',
                            'enable': 'enable',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            }

    def __init__(self,
                 bfd_probe_interval=None,
                 enable=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='BridgeHighAvailabilityClusterProfile',
                 tags=None,
                ):
        """
        :type  bfd_probe_interval: :class:`long` or ``None``
        :param bfd_probe_interval: the time interval (in millisec) between probe packets for heartbeat
            purpose format: int64
        :type  enable: :class:`bool` or ``None``
        :param enable: whether the heartbeat is enabled
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`ClusterProfile.RESOURCE_TYPE_EDGEHIGHAVAILABILITYPROFILE`
            *
              :attr:`ClusterProfile.RESOURCE_TYPE_BRIDGEHIGHAVAILABILITYCLUSTERPROFILE`
            
             Supported cluster profiles.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        """
        self.bfd_probe_interval = bfd_probe_interval
        self.enable = enable
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BridgeHighAvailabilityClusterProfile._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bridge_high_availability_cluster_profile', {
        'bfd_probe_interval': type.OptionalType(type.IntegerType()),
        'enable': type.OptionalType(type.BooleanType()),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
    },
    BridgeHighAvailabilityClusterProfile,
    False,
    None))



class BrokerProperties(VapiStruct):
    """
    Information about a management plane node this transport node is configured
    to communicate with

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'BrokerFqdn': 'broker_fqdn',
                            'BrokerIpAddress': 'broker_ip_address',
                            'BrokerIsMaster': 'broker_is_master',
                            'BrokerPort': 'broker_port',
                            'BrokerSslCertThumbprint': 'broker_ssl_cert_thumbprint',
                            'BrokerVirtualHost': 'broker_virtual_host',
                            }

    def __init__(self,
                 broker_fqdn=None,
                 broker_ip_address=None,
                 broker_is_master=None,
                 broker_port=None,
                 broker_ssl_cert_thumbprint=None,
                 broker_virtual_host=None,
                ):
        """
        :type  broker_fqdn: :class:`str` or ``None``
        :param broker_fqdn: Fully qualified domain name of the message bus broker on the
            management plane node.
        :type  broker_ip_address: :class:`str` or ``None``
        :param broker_ip_address: IP address or hostname of the message bus broker on the management
            plane node. format: hostname-or-ipv4
        :type  broker_is_master: :class:`str` or ``None``
        :param broker_is_master: Indicates whether this broker is the master.
        :type  broker_port: :class:`str` or ``None``
        :param broker_port: Port number of the message bus broker on the management plane node.
        :type  broker_ssl_cert_thumbprint: :class:`str` or ``None``
        :param broker_ssl_cert_thumbprint: Certificate thumbprint of the message bus broker on the management
            plane node.
        :type  broker_virtual_host: :class:`str` or ``None``
        :param broker_virtual_host: Type of host running the broker.
        """
        self.broker_fqdn = broker_fqdn
        self.broker_ip_address = broker_ip_address
        self.broker_is_master = broker_is_master
        self.broker_port = broker_port
        self.broker_ssl_cert_thumbprint = broker_ssl_cert_thumbprint
        self.broker_virtual_host = broker_virtual_host
        VapiStruct.__init__(self)


BrokerProperties._set_binding_type(type.StructType(
    'com.vmware.nsx.model.broker_properties', {
        'BrokerFqdn': type.OptionalType(type.StringType()),
        'BrokerIpAddress': type.OptionalType(type.StringType()),
        'BrokerIsMaster': type.OptionalType(type.StringType()),
        'BrokerPort': type.OptionalType(type.StringType()),
        'BrokerSslCertThumbprint': type.OptionalType(type.StringType()),
        'BrokerVirtualHost': type.OptionalType(type.StringType()),
    },
    BrokerProperties,
    False,
    None))



class BundleId(VapiStruct):
    """
    Identifier of the bundle

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'bundle_id': 'bundle_id',
                            }

    def __init__(self,
                 bundle_id=None,
                ):
        """
        :type  bundle_id: :class:`str` or ``None``
        :param bundle_id: Identifier of bundle upload
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.bundle_id = bundle_id
        VapiStruct.__init__(self)


BundleId._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bundle_id', {
        'bundle_id': type.OptionalType(type.StringType()),
    },
    BundleId,
    False,
    None))



class BundleIds(VapiStruct):
    """
    Contains a list of bundle-ids

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'failed': 'failed',
                            'in_progress': 'in_progress',
                            'successful': 'successful',
                            }

    def __init__(self,
                 failed=None,
                 in_progress=None,
                 successful=None,
                ):
        """
        :type  failed: :class:`str` or ``None``
        :param failed: Id of a bundle whose upload was failed
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  in_progress: :class:`str` or ``None``
        :param in_progress: Id of a bundle whose upload is in-progress
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  successful: :class:`str` or ``None``
        :param successful: Id of a bundle whose upload is successful
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.failed = failed
        self.in_progress = in_progress
        self.successful = successful
        VapiStruct.__init__(self)


BundleIds._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bundle_ids', {
        'failed': type.OptionalType(type.StringType()),
        'in_progress': type.OptionalType(type.StringType()),
        'successful': type.OptionalType(type.StringType()),
    },
    BundleIds,
    False,
    None))



class BundleUploadPermission(VapiStruct):
    """
    Describes wether bundle upload is allowed or not

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'reason': 'reason',
                            'upload_allowed': 'upload_allowed',
                            }

    def __init__(self,
                 reason=None,
                 upload_allowed=None,
                ):
        """
        :type  reason: :class:`str` or ``None``
        :param reason: Reason for not allowing upload
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  upload_allowed: :class:`bool` or ``None``
        :param upload_allowed: Flag indecation whether upload is allowed or not
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.reason = reason
        self.upload_allowed = upload_allowed
        VapiStruct.__init__(self)


BundleUploadPermission._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bundle_upload_permission', {
        'reason': type.OptionalType(type.StringType()),
        'upload_allowed': type.OptionalType(type.BooleanType()),
    },
    BundleUploadPermission,
    False,
    None))



class BundleUploadStatus(VapiStruct):
    """
    Upload status of bundle uploaded from local or remote location

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_UPLOADING = "UPLOADING"
    """


    """
    STATUS_VERIFYING = "VERIFYING"
    """


    """
    STATUS_SUCCESS = "SUCCESS"
    """


    """
    STATUS_FAILED = "FAILED"
    """


    """



    _canonical_to_pep_names = {
                            'bundle_name': 'bundle_name',
                            'detailed_status': 'detailed_status',
                            'percent': 'percent',
                            'status': 'status',
                            'url': 'url',
                            }

    def __init__(self,
                 bundle_name=None,
                 detailed_status=None,
                 percent=None,
                 status=None,
                 url=None,
                ):
        """
        :type  bundle_name: :class:`str` or ``None``
        :param bundle_name: Name of the uploaded bundle.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  detailed_status: :class:`str` or ``None``
        :param detailed_status: Detailed status of bundle upload
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  percent: :class:`float` or ``None``
        :param percent: Percent of bundle uploaded from remote location
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`BundleUploadStatus.STATUS_UPLOADING`
            * :attr:`BundleUploadStatus.STATUS_VERIFYING`
            * :attr:`BundleUploadStatus.STATUS_SUCCESS`
            * :attr:`BundleUploadStatus.STATUS_FAILED`
            
             Current status of bundle upload
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  url: :class:`str` or ``None``
        :param url: URL for uploading bundle
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.bundle_name = bundle_name
        self.detailed_status = detailed_status
        self.percent = percent
        self.status = status
        self.url = url
        VapiStruct.__init__(self)


BundleUploadStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bundle_upload_status', {
        'bundle_name': type.OptionalType(type.StringType()),
        'detailed_status': type.OptionalType(type.StringType()),
        'percent': type.OptionalType(type.DoubleType()),
        'status': type.OptionalType(type.StringType()),
        'url': type.OptionalType(type.StringType()),
    },
    BundleUploadStatus,
    False,
    None))



class ByodServiceInstance(VapiStruct):
    """
    ByodServiceInstance is a custom instance to be used when NSX is not
    handling the lifecycles of appliance/s. User will manage their own
    appliance (BYOD) to connect with NSX.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ByodServiceInstance"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    DEPLOYMENT_MODE_STAND_ALONE = "STAND_ALONE"
    """


    """
    DEPLOYMENT_MODE_ACTIVE_STANDBY = "ACTIVE_STANDBY"
    """


    """



    _canonical_to_pep_names = {
                            'deployment_mode': 'deployment_mode',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'on_failure_policy': 'on_failure_policy',
                            'service_id': 'service_id',
                            'transport_type': 'transport_type',
                            }

    def __init__(self,
                 deployment_mode=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='ByodServiceInstance',
                 tags=None,
                 on_failure_policy=None,
                 service_id=None,
                 transport_type=None,
                ):
        """
        :type  deployment_mode: :class:`str` or ``None``
        :param deployment_mode: Possible values are: 
            
            * :attr:`ByodServiceInstance.DEPLOYMENT_MODE_STAND_ALONE`
            * :attr:`ByodServiceInstance.DEPLOYMENT_MODE_ACTIVE_STANDBY`
            
            Deployment mode specifies where the partner appliance will be
            deployed in HA or non-HA i.e standalone mode.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`BaseServiceInstance.RESOURCE_TYPE_SERVICEINSTANCE`
            * :attr:`BaseServiceInstance.RESOURCE_TYPE_BYODSERVICEINSTANCE`
            * :attr:`BaseServiceInstance.RESOURCE_TYPE_VIRTUALSERVICEINSTANCE`
            
            ServiceInstance is used when NSX handles the lifecyle of appliance.
            Deployment and appliance related all the information is necessary.
            ByodServiceInstance is a custom instance to be used when NSX is not
            handling the lifecycles of appliance/s. User will manage their own
            appliance (BYOD) to connect with NSX. VirtualServiceInstance is a a
            custom instance to be used when NSX is not handling the lifecycle
            of an appliance and when the user is not bringing their own
            appliance.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  on_failure_policy: :class:`str` or ``None``
        :param on_failure_policy: Possible values are: 
            
            * :attr:`BaseServiceInstance.ON_FAILURE_POLICY_ALLOW`
            * :attr:`BaseServiceInstance.ON_FAILURE_POLICY_BLOCK`
            
            Failure policy of the service instance - if it has to be different
            from the service. By default the service instance inherits the
            FailurePolicy of the service it belongs to.
        :type  service_id: :class:`str` or ``None``
        :param service_id: The Service to which the service instance is associated.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  transport_type: :class:`str` or ``None``
        :param transport_type: Possible values are: 
            
            * :attr:`BaseServiceInstance.TRANSPORT_TYPE_L2_BRIDGE`
            * :attr:`BaseServiceInstance.TRANSPORT_TYPE_L3_ROUTED`
            * :attr:`BaseServiceInstance.TRANSPORT_TYPE_NSH`
            * :attr:`BaseServiceInstance.TRANSPORT_TYPE_NA`
            
            Transport to be used by this service instance for deploying the
            Service-VM. This field is to be set Not Applicable(NA) if the
            service only caters to functionality EPP(Endpoint Protection).
        """
        self.deployment_mode = deployment_mode
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.on_failure_policy = on_failure_policy
        self.service_id = service_id
        self.transport_type = transport_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ByodServiceInstance._set_binding_type(type.StructType(
    'com.vmware.nsx.model.byod_service_instance', {
        'deployment_mode': type.OptionalType(type.StringType()),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'on_failure_policy': type.OptionalType(type.StringType()),
        'service_id': type.OptionalType(type.StringType()),
        'transport_type': type.OptionalType(type.StringType()),
    },
    ByodServiceInstance,
    False,
    None))



class CCPUpgradeStatus(VapiStruct):
    """
    Status of CCP upgrade

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_SUCCESS = "SUCCESS"
    """


    """
    STATUS_FAILED = "FAILED"
    """


    """
    STATUS_IN_PROGRESS = "IN_PROGRESS"
    """


    """
    STATUS_NOT_STARTED = "NOT_STARTED"
    """


    """
    STATUS_PAUSING = "PAUSING"
    """


    """
    STATUS_PAUSED = "PAUSED"
    """


    """



    _canonical_to_pep_names = {
                            'can_skip': 'can_skip',
                            'component_type': 'component_type',
                            'current_version_node_summary': 'current_version_node_summary',
                            'details': 'details',
                            'node_count_at_target_version': 'node_count_at_target_version',
                            'percent_complete': 'percent_complete',
                            'pre_upgrade_status': 'pre_upgrade_status',
                            'status': 'status',
                            'target_component_version': 'target_component_version',
                            }

    def __init__(self,
                 can_skip=None,
                 component_type=None,
                 current_version_node_summary=None,
                 details=None,
                 node_count_at_target_version=None,
                 percent_complete=None,
                 pre_upgrade_status=None,
                 status=None,
                 target_component_version=None,
                ):
        """
        :type  can_skip: :class:`bool` or ``None``
        :param can_skip: Can the upgrade of the remaining units in this component be skipped
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  component_type: :class:`str` or ``None``
        :param component_type: Component type for the upgrade status
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  current_version_node_summary: :class:`NodeSummaryList` or ``None``
        :param current_version_node_summary: Mapping of current versions of nodes and counts of nodes at the
            respective versions.
        :type  details: :class:`str` or ``None``
        :param details: Details about the upgrade status
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_count_at_target_version: :class:`long` or ``None``
        :param node_count_at_target_version: Number of nodes of the type and at the component version format:
            int32
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  percent_complete: :class:`float` or ``None``
        :param percent_complete: Indicator of upgrade progress in percentage
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  pre_upgrade_status: :class:`UpgradeChecksExecutionStatus` or ``None``
        :param pre_upgrade_status: Pre-upgrade status of the component-type
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`CCPUpgradeStatus.STATUS_SUCCESS`
            * :attr:`CCPUpgradeStatus.STATUS_FAILED`
            * :attr:`CCPUpgradeStatus.STATUS_IN_PROGRESS`
            * :attr:`CCPUpgradeStatus.STATUS_NOT_STARTED`
            * :attr:`CCPUpgradeStatus.STATUS_PAUSING`
            * :attr:`CCPUpgradeStatus.STATUS_PAUSED`
            
             Upgrade status of component
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  target_component_version: :class:`str` or ``None``
        :param target_component_version: Target component version
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.can_skip = can_skip
        self.component_type = component_type
        self.current_version_node_summary = current_version_node_summary
        self.details = details
        self.node_count_at_target_version = node_count_at_target_version
        self.percent_complete = percent_complete
        self.pre_upgrade_status = pre_upgrade_status
        self.status = status
        self.target_component_version = target_component_version
        VapiStruct.__init__(self)


CCPUpgradeStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.CCP_upgrade_status', {
        'can_skip': type.OptionalType(type.BooleanType()),
        'component_type': type.OptionalType(type.StringType()),
        'current_version_node_summary': type.OptionalType(type.ReferenceType(__name__, 'NodeSummaryList')),
        'details': type.OptionalType(type.StringType()),
        'node_count_at_target_version': type.OptionalType(type.IntegerType()),
        'percent_complete': type.OptionalType(type.DoubleType()),
        'pre_upgrade_status': type.OptionalType(type.ReferenceType(__name__, 'UpgradeChecksExecutionStatus')),
        'status': type.OptionalType(type.StringType()),
        'target_component_version': type.OptionalType(type.StringType()),
    },
    CCPUpgradeStatus,
    False,
    None))



class CPUReservation(VapiStruct):
    """
    Relative to the form factor pre-defined reservation value. We recommended
    that you use the predefined measures of CPU reservation shares to reduce
    the CPU reservation of a VM. Reservation shares are relative to the default
    form-factor value. Though absolute values for CPU reservation is supported,
    we advise to use this option with caution as incorrect or high reservation
    values could lead to deployment failure or lead to resource starvation for
    other VMs running on the same host.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    RESERVATION_IN_SHARES_EXTRA_HIGH_PRIORITY = "EXTRA_HIGH_PRIORITY"
    """


    """
    RESERVATION_IN_SHARES_HIGH_PRIORITY = "HIGH_PRIORITY"
    """


    """
    RESERVATION_IN_SHARES_NORMAL_PRIORITY = "NORMAL_PRIORITY"
    """


    """
    RESERVATION_IN_SHARES_LOW_PRIORITY = "LOW_PRIORITY"
    """


    """



    _canonical_to_pep_names = {
                            'reservation_in_mhz': 'reservation_in_mhz',
                            'reservation_in_shares': 'reservation_in_shares',
                            }

    def __init__(self,
                 reservation_in_mhz=None,
                 reservation_in_shares=None,
                ):
        """
        :type  reservation_in_mhz: :class:`long` or ``None``
        :param reservation_in_mhz: The CPU reservation in MHz is the guaranteed minimum amount of
            clock cycles that the vmkernel CPU scheduler will give the Edge VM
            in case of contention. If an Edge VM is not using its reserved
            resources, then other machines can use them thus preventing waste
            of CPU cycles on the physical host. Note: We recommend use of
            reservation_in_shares instead of this absolute configuration. When
            you specify this value, set reservation_in_shares to LOW_PRIORITY.
            format: int32
        :type  reservation_in_shares: :class:`str` or ``None``
        :param reservation_in_shares: Possible values are: 
            
            * :attr:`CPUReservation.RESERVATION_IN_SHARES_EXTRA_HIGH_PRIORITY`
            * :attr:`CPUReservation.RESERVATION_IN_SHARES_HIGH_PRIORITY`
            * :attr:`CPUReservation.RESERVATION_IN_SHARES_NORMAL_PRIORITY`
            * :attr:`CPUReservation.RESERVATION_IN_SHARES_LOW_PRIORITY`
            
            Shares specify the relative importance of a virtual machine on a
            given host. When you assign shares to a virtual machine, you always
            specify the priority for that virtual machine relative to other
            powered-on virtual machines on the same host. The default priority
            for shares is HIGH_PRIORITY.
        """
        self.reservation_in_mhz = reservation_in_mhz
        self.reservation_in_shares = reservation_in_shares
        VapiStruct.__init__(self)


CPUReservation._set_binding_type(type.StructType(
    'com.vmware.nsx.model.CPU_reservation', {
        'reservation_in_mhz': type.OptionalType(type.IntegerType()),
        'reservation_in_shares': type.OptionalType(type.StringType()),
    },
    CPUReservation,
    False,
    None))



class CallbackAuthenticationScheme(VapiStruct):
    """
    CallbackAuthenticationScheme describes how notification requests should
    authenticate to the server.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    SCHEME_NAME_BASIC_AUTH = "BASIC_AUTH"
    """


    """
    SCHEME_NAME_CERTIFICATE = "CERTIFICATE"
    """


    """



    _canonical_to_pep_names = {
                            'certificate_id': 'certificate_id',
                            'password': 'password',
                            'scheme_name': 'scheme_name',
                            'username': 'username',
                            }

    def __init__(self,
                 certificate_id=None,
                 password=None,
                 scheme_name=None,
                 username=None,
                ):
        """
        :type  certificate_id: :class:`str` or ``None``
        :param certificate_id: Certificate ID with a valid certificate and private key, procured
            from trust-management API.
        :type  password: :class:`str` or ``None``
        :param password: Password to use if scheme_name is BASIC_AUTH.
        :type  scheme_name: :class:`str` or ``None``
        :param scheme_name: Possible values are: 
            
            * :attr:`CallbackAuthenticationScheme.SCHEME_NAME_BASIC_AUTH`
            * :attr:`CallbackAuthenticationScheme.SCHEME_NAME_CERTIFICATE`
            
            Authentication scheme to use when making notification requests to
            the partner console. Specify one of BASIC_AUTH or CERTIFICATE.
        :type  username: :class:`str` or ``None``
        :param username: Username to use if scheme_name is BASIC_AUTH.
        """
        self.certificate_id = certificate_id
        self.password = password
        self.scheme_name = scheme_name
        self.username = username
        VapiStruct.__init__(self)


CallbackAuthenticationScheme._set_binding_type(type.StructType(
    'com.vmware.nsx.model.callback_authentication_scheme', {
        'certificate_id': type.OptionalType(type.StringType()),
        'password': type.OptionalType(type.StringType()),
        'scheme_name': type.OptionalType(type.StringType()),
        'username': type.OptionalType(type.StringType()),
    },
    CallbackAuthenticationScheme,
    False,
    None))



class CapacityDashboardUsage(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    SEVERITY_INFO = "INFO"
    """


    """
    SEVERITY_WARNING = "WARNING"
    """


    """
    SEVERITY_CRITICAL = "CRITICAL"
    """


    """
    SEVERITY_ERROR = "ERROR"
    """


    """
    USAGE_TYPE_LOGICAL_SWITCHES = "NUMBER_OF_LOGICAL_SWITCHES"
    """


    """
    USAGE_TYPE_PREPARED_HOSTS = "NUMBER_OF_PREPARED_HOSTS"
    """


    """
    USAGE_TYPE_NSGROUP = "NUMBER_OF_NSGROUP"
    """


    """
    USAGE_TYPE_VCENTER_CLUSTERS = "NUMBER_OF_VCENTER_CLUSTERS"
    """


    """
    USAGE_TYPE_GI_PROTECTED_HOSTS = "NUMBER_OF_GI_PROTECTED_HOSTS"
    """


    """
    USAGE_TYPE_GI_PROTECTED_VMS = "NUMBER_OF_GI_PROTECTED_VMS"
    """


    """
    USAGE_TYPE_DFW_RULES = "NUMBER_OF_DFW_RULES"
    """


    """
    USAGE_TYPE_DFW_SECTIONS = "NUMBER_OF_DFW_SECTIONS"
    """


    """
    USAGE_TYPE_L2_DFW_SECTIONS = "NUMBER_OF_L2_DFW_SECTIONS"
    """


    """
    USAGE_TYPE_L3_DFW_SECTIONS = "NUMBER_OF_L3_DFW_SECTIONS"
    """


    """
    USAGE_TYPE_L2_DFW_RULES = "NUMBER_OF_L2_DFW_RULES"
    """


    """
    USAGE_TYPE_L3_DFW_RULES = "NUMBER_OF_L3_DFW_RULES"
    """


    """
    USAGE_TYPE_L3_EDGE_SECTIONS = "NUMBER_OF_L3_EDGE_SECTIONS"
    """


    """
    USAGE_TYPE_L3_EDGE_RULES = "NUMBER_OF_L3_EDGE_RULES"
    """


    """
    USAGE_TYPE_L3_BRIDGEPORT_SECTIONS = "NUMBER_OF_L3_BRIDGEPORT_SECTIONS"
    """


    """
    USAGE_TYPE_L3_BRIDGEPORT_RULES = "NUMBER_OF_L3_BRIDGEPORT_RULES"
    """


    """
    USAGE_TYPE_IPSETS = "NUMBER_OF_IPSETS"
    """


    """
    USAGE_TYPE_GROUPS_BASED_ON_IP_SETS = "NUMBER_OF_GROUPS_BASED_ON_IP_SETS"
    """


    """
    USAGE_TYPE_LOGICAL_PORTS = "NUMBER_OF_LOGICAL_PORTS"
    """


    """
    USAGE_TYPE_EDGE_CLUSTERS = "NUMBER_OF_EDGE_CLUSTERS"
    """


    """
    USAGE_TYPE_EDGE_NODES = "NUMBER_OF_EDGE_NODES"
    """


    """
    USAGE_TYPE_TIER0_ROUTERS = "NUMBER_OF_TIER0_ROUTERS"
    """


    """
    USAGE_TYPE_TIER1_ROUTERS = "NUMBER_OF_TIER1_ROUTERS"
    """


    """
    USAGE_TYPE_PREFIX_LIST = "NUMBER_OF_PREFIX_LIST"
    """


    """
    USAGE_TYPE_NAT_RULES = "NUMBER_OF_NAT_RULES"
    """


    """
    USAGE_TYPE_TIER1_WITH_NAT_RULE = "NUMBER_OF_TIER1_WITH_NAT_RULE"
    """


    """
    USAGE_TYPE_DHCP_SERVERS = "NUMBER_OF_DHCP_SERVERS"
    """


    """
    USAGE_TYPE_DHCP_IP_POOLS = "NUMBER_OF_DHCP_IP_POOLS"
    """


    """
    USAGE_TYPE_ACTIVE_DIRECTORY_GROUPS = "NUMBER_OF_ACTIVE_DIRECTORY_GROUPS"
    """


    """
    USAGE_TYPE_ACTIVE_DIRECTORY_DOMAINS = "NUMBER_OF_ACTIVE_DIRECTORY_DOMAINS"
    """


    """
    USAGE_TYPE_FIREWALL_SECTIONS = "NUMBER_OF_FIREWALL_SECTIONS"
    """


    """
    USAGE_TYPE_FIREWALL_RULES = "NUMBER_OF_FIREWALL_RULES"
    """


    """



    _canonical_to_pep_names = {
                            'current_usage_count': 'current_usage_count',
                            'current_usage_percentage': 'current_usage_percentage',
                            'display_name': 'display_name',
                            'max_supported_count': 'max_supported_count',
                            'max_threshold_percentage': 'max_threshold_percentage',
                            'min_threshold_percentage': 'min_threshold_percentage',
                            'severity': 'severity',
                            'usage_type': 'usage_type',
                            }

    def __init__(self,
                 current_usage_count=None,
                 current_usage_percentage=None,
                 display_name=None,
                 max_supported_count=None,
                 max_threshold_percentage=None,
                 min_threshold_percentage=None,
                 severity=None,
                 usage_type=None,
                ):
        """
        :type  current_usage_count: :class:`long` or ``None``
        :param current_usage_count: Indicate the current usage count of object type. format: int64
        :type  current_usage_percentage: :class:`float` or ``None``
        :param current_usage_percentage: Current usage percentage for object type
        :type  display_name: :class:`str` or ``None``
        :param display_name: Display name for NSX object type.
        :type  max_supported_count: :class:`long` or ``None``
        :param max_supported_count: This is the maximum supported count for object type in
            consideration. format: int64
        :type  max_threshold_percentage: :class:`float` or ``None``
        :param max_threshold_percentage: This indicates the maximum threshold percentage for object type.
        :type  min_threshold_percentage: :class:`float` or ``None``
        :param min_threshold_percentage: This indicates the minimum threshold percentage for object type.
        :type  severity: :class:`str` or ``None``
        :param severity: Possible values are: 
            
            * :attr:`CapacityDashboardUsage.SEVERITY_INFO`
            * :attr:`CapacityDashboardUsage.SEVERITY_WARNING`
            * :attr:`CapacityDashboardUsage.SEVERITY_CRITICAL`
            * :attr:`CapacityDashboardUsage.SEVERITY_ERROR`
            
             Severity calculated from percentage usage
        :type  usage_type: :class:`str` or ``None``
        :param usage_type: Possible values are: 
            
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_LOGICAL_SWITCHES`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_PREPARED_HOSTS`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_NSGROUP`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_VCENTER_CLUSTERS`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_GI_PROTECTED_HOSTS`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_GI_PROTECTED_VMS`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_DFW_RULES`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_DFW_SECTIONS`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_L2_DFW_SECTIONS`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_L3_DFW_SECTIONS`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_L2_DFW_RULES`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_L3_DFW_RULES`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_L3_EDGE_SECTIONS`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_L3_EDGE_RULES`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_L3_BRIDGEPORT_SECTIONS`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_L3_BRIDGEPORT_RULES`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_IPSETS`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_GROUPS_BASED_ON_IP_SETS`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_LOGICAL_PORTS`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_EDGE_CLUSTERS`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_EDGE_NODES`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_TIER0_ROUTERS`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_TIER1_ROUTERS`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_PREFIX_LIST`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_NAT_RULES`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_TIER1_WITH_NAT_RULE`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_DHCP_SERVERS`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_DHCP_IP_POOLS`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_ACTIVE_DIRECTORY_GROUPS`
            *
              :attr:`CapacityDashboardUsage.USAGE_TYPE_ACTIVE_DIRECTORY_DOMAINS`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_FIREWALL_SECTIONS`
            * :attr:`CapacityDashboardUsage.USAGE_TYPE_FIREWALL_RULES`
            
             Indicate the object type for which usage is calculated.
        """
        self.current_usage_count = current_usage_count
        self.current_usage_percentage = current_usage_percentage
        self.display_name = display_name
        self.max_supported_count = max_supported_count
        self.max_threshold_percentage = max_threshold_percentage
        self.min_threshold_percentage = min_threshold_percentage
        self.severity = severity
        self.usage_type = usage_type
        VapiStruct.__init__(self)


CapacityDashboardUsage._set_binding_type(type.StructType(
    'com.vmware.nsx.model.capacity_dashboard_usage', {
        'current_usage_count': type.OptionalType(type.IntegerType()),
        'current_usage_percentage': type.OptionalType(type.DoubleType()),
        'display_name': type.OptionalType(type.StringType()),
        'max_supported_count': type.OptionalType(type.IntegerType()),
        'max_threshold_percentage': type.OptionalType(type.DoubleType()),
        'min_threshold_percentage': type.OptionalType(type.DoubleType()),
        'severity': type.OptionalType(type.StringType()),
        'usage_type': type.OptionalType(type.StringType()),
    },
    CapacityDashboardUsage,
    False,
    None))



class CapacityThreshold(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    THRESHOLD_TYPE_NUMBER_OF_LOGICAL_SWITCHES = "NUMBER_OF_LOGICAL_SWITCHES"
    """


    """
    THRESHOLD_TYPE_NUMBER_OF_PREPARED_HOSTS = "NUMBER_OF_PREPARED_HOSTS"
    """


    """
    THRESHOLD_TYPE_NUMBER_OF_NSGROUP = "NUMBER_OF_NSGROUP"
    """


    """
    THRESHOLD_TYPE_NUMBER_OF_VCENTER_CLUSTERS = "NUMBER_OF_VCENTER_CLUSTERS"
    """


    """
    THRESHOLD_TYPE_NUMBER_OF_GI_PROTECTED_HOSTS = "NUMBER_OF_GI_PROTECTED_HOSTS"
    """


    """
    THRESHOLD_TYPE_NUMBER_OF_GI_PROTECTED_VMS = "NUMBER_OF_GI_PROTECTED_VMS"
    """


    """
    THRESHOLD_TYPE_NUMBER_OF_DFW_RULES = "NUMBER_OF_DFW_RULES"
    """


    """
    THRESHOLD_TYPE_NUMBER_OF_DFW_SECTIONS = "NUMBER_OF_DFW_SECTIONS"
    """


    """
    THRESHOLD_TYPE_NUMBER_OF_IPSETS = "NUMBER_OF_IPSETS"
    """


    """
    THRESHOLD_TYPE_NUMBER_OF_GROUPS_BASED_ON_IP_SETS = "NUMBER_OF_GROUPS_BASED_ON_IP_SETS"
    """


    """
    THRESHOLD_TYPE_NUMBER_OF_LOGICAL_PORTS = "NUMBER_OF_LOGICAL_PORTS"
    """


    """
    THRESHOLD_TYPE_NUMBER_OF_EDGE_CLUSTERS = "NUMBER_OF_EDGE_CLUSTERS"
    """


    """
    THRESHOLD_TYPE_NUMBER_OF_EDGE_NODES = "NUMBER_OF_EDGE_NODES"
    """


    """
    THRESHOLD_TYPE_NUMBER_OF_TIER0_ROUTERS = "NUMBER_OF_TIER0_ROUTERS"
    """


    """
    THRESHOLD_TYPE_NUMBER_OF_TIER1_ROUTERS = "NUMBER_OF_TIER1_ROUTERS"
    """


    """
    THRESHOLD_TYPE_NUMBER_OF_PREFIX_LIST = "NUMBER_OF_PREFIX_LIST"
    """


    """
    THRESHOLD_TYPE_NUMBER_OF_NAT_RULES = "NUMBER_OF_NAT_RULES"
    """


    """
    THRESHOLD_TYPE_NUMBER_OF_TIER1_WITH_NAT_RULE = "NUMBER_OF_TIER1_WITH_NAT_RULE"
    """


    """
    THRESHOLD_TYPE_NUMBER_OF_DHCP_SERVERS = "NUMBER_OF_DHCP_SERVERS"
    """


    """
    THRESHOLD_TYPE_NUMBER_OF_DHCP_IP_POOLS = "NUMBER_OF_DHCP_IP_POOLS"
    """


    """
    THRESHOLD_TYPE_NUMBER_OF_ACTIVE_DIRECTORY_GROUPS = "NUMBER_OF_ACTIVE_DIRECTORY_GROUPS"
    """


    """
    THRESHOLD_TYPE_NUMBER_OF_ACTIVE_DIRECTORY_DOMAINS = "NUMBER_OF_ACTIVE_DIRECTORY_DOMAINS"
    """


    """
    THRESHOLD_TYPE_NUMBER_OF_FIREWALL_SECTIONS = "NUMBER_OF_FIREWALL_SECTIONS"
    """


    """
    THRESHOLD_TYPE_NUMBER_OF_FIREWALL_RULES = "NUMBER_OF_FIREWALL_RULES"
    """


    """
    THRESHOLD_TYPE_GLOBAL_DEFAULT = "GLOBAL_DEFAULT"
    """


    """



    _canonical_to_pep_names = {
                            'max_threshold_percentage': 'max_threshold_percentage',
                            'min_threshold_percentage': 'min_threshold_percentage',
                            'threshold_type': 'threshold_type',
                            }

    def __init__(self,
                 max_threshold_percentage=None,
                 min_threshold_percentage=None,
                 threshold_type=None,
                ):
        """
        :type  max_threshold_percentage: :class:`float` or ``None``
        :param max_threshold_percentage: Set the maximum threshold percentage. Specify a value between 0 and
            100. Usage percentage above this value is tagged as critical.
        :type  min_threshold_percentage: :class:`float` or ``None``
        :param min_threshold_percentage: Set the minimum threshold percentage. Specify a value between 0 and
            100. Usage percentage above this value is tagged as warning.
        :type  threshold_type: :class:`str` or ``None``
        :param threshold_type: Possible values are: 
            
            *
              :attr:`CapacityThreshold.THRESHOLD_TYPE_NUMBER_OF_LOGICAL_SWITCHES`
            * :attr:`CapacityThreshold.THRESHOLD_TYPE_NUMBER_OF_PREPARED_HOSTS`
            * :attr:`CapacityThreshold.THRESHOLD_TYPE_NUMBER_OF_NSGROUP`
            *
              :attr:`CapacityThreshold.THRESHOLD_TYPE_NUMBER_OF_VCENTER_CLUSTERS`
            *
              :attr:`CapacityThreshold.THRESHOLD_TYPE_NUMBER_OF_GI_PROTECTED_HOSTS`
            *
              :attr:`CapacityThreshold.THRESHOLD_TYPE_NUMBER_OF_GI_PROTECTED_VMS`
            * :attr:`CapacityThreshold.THRESHOLD_TYPE_NUMBER_OF_DFW_RULES`
            * :attr:`CapacityThreshold.THRESHOLD_TYPE_NUMBER_OF_DFW_SECTIONS`
            * :attr:`CapacityThreshold.THRESHOLD_TYPE_NUMBER_OF_IPSETS`
            *
              :attr:`CapacityThreshold.THRESHOLD_TYPE_NUMBER_OF_GROUPS_BASED_ON_IP_SETS`
            * :attr:`CapacityThreshold.THRESHOLD_TYPE_NUMBER_OF_LOGICAL_PORTS`
            * :attr:`CapacityThreshold.THRESHOLD_TYPE_NUMBER_OF_EDGE_CLUSTERS`
            * :attr:`CapacityThreshold.THRESHOLD_TYPE_NUMBER_OF_EDGE_NODES`
            * :attr:`CapacityThreshold.THRESHOLD_TYPE_NUMBER_OF_TIER0_ROUTERS`
            * :attr:`CapacityThreshold.THRESHOLD_TYPE_NUMBER_OF_TIER1_ROUTERS`
            * :attr:`CapacityThreshold.THRESHOLD_TYPE_NUMBER_OF_PREFIX_LIST`
            * :attr:`CapacityThreshold.THRESHOLD_TYPE_NUMBER_OF_NAT_RULES`
            *
              :attr:`CapacityThreshold.THRESHOLD_TYPE_NUMBER_OF_TIER1_WITH_NAT_RULE`
            * :attr:`CapacityThreshold.THRESHOLD_TYPE_NUMBER_OF_DHCP_SERVERS`
            * :attr:`CapacityThreshold.THRESHOLD_TYPE_NUMBER_OF_DHCP_IP_POOLS`
            *
              :attr:`CapacityThreshold.THRESHOLD_TYPE_NUMBER_OF_ACTIVE_DIRECTORY_GROUPS`
            *
              :attr:`CapacityThreshold.THRESHOLD_TYPE_NUMBER_OF_ACTIVE_DIRECTORY_DOMAINS`
            *
              :attr:`CapacityThreshold.THRESHOLD_TYPE_NUMBER_OF_FIREWALL_SECTIONS`
            * :attr:`CapacityThreshold.THRESHOLD_TYPE_NUMBER_OF_FIREWALL_RULES`
            * :attr:`CapacityThreshold.THRESHOLD_TYPE_GLOBAL_DEFAULT`
            
             Indicate the object type for which threshold is to be set.
        """
        self.max_threshold_percentage = max_threshold_percentage
        self.min_threshold_percentage = min_threshold_percentage
        self.threshold_type = threshold_type
        VapiStruct.__init__(self)


CapacityThreshold._set_binding_type(type.StructType(
    'com.vmware.nsx.model.capacity_threshold', {
        'max_threshold_percentage': type.OptionalType(type.DoubleType()),
        'min_threshold_percentage': type.OptionalType(type.DoubleType()),
        'threshold_type': type.OptionalType(type.StringType()),
    },
    CapacityThreshold,
    False,
    None))



class CapacityThresholdList(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'capacity_thresholds': 'capacity_thresholds',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 capacity_thresholds=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  capacity_thresholds: :class:`list` of :class:`CapacityThreshold` or ``None``
        :param capacity_thresholds: List of capacity thresholds for NSX Objects
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.capacity_thresholds = capacity_thresholds
        VapiStruct.__init__(self)


CapacityThresholdList._set_binding_type(type.StructType(
    'com.vmware.nsx.model.capacity_threshold_list', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'capacity_thresholds': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CapacityThreshold'))),
    },
    CapacityThresholdList,
    False,
    None))



class CapacityUsage(VapiStruct):
    """
    usage of each capacity type ex. vm, cpu

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'capacity_type': 'capacity_type',
                            'usage_count': 'usage_count',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 capacity_type=None,
                 usage_count=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  capacity_type: :class:`str` or ``None``
        :param capacity_type: type of the capacity field
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  usage_count: :class:`long` or ``None``
        :param usage_count: count of number of items of capacity_type format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.capacity_type = capacity_type
        self.usage_count = usage_count
        VapiStruct.__init__(self)


CapacityUsage._set_binding_type(type.StructType(
    'com.vmware.nsx.model.capacity_usage', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'capacity_type': type.OptionalType(type.StringType()),
        'usage_count': type.OptionalType(type.IntegerType()),
    },
    CapacityUsage,
    False,
    None))



class CapacityUsageMetaInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'last_updated_timestamp': 'last_updated_timestamp',
                            'max_global_threshold_percentage': 'max_global_threshold_percentage',
                            'min_global_threshold_percentage': 'min_global_threshold_percentage',
                            }

    def __init__(self,
                 last_updated_timestamp=None,
                 max_global_threshold_percentage=None,
                 min_global_threshold_percentage=None,
                ):
        """
        :type  last_updated_timestamp: :class:`long` or ``None``
        :param last_updated_timestamp: Timestamp at which capacity usage was last calculated format: int64
        :type  max_global_threshold_percentage: :class:`float` or ``None``
        :param max_global_threshold_percentage: Indicates the maximum global threshold percentage
        :type  min_global_threshold_percentage: :class:`float` or ``None``
        :param min_global_threshold_percentage: Indicates the minimum global threshold percentage
        """
        self.last_updated_timestamp = last_updated_timestamp
        self.max_global_threshold_percentage = max_global_threshold_percentage
        self.min_global_threshold_percentage = min_global_threshold_percentage
        VapiStruct.__init__(self)


CapacityUsageMetaInfo._set_binding_type(type.StructType(
    'com.vmware.nsx.model.capacity_usage_meta_info', {
        'last_updated_timestamp': type.OptionalType(type.IntegerType()),
        'max_global_threshold_percentage': type.OptionalType(type.DoubleType()),
        'min_global_threshold_percentage': type.OptionalType(type.DoubleType()),
    },
    CapacityUsageMetaInfo,
    False,
    None))



class CapacityUsageResponse(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'capacity_usage': 'capacity_usage',
                            'meta_info': 'meta_info',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 capacity_usage=None,
                 meta_info=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  capacity_usage: :class:`list` of :class:`CapacityDashboardUsage` or ``None``
        :param capacity_usage: List of capacity usage for NSX Objects
        :type  meta_info: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param meta_info: Meta data for capacity usage statistics
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.capacity_usage = capacity_usage
        self.meta_info = meta_info
        VapiStruct.__init__(self)


CapacityUsageResponse._set_binding_type(type.StructType(
    'com.vmware.nsx.model.capacity_usage_response', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'capacity_usage': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CapacityDashboardUsage'))),
        'meta_info': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
    },
    CapacityUsageResponse,
    False,
    None))



class CentralConfigProperties(VapiStruct):
    """
    Central Config properties

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'local_override': 'local_override',
                            }

    def __init__(self,
                 local_override=None,
                ):
        """
        :type  local_override: :class:`bool` or ``None``
        :param local_override: Override Central Config
        """
        self.local_override = local_override
        VapiStruct.__init__(self)


CentralConfigProperties._set_binding_type(type.StructType(
    'com.vmware.nsx.model.central_config_properties', {
        'local_override': type.OptionalType(type.BooleanType()),
    },
    CentralConfigProperties,
    False,
    None))



class CentralNodeConfigProfile(VapiStruct):
    """
    Central Node Config profile for NSX nodes. This set of properties will be
    pushed to NSX Manager and Edge nodes. SNMP properties will be pushed to KVM
    Hypervisors in addition to Manager and Edge nodes.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'ntp': 'ntp',
                            'snmp': 'snmp',
                            'syslog': 'syslog',
                            'timezone': 'timezone',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 ntp=None,
                 snmp=None,
                 syslog=None,
                 timezone=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  ntp: :class:`NtpProperties` or ``None``
        :param ntp: NTP service properties for NSX nodes.
        :type  snmp: :class:`SnmpProperties` or ``None``
        :param snmp: SNMP service properties for NSX nodes.
        :type  syslog: :class:`SyslogProperties` or ``None``
        :param syslog: Syslog service properties for NSX nodes.
        :type  timezone: :class:`str` or ``None``
        :param timezone: Timezone to be set for NSX nodes. Only timezone strings listed in
            the Time Zone database (https://www.iana.org/time-zones) are
            allowed.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.ntp = ntp
        self.snmp = snmp
        self.syslog = syslog
        self.timezone = timezone
        VapiStruct.__init__(self)


CentralNodeConfigProfile._set_binding_type(type.StructType(
    'com.vmware.nsx.model.central_node_config_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'ntp': type.OptionalType(type.ReferenceType(__name__, 'NtpProperties')),
        'snmp': type.OptionalType(type.ReferenceType(__name__, 'SnmpProperties')),
        'syslog': type.OptionalType(type.ReferenceType(__name__, 'SyslogProperties')),
        'timezone': type.OptionalType(type.StringType()),
    },
    CentralNodeConfigProfile,
    False,
    None))



class CentralNodeConfigProfileListResult(VapiStruct):
    """
    Paged collection of Central Node Config profiles.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`CentralNodeConfigProfile` or ``None``
        :param results: Central Node Config profiles
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


CentralNodeConfigProfileListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.central_node_config_profile_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CentralNodeConfigProfile'))),
    },
    CentralNodeConfigProfileListResult,
    False,
    None))



class Certificate(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'details': 'details',
                            'pem_encoded': 'pem_encoded',
                            'used_by': 'used_by',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 details=None,
                 pem_encoded=None,
                 used_by=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  details: :class:`list` of :class:`X509Certificate` or ``None``
        :param details: List of X509Certificates.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  pem_encoded: :class:`str` or ``None``
        :param pem_encoded: PEM encoded certificate data.
        :type  used_by: :class:`list` of :class:`NodeIdServicesMap` or ``None``
        :param used_by: List of node IDs with services, that are using this certificate.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.details = details
        self.pem_encoded = pem_encoded
        self.used_by = used_by
        VapiStruct.__init__(self)


Certificate._set_binding_type(type.StructType(
    'com.vmware.nsx.model.certificate', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'details': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'X509Certificate'))),
        'pem_encoded': type.OptionalType(type.StringType()),
        'used_by': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NodeIdServicesMap'))),
    },
    Certificate,
    False,
    None))



class CertificateCheckingStatus(VapiStruct):
    """
    Result of checking a certificate

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_OK = "OK"
    """


    """
    STATUS_CRL_NOT_READY = "CRL_NOT_READY"
    """


    """
    STATUS_REJECTED = "REJECTED"
    """


    """
    STATUS_ERROR = "ERROR"
    """


    """



    _canonical_to_pep_names = {
                            'error_message': 'error_message',
                            'status': 'status',
                            }

    def __init__(self,
                 error_message=None,
                 status=None,
                ):
        """
        :type  error_message: :class:`str` or ``None``
        :param error_message: Error message when checking the certificate.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`CertificateCheckingStatus.STATUS_OK`
            * :attr:`CertificateCheckingStatus.STATUS_CRL_NOT_READY`
            * :attr:`CertificateCheckingStatus.STATUS_REJECTED`
            * :attr:`CertificateCheckingStatus.STATUS_ERROR`
            
             Status of the checked certificate.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.error_message = error_message
        self.status = status
        VapiStruct.__init__(self)


CertificateCheckingStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.certificate_checking_status', {
        'error_message': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
    },
    CertificateCheckingStatus,
    False,
    None))



class CertificateKeyPair(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'certificate': 'certificate',
                            'rsa_private_key': 'rsa_private_key',
                            }

    def __init__(self,
                 certificate=None,
                 rsa_private_key=None,
                ):
        """
        :type  certificate: :class:`SecurityCertificate` or ``None``
        :param certificate: 
        :type  rsa_private_key: :class:`str` or ``None``
        :param rsa_private_key: The private key must include the enclosing \"-----BEGIN RSA PRIVATE
            KEY-----\" and \"-----END RSA PRIVATE KEY-----\". An empty string
            is returned in read responses.
        """
        self.certificate = certificate
        self.rsa_private_key = rsa_private_key
        VapiStruct.__init__(self)


CertificateKeyPair._set_binding_type(type.StructType(
    'com.vmware.nsx.model.certificate_key_pair', {
        'certificate': type.OptionalType(type.ReferenceType(__name__, 'SecurityCertificate')),
        'rsa_private_key': type.OptionalType(type.StringType()),
    },
    CertificateKeyPair,
    False,
    None))



class CertificateList(VapiStruct):
    """
    Certificate queries result

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`Certificate` or ``None``
        :param results: Certificate list.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


CertificateList._set_binding_type(type.StructType(
    'com.vmware.nsx.model.certificate_list', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Certificate'))),
    },
    CertificateList,
    False,
    None))



class CipherSuite(VapiStruct):
    """
    TLS cipher suite

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'enabled': 'enabled',
                            'name': 'name',
                            }

    def __init__(self,
                 enabled=None,
                 name=None,
                ):
        """
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Enable status for this cipher suite
        :type  name: :class:`str` or ``None``
        :param name: Name of the TLS cipher suite
        """
        self.enabled = enabled
        self.name = name
        VapiStruct.__init__(self)


CipherSuite._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cipher_suite', {
        'enabled': type.OptionalType(type.BooleanType()),
        'name': type.OptionalType(type.StringType()),
    },
    CipherSuite,
    False,
    None))



class ClasslessStaticRoute(VapiStruct):
    """
    DHCP classless static route option.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'network': 'network',
                            'next_hop': 'next_hop',
                            }

    def __init__(self,
                 network=None,
                 next_hop=None,
                ):
        """
        :type  network: :class:`str` or ``None``
        :param network: Destination network in CIDR format. format:
            address-or-block-or-range
        :type  next_hop: :class:`str` or ``None``
        :param next_hop: IP address of next hop of the route. format: ip
        """
        self.network = network
        self.next_hop = next_hop
        VapiStruct.__init__(self)


ClasslessStaticRoute._set_binding_type(type.StructType(
    'com.vmware.nsx.model.classless_static_route', {
        'network': type.OptionalType(type.StringType()),
        'next_hop': type.OptionalType(type.StringType()),
    },
    ClasslessStaticRoute,
    False,
    None))



class ClientSslProfileBinding(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    CLIENT_AUTH_REQUIRED = "REQUIRED"
    """


    """
    CLIENT_AUTH_IGNORE = "IGNORE"
    """


    """



    _canonical_to_pep_names = {
                            'certificate_chain_depth': 'certificate_chain_depth',
                            'client_auth': 'client_auth',
                            'client_auth_ca_ids': 'client_auth_ca_ids',
                            'client_auth_crl_ids': 'client_auth_crl_ids',
                            'default_certificate_id': 'default_certificate_id',
                            'sni_certificate_ids': 'sni_certificate_ids',
                            'ssl_profile_id': 'ssl_profile_id',
                            }

    def __init__(self,
                 certificate_chain_depth=None,
                 client_auth=None,
                 client_auth_ca_ids=None,
                 client_auth_crl_ids=None,
                 default_certificate_id=None,
                 sni_certificate_ids=None,
                 ssl_profile_id=None,
                ):
        """
        :type  certificate_chain_depth: :class:`long` or ``None``
        :param certificate_chain_depth: authentication depth is used to set the verification depth in the
            client certificates chain. format: int64
        :type  client_auth: :class:`str` or ``None``
        :param client_auth: Possible values are: 
            
            * :attr:`ClientSslProfileBinding.CLIENT_AUTH_REQUIRED`
            * :attr:`ClientSslProfileBinding.CLIENT_AUTH_IGNORE`
            
             client authentication mode
        :type  client_auth_ca_ids: :class:`list` of :class:`str` or ``None``
        :param client_auth_ca_ids: If client auth type is REQUIRED, client certificate must be signed
            by one of the trusted Certificate Authorities (CAs), also referred
            to as root CAs, whose self signed certificates are specified.
        :type  client_auth_crl_ids: :class:`list` of :class:`str` or ``None``
        :param client_auth_crl_ids: A Certificate Revocation List (CRL) can be specified in the
            client-side SSL profile binding to disallow compromised client
            certificates.
        :type  default_certificate_id: :class:`str` or ``None``
        :param default_certificate_id: A default certificate should be specified which will be used if the
            server does not host multiple hostnames on the same IP address or
            if the client does not support SNI extension.
        :type  sni_certificate_ids: :class:`list` of :class:`str` or ``None``
        :param sni_certificate_ids: Client-side SSL profile binding allows multiple certificates, for
            different hostnames, to be bound to the same virtual server.
        :type  ssl_profile_id: :class:`str` or ``None``
        :param ssl_profile_id: Client SSL profile defines reusable, application-independent client
            side SSL properties.
        """
        self.certificate_chain_depth = certificate_chain_depth
        self.client_auth = client_auth
        self.client_auth_ca_ids = client_auth_ca_ids
        self.client_auth_crl_ids = client_auth_crl_ids
        self.default_certificate_id = default_certificate_id
        self.sni_certificate_ids = sni_certificate_ids
        self.ssl_profile_id = ssl_profile_id
        VapiStruct.__init__(self)


ClientSslProfileBinding._set_binding_type(type.StructType(
    'com.vmware.nsx.model.client_ssl_profile_binding', {
        'certificate_chain_depth': type.OptionalType(type.IntegerType()),
        'client_auth': type.OptionalType(type.StringType()),
        'client_auth_ca_ids': type.OptionalType(type.ListType(type.StringType())),
        'client_auth_crl_ids': type.OptionalType(type.ListType(type.StringType())),
        'default_certificate_id': type.OptionalType(type.StringType()),
        'sni_certificate_ids': type.OptionalType(type.ListType(type.StringType())),
        'ssl_profile_id': type.OptionalType(type.StringType()),
    },
    ClientSslProfileBinding,
    False,
    None))



class ClientTypeCollectionConfiguration(VapiStruct):
    """
    HPM client data collection configuration

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    CLIENT_TYPE_HYPERVISOR = "HYPERVISOR"
    """


    """
    CLIENT_TYPE_EDGE = "EDGE"
    """


    """
    CLIENT_TYPE_CONTROL_PLANE = "CONTROL_PLANE"
    """


    """
    CLIENT_TYPE_CONTROL_PLANE_PLATFORM = "CONTROL_PLANE_PLATFORM"
    """


    """
    CLIENT_TYPE_MANAGEMENT_PLANE = "MANAGEMENT_PLANE"
    """


    """
    CLIENT_TYPE_MANAGEMENT_PLANE_PLATFORM = "MANAGEMENT_PLANE_PLATFORM"
    """


    """



    _canonical_to_pep_names = {
                            'client_type': 'client_type',
                            'data_type_configurations': 'data_type_configurations',
                            }

    def __init__(self,
                 client_type=None,
                 data_type_configurations=None,
                ):
        """
        :type  client_type: :class:`str` or ``None``
        :param client_type: Possible values are: 
            
            * :attr:`ClientTypeCollectionConfiguration.CLIENT_TYPE_HYPERVISOR`
            * :attr:`ClientTypeCollectionConfiguration.CLIENT_TYPE_EDGE`
            *
              :attr:`ClientTypeCollectionConfiguration.CLIENT_TYPE_CONTROL_PLANE`
            *
              :attr:`ClientTypeCollectionConfiguration.CLIENT_TYPE_CONTROL_PLANE_PLATFORM`
            *
              :attr:`ClientTypeCollectionConfiguration.CLIENT_TYPE_MANAGEMENT_PLANE`
            *
              :attr:`ClientTypeCollectionConfiguration.CLIENT_TYPE_MANAGEMENT_PLANE_PLATFORM`
            
            The client type for which this data collection frequency setting
            applies
        :type  data_type_configurations: :class:`list` of :class:`DataTypeCollectionConfiguration` or ``None``
        :param data_type_configurations: The set of data collection type configurations, one for each data
            collection type
        """
        self.client_type = client_type
        self.data_type_configurations = data_type_configurations
        VapiStruct.__init__(self)


ClientTypeCollectionConfiguration._set_binding_type(type.StructType(
    'com.vmware.nsx.model.client_type_collection_configuration', {
        'client_type': type.OptionalType(type.StringType()),
        'data_type_configurations': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'DataTypeCollectionConfiguration'))),
    },
    ClientTypeCollectionConfiguration,
    False,
    None))



class CloudNativeServiceInstance(VapiStruct):
    """
    Stores the information about cloud native service instance.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'external_id': 'external_id',
                            'service_type': 'service_type',
                            'source': 'source',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_last_sync_time': 'last_sync_time',
                            'description': 'description',
                            'display_name': 'display_name',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            }

    def __init__(self,
                 external_id=None,
                 service_type=None,
                 source=None,
                 links=None,
                 schema=None,
                 self_=None,
                 last_sync_time=None,
                 description=None,
                 display_name=None,
                 resource_type=None,
                 tags=None,
                ):
        """
        :type  external_id: :class:`str` or ``None``
        :param external_id: Id of service instance fetched from public cloud.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  service_type: :class:`str` or ``None``
        :param service_type: Type of cloud native service.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  source: :class:`ResourceReference` or ``None``
        :param source: Reference of the public cloud gateway that reported the service
            instance.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  last_sync_time: :class:`long` or ``None``
        :param last_sync_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  resource_type: :class:`str`
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        """
        self.external_id = external_id
        self.service_type = service_type
        self.source = source
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.last_sync_time = last_sync_time
        self.description = description
        self.display_name = display_name
        self._resource_type = resource_type
        self.tags = tags
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

CloudNativeServiceInstance._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cloud_native_service_instance', {
        'external_id': type.OptionalType(type.StringType()),
        'service_type': type.OptionalType(type.StringType()),
        'source': type.OptionalType(type.ReferenceType(__name__, 'ResourceReference')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_last_sync_time': type.OptionalType(type.IntegerType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
    },
    CloudNativeServiceInstance,
    False,
    None))



class CloudNativeServiceInstanceListResult(VapiStruct):
    """
    Stores a list of cloud native service instances and information about them.
    NSX supported service instances are currently limited to Relational
    Database Service (RDS),Elastic Load Balancing (ELB).

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`CloudNativeServiceInstance` or ``None``
        :param results: List of cloud native service instances
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


CloudNativeServiceInstanceListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cloud_native_service_instance_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CloudNativeServiceInstance'))),
    },
    CloudNativeServiceInstanceListResult,
    False,
    None))



class ClusterBackupInfo(VapiStruct):
    """
    Cluster backup details

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    RESTORE_TYPE_REGULAR_RESTORE = "REGULAR_RESTORE"
    """


    """
    RESTORE_TYPE_POLICY_ONLY_RESTORE = "POLICY_ONLY_RESTORE"
    """


    """



    _canonical_to_pep_names = {
                            'ip_address': 'ip_address',
                            'node_id': 'node_id',
                            'restore_type': 'restore_type',
                            'timestamp': 'timestamp',
                            }

    def __init__(self,
                 ip_address=None,
                 node_id=None,
                 restore_type=None,
                 timestamp=None,
                ):
        """
        :type  ip_address: :class:`str` or ``None``
        :param ip_address: IP address or FQDN of the node from which the backup was taken
            format: hostname-or-ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_id: :class:`str` or ``None``
        :param node_id: ID of the node from which the backup was taken
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  restore_type: :class:`list` of :class:`str` or ``None``
        :param restore_type: Possible values are: 
            
            * :attr:`ClusterBackupInfo.RESTORE_TYPE_REGULAR_RESTORE`
            * :attr:`ClusterBackupInfo.RESTORE_TYPE_POLICY_ONLY_RESTORE`
            
             Type of restore allowed
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  timestamp: :class:`long` or ``None``
        :param timestamp: timestamp of the cluster backup file format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.ip_address = ip_address
        self.node_id = node_id
        self.restore_type = restore_type
        self.timestamp = timestamp
        VapiStruct.__init__(self)


ClusterBackupInfo._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_backup_info', {
        'ip_address': type.OptionalType(type.StringType()),
        'node_id': type.OptionalType(type.StringType()),
        'restore_type': type.OptionalType(type.ListType(type.StringType())),
        'timestamp': type.OptionalType(type.IntegerType()),
    },
    ClusterBackupInfo,
    False,
    None))



class ClusterBackupInfoListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ClusterBackupInfo` or ``None``
        :param results: List of timestamps of backed-up cluster files
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ClusterBackupInfoListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_backup_info_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ClusterBackupInfo'))),
    },
    ClusterBackupInfoListResult,
    False,
    None))



class ClusterCertificateId(VapiStruct):
    """
    Cluster Certificate ID

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'certificate_id': 'certificate_id',
                            }

    def __init__(self,
                 certificate_id=None,
                ):
        """
        :type  certificate_id: :class:`str` or ``None``
        :param certificate_id: Certificate ID
        """
        self.certificate_id = certificate_id
        VapiStruct.__init__(self)


ClusterCertificateId._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_certificate_id', {
        'certificate_id': type.OptionalType(type.StringType()),
    },
    ClusterCertificateId,
    False,
    None))



class ClusterConfig(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            'cluster_id': 'cluster_id',
                            'control_cluster_changes_allowed': 'control_cluster_changes_allowed',
                            'mgmt_cluster_changes_allowed': 'mgmt_cluster_changes_allowed',
                            'nodes': 'nodes',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 cluster_id=None,
                 control_cluster_changes_allowed=None,
                 mgmt_cluster_changes_allowed=None,
                 nodes=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: Unique identifier of this cluster
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  control_cluster_changes_allowed: :class:`bool` or ``None``
        :param control_cluster_changes_allowed: True if control cluster nodes may be added or removed
        :type  mgmt_cluster_changes_allowed: :class:`bool` or ``None``
        :param mgmt_cluster_changes_allowed: True if management cluster nodes may be added or removed
        :type  nodes: :class:`list` of :class:`ClusterNodeInfo` or ``None``
        :param nodes: Configuration of each node in cluster
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.cluster_id = cluster_id
        self.control_cluster_changes_allowed = control_cluster_changes_allowed
        self.mgmt_cluster_changes_allowed = mgmt_cluster_changes_allowed
        self.nodes = nodes
        VapiStruct.__init__(self)


ClusterConfig._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        'cluster_id': type.OptionalType(type.StringType()),
        'control_cluster_changes_allowed': type.OptionalType(type.BooleanType()),
        'mgmt_cluster_changes_allowed': type.OptionalType(type.BooleanType()),
        'nodes': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ClusterNodeInfo'))),
    },
    ClusterConfig,
    False,
    None))



class ClusterConfiguration(VapiStruct):
    """
    The configuration of the NSX cluster. The cluster configuration consists of
    a list of cluster node attributes.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'cluster_id': 'cluster_id',
                            'config_version': 'config_version',
                            'nodes': 'nodes',
                            }

    def __init__(self,
                 cluster_id=None,
                 config_version=None,
                 nodes=None,
                ):
        """
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: UUID of the cluster
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  config_version: :class:`long` or ``None``
        :param config_version: Cluster configuration version format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  nodes: :class:`list` of :class:`ClusterNode` or ``None``
        :param nodes: Nodes in the cluster configuration
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.cluster_id = cluster_id
        self.config_version = config_version
        self.nodes = nodes
        VapiStruct.__init__(self)


ClusterConfiguration._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_configuration', {
        'cluster_id': type.OptionalType(type.StringType()),
        'config_version': type.OptionalType(type.IntegerType()),
        'nodes': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ClusterNode'))),
    },
    ClusterConfiguration,
    False,
    None))



class ClusterGroupMemberStatus(VapiStruct):
    """
    This type contains the attributes and status of a group member.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MEMBER_STATUS_UP = "UP"
    """


    """
    MEMBER_STATUS_DOWN = "DOWN"
    """


    """
    MEMBER_STATUS_UNKNOWN = "UNKNOWN"
    """


    """



    _canonical_to_pep_names = {
                            'member_fqdn': 'member_fqdn',
                            'member_ip': 'member_ip',
                            'member_status': 'member_status',
                            'member_uuid': 'member_uuid',
                            }

    def __init__(self,
                 member_fqdn=None,
                 member_ip=None,
                 member_status=None,
                 member_uuid=None,
                ):
        """
        :type  member_fqdn: :class:`str` or ``None``
        :param member_fqdn: FQDN of the group member format: hostname
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  member_ip: :class:`str` or ``None``
        :param member_ip: IP of the group member format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  member_status: :class:`str` or ``None``
        :param member_status: Possible values are: 
            
            * :attr:`ClusterGroupMemberStatus.MEMBER_STATUS_UP`
            * :attr:`ClusterGroupMemberStatus.MEMBER_STATUS_DOWN`
            * :attr:`ClusterGroupMemberStatus.MEMBER_STATUS_UNKNOWN`
            
             Status of the group member
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  member_uuid: :class:`str` or ``None``
        :param member_uuid: UUID of the group member
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.member_fqdn = member_fqdn
        self.member_ip = member_ip
        self.member_status = member_status
        self.member_uuid = member_uuid
        VapiStruct.__init__(self)


ClusterGroupMemberStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_group_member_status', {
        'member_fqdn': type.OptionalType(type.StringType()),
        'member_ip': type.OptionalType(type.StringType()),
        'member_status': type.OptionalType(type.StringType()),
        'member_uuid': type.OptionalType(type.StringType()),
    },
    ClusterGroupMemberStatus,
    False,
    None))



class ClusterGroupServiceLeader(VapiStruct):
    """
    Each cluster node entity provides multiple services. When working in a
    group, each service can elect a cluster node entity to be the leader of the
    service. Leader election helps in coordination of the service. The leader
    holds a renewable lease on the leadership for a fixed period of time. The
    lease version is incremented every time the leadership lease is renewed.
    This type contains the attributes of a leader.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'leader_uuid': 'leader_uuid',
                            'lease_version': 'lease_version',
                            'service_name': 'service_name',
                            }

    def __init__(self,
                 leader_uuid=None,
                 lease_version=None,
                 service_name=None,
                ):
        """
        :type  leader_uuid: :class:`str` or ``None``
        :param leader_uuid: Member UUID of the leader
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  lease_version: :class:`long` or ``None``
        :param lease_version: Number of times the lease has been renewed format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  service_name: :class:`str` or ``None``
        :param service_name: Name of the service
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.leader_uuid = leader_uuid
        self.lease_version = lease_version
        self.service_name = service_name
        VapiStruct.__init__(self)


ClusterGroupServiceLeader._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_group_service_leader', {
        'leader_uuid': type.OptionalType(type.StringType()),
        'lease_version': type.OptionalType(type.IntegerType()),
        'service_name': type.OptionalType(type.StringType()),
    },
    ClusterGroupServiceLeader,
    False,
    None))



class ClusterGroupStatus(VapiStruct):
    """
    This type contains the attributes and status of a group.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    GROUP_STATUS_STABLE = "STABLE"
    """


    """
    GROUP_STATUS_DEGRADED = "DEGRADED"
    """


    """
    GROUP_STATUS_UNSTABLE = "UNSTABLE"
    """


    """
    GROUP_STATUS_UNAVAILABLE = "UNAVAILABLE"
    """


    """
    GROUP_TYPE_MANAGER = "MANAGER"
    """


    """
    GROUP_TYPE_CONTROLLER = "CONTROLLER"
    """


    """
    GROUP_TYPE_POLICY = "POLICY"
    """


    """
    GROUP_TYPE_HTTPS = "HTTPS"
    """


    """
    GROUP_TYPE_DATASTORE = "DATASTORE"
    """


    """
    GROUP_TYPE_CLUSTER_BOOT_MANAGER = "CLUSTER_BOOT_MANAGER"
    """


    """
    GROUP_TYPE_GLOBAL_MANAGER = "GLOBAL_MANAGER"
    """


    """
    GROUP_TYPE_ASYNC_REPLICATOR = "ASYNC_REPLICATOR"
    """


    """
    GROUP_TYPE_MONITORING = "MONITORING"
    """


    """
    GROUP_TYPE_IDPS_REPORTING = "IDPS_REPORTING"
    """


    """
    GROUP_TYPE_CORFU_NONCONFIG = "CORFU_NONCONFIG"
    """


    """



    _canonical_to_pep_names = {
                            'group_id': 'group_id',
                            'group_status': 'group_status',
                            'group_type': 'group_type',
                            'leaders': 'leaders',
                            'members': 'members',
                            }

    def __init__(self,
                 group_id=None,
                 group_status=None,
                 group_type=None,
                 leaders=None,
                 members=None,
                ):
        """
        :type  group_id: :class:`str` or ``None``
        :param group_id: UUID of the group
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  group_status: :class:`str` or ``None``
        :param group_status: Possible values are: 
            
            * :attr:`ClusterGroupStatus.GROUP_STATUS_STABLE`
            * :attr:`ClusterGroupStatus.GROUP_STATUS_DEGRADED`
            * :attr:`ClusterGroupStatus.GROUP_STATUS_UNSTABLE`
            * :attr:`ClusterGroupStatus.GROUP_STATUS_UNAVAILABLE`
            
             Group status
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  group_type: :class:`str` or ``None``
        :param group_type: Possible values are: 
            
            * :attr:`ClusterGroupStatus.GROUP_TYPE_MANAGER`
            * :attr:`ClusterGroupStatus.GROUP_TYPE_CONTROLLER`
            * :attr:`ClusterGroupStatus.GROUP_TYPE_POLICY`
            * :attr:`ClusterGroupStatus.GROUP_TYPE_HTTPS`
            * :attr:`ClusterGroupStatus.GROUP_TYPE_DATASTORE`
            * :attr:`ClusterGroupStatus.GROUP_TYPE_CLUSTER_BOOT_MANAGER`
            * :attr:`ClusterGroupStatus.GROUP_TYPE_GLOBAL_MANAGER`
            * :attr:`ClusterGroupStatus.GROUP_TYPE_ASYNC_REPLICATOR`
            * :attr:`ClusterGroupStatus.GROUP_TYPE_MONITORING`
            * :attr:`ClusterGroupStatus.GROUP_TYPE_IDPS_REPORTING`
            * :attr:`ClusterGroupStatus.GROUP_TYPE_CORFU_NONCONFIG`
            
             Type of the group
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  leaders: :class:`list` of :class:`ClusterGroupServiceLeader` or ``None``
        :param leaders: Array of group leaders and their attributes
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  members: :class:`list` of :class:`ClusterGroupMemberStatus` or ``None``
        :param members: Array of group members and their statuses
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.group_id = group_id
        self.group_status = group_status
        self.group_type = group_type
        self.leaders = leaders
        self.members = members
        VapiStruct.__init__(self)


ClusterGroupStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_group_status', {
        'group_id': type.OptionalType(type.StringType()),
        'group_status': type.OptionalType(type.StringType()),
        'group_type': type.OptionalType(type.StringType()),
        'leaders': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ClusterGroupServiceLeader'))),
        'members': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ClusterGroupMemberStatus'))),
    },
    ClusterGroupStatus,
    False,
    None))



class ClusterInitializationNodeInfo(VapiStruct):
    """
    The type provides the information of a non-running cluster node required
    for the initialization of a management cluster. The administrator needs to
    start this node for management cluster to initialize properly (or
    decommission it explicitly).

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'disk_store_id': 'disk_store_id',
                            'host_address': 'host_address',
                            }

    def __init__(self,
                 disk_store_id=None,
                 host_address=None,
                ):
        """
        :type  disk_store_id: :class:`str` or ``None``
        :param disk_store_id: The (internal) disk-store ID of the member
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  host_address: :class:`str` or ``None``
        :param host_address: The IP address (or domain name) of the cluster node
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.disk_store_id = disk_store_id
        self.host_address = host_address
        VapiStruct.__init__(self)


ClusterInitializationNodeInfo._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_initialization_node_info', {
        'disk_store_id': type.OptionalType(type.StringType()),
        'host_address': type.OptionalType(type.StringType()),
    },
    ClusterInitializationNodeInfo,
    False,
    None))



class ClusterNode(VapiStruct):
    """
    This type contains attributes of a cluster node that are relevant to the
    Cluster Boot Manager.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_JOINING = "JOINING"
    """


    """
    STATUS_JOINED = "JOINED"
    """


    """
    STATUS_REMOVING = "REMOVING"
    """


    """
    STATUS_REMOVED = "REMOVED"
    """


    """



    _canonical_to_pep_names = {
                            'entities': 'entities',
                            'node_uuid': 'node_uuid',
                            'status': 'status',
                            }

    def __init__(self,
                 entities=None,
                 node_uuid=None,
                 status=None,
                ):
        """
        :type  entities: :class:`list` of :class:`ClusterNodeEntity` or ``None``
        :param entities: Entities on the node
        :type  node_uuid: :class:`str` or ``None``
        :param node_uuid: UUID of the node
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ClusterNode.STATUS_JOINING`
            * :attr:`ClusterNode.STATUS_JOINED`
            * :attr:`ClusterNode.STATUS_REMOVING`
            * :attr:`ClusterNode.STATUS_REMOVED`
            
             Current clustering status of the node
        """
        self.entities = entities
        self.node_uuid = node_uuid
        self.status = status
        VapiStruct.__init__(self)


ClusterNode._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_node', {
        'entities': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ClusterNodeEntity'))),
        'node_uuid': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
    },
    ClusterNode,
    False,
    None))



class ClusterNodeConfig(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'appliance_mgmt_listen_addr': 'appliance_mgmt_listen_addr',
                            'controller_role': 'controller_role',
                            'external_id': 'external_id',
                            'manager_role': 'manager_role',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 appliance_mgmt_listen_addr=None,
                 controller_role=None,
                 external_id=None,
                 manager_role=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  appliance_mgmt_listen_addr: :class:`str` or ``None``
        :param appliance_mgmt_listen_addr: The IP and port for the appliance management API service on this
            node
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  controller_role: :class:`ControllerClusterRoleConfig` or ``None``
        :param controller_role: 
        :type  external_id: :class:`str` or ``None``
        :param external_id: Internal identifier provided by the node
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  manager_role: :class:`ManagementClusterRoleConfig` or ``None``
        :param manager_role: 
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.appliance_mgmt_listen_addr = appliance_mgmt_listen_addr
        self.controller_role = controller_role
        self.external_id = external_id
        self.manager_role = manager_role
        VapiStruct.__init__(self)


ClusterNodeConfig._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_node_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'appliance_mgmt_listen_addr': type.OptionalType(type.StringType()),
        'controller_role': type.OptionalType(type.ReferenceType(__name__, 'ControllerClusterRoleConfig')),
        'external_id': type.OptionalType(type.StringType()),
        'manager_role': type.OptionalType(type.ReferenceType(__name__, 'ManagementClusterRoleConfig')),
    },
    ClusterNodeConfig,
    False,
    None))



class ClusterNodeConfigListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ClusterNodeConfig` or ``None``
        :param results: Cluster node configuration results
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ClusterNodeConfigListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_node_config_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ClusterNodeConfig'))),
    },
    ClusterNodeConfigListResult,
    False,
    None))



class ClusterNodeEntity(VapiStruct):
    """
    NSX Cluster is made up of multiple cluster nodes. Each node can perform
    multiple functions, commonly referred to as roles. Cluster node entities
    are processes running in a cluster node that assist in the performance of a
    role. Cluster Boot Manager is a daemon that securely bootstraps and
    configures the entities. This type contains attributes of a cluster node
    entity that are relevant to the Cluster Boot Manager.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ENTITY_TYPE_MANAGER = "MANAGER"
    """


    """
    ENTITY_TYPE_CONTROLLER = "CONTROLLER"
    """


    """
    ENTITY_TYPE_POLICY = "POLICY"
    """


    """
    ENTITY_TYPE_HTTPS = "HTTPS"
    """


    """
    ENTITY_TYPE_CLUSTER_BOOT_MANAGER = "CLUSTER_BOOT_MANAGER"
    """


    """
    ENTITY_TYPE_DATASTORE = "DATASTORE"
    """


    """
    ENTITY_TYPE_GLOBAL_MANAGER = "GLOBAL_MANAGER"
    """


    """
    ENTITY_TYPE_ASYNC_REPLICATOR = "ASYNC_REPLICATOR"
    """


    """
    ENTITY_TYPE_MONITORING = "MONITORING"
    """


    """
    ENTITY_TYPE_IDPS_REPORTING = "IDPS_REPORTING"
    """


    """
    ENTITY_TYPE_CORFU_NONCONFIG = "CORFU_NONCONFIG"
    """


    """



    _canonical_to_pep_names = {
                            'certificate': 'certificate',
                            'entity_type': 'entity_type',
                            'entity_uuid': 'entity_uuid',
                            'fqdn': 'fqdn',
                            'ip_address': 'ip_address',
                            'port': 'port',
                            'subnet_prefix_length': 'subnet_prefix_length',
                            }

    def __init__(self,
                 certificate=None,
                 entity_type=None,
                 entity_uuid=None,
                 fqdn=None,
                 ip_address=None,
                 port=None,
                 subnet_prefix_length=None,
                ):
        """
        :type  certificate: :class:`str` or ``None``
        :param certificate: Public certificate of the entity in PEM format
        :type  entity_type: :class:`str` or ``None``
        :param entity_type: Possible values are: 
            
            * :attr:`ClusterNodeEntity.ENTITY_TYPE_MANAGER`
            * :attr:`ClusterNodeEntity.ENTITY_TYPE_CONTROLLER`
            * :attr:`ClusterNodeEntity.ENTITY_TYPE_POLICY`
            * :attr:`ClusterNodeEntity.ENTITY_TYPE_HTTPS`
            * :attr:`ClusterNodeEntity.ENTITY_TYPE_CLUSTER_BOOT_MANAGER`
            * :attr:`ClusterNodeEntity.ENTITY_TYPE_DATASTORE`
            * :attr:`ClusterNodeEntity.ENTITY_TYPE_GLOBAL_MANAGER`
            * :attr:`ClusterNodeEntity.ENTITY_TYPE_ASYNC_REPLICATOR`
            * :attr:`ClusterNodeEntity.ENTITY_TYPE_MONITORING`
            * :attr:`ClusterNodeEntity.ENTITY_TYPE_IDPS_REPORTING`
            * :attr:`ClusterNodeEntity.ENTITY_TYPE_CORFU_NONCONFIG`
            
             Type of the entity
        :type  entity_uuid: :class:`str` or ``None``
        :param entity_uuid: UUID of the entity
        :type  fqdn: :class:`str` or ``None``
        :param fqdn: Domain name the entity binds to format: hostname
        :type  ip_address: :class:`str` or ``None``
        :param ip_address: IP address the entity binds to
        :type  port: :class:`long` or ``None``
        :param port: Port the entity binds to format: int64
        :type  subnet_prefix_length: :class:`long` or ``None``
        :param subnet_prefix_length: Subnet mask prefix length of the entity binds to format: int64
        """
        self.certificate = certificate
        self.entity_type = entity_type
        self.entity_uuid = entity_uuid
        self.fqdn = fqdn
        self.ip_address = ip_address
        self.port = port
        self.subnet_prefix_length = subnet_prefix_length
        VapiStruct.__init__(self)


ClusterNodeEntity._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_node_entity', {
        'certificate': type.OptionalType(type.StringType()),
        'entity_type': type.OptionalType(type.StringType()),
        'entity_uuid': type.OptionalType(type.StringType()),
        'fqdn': type.OptionalType(type.StringType()),
        'ip_address': type.OptionalType(type.StringType()),
        'port': type.OptionalType(type.IntegerType()),
        'subnet_prefix_length': type.OptionalType(type.IntegerType()),
    },
    ClusterNodeEntity,
    False,
    None))



class ClusterNodeInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_JOINING = "JOINING"
    """


    """
    STATUS_JOINED = "JOINED"
    """


    """
    STATUS_REMOVING = "REMOVING"
    """


    """
    STATUS_REMOVED = "REMOVED"
    """


    """



    _canonical_to_pep_names = {
                            'certificates': 'certificates',
                            'display_name': 'display_name',
                            'entities': 'entities',
                            'fqdn': 'fqdn',
                            'msg_clients': 'msg_clients',
                            'node_uuid': 'node_uuid',
                            'status': 'status',
                            }

    def __init__(self,
                 certificates=None,
                 display_name=None,
                 entities=None,
                 fqdn=None,
                 msg_clients=None,
                 node_uuid=None,
                 status=None,
                ):
        """
        :type  certificates: :class:`list` of :class:`NodeCertificateInfo` or ``None``
        :param certificates: Certificate and thumbprint of all entities
        :type  display_name: :class:`str` or ``None``
        :param display_name: The display name of this node
        :type  entities: :class:`list` of :class:`NodeEntityInfo` or ``None``
        :param entities: Service endpoint of all entities
        :type  fqdn: :class:`str` or ``None``
        :param fqdn: The fqdn of this node
        :type  msg_clients: :class:`list` of :class:`NodeMessagingClientInfo` or ``None``
        :param msg_clients: Messaging client of all entities
        :type  node_uuid: :class:`str` or ``None``
        :param node_uuid: Unique identifier of this node
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ClusterNodeInfo.STATUS_JOINING`
            * :attr:`ClusterNodeInfo.STATUS_JOINED`
            * :attr:`ClusterNodeInfo.STATUS_REMOVING`
            * :attr:`ClusterNodeInfo.STATUS_REMOVED`
            
             Node clustering status
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.certificates = certificates
        self.display_name = display_name
        self.entities = entities
        self.fqdn = fqdn
        self.msg_clients = msg_clients
        self.node_uuid = node_uuid
        self.status = status
        VapiStruct.__init__(self)


ClusterNodeInfo._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_node_info', {
        'certificates': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NodeCertificateInfo'))),
        'display_name': type.OptionalType(type.StringType()),
        'entities': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NodeEntityInfo'))),
        'fqdn': type.OptionalType(type.StringType()),
        'msg_clients': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NodeMessagingClientInfo'))),
        'node_uuid': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
    },
    ClusterNodeInfo,
    False,
    None))



class ClusterNodeStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'control_cluster_status': 'control_cluster_status',
                            'mgmt_cluster_status': 'mgmt_cluster_status',
                            'system_status': 'system_status',
                            'version': 'version',
                            }

    def __init__(self,
                 control_cluster_status=None,
                 mgmt_cluster_status=None,
                 system_status=None,
                 version=None,
                ):
        """
        :type  control_cluster_status: :class:`ControlClusterNodeStatus` or ``None``
        :param control_cluster_status: Clustering status for control plane functions on this node
        :type  mgmt_cluster_status: :class:`ManagementClusterNodeStatus` or ``None``
        :param mgmt_cluster_status: Clustering status for management plane functions on this node
        :type  system_status: :class:`NodeStatusProperties` or ``None``
        :param system_status: Node status properties
        :type  version: :class:`str` or ``None``
        :param version: Software version running on node
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.control_cluster_status = control_cluster_status
        self.mgmt_cluster_status = mgmt_cluster_status
        self.system_status = system_status
        self.version = version
        VapiStruct.__init__(self)


ClusterNodeStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_node_status', {
        'control_cluster_status': type.OptionalType(type.ReferenceType(__name__, 'ControlClusterNodeStatus')),
        'mgmt_cluster_status': type.OptionalType(type.ReferenceType(__name__, 'ManagementClusterNodeStatus')),
        'system_status': type.OptionalType(type.ReferenceType(__name__, 'NodeStatusProperties')),
        'version': type.OptionalType(type.StringType()),
    },
    ClusterNodeStatus,
    False,
    None))



class ClusterNodeVMDeploymentConfig(VapiStruct):
    """
    Contains info used to configure the VM on deployment

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ClusterNodeVMDeploymentConfig"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    PLACEMENT_TYPE_VSPHERECLUSTERNODEVMDEPLOYMENTCONFIG = "VsphereClusterNodeVMDeploymentConfig"
    """


    """



    _canonical_to_pep_names = {
                            'placement_type': 'placement_type',
                            }

    def __init__(self,
                 placement_type='ClusterNodeVMDeploymentConfig',
                ):
        """
        :type  placement_type: :class:`str`
        :param placement_type: Possible values are: 
            
            *
              :attr:`ClusterNodeVMDeploymentConfig.PLACEMENT_TYPE_VSPHERECLUSTERNODEVMDEPLOYMENTCONFIG`
            
            Specifies the config for the platform through which to deploy the
            VM
        """
        self._placement_type = placement_type
        VapiStruct.__init__(self)

    @property
    def placement_type(self):
        """
        Return the discriminator value
        """
        return self._placement_type

ClusterNodeVMDeploymentConfig._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_node_VM_deployment_config', {
        'placement_type': type.StringType(),
    },
    ClusterNodeVMDeploymentConfig,
    False,
    None))



class ClusterNodeVMDeploymentProgressState(VapiStruct):
    """
    Deployment progress state of node VM. This Object contains name of current
    deployment step and overall progress percentage.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'current_step_title': 'current_step_title',
                            'progress': 'progress',
                            }

    def __init__(self,
                 current_step_title=None,
                 progress=None,
                ):
        """
        :type  current_step_title: :class:`str` or ``None``
        :param current_step_title: Name of the current running step of deployment
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  progress: :class:`long` or ``None``
        :param progress: Overall progress percentage of deployment completed format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.current_step_title = current_step_title
        self.progress = progress
        VapiStruct.__init__(self)


ClusterNodeVMDeploymentProgressState._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_node_VM_deployment_progress_state', {
        'current_step_title': type.OptionalType(type.StringType()),
        'progress': type.OptionalType(type.IntegerType()),
    },
    ClusterNodeVMDeploymentProgressState,
    False,
    None))



class ClusterNodeVMDeploymentRequest(VapiStruct):
    """
    Contains the deployment information for a cluster node VM soon to be
    deployed or already deployed by the Manager

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    FORM_FACTOR_SMALL = "SMALL"
    """


    """
    FORM_FACTOR_MEDIUM = "MEDIUM"
    """


    """
    FORM_FACTOR_LARGE = "LARGE"
    """


    """
    ROLES_CONTROLLER = "CONTROLLER"
    """


    """
    ROLES_MANAGER = "MANAGER"
    """


    """



    _canonical_to_pep_names = {
                            'deployment_config': 'deployment_config',
                            'form_factor': 'form_factor',
                            'roles': 'roles',
                            'user_settings': 'user_settings',
                            'vm_id': 'vm_id',
                            }

    def __init__(self,
                 deployment_config=None,
                 form_factor=None,
                 roles=None,
                 user_settings=None,
                 vm_id=None,
                ):
        """
        :type  deployment_config: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param deployment_config: Info needed to configure a cluster node VM at deployment for a
            specific platform. May require different parameters depending on
            the method used to deploy the VM.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ClusterNodeVMDeploymentConfig`. When methods return a value
            of this class as a return value, the attribute will contain all the
            attributes defined in :class:`ClusterNodeVMDeploymentConfig`.
        :type  form_factor: :class:`str` or ``None``
        :param form_factor: Possible values are: 
            
            * :attr:`ClusterNodeVMDeploymentRequest.FORM_FACTOR_SMALL`
            * :attr:`ClusterNodeVMDeploymentRequest.FORM_FACTOR_MEDIUM`
            * :attr:`ClusterNodeVMDeploymentRequest.FORM_FACTOR_LARGE`
            
             Specifies the desired \"size\" of the VM
        :type  roles: :class:`list` of :class:`str` or ``None``
        :param roles: Possible values are: 
            
            * :attr:`ClusterNodeVMDeploymentRequest.ROLES_CONTROLLER`
            * :attr:`ClusterNodeVMDeploymentRequest.ROLES_MANAGER`
            
            List of cluster node role (or roles) which the VM should take on.
            They specify what type (or types) of cluster node which the new VM
            should act as. Currently both CONTROLLER and MANAGER must be
            provided, since this permutation is the only one supported now.
        :type  user_settings: :class:`NodeUserSettings` or ``None``
        :param user_settings: Username and password settings for the cluster node VM. Passwords
            must be at least 12 characters in length and contain at least one
            lowercase, one uppercase, one numerical, and one special character.
            Note: These settings will be honored only during VM deployment.
            Post-deployment, CLI must be used for changing the user settings
            and changes to these parameters will not have any effect.
        :type  vm_id: :class:`str` or ``None``
        :param vm_id: ID of the VM maintained internally and used to recognize it. Note:
            This is automatically generated and cannot be modified.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.deployment_config = deployment_config
        self.form_factor = form_factor
        self.roles = roles
        self.user_settings = user_settings
        self.vm_id = vm_id
        VapiStruct.__init__(self)


ClusterNodeVMDeploymentRequest._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_node_VM_deployment_request', {
        'deployment_config': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ClusterNodeVMDeploymentConfig')])),
        'form_factor': type.OptionalType(type.StringType()),
        'roles': type.OptionalType(type.ListType(type.StringType())),
        'user_settings': type.OptionalType(type.ReferenceType(__name__, 'NodeUserSettings')),
        'vm_id': type.OptionalType(type.StringType()),
    },
    ClusterNodeVMDeploymentRequest,
    False,
    None))



class ClusterNodeVMDeploymentRequestList(VapiStruct):
    """
    List of ClusterNodeVMDeploymentRequests

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ClusterNodeVMDeploymentRequest` or ``None``
        :param results: Array of existing ClusterNodeVMDeploymentRequests
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ClusterNodeVMDeploymentRequestList._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_node_VM_deployment_request_list', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ClusterNodeVMDeploymentRequest'))),
    },
    ClusterNodeVMDeploymentRequestList,
    False,
    None))



class ClusterNodeVMDeploymentStatusReport(VapiStruct):
    """
    Contains up-to-date information relating to an auto-deployed VM, including
    its status and (potentially) an error message.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_UNKNOWN_STATE = "UNKNOWN_STATE"
    """


    """
    STATUS_VM_DEPLOYMENT_QUEUED = "VM_DEPLOYMENT_QUEUED"
    """


    """
    STATUS_VM_DEPLOYMENT_IN_PROGRESS = "VM_DEPLOYMENT_IN_PROGRESS"
    """


    """
    STATUS_VM_DEPLOYMENT_FAILED = "VM_DEPLOYMENT_FAILED"
    """


    """
    STATUS_VM_POWER_ON_IN_PROGRESS = "VM_POWER_ON_IN_PROGRESS"
    """


    """
    STATUS_VM_POWER_ON_FAILED = "VM_POWER_ON_FAILED"
    """


    """
    STATUS_WAITING_TO_REGISTER_VM = "WAITING_TO_REGISTER_VM"
    """


    """
    STATUS_VM_REGISTRATION_FAILED = "VM_REGISTRATION_FAILED"
    """


    """
    STATUS_VM_WAITING_TO_CLUSTER = "VM_WAITING_TO_CLUSTER"
    """


    """
    STATUS_VM_WAITING_TO_COME_ONLINE = "VM_WAITING_TO_COME_ONLINE"
    """


    """
    STATUS_VM_ONLINE_FAILED = "VM_ONLINE_FAILED"
    """


    """
    STATUS_VM_CLUSTERING_IN_PROGRESS = "VM_CLUSTERING_IN_PROGRESS"
    """


    """
    STATUS_VM_CLUSTERING_FAILED = "VM_CLUSTERING_FAILED"
    """


    """
    STATUS_VM_CLUSTERING_SUCCESSFUL = "VM_CLUSTERING_SUCCESSFUL"
    """


    """
    STATUS_WAITING_TO_UNDEPLOY_VM = "WAITING_TO_UNDEPLOY_VM"
    """


    """
    STATUS_VM_DECLUSTER_IN_PROGRESS = "VM_DECLUSTER_IN_PROGRESS"
    """


    """
    STATUS_VM_DECLUSTER_FAILED = "VM_DECLUSTER_FAILED"
    """


    """
    STATUS_VM_DECLUSTER_SUCCESSFUL = "VM_DECLUSTER_SUCCESSFUL"
    """


    """
    STATUS_VM_POWER_OFF_IN_PROGRESS = "VM_POWER_OFF_IN_PROGRESS"
    """


    """
    STATUS_VM_POWER_OFF_FAILED = "VM_POWER_OFF_FAILED"
    """


    """
    STATUS_VM_UNDEPLOY_IN_PROGRESS = "VM_UNDEPLOY_IN_PROGRESS"
    """


    """
    STATUS_VM_UNDEPLOY_FAILED = "VM_UNDEPLOY_FAILED"
    """


    """
    STATUS_VM_UNDEPLOY_SUCCESSFUL = "VM_UNDEPLOY_SUCCESSFUL"
    """


    """



    _canonical_to_pep_names = {
                            'deployment_progress_state': 'deployment_progress_state',
                            'failure_code': 'failure_code',
                            'failure_message': 'failure_message',
                            'status': 'status',
                            }

    def __init__(self,
                 deployment_progress_state=None,
                 failure_code=None,
                 failure_message=None,
                 status=None,
                ):
        """
        :type  deployment_progress_state: :class:`VMDeploymentProgressState` or ``None``
        :param deployment_progress_state: Detailed progress state of node VM deployment realization
        :type  failure_code: :class:`long` or ``None``
        :param failure_code: In case of auto-deployment-related failure, the code for the error
            will be stored here. format: int64
        :type  failure_message: :class:`str` or ``None``
        :param failure_message: In case of auto-deployment-related failure, an error message will
            be stored here.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_UNKNOWN_STATE`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_DEPLOYMENT_QUEUED`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_DEPLOYMENT_IN_PROGRESS`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_DEPLOYMENT_FAILED`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_POWER_ON_IN_PROGRESS`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_POWER_ON_FAILED`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_WAITING_TO_REGISTER_VM`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_REGISTRATION_FAILED`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_WAITING_TO_CLUSTER`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_WAITING_TO_COME_ONLINE`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_ONLINE_FAILED`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_CLUSTERING_IN_PROGRESS`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_CLUSTERING_FAILED`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_CLUSTERING_SUCCESSFUL`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_WAITING_TO_UNDEPLOY_VM`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_DECLUSTER_IN_PROGRESS`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_DECLUSTER_FAILED`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_DECLUSTER_SUCCESSFUL`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_POWER_OFF_IN_PROGRESS`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_POWER_OFF_FAILED`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_UNDEPLOY_IN_PROGRESS`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_UNDEPLOY_FAILED`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_UNDEPLOY_SUCCESSFUL`
            
            Status of the addition or deletion of an auto-deployed cluster node
            VM.
        """
        self.deployment_progress_state = deployment_progress_state
        self.failure_code = failure_code
        self.failure_message = failure_message
        self.status = status
        VapiStruct.__init__(self)


ClusterNodeVMDeploymentStatusReport._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_node_VM_deployment_status_report', {
        'deployment_progress_state': type.OptionalType(type.ReferenceType(__name__, 'VMDeploymentProgressState')),
        'failure_code': type.OptionalType(type.IntegerType()),
        'failure_message': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
    },
    ClusterNodeVMDeploymentStatusReport,
    False,
    None))



class ClusterProfile(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ClusterProfile"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    RESOURCE_TYPE_EDGEHIGHAVAILABILITYPROFILE = "EdgeHighAvailabilityProfile"
    """


    """
    RESOURCE_TYPE_BRIDGEHIGHAVAILABILITYCLUSTERPROFILE = "BridgeHighAvailabilityClusterProfile"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='ClusterProfile',
                 tags=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`ClusterProfile.RESOURCE_TYPE_EDGEHIGHAVAILABILITYPROFILE`
            *
              :attr:`ClusterProfile.RESOURCE_TYPE_BRIDGEHIGHAVAILABILITYCLUSTERPROFILE`
            
             Supported cluster profiles.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ClusterProfile._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
    },
    ClusterProfile,
    False,
    None))



class ClusterProfileListResult(VapiStruct):
    """
    Cluster Profile queries result

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: Cluster Profile Results
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ClusterProfile`. When methods return a value of this class
            as a return value, the attribute will contain all the attributes
            defined in :class:`ClusterProfile`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ClusterProfileListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_profile_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ClusterProfile')]))),
    },
    ClusterProfileListResult,
    False,
    None))



class ClusterProfileTypeIdEntry(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    RESOURCE_TYPE_EDGEHIGHAVAILABILITYPROFILE = "EdgeHighAvailabilityProfile"
    """


    """
    RESOURCE_TYPE_BRIDGEHIGHAVAILABILITYCLUSTERPROFILE = "BridgeHighAvailabilityClusterProfile"
    """


    """



    _canonical_to_pep_names = {
                            'profile_id': 'profile_id',
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 profile_id=None,
                 resource_type=None,
                ):
        """
        :type  profile_id: :class:`str` or ``None``
        :param profile_id: key value
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: Possible values are: 
            
            *
              :attr:`ClusterProfileTypeIdEntry.RESOURCE_TYPE_EDGEHIGHAVAILABILITYPROFILE`
            *
              :attr:`ClusterProfileTypeIdEntry.RESOURCE_TYPE_BRIDGEHIGHAVAILABILITYCLUSTERPROFILE`
            
             Supported cluster profiles.
        """
        self.profile_id = profile_id
        self.resource_type = resource_type
        VapiStruct.__init__(self)


ClusterProfileTypeIdEntry._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_profile_type_id_entry', {
        'profile_id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
    },
    ClusterProfileTypeIdEntry,
    False,
    None))



class ClusterRestoreStatus(VapiStruct):
    """
    Cluster restore status

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'backup_timestamp': 'backup_timestamp',
                            'endpoints': 'endpoints',
                            'id': 'id',
                            'instructions': 'instructions',
                            'restore_end_time': 'restore_end_time',
                            'restore_start_time': 'restore_start_time',
                            'status': 'status',
                            'step': 'step',
                            'total_steps': 'total_steps',
                            }

    def __init__(self,
                 backup_timestamp=None,
                 endpoints=None,
                 id=None,
                 instructions=None,
                 restore_end_time=None,
                 restore_start_time=None,
                 status=None,
                 step=None,
                 total_steps=None,
                ):
        """
        :type  backup_timestamp: :class:`long` or ``None``
        :param backup_timestamp: Timestamp when backup was initiated in epoch millisecond format:
            int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  endpoints: :class:`list` of :class:`ResourceLink` or ``None``
        :param endpoints: The list of allowed endpoints, based on the current state of the
            restore process
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  id: :class:`str` or ``None``
        :param id: Unique id for backup request
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  instructions: :class:`list` of :class:`InstructionInfo` or ``None``
        :param instructions: Instructions for users to reconcile Restore operations
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  restore_end_time: :class:`long` or ``None``
        :param restore_end_time: Timestamp when restore was completed in epoch millisecond format:
            int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  restore_start_time: :class:`long` or ``None``
        :param restore_start_time: Timestamp when restore was started in epoch millisecond format:
            int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  status: :class:`GlobalRestoreStatus` or ``None``
        :param status: 
        :type  step: :class:`RestoreStep` or ``None``
        :param step: 
        :type  total_steps: :class:`long` or ``None``
        :param total_steps: Total number of steps in the entire restore process format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.backup_timestamp = backup_timestamp
        self.endpoints = endpoints
        self.id = id
        self.instructions = instructions
        self.restore_end_time = restore_end_time
        self.restore_start_time = restore_start_time
        self.status = status
        self.step = step
        self.total_steps = total_steps
        VapiStruct.__init__(self)


ClusterRestoreStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_restore_status', {
        'backup_timestamp': type.OptionalType(type.IntegerType()),
        'endpoints': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        'id': type.OptionalType(type.StringType()),
        'instructions': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'InstructionInfo'))),
        'restore_end_time': type.OptionalType(type.IntegerType()),
        'restore_start_time': type.OptionalType(type.IntegerType()),
        'status': type.OptionalType(type.ReferenceType(__name__, 'GlobalRestoreStatus')),
        'step': type.OptionalType(type.ReferenceType(__name__, 'RestoreStep')),
        'total_steps': type.OptionalType(type.IntegerType()),
    },
    ClusterRestoreStatus,
    False,
    None))



class ClusterRoleConfig(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_MANAGEMENTCLUSTERROLECONFIG = "ManagementClusterRoleConfig"
    """


    """
    TYPE_CONTROLLERCLUSTERROLECONFIG = "ControllerClusterRoleConfig"
    """


    """



    _canonical_to_pep_names = {
                            'type': 'type',
                            }

    def __init__(self,
                 type=None,
                ):
        """
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ClusterRoleConfig.TYPE_MANAGEMENTCLUSTERROLECONFIG`
            * :attr:`ClusterRoleConfig.TYPE_CONTROLLERCLUSTERROLECONFIG`
            
             Type of this role configuration
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.type = type
        VapiStruct.__init__(self)


ClusterRoleConfig._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_role_config', {
        'type': type.OptionalType(type.StringType()),
    },
    ClusterRoleConfig,
    False,
    None))



class ClusterStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'cluster_id': 'cluster_id',
                            'control_cluster_status': 'control_cluster_status',
                            'detailed_cluster_status': 'detailed_cluster_status',
                            'mgmt_cluster_status': 'mgmt_cluster_status',
                            }

    def __init__(self,
                 cluster_id=None,
                 control_cluster_status=None,
                 detailed_cluster_status=None,
                 mgmt_cluster_status=None,
                ):
        """
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: Unique identifier of this cluster
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  control_cluster_status: :class:`ControllerClusterStatus` or ``None``
        :param control_cluster_status: The current status of the control cluster
        :type  detailed_cluster_status: :class:`AllClusterGroupStatus` or ``None``
        :param detailed_cluster_status: Status of all the cluster groups
        :type  mgmt_cluster_status: :class:`ManagementClusterStatus` or ``None``
        :param mgmt_cluster_status: The current status of the management cluster
        """
        self.cluster_id = cluster_id
        self.control_cluster_status = control_cluster_status
        self.detailed_cluster_status = detailed_cluster_status
        self.mgmt_cluster_status = mgmt_cluster_status
        VapiStruct.__init__(self)


ClusterStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_status', {
        'cluster_id': type.OptionalType(type.StringType()),
        'control_cluster_status': type.OptionalType(type.ReferenceType(__name__, 'ControllerClusterStatus')),
        'detailed_cluster_status': type.OptionalType(type.ReferenceType(__name__, 'AllClusterGroupStatus')),
        'mgmt_cluster_status': type.OptionalType(type.ReferenceType(__name__, 'ManagementClusterStatus')),
    },
    ClusterStatus,
    False,
    None))



class ClusterVirtualIpProperties(VapiStruct):
    """
    Cluster virtual IP properties

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'ip_address': 'ip_address',
                            }

    def __init__(self,
                 ip_address=None,
                ):
        """
        :type  ip_address: :class:`str` or ``None``
        :param ip_address: Virtual IP address, 0.0.0.0 if not configured
        """
        self.ip_address = ip_address
        VapiStruct.__init__(self)


ClusterVirtualIpProperties._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_virtual_ip_properties', {
        'ip_address': type.OptionalType(type.StringType()),
    },
    ClusterVirtualIpProperties,
    False,
    None))



class ClusteringConfig(VapiStruct):
    """
    Configuration for automatically joining a cluster node to the cluster after
    it is deployed. ClusteringConfig is required if any of the deployment nodes
    has CONTROLLER role.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ClusteringConfig"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    CLUSTERING_TYPE_CONTROLCLUSTERINGCONFIG = "ControlClusteringConfig"
    """


    """



    _canonical_to_pep_names = {
                            'clustering_type': 'clustering_type',
                            }

    def __init__(self,
                 clustering_type='ClusteringConfig',
                ):
        """
        :type  clustering_type: :class:`str`
        :param clustering_type: Possible values are: 
            
            * :attr:`ClusteringConfig.CLUSTERING_TYPE_CONTROLCLUSTERINGCONFIG`
            
             Specifies the type of clustering config to be used.
        """
        self._clustering_type = clustering_type
        VapiStruct.__init__(self)

    @property
    def clustering_type(self):
        """
        Return the discriminator value
        """
        return self._clustering_type

ClusteringConfig._set_binding_type(type.StructType(
    'com.vmware.nsx.model.clustering_config', {
        'clustering_type': type.StringType(),
    },
    ClusteringConfig,
    False,
    None))



class ClusteringInfo(VapiStruct):
    """
    Clustering parameters for the controller cluster

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'join_to_existing_cluster': 'join_to_existing_cluster',
                            'shared_secret': 'shared_secret',
                            }

    def __init__(self,
                 join_to_existing_cluster=None,
                 shared_secret=None,
                ):
        """
        :type  join_to_existing_cluster: :class:`bool` or ``None``
        :param join_to_existing_cluster: Property to indicate if the node must join an existing cluster.
        :type  shared_secret: :class:`str` or ``None``
        :param shared_secret: Shared secret of the cluster.
        """
        self.join_to_existing_cluster = join_to_existing_cluster
        self.shared_secret = shared_secret
        VapiStruct.__init__(self)


ClusteringInfo._set_binding_type(type.StructType(
    'com.vmware.nsx.model.clustering_info', {
        'join_to_existing_cluster': type.OptionalType(type.BooleanType()),
        'shared_secret': type.OptionalType(type.StringType()),
    },
    ClusteringInfo,
    False,
    None))



class ClustersAggregateInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'cluster_status': 'cluster_status',
                            'controller_cluster': 'controller_cluster',
                            'management_cluster': 'management_cluster',
                            }

    def __init__(self,
                 cluster_status=None,
                 controller_cluster=None,
                 management_cluster=None,
                ):
        """
        :type  cluster_status: :class:`AllClusterGroupStatus` or ``None``
        :param cluster_status: Status of all the cluster groups
        :type  controller_cluster: :class:`list` of :class:`ControllerNodeAggregateInfo` or ``None``
        :param controller_cluster: Array of Controller Nodes
        :type  management_cluster: :class:`list` of :class:`ManagementNodeAggregateInfo` or ``None``
        :param management_cluster: Array of Management Nodes
        """
        self.cluster_status = cluster_status
        self.controller_cluster = controller_cluster
        self.management_cluster = management_cluster
        VapiStruct.__init__(self)


ClustersAggregateInfo._set_binding_type(type.StructType(
    'com.vmware.nsx.model.clusters_aggregate_info', {
        'cluster_status': type.OptionalType(type.ReferenceType(__name__, 'AllClusterGroupStatus')),
        'controller_cluster': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ControllerNodeAggregateInfo'))),
        'management_cluster': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ManagementNodeAggregateInfo'))),
    },
    ClustersAggregateInfo,
    False,
    None))



class ColumnItem(VapiStruct):
    """
    Represents a column of the Grid

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_STRING = "String"
    """


    """
    TYPE_NUMBER = "Number"
    """


    """
    TYPE_DATE = "Date"
    """


    """



    _canonical_to_pep_names = {
                            'column_identifier': 'column_identifier',
                            'drilldown_id': 'drilldown_id',
                            'field': 'field',
                            'hidden': 'hidden',
                            'label': 'label',
                            'navigation': 'navigation',
                            'render_configuration': 'render_configuration',
                            'sort_ascending': 'sort_ascending',
                            'sort_key': 'sort_key',
                            'tooltip': 'tooltip',
                            'type': 'type',
                            }

    def __init__(self,
                 column_identifier=None,
                 drilldown_id=None,
                 field=None,
                 hidden=None,
                 label=None,
                 navigation=None,
                 render_configuration=None,
                 sort_ascending=None,
                 sort_key=None,
                 tooltip=None,
                 type=None,
                ):
        """
        :type  column_identifier: :class:`str` or ``None``
        :param column_identifier: Identifies the column and used for fetching content upon an user
            click or drilldown. If column identifier is not provided, the
            column's data will not participate in searches and drilldowns.
        :type  drilldown_id: :class:`str` or ``None``
        :param drilldown_id: Id of drilldown widget, if any. Id should be a valid id of an
            existing widget.
        :type  field: :class:`str` or ``None``
        :param field: Field from which values of the column will be derived.
        :type  hidden: :class:`bool` or ``None``
        :param hidden: If set to true, hides the column
        :type  label: :class:`Label` or ``None``
        :param label: Label of the column.
        :type  navigation: :class:`str` or ``None``
        :param navigation: Hyperlink of the specified UI page that provides details. If
            drilldown_id is provided, then navigation cannot be used.
        :type  render_configuration: :class:`list` of :class:`RenderConfiguration` or ``None``
        :param render_configuration: Render configuration to be applied, if any.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, the value of the column are sorted in ascending order.
            Otherwise, in descending order.
        :type  sort_key: :class:`str` or ``None``
        :param sort_key: Sorting on column is based on the sort_key. sort_key represents the
            field in the output data on which sort is requested.
        :type  tooltip: :class:`list` of :class:`Tooltip` or ``None``
        :param tooltip: Multi-line text to be shown on tooltip while hovering over a cell
            in the grid.
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ColumnItem.TYPE_STRING`
            * :attr:`ColumnItem.TYPE_NUMBER`
            * :attr:`ColumnItem.TYPE_DATE`
            
             Data type of the field.
        """
        self.column_identifier = column_identifier
        self.drilldown_id = drilldown_id
        self.field = field
        self.hidden = hidden
        self.label = label
        self.navigation = navigation
        self.render_configuration = render_configuration
        self.sort_ascending = sort_ascending
        self.sort_key = sort_key
        self.tooltip = tooltip
        self.type = type
        VapiStruct.__init__(self)


ColumnItem._set_binding_type(type.StructType(
    'com.vmware.nsx.model.column_item', {
        'column_identifier': type.OptionalType(type.StringType()),
        'drilldown_id': type.OptionalType(type.StringType()),
        'field': type.OptionalType(type.StringType()),
        'hidden': type.OptionalType(type.BooleanType()),
        'label': type.OptionalType(type.ReferenceType(__name__, 'Label')),
        'navigation': type.OptionalType(type.StringType()),
        'render_configuration': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'RenderConfiguration'))),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_key': type.OptionalType(type.StringType()),
        'tooltip': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tooltip'))),
        'type': type.OptionalType(type.StringType()),
    },
    ColumnItem,
    False,
    None))



class CommunityMatchExpression(VapiStruct):
    """
    Community match expression

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    OPERATOR_AND = "AND"
    """


    """



    _canonical_to_pep_names = {
                            'expression': 'expression',
                            'operator': 'operator',
                            }

    def __init__(self,
                 expression=None,
                 operator=None,
                ):
        """
        :type  expression: :class:`list` of :class:`CommunityMatchOperation` or ``None``
        :param expression: Array of community match operations
        :type  operator: :class:`str` or ``None``
        :param operator: Possible values are: 
            
            * :attr:`CommunityMatchExpression.OPERATOR_AND`
            
            Operator for evaluating community match expressions. AND logical
            AND operator
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.expression = expression
        self.operator = operator
        VapiStruct.__init__(self)


CommunityMatchExpression._set_binding_type(type.StructType(
    'com.vmware.nsx.model.community_match_expression', {
        'expression': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CommunityMatchOperation'))),
        'operator': type.OptionalType(type.StringType()),
    },
    CommunityMatchExpression,
    False,
    None))



class CommunityMatchOperation(VapiStruct):
    """
    Community match operation

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MATCH_OPERATOR_ANY = "MATCH_ANY"
    """


    """
    MATCH_OPERATOR_ALL = "MATCH_ALL"
    """


    """
    MATCH_OPERATOR_EXACT = "MATCH_EXACT"
    """


    """
    MATCH_OPERATOR_NONE = "MATCH_NONE"
    """


    """
    MATCH_OPERATOR_REGEX = "MATCH_REGEX"
    """


    """
    MATCH_OPERATOR_LARGE_COMMUNITY_REGEX = "MATCH_LARGE_COMMUNITY_REGEX"
    """


    """



    _canonical_to_pep_names = {
                            'community_list_id': 'community_list_id',
                            'match_operator': 'match_operator',
                            'regular_expression': 'regular_expression',
                            }

    def __init__(self,
                 community_list_id=None,
                 match_operator=None,
                 regular_expression=None,
                ):
        """
        :type  community_list_id: :class:`str` or ``None``
        :param community_list_id: ID of BGP community list. This value is not required when
            match_operator is MATCH_REGEX otherwise required.
        :type  match_operator: :class:`str` or ``None``
        :param match_operator: Possible values are: 
            
            * :attr:`CommunityMatchOperation.MATCH_OPERATOR_ANY`
            * :attr:`CommunityMatchOperation.MATCH_OPERATOR_ALL`
            * :attr:`CommunityMatchOperation.MATCH_OPERATOR_EXACT`
            * :attr:`CommunityMatchOperation.MATCH_OPERATOR_NONE`
            * :attr:`CommunityMatchOperation.MATCH_OPERATOR_REGEX`
            *
              :attr:`CommunityMatchOperation.MATCH_OPERATOR_LARGE_COMMUNITY_REGEX`
            
            Match operator for communities from provided community list id.
            MATCH_ANY will match any community MATCH_ALL will match all
            communities MATCH_EXACT will do exact match on community MATCH_NONE
            [operator not supported] will not match any community MATCH_REGEX
            will match normal communities by evaluating regular expression
            MATCH_LARGE_COMMUNITY_REGEX will match large communities by
            evaluating regular expression
        :type  regular_expression: :class:`str` or ``None``
        :param regular_expression: Regular expression to match BGP communities. If match_operator is
            MATCH_REGEX then this value must be specified.
        """
        self.community_list_id = community_list_id
        self.match_operator = match_operator
        self.regular_expression = regular_expression
        VapiStruct.__init__(self)


CommunityMatchOperation._set_binding_type(type.StructType(
    'com.vmware.nsx.model.community_match_operation', {
        'community_list_id': type.OptionalType(type.StringType()),
        'match_operator': type.OptionalType(type.StringType()),
        'regular_expression': type.OptionalType(type.StringType()),
    },
    CommunityMatchOperation,
    False,
    None))



class ComponentMigrationStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_SUCCESS = "SUCCESS"
    """


    """
    STATUS_FAILED = "FAILED"
    """


    """
    STATUS_IN_PROGRESS = "IN_PROGRESS"
    """


    """
    STATUS_NOT_STARTED = "NOT_STARTED"
    """


    """
    STATUS_PAUSED = "PAUSED"
    """


    """



    _canonical_to_pep_names = {
                            'can_skip': 'can_skip',
                            'component_type': 'component_type',
                            'details': 'details',
                            'percent_complete': 'percent_complete',
                            'status': 'status',
                            }

    def __init__(self,
                 can_skip=None,
                 component_type=None,
                 details=None,
                 percent_complete=None,
                 status=None,
                ):
        """
        :type  can_skip: :class:`bool` or ``None``
        :param can_skip: Can the migration of the remaining units in this component be
            skipped
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  component_type: :class:`str` or ``None``
        :param component_type: Component type for the migration status
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  details: :class:`str` or ``None``
        :param details: Details about the migration status
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  percent_complete: :class:`float` or ``None``
        :param percent_complete: Indicator of migration progress in percentage
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ComponentMigrationStatus.STATUS_SUCCESS`
            * :attr:`ComponentMigrationStatus.STATUS_FAILED`
            * :attr:`ComponentMigrationStatus.STATUS_IN_PROGRESS`
            * :attr:`ComponentMigrationStatus.STATUS_NOT_STARTED`
            * :attr:`ComponentMigrationStatus.STATUS_PAUSED`
            
             Migration status of component
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.can_skip = can_skip
        self.component_type = component_type
        self.details = details
        self.percent_complete = percent_complete
        self.status = status
        VapiStruct.__init__(self)


ComponentMigrationStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.component_migration_status', {
        'can_skip': type.OptionalType(type.BooleanType()),
        'component_type': type.OptionalType(type.StringType()),
        'details': type.OptionalType(type.StringType()),
        'percent_complete': type.OptionalType(type.DoubleType()),
        'status': type.OptionalType(type.StringType()),
    },
    ComponentMigrationStatus,
    False,
    None))



class ComponentTargetVersion(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'component_type': 'component_type',
                            'target_version': 'target_version',
                            }

    def __init__(self,
                 component_type=None,
                 target_version=None,
                ):
        """
        :type  component_type: :class:`str` or ``None``
        :param component_type: 
        :type  target_version: :class:`str` or ``None``
        :param target_version: 
        """
        self.component_type = component_type
        self.target_version = target_version
        VapiStruct.__init__(self)


ComponentTargetVersion._set_binding_type(type.StructType(
    'com.vmware.nsx.model.component_target_version', {
        'component_type': type.OptionalType(type.StringType()),
        'target_version': type.OptionalType(type.StringType()),
    },
    ComponentTargetVersion,
    False,
    None))



class ComponentUpgradeChecksInfo(VapiStruct):
    """
    Meta-data of pre/post-upgrade checks for a component

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'component_type': 'component_type',
                            'post_upgrade_checks_info': 'post_upgrade_checks_info',
                            'pre_upgrade_checks_info': 'pre_upgrade_checks_info',
                            }

    def __init__(self,
                 component_type=None,
                 post_upgrade_checks_info=None,
                 pre_upgrade_checks_info=None,
                ):
        """
        :type  component_type: :class:`str` or ``None``
        :param component_type: Component type of the pre/post-upgrade checks
        :type  post_upgrade_checks_info: :class:`list` of :class:`UpgradeCheckInfo` or ``None``
        :param post_upgrade_checks_info: Collection of post-upgrade checks
        :type  pre_upgrade_checks_info: :class:`list` of :class:`UpgradeCheckInfo` or ``None``
        :param pre_upgrade_checks_info: Collection of pre-upgrade checks
        """
        self.component_type = component_type
        self.post_upgrade_checks_info = post_upgrade_checks_info
        self.pre_upgrade_checks_info = pre_upgrade_checks_info
        VapiStruct.__init__(self)


ComponentUpgradeChecksInfo._set_binding_type(type.StructType(
    'com.vmware.nsx.model.component_upgrade_checks_info', {
        'component_type': type.OptionalType(type.StringType()),
        'post_upgrade_checks_info': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'UpgradeCheckInfo'))),
        'pre_upgrade_checks_info': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'UpgradeCheckInfo'))),
    },
    ComponentUpgradeChecksInfo,
    False,
    None))



class ComponentUpgradeChecksInfoListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ComponentUpgradeChecksInfo` or ``None``
        :param results: Collection of info of pre/post-upgrade checks for components
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ComponentUpgradeChecksInfoListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.component_upgrade_checks_info_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ComponentUpgradeChecksInfo'))),
    },
    ComponentUpgradeChecksInfoListResult,
    False,
    None))



class ComponentUpgradeStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_SUCCESS = "SUCCESS"
    """


    """
    STATUS_FAILED = "FAILED"
    """


    """
    STATUS_IN_PROGRESS = "IN_PROGRESS"
    """


    """
    STATUS_NOT_STARTED = "NOT_STARTED"
    """


    """
    STATUS_PAUSING = "PAUSING"
    """


    """
    STATUS_PAUSED = "PAUSED"
    """


    """



    _canonical_to_pep_names = {
                            'can_skip': 'can_skip',
                            'component_type': 'component_type',
                            'current_version_node_summary': 'current_version_node_summary',
                            'details': 'details',
                            'node_count_at_target_version': 'node_count_at_target_version',
                            'percent_complete': 'percent_complete',
                            'pre_upgrade_status': 'pre_upgrade_status',
                            'status': 'status',
                            'target_component_version': 'target_component_version',
                            }

    def __init__(self,
                 can_skip=None,
                 component_type=None,
                 current_version_node_summary=None,
                 details=None,
                 node_count_at_target_version=None,
                 percent_complete=None,
                 pre_upgrade_status=None,
                 status=None,
                 target_component_version=None,
                ):
        """
        :type  can_skip: :class:`bool` or ``None``
        :param can_skip: Can the upgrade of the remaining units in this component be skipped
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  component_type: :class:`str` or ``None``
        :param component_type: Component type for the upgrade status
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  current_version_node_summary: :class:`NodeSummaryList` or ``None``
        :param current_version_node_summary: Mapping of current versions of nodes and counts of nodes at the
            respective versions.
        :type  details: :class:`str` or ``None``
        :param details: Details about the upgrade status
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_count_at_target_version: :class:`long` or ``None``
        :param node_count_at_target_version: Number of nodes of the type and at the component version format:
            int32
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  percent_complete: :class:`float` or ``None``
        :param percent_complete: Indicator of upgrade progress in percentage
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  pre_upgrade_status: :class:`UpgradeChecksExecutionStatus` or ``None``
        :param pre_upgrade_status: Pre-upgrade status of the component-type
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ComponentUpgradeStatus.STATUS_SUCCESS`
            * :attr:`ComponentUpgradeStatus.STATUS_FAILED`
            * :attr:`ComponentUpgradeStatus.STATUS_IN_PROGRESS`
            * :attr:`ComponentUpgradeStatus.STATUS_NOT_STARTED`
            * :attr:`ComponentUpgradeStatus.STATUS_PAUSING`
            * :attr:`ComponentUpgradeStatus.STATUS_PAUSED`
            
             Upgrade status of component
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  target_component_version: :class:`str` or ``None``
        :param target_component_version: Target component version
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.can_skip = can_skip
        self.component_type = component_type
        self.current_version_node_summary = current_version_node_summary
        self.details = details
        self.node_count_at_target_version = node_count_at_target_version
        self.percent_complete = percent_complete
        self.pre_upgrade_status = pre_upgrade_status
        self.status = status
        self.target_component_version = target_component_version
        VapiStruct.__init__(self)


ComponentUpgradeStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.component_upgrade_status', {
        'can_skip': type.OptionalType(type.BooleanType()),
        'component_type': type.OptionalType(type.StringType()),
        'current_version_node_summary': type.OptionalType(type.ReferenceType(__name__, 'NodeSummaryList')),
        'details': type.OptionalType(type.StringType()),
        'node_count_at_target_version': type.OptionalType(type.IntegerType()),
        'percent_complete': type.OptionalType(type.DoubleType()),
        'pre_upgrade_status': type.OptionalType(type.ReferenceType(__name__, 'UpgradeChecksExecutionStatus')),
        'status': type.OptionalType(type.StringType()),
        'target_component_version': type.OptionalType(type.StringType()),
    },
    ComponentUpgradeStatus,
    False,
    None))



class ComputeCollection(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'cm_local_id': 'cm_local_id',
                            'external_id': 'external_id',
                            'origin_id': 'origin_id',
                            'origin_properties': 'origin_properties',
                            'origin_type': 'origin_type',
                            'owner_id': 'owner_id',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_last_sync_time': 'last_sync_time',
                            'description': 'description',
                            'display_name': 'display_name',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            }

    def __init__(self,
                 cm_local_id=None,
                 external_id=None,
                 origin_id=None,
                 origin_properties=None,
                 origin_type=None,
                 owner_id=None,
                 links=None,
                 schema=None,
                 self_=None,
                 last_sync_time=None,
                 description=None,
                 display_name=None,
                 resource_type=None,
                 tags=None,
                ):
        """
        :type  cm_local_id: :class:`str` or ``None``
        :param cm_local_id: Local Id of the compute collection in the Compute Manager
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  external_id: :class:`str` or ``None``
        :param external_id: External ID of the ComputeCollection in the source Compute manager,
            e.g. mo-ref in VC
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  origin_id: :class:`str` or ``None``
        :param origin_id: Id of the compute manager from where this Compute Collection was
            discovered
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  origin_properties: :class:`list` of :class:`KeyValuePair` or ``None``
        :param origin_properties: Key-Value map of additional specific properties of compute
            collection in the Compute Manager
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  origin_type: :class:`str` or ``None``
        :param origin_type: ComputeCollection type like VC_Cluster. Here the Compute Manager
            type prefix would help in differentiating similar named Compute
            Collection types from different Compute Managers
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  owner_id: :class:`str` or ``None``
        :param owner_id: Id of the owner of compute collection in the Compute Manager
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  last_sync_time: :class:`long` or ``None``
        :param last_sync_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  resource_type: :class:`str`
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        """
        self.cm_local_id = cm_local_id
        self.external_id = external_id
        self.origin_id = origin_id
        self.origin_properties = origin_properties
        self.origin_type = origin_type
        self.owner_id = owner_id
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.last_sync_time = last_sync_time
        self.description = description
        self.display_name = display_name
        self._resource_type = resource_type
        self.tags = tags
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ComputeCollection._set_binding_type(type.StructType(
    'com.vmware.nsx.model.compute_collection', {
        'cm_local_id': type.OptionalType(type.StringType()),
        'external_id': type.OptionalType(type.StringType()),
        'origin_id': type.OptionalType(type.StringType()),
        'origin_properties': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'KeyValuePair'))),
        'origin_type': type.OptionalType(type.StringType()),
        'owner_id': type.OptionalType(type.StringType()),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_last_sync_time': type.OptionalType(type.IntegerType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
    },
    ComputeCollection,
    False,
    None))



class ComputeCollectionFabricTemplate(VapiStruct):
    """
    Compute collection fabric template

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'auto_install_nsx': 'auto_install_nsx',
                            'compute_collection_id': 'compute_collection_id',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 auto_install_nsx=None,
                 compute_collection_id=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  auto_install_nsx: :class:`bool` or ``None``
        :param auto_install_nsx: Indicates whether NSX components should be automcatically
            installed. When 'true' NSX components will be automatically
            installed on the new host added to compute collection.
        :type  compute_collection_id: :class:`str` or ``None``
        :param compute_collection_id: Associated compute collection id
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.auto_install_nsx = auto_install_nsx
        self.compute_collection_id = compute_collection_id
        VapiStruct.__init__(self)


ComputeCollectionFabricTemplate._set_binding_type(type.StructType(
    'com.vmware.nsx.model.compute_collection_fabric_template', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'auto_install_nsx': type.OptionalType(type.BooleanType()),
        'compute_collection_id': type.OptionalType(type.StringType()),
    },
    ComputeCollectionFabricTemplate,
    False,
    None))



class ComputeCollectionFabricTemplateListResult(VapiStruct):
    """
    List of compute collection fabric template

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ComputeCollectionFabricTemplate` or ``None``
        :param results: List of compute collection fabric template
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ComputeCollectionFabricTemplateListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.compute_collection_fabric_template_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ComputeCollectionFabricTemplate'))),
    },
    ComputeCollectionFabricTemplateListResult,
    False,
    None))



class ComputeCollectionListResult(VapiStruct):
    """
    Compute Collection list result

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ComputeCollection` or ``None``
        :param results: Compute Collection list results
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ComputeCollectionListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.compute_collection_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ComputeCollection'))),
    },
    ComputeCollectionListResult,
    False,
    None))



class ComputeCollectionNetworkInterfacesListResult(VapiStruct):
    """
    List of network interfaces for all discovered nodes in compute collection

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`DiscoveredNodeNetworkInterfaces` or ``None``
        :param results: List of discovered node with network interfaces
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ComputeCollectionNetworkInterfacesListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.compute_collection_network_interfaces_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'DiscoveredNodeNetworkInterfaces'))),
    },
    ComputeCollectionNetworkInterfacesListResult,
    False,
    None))



class ComputeManager(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'credential': 'credential',
                            'origin_properties': 'origin_properties',
                            'origin_type': 'origin_type',
                            'reverse_proxy_https_port': 'reverse_proxy_https_port',
                            'server': 'server',
                            'set_as_oidc_provider': 'set_as_oidc_provider',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 credential=None,
                 origin_properties=None,
                 origin_type=None,
                 reverse_proxy_https_port=None,
                 server=None,
                 set_as_oidc_provider=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  credential: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param credential: Login credentials for the compute manager
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`LoginCredential`. When methods return a value of this class
            as a return value, the attribute will contain all the attributes
            defined in :class:`LoginCredential`.
        :type  origin_properties: :class:`list` of :class:`KeyValuePair` or ``None``
        :param origin_properties: Key-Value map of additional specific properties of compute manager
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  origin_type: :class:`str` or ``None``
        :param origin_type: Compute manager type like vCenter
        :type  reverse_proxy_https_port: :class:`long` or ``None``
        :param reverse_proxy_https_port: Specifies https port of the reverse proxy to connect to compute
            manager. For e.g. In case of VC, this port can be retrieved from
            this config file /etc/vmware-rhttpproxy/config.xml. format: int64
        :type  server: :class:`str` or ``None``
        :param server: IP address or hostname of compute manager format: hostname-or-ip
        :type  set_as_oidc_provider: :class:`bool` or ``None``
        :param set_as_oidc_provider: If the compute manager is VC and need to set set as OIDC provider
            for NSX then this flag should be set as true. This is specific to
            wcp feature, should be enabled when this feature is being used.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.credential = credential
        self.origin_properties = origin_properties
        self.origin_type = origin_type
        self.reverse_proxy_https_port = reverse_proxy_https_port
        self.server = server
        self.set_as_oidc_provider = set_as_oidc_provider
        VapiStruct.__init__(self)


ComputeManager._set_binding_type(type.StructType(
    'com.vmware.nsx.model.compute_manager', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'credential': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'LoginCredential')])),
        'origin_properties': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'KeyValuePair'))),
        'origin_type': type.OptionalType(type.StringType()),
        'reverse_proxy_https_port': type.OptionalType(type.IntegerType()),
        'server': type.OptionalType(type.StringType()),
        'set_as_oidc_provider': type.OptionalType(type.BooleanType()),
    },
    ComputeManager,
    False,
    None))



class ComputeManagerListResult(VapiStruct):
    """
    List of compute managers

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ComputeManager` or ``None``
        :param results: List of compute managers
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ComputeManagerListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.compute_manager_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ComputeManager'))),
    },
    ComputeManagerListResult,
    False,
    None))



class ComputeManagerStatus(VapiStruct):
    """
    Runtime status information of the compute manager

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    CONNECTION_STATUS_UP = "UP"
    """


    """
    CONNECTION_STATUS_DOWN = "DOWN"
    """


    """
    CONNECTION_STATUS_CONNECTING = "CONNECTING"
    """


    """
    REGISTRATION_STATUS_REGISTERED = "REGISTERED"
    """


    """
    REGISTRATION_STATUS_UNREGISTERED = "UNREGISTERED"
    """


    """
    REGISTRATION_STATUS_REGISTERING = "REGISTERING"
    """


    """



    _canonical_to_pep_names = {
                            'connection_errors': 'connection_errors',
                            'connection_status': 'connection_status',
                            'connection_status_details': 'connection_status_details',
                            'last_sync_time': 'last_sync_time',
                            'oidc_end_point_id': 'oidc_end_point_id',
                            'registration_errors': 'registration_errors',
                            'registration_status': 'registration_status',
                            'version': 'version',
                            }

    def __init__(self,
                 connection_errors=None,
                 connection_status=None,
                 connection_status_details=None,
                 last_sync_time=None,
                 oidc_end_point_id=None,
                 registration_errors=None,
                 registration_status=None,
                 version=None,
                ):
        """
        :type  connection_errors: :class:`list` of :class:`ErrorInfo` or ``None``
        :param connection_errors: Errors when connecting with compute manager
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  connection_status: :class:`str` or ``None``
        :param connection_status: Possible values are: 
            
            * :attr:`ComputeManagerStatus.CONNECTION_STATUS_UP`
            * :attr:`ComputeManagerStatus.CONNECTION_STATUS_DOWN`
            * :attr:`ComputeManagerStatus.CONNECTION_STATUS_CONNECTING`
            
             Status of connection with the compute manager
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  connection_status_details: :class:`str` or ``None``
        :param connection_status_details: Details about connection status
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_sync_time: :class:`long` or ``None``
        :param last_sync_time: Timestamp of the last successful update of Inventory, in epoch
            milliseconds. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  oidc_end_point_id: :class:`str` or ``None``
        :param oidc_end_point_id: If Compute manager is trusted as authorization server, then this Id
            will be Id of corresponding oidc end point.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  registration_errors: :class:`list` of :class:`ErrorInfo` or ``None``
        :param registration_errors: Errors when registering with compute manager
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  registration_status: :class:`str` or ``None``
        :param registration_status: Possible values are: 
            
            * :attr:`ComputeManagerStatus.REGISTRATION_STATUS_REGISTERED`
            * :attr:`ComputeManagerStatus.REGISTRATION_STATUS_UNREGISTERED`
            * :attr:`ComputeManagerStatus.REGISTRATION_STATUS_REGISTERING`
            
             Registration status of compute manager
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  version: :class:`str` or ``None``
        :param version: Version of the compute manager
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.connection_errors = connection_errors
        self.connection_status = connection_status
        self.connection_status_details = connection_status_details
        self.last_sync_time = last_sync_time
        self.oidc_end_point_id = oidc_end_point_id
        self.registration_errors = registration_errors
        self.registration_status = registration_status
        self.version = version
        VapiStruct.__init__(self)


ComputeManagerStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.compute_manager_status', {
        'connection_errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ErrorInfo'))),
        'connection_status': type.OptionalType(type.StringType()),
        'connection_status_details': type.OptionalType(type.StringType()),
        'last_sync_time': type.OptionalType(type.IntegerType()),
        'oidc_end_point_id': type.OptionalType(type.StringType()),
        'registration_errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ErrorInfo'))),
        'registration_status': type.OptionalType(type.StringType()),
        'version': type.OptionalType(type.StringType()),
    },
    ComputeManagerStatus,
    False,
    None))



class ComputeManagerTopology(VapiStruct):
    """
    Details where NVDS will be migrated to

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'compute_manager_id': 'compute_manager_id',
                            'dvswitch': 'dvswitch',
                            }

    def __init__(self,
                 compute_manager_id=None,
                 dvswitch=None,
                ):
        """
        :type  compute_manager_id: :class:`str` or ``None``
        :param compute_manager_id: Identifier of vcenter where VDS will be created
        :type  dvswitch: :class:`list` of :class:`VdsTopology` or ``None``
        :param dvswitch: Datacenter, VDS mapping
        """
        self.compute_manager_id = compute_manager_id
        self.dvswitch = dvswitch
        VapiStruct.__init__(self)


ComputeManagerTopology._set_binding_type(type.StructType(
    'com.vmware.nsx.model.compute_manager_topology', {
        'compute_manager_id': type.OptionalType(type.StringType()),
        'dvswitch': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'VdsTopology'))),
    },
    ComputeManagerTopology,
    False,
    None))



class ConditionalForwarderZone(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'source_ip': 'source_ip',
                            'upstream_servers': 'upstream_servers',
                            'domain_names': 'domain_names',
                            }

    def __init__(self,
                 source_ip=None,
                 upstream_servers=None,
                 domain_names=None,
                ):
        """
        :type  source_ip: :class:`str` or ``None``
        :param source_ip: The source ip used by the fowarder of the zone. If no source ip
            specified, the ip address of listener of the DNS forwarder will be
            used. format: ipv4
        :type  upstream_servers: :class:`list` of :class:`str` or ``None``
        :param upstream_servers: Ip address of the upstream DNS servers the DNS forwarder accesses.
            format: ipv4
        :type  domain_names: :class:`list` of :class:`str` or ``None``
        :param domain_names: A forwarder domain name should be a valid FQDN. If reverse lookup
            is needed for this zone, reverse lookup domain name like
            X.in-addr.arpa can be defined. Here the X represents a subnet.
        """
        self.source_ip = source_ip
        self.upstream_servers = upstream_servers
        self.domain_names = domain_names
        VapiStruct.__init__(self)


ConditionalForwarderZone._set_binding_type(type.StructType(
    'com.vmware.nsx.model.conditional_forwarder_zone', {
        'source_ip': type.OptionalType(type.StringType()),
        'upstream_servers': type.OptionalType(type.ListType(type.StringType())),
        'domain_names': type.OptionalType(type.ListType(type.StringType())),
    },
    ConditionalForwarderZone,
    False,
    None))



class ConfigurationState(VapiStruct):
    """
    Describes status of configuration of an entity

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATE_PENDING = "pending"
    """


    """
    STATE_IN_PROGRESS = "in_progress"
    """


    """
    STATE_SUCCESS = "success"
    """


    """
    STATE_FAILED = "failed"
    """


    """
    STATE_PARTIAL_SUCCESS = "partial_success"
    """


    """
    STATE_ORPHANED = "orphaned"
    """


    """
    STATE_UNKNOWN = "unknown"
    """


    """
    STATE_ERROR = "error"
    """


    """
    STATE_IN_SYNC = "in_sync"
    """


    """
    STATE_NOT_AVAILABLE = "NOT_AVAILABLE"
    """


    """
    STATE_VM_DEPLOYMENT_QUEUED = "VM_DEPLOYMENT_QUEUED"
    """


    """
    STATE_VM_DEPLOYMENT_IN_PROGRESS = "VM_DEPLOYMENT_IN_PROGRESS"
    """


    """
    STATE_VM_DEPLOYMENT_FAILED = "VM_DEPLOYMENT_FAILED"
    """


    """
    STATE_VM_POWER_ON_IN_PROGRESS = "VM_POWER_ON_IN_PROGRESS"
    """


    """
    STATE_VM_POWER_ON_FAILED = "VM_POWER_ON_FAILED"
    """


    """
    STATE_REGISTRATION_PENDING = "REGISTRATION_PENDING"
    """


    """
    STATE_NODE_NOT_READY = "NODE_NOT_READY"
    """


    """
    STATE_NODE_READY = "NODE_READY"
    """


    """
    STATE_VM_POWER_OFF_IN_PROGRESS = "VM_POWER_OFF_IN_PROGRESS"
    """


    """
    STATE_VM_POWER_OFF_FAILED = "VM_POWER_OFF_FAILED"
    """


    """
    STATE_VM_UNDEPLOY_IN_PROGRESS = "VM_UNDEPLOY_IN_PROGRESS"
    """


    """
    STATE_VM_UNDEPLOY_FAILED = "VM_UNDEPLOY_FAILED"
    """


    """
    STATE_VM_UNDEPLOY_SUCCESSFUL = "VM_UNDEPLOY_SUCCESSFUL"
    """


    """
    STATE_EDGE_CONFIG_ERROR = "EDGE_CONFIG_ERROR"
    """


    """
    STATE_VM_DEPLOYMENT_RESTARTED = "VM_DEPLOYMENT_RESTARTED"
    """


    """
    STATE_REGISTRATION_FAILED = "REGISTRATION_FAILED"
    """


    """
    STATE_TRANSPORT_NODE_SYNC_PENDING = "TRANSPORT_NODE_SYNC_PENDING"
    """


    """
    STATE_TRANSPORT_NODE_CONFIGURATION_MISSING = "TRANSPORT_NODE_CONFIGURATION_MISSING"
    """


    """
    STATE_EDGE_HARDWARE_NOT_SUPPORTED = "EDGE_HARDWARE_NOT_SUPPORTED"
    """


    """
    STATE_MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED = "MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED"
    """


    """
    STATE_TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER = "TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER"
    """


    """
    STATE_TZ_ENDPOINTS_NOT_SPECIFIED = "TZ_ENDPOINTS_NOT_SPECIFIED"
    """


    """
    STATE_NO_PNIC_PREPARED_IN_EDGE = "NO_PNIC_PREPARED_IN_EDGE"
    """


    """
    STATE_APPLIANCE_INTERNAL_ERROR = "APPLIANCE_INTERNAL_ERROR"
    """


    """
    STATE_VTEP_DHCP_NOT_SUPPORTED = "VTEP_DHCP_NOT_SUPPORTED"
    """


    """
    STATE_UNSUPPORTED_HOST_SWITCH_PROFILE = "UNSUPPORTED_HOST_SWITCH_PROFILE"
    """


    """
    STATE_UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED = "UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED"
    """


    """
    STATE_HOSTSWITCH_PROFILE_NOT_FOUND = "HOSTSWITCH_PROFILE_NOT_FOUND"
    """


    """
    STATE_LLDP_SEND_ENABLED_NOT_SUPPORTED = "LLDP_SEND_ENABLED_NOT_SUPPORTED"
    """


    """
    STATE_UNSUPPORTED_NAMED_TEAMING_POLICY = "UNSUPPORTED_NAMED_TEAMING_POLICY"
    """


    """
    STATE_LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM = "LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM"
    """


    """
    STATE_LACP_NOT_SUPPORTED_FOR_EDGE_VM = "LACP_NOT_SUPPORTED_FOR_EDGE_VM"
    """


    """
    STATE_STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM = "STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM"
    """


    """
    STATE_MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE = "MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE"
    """


    """
    STATE_UNSUPPORTED_LACP_LB_ALGO_FOR_NODE = "UNSUPPORTED_LACP_LB_ALGO_FOR_NODE"
    """


    """
    STATE_EDGE_NODE_VERSION_NOT_SUPPORTED = "EDGE_NODE_VERSION_NOT_SUPPORTED"
    """


    """
    STATE_NO_PNIC_SPECIFIED_IN_TN = "NO_PNIC_SPECIFIED_IN_TN"
    """


    """
    STATE_INVALID_PNIC_DEVICE_NAME = "INVALID_PNIC_DEVICE_NAME"
    """


    """
    STATE_TRANSPORT_NODE_READY = "TRANSPORT_NODE_READY"
    """


    """
    STATE_VM_NETWORK_EDIT_PENDING = "VM_NETWORK_EDIT_PENDING"
    """


    """
    STATE_UNSUPPORTED_DEFAULT_TEAMING_POLICY = "UNSUPPORTED_DEFAULT_TEAMING_POLICY"
    """


    """
    STATE_MPA_DISCONNECTED = "MPA_DISCONNECTED"
    """


    """
    STATE_VM_RENAME_PENDING = "VM_RENAME_PENDING"
    """


    """
    STATE_VM_CONFIG_EDIT_PENDING = "VM_CONFIG_EDIT_PENDING"
    """


    """
    STATE_VM_NETWORK_EDIT_FAILED = "VM_NETWORK_EDIT_FAILED"
    """


    """
    STATE_VM_RENAME_FAILED = "VM_RENAME_FAILED"
    """


    """
    STATE_VM_CONFIG_EDIT_FAILED = "VM_CONFIG_EDIT_FAILED"
    """


    """
    STATE_VM_CONFIG_DISCREPANCY = "VM_CONFIG_DISCREPANCY"
    """


    """
    STATE_VM_NODE_REFRESH_FAILED = "VM_NODE_REFRESH_FAILED"
    """


    """
    STATE_VM_PLACEMENT_REFRESH_FAILED = "VM_PLACEMENT_REFRESH_FAILED"
    """


    """
    STATE_REGISTRATION_TIMEDOUT = "REGISTRATION_TIMEDOUT"
    """


    """



    _canonical_to_pep_names = {
                            'details': 'details',
                            'failure_code': 'failure_code',
                            'failure_message': 'failure_message',
                            'state': 'state',
                            }

    def __init__(self,
                 details=None,
                 failure_code=None,
                 failure_message=None,
                 state=None,
                ):
        """
        :type  details: :class:`list` of :class:`ConfigurationStateElement` or ``None``
        :param details: Array of configuration state of various sub systems
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  failure_code: :class:`long` or ``None``
        :param failure_code: Error code format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  failure_message: :class:`str` or ``None``
        :param failure_message: Error message in case of failure
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  state: :class:`str` or ``None``
        :param state: Possible values are: 
            
            * :attr:`ConfigurationState.STATE_PENDING`
            * :attr:`ConfigurationState.STATE_IN_PROGRESS`
            * :attr:`ConfigurationState.STATE_SUCCESS`
            * :attr:`ConfigurationState.STATE_FAILED`
            * :attr:`ConfigurationState.STATE_PARTIAL_SUCCESS`
            * :attr:`ConfigurationState.STATE_ORPHANED`
            * :attr:`ConfigurationState.STATE_UNKNOWN`
            * :attr:`ConfigurationState.STATE_ERROR`
            * :attr:`ConfigurationState.STATE_IN_SYNC`
            * :attr:`ConfigurationState.STATE_NOT_AVAILABLE`
            * :attr:`ConfigurationState.STATE_VM_DEPLOYMENT_QUEUED`
            * :attr:`ConfigurationState.STATE_VM_DEPLOYMENT_IN_PROGRESS`
            * :attr:`ConfigurationState.STATE_VM_DEPLOYMENT_FAILED`
            * :attr:`ConfigurationState.STATE_VM_POWER_ON_IN_PROGRESS`
            * :attr:`ConfigurationState.STATE_VM_POWER_ON_FAILED`
            * :attr:`ConfigurationState.STATE_REGISTRATION_PENDING`
            * :attr:`ConfigurationState.STATE_NODE_NOT_READY`
            * :attr:`ConfigurationState.STATE_NODE_READY`
            * :attr:`ConfigurationState.STATE_VM_POWER_OFF_IN_PROGRESS`
            * :attr:`ConfigurationState.STATE_VM_POWER_OFF_FAILED`
            * :attr:`ConfigurationState.STATE_VM_UNDEPLOY_IN_PROGRESS`
            * :attr:`ConfigurationState.STATE_VM_UNDEPLOY_FAILED`
            * :attr:`ConfigurationState.STATE_VM_UNDEPLOY_SUCCESSFUL`
            * :attr:`ConfigurationState.STATE_EDGE_CONFIG_ERROR`
            * :attr:`ConfigurationState.STATE_VM_DEPLOYMENT_RESTARTED`
            * :attr:`ConfigurationState.STATE_REGISTRATION_FAILED`
            * :attr:`ConfigurationState.STATE_TRANSPORT_NODE_SYNC_PENDING`
            *
              :attr:`ConfigurationState.STATE_TRANSPORT_NODE_CONFIGURATION_MISSING`
            * :attr:`ConfigurationState.STATE_EDGE_HARDWARE_NOT_SUPPORTED`
            *
              :attr:`ConfigurationState.STATE_MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED`
            *
              :attr:`ConfigurationState.STATE_TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER`
            * :attr:`ConfigurationState.STATE_TZ_ENDPOINTS_NOT_SPECIFIED`
            * :attr:`ConfigurationState.STATE_NO_PNIC_PREPARED_IN_EDGE`
            * :attr:`ConfigurationState.STATE_APPLIANCE_INTERNAL_ERROR`
            * :attr:`ConfigurationState.STATE_VTEP_DHCP_NOT_SUPPORTED`
            * :attr:`ConfigurationState.STATE_UNSUPPORTED_HOST_SWITCH_PROFILE`
            *
              :attr:`ConfigurationState.STATE_UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED`
            * :attr:`ConfigurationState.STATE_HOSTSWITCH_PROFILE_NOT_FOUND`
            * :attr:`ConfigurationState.STATE_LLDP_SEND_ENABLED_NOT_SUPPORTED`
            * :attr:`ConfigurationState.STATE_UNSUPPORTED_NAMED_TEAMING_POLICY`
            *
              :attr:`ConfigurationState.STATE_LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM`
            * :attr:`ConfigurationState.STATE_LACP_NOT_SUPPORTED_FOR_EDGE_VM`
            *
              :attr:`ConfigurationState.STATE_STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM`
            *
              :attr:`ConfigurationState.STATE_MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE`
            *
              :attr:`ConfigurationState.STATE_UNSUPPORTED_LACP_LB_ALGO_FOR_NODE`
            * :attr:`ConfigurationState.STATE_EDGE_NODE_VERSION_NOT_SUPPORTED`
            * :attr:`ConfigurationState.STATE_NO_PNIC_SPECIFIED_IN_TN`
            * :attr:`ConfigurationState.STATE_INVALID_PNIC_DEVICE_NAME`
            * :attr:`ConfigurationState.STATE_TRANSPORT_NODE_READY`
            * :attr:`ConfigurationState.STATE_VM_NETWORK_EDIT_PENDING`
            *
              :attr:`ConfigurationState.STATE_UNSUPPORTED_DEFAULT_TEAMING_POLICY`
            * :attr:`ConfigurationState.STATE_MPA_DISCONNECTED`
            * :attr:`ConfigurationState.STATE_VM_RENAME_PENDING`
            * :attr:`ConfigurationState.STATE_VM_CONFIG_EDIT_PENDING`
            * :attr:`ConfigurationState.STATE_VM_NETWORK_EDIT_FAILED`
            * :attr:`ConfigurationState.STATE_VM_RENAME_FAILED`
            * :attr:`ConfigurationState.STATE_VM_CONFIG_EDIT_FAILED`
            * :attr:`ConfigurationState.STATE_VM_CONFIG_DISCREPANCY`
            * :attr:`ConfigurationState.STATE_VM_NODE_REFRESH_FAILED`
            * :attr:`ConfigurationState.STATE_VM_PLACEMENT_REFRESH_FAILED`
            * :attr:`ConfigurationState.STATE_REGISTRATION_TIMEDOUT`
            
            Gives details of state of desired configuration. Additional enums
            with more details on progress/success/error states are sent for
            edge node. The success states are NODE_READY and
            TRANSPORT_NODE_READY, pending states are {VM_DEPLOYMENT_QUEUED,
            VM_DEPLOYMENT_IN_PROGRESS, REGISTRATION_PENDING} and other values
            indicate failures. \"in_sync\" state indicates that the desired
            configuration has been received by the host to which it applies,
            but is not yet in effect. When the configuration is actually in
            effect, the state will change to \"success\". Please note, failed
            state is deprecated.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.details = details
        self.failure_code = failure_code
        self.failure_message = failure_message
        self.state = state
        VapiStruct.__init__(self)


ConfigurationState._set_binding_type(type.StructType(
    'com.vmware.nsx.model.configuration_state', {
        'details': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ConfigurationStateElement'))),
        'failure_code': type.OptionalType(type.IntegerType()),
        'failure_message': type.OptionalType(type.StringType()),
        'state': type.OptionalType(type.StringType()),
    },
    ConfigurationState,
    False,
    None))



class ConfigurationStateElement(VapiStruct):
    """
    Describes status of configuration of an entity

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATE_IN_PROGRESS = "in_progress"
    """


    """
    STATE_SUCCESS = "success"
    """


    """
    STATE_FAILED = "failed"
    """


    """
    STATE_PARTIAL_SUCCESS = "partial_success"
    """


    """
    STATE_IN_SYNC = "in_sync"
    """


    """
    STATE_VM_DEPLOYMENT_FAILED = "VM_DEPLOYMENT_FAILED"
    """


    """
    STATE_VM_POWER_ON_FAILED = "VM_POWER_ON_FAILED"
    """


    """
    STATE_VM_POWER_OFF_FAILED = "VM_POWER_OFF_FAILED"
    """


    """
    STATE_VM_UNDEPLOY_FAILED = "VM_UNDEPLOY_FAILED"
    """


    """
    STATE_EDGE_CONFIG_ERROR = "EDGE_CONFIG_ERROR"
    """


    """
    STATE_REGISTRATION_FAILED = "REGISTRATION_FAILED"
    """


    """
    STATE_TRANSPORT_NODE_CONFIGURATION_MISSING = "TRANSPORT_NODE_CONFIGURATION_MISSING"
    """


    """
    STATE_EDGE_HARDWARE_NOT_SUPPORTED = "EDGE_HARDWARE_NOT_SUPPORTED"
    """


    """
    STATE_MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED = "MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED"
    """


    """
    STATE_TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER = "TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER"
    """


    """
    STATE_TZ_ENDPOINTS_NOT_SPECIFIED = "TZ_ENDPOINTS_NOT_SPECIFIED"
    """


    """
    STATE_NO_PNIC_PREPARED_IN_EDGE = "NO_PNIC_PREPARED_IN_EDGE"
    """


    """
    STATE_APPLIANCE_INTERNAL_ERROR = "APPLIANCE_INTERNAL_ERROR"
    """


    """
    STATE_VTEP_DHCP_NOT_SUPPORTED = "VTEP_DHCP_NOT_SUPPORTED"
    """


    """
    STATE_UNSUPPORTED_HOST_SWITCH_PROFILE = "UNSUPPORTED_HOST_SWITCH_PROFILE"
    """


    """
    STATE_UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED = "UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED"
    """


    """
    STATE_HOSTSWITCH_PROFILE_NOT_FOUND = "HOSTSWITCH_PROFILE_NOT_FOUND"
    """


    """
    STATE_LLDP_SEND_ENABLED_NOT_SUPPORTED = "LLDP_SEND_ENABLED_NOT_SUPPORTED"
    """


    """
    STATE_UNSUPPORTED_NAMED_TEAMING_POLICY = "UNSUPPORTED_NAMED_TEAMING_POLICY"
    """


    """
    STATE_LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM = "LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM"
    """


    """
    STATE_LACP_NOT_SUPPORTED_FOR_EDGE_VM = "LACP_NOT_SUPPORTED_FOR_EDGE_VM"
    """


    """
    STATE_STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM = "STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM"
    """


    """
    STATE_MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE = "MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE"
    """


    """
    STATE_UNSUPPORTED_LACP_LB_ALGO_FOR_NODE = "UNSUPPORTED_LACP_LB_ALGO_FOR_NODE"
    """


    """
    STATE_EDGE_NODE_VERSION_NOT_SUPPORTED = "EDGE_NODE_VERSION_NOT_SUPPORTED"
    """


    """
    STATE_NO_PNIC_SPECIFIED_IN_TN = "NO_PNIC_SPECIFIED_IN_TN"
    """


    """
    STATE_INVALID_PNIC_DEVICE_NAME = "INVALID_PNIC_DEVICE_NAME"
    """


    """
    STATE_UNSUPPORTED_DEFAULT_TEAMING_POLICY = "UNSUPPORTED_DEFAULT_TEAMING_POLICY"
    """


    """
    STATE_MPA_DISCONNECTED = "MPA_DISCONNECTED"
    """


    """
    STATE_VM_NETWORK_EDIT_PENDING = "VM_NETWORK_EDIT_PENDING"
    """


    """
    STATE_VM_RENAME_PENDING = "VM_RENAME_PENDING"
    """


    """
    STATE_VM_CONFIG_EDIT_PENDING = "VM_CONFIG_EDIT_PENDING"
    """


    """
    STATE_VM_NETWORK_EDIT_FAILED = "VM_NETWORK_EDIT_FAILED"
    """


    """
    STATE_VM_RENAME_FAILED = "VM_RENAME_FAILED"
    """


    """
    STATE_VM_CONFIG_EDIT_FAILED = "VM_CONFIG_EDIT_FAILED"
    """


    """
    STATE_VM_CONFIG_DISCREPANCY = "VM_CONFIG_DISCREPANCY"
    """


    """
    STATE_VM_NODE_REFRESH_FAILED = "VM_NODE_REFRESH_FAILED"
    """


    """
    STATE_VM_PLACEMENT_REFRESH_FAILED = "VM_PLACEMENT_REFRESH_FAILED"
    """


    """
    STATE_NOT_AVAILABLE = "NOT_AVAILABLE"
    """


    """
    STATE_REGISTRATION_TIMEDOUT = "REGISTRATION_TIMEDOUT"
    """


    """
    STATE_PENDING = "pending"
    """


    """
    STATE_ORPHANED = "orphaned"
    """


    """
    STATE_UNKNOWN = "unknown"
    """


    """
    STATE_ERROR = "error"
    """


    """



    _canonical_to_pep_names = {
                            'failure_code': 'failure_code',
                            'failure_message': 'failure_message',
                            'state': 'state',
                            'sub_system_address': 'sub_system_address',
                            'sub_system_id': 'sub_system_id',
                            'sub_system_name': 'sub_system_name',
                            'sub_system_type': 'sub_system_type',
                            }

    def __init__(self,
                 failure_code=None,
                 failure_message=None,
                 state=None,
                 sub_system_address=None,
                 sub_system_id=None,
                 sub_system_name=None,
                 sub_system_type=None,
                ):
        """
        :type  failure_code: :class:`long` or ``None``
        :param failure_code: Error code format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  failure_message: :class:`str` or ``None``
        :param failure_message: Error message in case of failure
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  state: :class:`str` or ``None``
        :param state: Possible values are: 
            
            * :attr:`ConfigurationStateElement.STATE_IN_PROGRESS`
            * :attr:`ConfigurationStateElement.STATE_SUCCESS`
            * :attr:`ConfigurationStateElement.STATE_FAILED`
            * :attr:`ConfigurationStateElement.STATE_PARTIAL_SUCCESS`
            * :attr:`ConfigurationStateElement.STATE_IN_SYNC`
            * :attr:`ConfigurationStateElement.STATE_VM_DEPLOYMENT_FAILED`
            * :attr:`ConfigurationStateElement.STATE_VM_POWER_ON_FAILED`
            * :attr:`ConfigurationStateElement.STATE_VM_POWER_OFF_FAILED`
            * :attr:`ConfigurationStateElement.STATE_VM_UNDEPLOY_FAILED`
            * :attr:`ConfigurationStateElement.STATE_EDGE_CONFIG_ERROR`
            * :attr:`ConfigurationStateElement.STATE_REGISTRATION_FAILED`
            *
              :attr:`ConfigurationStateElement.STATE_TRANSPORT_NODE_CONFIGURATION_MISSING`
            *
              :attr:`ConfigurationStateElement.STATE_EDGE_HARDWARE_NOT_SUPPORTED`
            *
              :attr:`ConfigurationStateElement.STATE_MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED`
            *
              :attr:`ConfigurationStateElement.STATE_TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER`
            *
              :attr:`ConfigurationStateElement.STATE_TZ_ENDPOINTS_NOT_SPECIFIED`
            * :attr:`ConfigurationStateElement.STATE_NO_PNIC_PREPARED_IN_EDGE`
            * :attr:`ConfigurationStateElement.STATE_APPLIANCE_INTERNAL_ERROR`
            * :attr:`ConfigurationStateElement.STATE_VTEP_DHCP_NOT_SUPPORTED`
            *
              :attr:`ConfigurationStateElement.STATE_UNSUPPORTED_HOST_SWITCH_PROFILE`
            *
              :attr:`ConfigurationStateElement.STATE_UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED`
            *
              :attr:`ConfigurationStateElement.STATE_HOSTSWITCH_PROFILE_NOT_FOUND`
            *
              :attr:`ConfigurationStateElement.STATE_LLDP_SEND_ENABLED_NOT_SUPPORTED`
            *
              :attr:`ConfigurationStateElement.STATE_UNSUPPORTED_NAMED_TEAMING_POLICY`
            *
              :attr:`ConfigurationStateElement.STATE_LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM`
            *
              :attr:`ConfigurationStateElement.STATE_LACP_NOT_SUPPORTED_FOR_EDGE_VM`
            *
              :attr:`ConfigurationStateElement.STATE_STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM`
            *
              :attr:`ConfigurationStateElement.STATE_MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE`
            *
              :attr:`ConfigurationStateElement.STATE_UNSUPPORTED_LACP_LB_ALGO_FOR_NODE`
            *
              :attr:`ConfigurationStateElement.STATE_EDGE_NODE_VERSION_NOT_SUPPORTED`
            * :attr:`ConfigurationStateElement.STATE_NO_PNIC_SPECIFIED_IN_TN`
            * :attr:`ConfigurationStateElement.STATE_INVALID_PNIC_DEVICE_NAME`
            *
              :attr:`ConfigurationStateElement.STATE_UNSUPPORTED_DEFAULT_TEAMING_POLICY`
            * :attr:`ConfigurationStateElement.STATE_MPA_DISCONNECTED`
            * :attr:`ConfigurationStateElement.STATE_VM_NETWORK_EDIT_PENDING`
            * :attr:`ConfigurationStateElement.STATE_VM_RENAME_PENDING`
            * :attr:`ConfigurationStateElement.STATE_VM_CONFIG_EDIT_PENDING`
            * :attr:`ConfigurationStateElement.STATE_VM_NETWORK_EDIT_FAILED`
            * :attr:`ConfigurationStateElement.STATE_VM_RENAME_FAILED`
            * :attr:`ConfigurationStateElement.STATE_VM_CONFIG_EDIT_FAILED`
            * :attr:`ConfigurationStateElement.STATE_VM_CONFIG_DISCREPANCY`
            * :attr:`ConfigurationStateElement.STATE_VM_NODE_REFRESH_FAILED`
            *
              :attr:`ConfigurationStateElement.STATE_VM_PLACEMENT_REFRESH_FAILED`
            * :attr:`ConfigurationStateElement.STATE_NOT_AVAILABLE`
            * :attr:`ConfigurationStateElement.STATE_REGISTRATION_TIMEDOUT`
            * :attr:`ConfigurationStateElement.STATE_PENDING`
            * :attr:`ConfigurationStateElement.STATE_ORPHANED`
            * :attr:`ConfigurationStateElement.STATE_UNKNOWN`
            * :attr:`ConfigurationStateElement.STATE_ERROR`
            
             State of configuration on this sub system
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sub_system_address: :class:`str` or ``None``
        :param sub_system_address: URI of backing resource on sub system
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sub_system_id: :class:`str` or ``None``
        :param sub_system_id: Identifier of backing resource on sub system
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sub_system_name: :class:`str` or ``None``
        :param sub_system_name: Name of backing resource on sub system
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sub_system_type: :class:`str` or ``None``
        :param sub_system_type: Type of backing resource on sub system
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.failure_code = failure_code
        self.failure_message = failure_message
        self.state = state
        self.sub_system_address = sub_system_address
        self.sub_system_id = sub_system_id
        self.sub_system_name = sub_system_name
        self.sub_system_type = sub_system_type
        VapiStruct.__init__(self)


ConfigurationStateElement._set_binding_type(type.StructType(
    'com.vmware.nsx.model.configuration_state_element', {
        'failure_code': type.OptionalType(type.IntegerType()),
        'failure_message': type.OptionalType(type.StringType()),
        'state': type.OptionalType(type.StringType()),
        'sub_system_address': type.OptionalType(type.StringType()),
        'sub_system_id': type.OptionalType(type.StringType()),
        'sub_system_name': type.OptionalType(type.StringType()),
        'sub_system_type': type.OptionalType(type.StringType()),
    },
    ConfigurationStateElement,
    False,
    None))



class ConsolidatedEffectiveIPAddressMemberListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`EffectiveIPInfo` or ``None``
        :param results: Paged Collection of site wise consolidated effective ip addresses
            for the given NSGroup
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ConsolidatedEffectiveIPAddressMemberListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.consolidated_effective_IP_address_member_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'EffectiveIPInfo'))),
    },
    ConsolidatedEffectiveIPAddressMemberListResult,
    False,
    None))



class ContainerApplication(VapiStruct):
    """
    Container application within a project.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ContainerApplication"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    NETWORK_STATUS_HEALTHY = "HEALTHY"
    """


    """
    NETWORK_STATUS_UNHEALTHY = "UNHEALTHY"
    """


    """
    STATUS_UNKNOWN = "UNKNOWN"
    """


    """
    STATUS_HEALTHY = "HEALTHY"
    """


    """
    STATUS_UP = "UP"
    """


    """
    STATUS_DOWN = "DOWN"
    """


    """
    STATUS_DEGRADED = "DEGRADED"
    """


    """



    _canonical_to_pep_names = {
                            'container_cluster_id': 'container_cluster_id',
                            'container_project_id': 'container_project_id',
                            'external_id': 'external_id',
                            'network_errors': 'network_errors',
                            'network_status': 'network_status',
                            'origin_properties': 'origin_properties',
                            'status': 'status',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_last_sync_time': 'last_sync_time',
                            'description': 'description',
                            'display_name': 'display_name',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            }

    def __init__(self,
                 container_cluster_id=None,
                 container_project_id=None,
                 external_id=None,
                 network_errors=None,
                 network_status=None,
                 origin_properties=None,
                 status=None,
                 links=None,
                 schema=None,
                 self_=None,
                 last_sync_time=None,
                 description=None,
                 display_name=None,
                 resource_type='ContainerApplication',
                 tags=None,
                ):
        """
        :type  container_cluster_id: :class:`str` or ``None``
        :param container_cluster_id: Identifier of the container cluster this container application
            belongs to.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  container_project_id: :class:`str` or ``None``
        :param container_project_id: Identifier of the project which this container application belongs
            to.
        :type  external_id: :class:`str` or ``None``
        :param external_id: Identifier of the container application on container cluster e.g.
            PCF app id, k8s service id.
        :type  network_errors: :class:`list` of :class:`NetworkError` or ``None``
        :param network_errors: List of network errors related to container application.
        :type  network_status: :class:`str` or ``None``
        :param network_status: Possible values are: 
            
            * :attr:`ContainerApplication.NETWORK_STATUS_HEALTHY`
            * :attr:`ContainerApplication.NETWORK_STATUS_UNHEALTHY`
            
             Network status of container application.
        :type  origin_properties: :class:`list` of :class:`KeyValuePair` or ``None``
        :param origin_properties: Array of additional specific properties of container application in
            key-value format.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ContainerApplication.STATUS_UNKNOWN`
            * :attr:`ContainerApplication.STATUS_HEALTHY`
            * :attr:`ContainerApplication.STATUS_UP`
            * :attr:`ContainerApplication.STATUS_DOWN`
            * :attr:`ContainerApplication.STATUS_DEGRADED`
            
             Status of the container application.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  last_sync_time: :class:`long` or ``None``
        :param last_sync_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  resource_type: :class:`str`
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        """
        self.container_cluster_id = container_cluster_id
        self.container_project_id = container_project_id
        self.external_id = external_id
        self.network_errors = network_errors
        self.network_status = network_status
        self.origin_properties = origin_properties
        self.status = status
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.last_sync_time = last_sync_time
        self.description = description
        self.display_name = display_name
        self._resource_type = resource_type
        self.tags = tags
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ContainerApplication._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_application', {
        'container_cluster_id': type.OptionalType(type.StringType()),
        'container_project_id': type.OptionalType(type.StringType()),
        'external_id': type.OptionalType(type.StringType()),
        'network_errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NetworkError'))),
        'network_status': type.OptionalType(type.StringType()),
        'origin_properties': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'KeyValuePair'))),
        'status': type.OptionalType(type.StringType()),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_last_sync_time': type.OptionalType(type.IntegerType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
    },
    ContainerApplication,
    False,
    None))



class ContainerApplicationInstance(VapiStruct):
    """
    Container application instance within a project.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ContainerApplicationInstance"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    NETWORK_STATUS_HEALTHY = "HEALTHY"
    """


    """
    NETWORK_STATUS_UNHEALTHY = "UNHEALTHY"
    """


    """
    STATUS_UNKNOWN = "UNKNOWN"
    """


    """
    STATUS_HEALTHY = "HEALTHY"
    """


    """
    STATUS_UP = "UP"
    """


    """
    STATUS_DOWN = "DOWN"
    """


    """
    STATUS_DEGRADED = "DEGRADED"
    """


    """



    _canonical_to_pep_names = {
                            'cluster_node_id': 'cluster_node_id',
                            'container_application_ids': 'container_application_ids',
                            'container_cluster_id': 'container_cluster_id',
                            'container_project_id': 'container_project_id',
                            'external_id': 'external_id',
                            'network_errors': 'network_errors',
                            'network_status': 'network_status',
                            'origin_properties': 'origin_properties',
                            'status': 'status',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_last_sync_time': 'last_sync_time',
                            'description': 'description',
                            'display_name': 'display_name',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            }

    def __init__(self,
                 cluster_node_id=None,
                 container_application_ids=None,
                 container_cluster_id=None,
                 container_project_id=None,
                 external_id=None,
                 network_errors=None,
                 network_status=None,
                 origin_properties=None,
                 status=None,
                 links=None,
                 schema=None,
                 self_=None,
                 last_sync_time=None,
                 description=None,
                 display_name=None,
                 resource_type='ContainerApplicationInstance',
                 tags=None,
                ):
        """
        :type  cluster_node_id: :class:`str` or ``None``
        :param cluster_node_id: Cluster node id where application instance is running.
        :type  container_application_ids: :class:`list` of :class:`str` or ``None``
        :param container_application_ids: List of identifiers of the container application.
        :type  container_cluster_id: :class:`str` or ``None``
        :param container_cluster_id: Identifier of the container cluster this application instance
            belongs to.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  container_project_id: :class:`str` or ``None``
        :param container_project_id: Identifier of the container project which this container
            application instance belongs to.
        :type  external_id: :class:`str` or ``None``
        :param external_id: Identifier of the container application instance on container
            cluster.
        :type  network_errors: :class:`list` of :class:`NetworkError` or ``None``
        :param network_errors: List of network errors related to container application instance.
        :type  network_status: :class:`str` or ``None``
        :param network_status: Possible values are: 
            
            * :attr:`ContainerApplicationInstance.NETWORK_STATUS_HEALTHY`
            * :attr:`ContainerApplicationInstance.NETWORK_STATUS_UNHEALTHY`
            
             Network status of container application instance.
        :type  origin_properties: :class:`list` of :class:`KeyValuePair` or ``None``
        :param origin_properties: Array of additional specific properties of container application
            instance in key-value format.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ContainerApplicationInstance.STATUS_UNKNOWN`
            * :attr:`ContainerApplicationInstance.STATUS_HEALTHY`
            * :attr:`ContainerApplicationInstance.STATUS_UP`
            * :attr:`ContainerApplicationInstance.STATUS_DOWN`
            * :attr:`ContainerApplicationInstance.STATUS_DEGRADED`
            
             Status of the container application instance.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  last_sync_time: :class:`long` or ``None``
        :param last_sync_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  resource_type: :class:`str`
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        """
        self.cluster_node_id = cluster_node_id
        self.container_application_ids = container_application_ids
        self.container_cluster_id = container_cluster_id
        self.container_project_id = container_project_id
        self.external_id = external_id
        self.network_errors = network_errors
        self.network_status = network_status
        self.origin_properties = origin_properties
        self.status = status
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.last_sync_time = last_sync_time
        self.description = description
        self.display_name = display_name
        self._resource_type = resource_type
        self.tags = tags
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ContainerApplicationInstance._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_application_instance', {
        'cluster_node_id': type.OptionalType(type.StringType()),
        'container_application_ids': type.OptionalType(type.ListType(type.StringType())),
        'container_cluster_id': type.OptionalType(type.StringType()),
        'container_project_id': type.OptionalType(type.StringType()),
        'external_id': type.OptionalType(type.StringType()),
        'network_errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NetworkError'))),
        'network_status': type.OptionalType(type.StringType()),
        'origin_properties': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'KeyValuePair'))),
        'status': type.OptionalType(type.StringType()),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_last_sync_time': type.OptionalType(type.IntegerType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
    },
    ContainerApplicationInstance,
    False,
    None))



class ContainerApplicationInstanceListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ContainerApplicationInstance` or ``None``
        :param results: List of Container Applications
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ContainerApplicationInstanceListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_application_instance_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ContainerApplicationInstance'))),
    },
    ContainerApplicationInstanceListResult,
    False,
    None))



class ContainerApplicationListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ContainerApplication` or ``None``
        :param results: List of Container Applications
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ContainerApplicationListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_application_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ContainerApplication'))),
    },
    ContainerApplicationListResult,
    False,
    None))



class ContainerCluster(VapiStruct):
    """
    Details of container cluster.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ContainerCluster"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    CLUSTER_TYPE_PAS = "PAS"
    """


    """
    CLUSTER_TYPE_PKS = "PKS"
    """


    """
    CLUSTER_TYPE_KUBERNETES = "Kubernetes"
    """


    """
    CLUSTER_TYPE_OPENSHIFT = "Openshift"
    """


    """
    CLUSTER_TYPE_WCP = "WCP"
    """


    """
    CLUSTER_TYPE_WCP_GUEST = "WCP_Guest"
    """


    """
    CLUSTER_TYPE_OTHER = "Other"
    """


    """
    NETWORK_STATUS_HEALTHY = "HEALTHY"
    """


    """
    NETWORK_STATUS_UNHEALTHY = "UNHEALTHY"
    """


    """



    _canonical_to_pep_names = {
                            'cluster_type': 'cluster_type',
                            'external_id': 'external_id',
                            'infrastructure': 'infrastructure',
                            'network_errors': 'network_errors',
                            'network_status': 'network_status',
                            'origin_properties': 'origin_properties',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_last_sync_time': 'last_sync_time',
                            'description': 'description',
                            'display_name': 'display_name',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            }

    def __init__(self,
                 cluster_type=None,
                 external_id=None,
                 infrastructure=None,
                 network_errors=None,
                 network_status=None,
                 origin_properties=None,
                 links=None,
                 schema=None,
                 self_=None,
                 last_sync_time=None,
                 description=None,
                 display_name=None,
                 resource_type='ContainerCluster',
                 tags=None,
                ):
        """
        :type  cluster_type: :class:`str` or ``None``
        :param cluster_type: Possible values are: 
            
            * :attr:`ContainerCluster.CLUSTER_TYPE_PAS`
            * :attr:`ContainerCluster.CLUSTER_TYPE_PKS`
            * :attr:`ContainerCluster.CLUSTER_TYPE_KUBERNETES`
            * :attr:`ContainerCluster.CLUSTER_TYPE_OPENSHIFT`
            * :attr:`ContainerCluster.CLUSTER_TYPE_WCP`
            * :attr:`ContainerCluster.CLUSTER_TYPE_WCP_GUEST`
            * :attr:`ContainerCluster.CLUSTER_TYPE_OTHER`
            
            Type of the container cluster. In case of creating container
            cluster first time, it is expected to pass the valid cluster-type.
            In case of update, if there is no change in cluster-type, then this
            field can be omitted in the request.
        :type  external_id: :class:`str` or ``None``
        :param external_id: External identifier of the container cluster.
        :type  infrastructure: :class:`ContainerInfrastructureInfo` or ``None``
        :param infrastructure: Details of underlying infrastructure that hosts the container
            cluster. In case of creating container cluster first time, it is
            expected to pass the valid infrastructure. In case of update, if
            there is no change in cluster-type, then this field can be omitted
            in the request.
        :type  network_errors: :class:`list` of :class:`NetworkError` or ``None``
        :param network_errors: List of network errors related to container cluster.
        :type  network_status: :class:`str` or ``None``
        :param network_status: Possible values are: 
            
            * :attr:`ContainerCluster.NETWORK_STATUS_HEALTHY`
            * :attr:`ContainerCluster.NETWORK_STATUS_UNHEALTHY`
            
             Network status of container cluster.
        :type  origin_properties: :class:`list` of :class:`KeyValuePair` or ``None``
        :param origin_properties: Array of additional specific properties of container cluster in
            key-value format.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  last_sync_time: :class:`long` or ``None``
        :param last_sync_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  resource_type: :class:`str`
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        """
        self.cluster_type = cluster_type
        self.external_id = external_id
        self.infrastructure = infrastructure
        self.network_errors = network_errors
        self.network_status = network_status
        self.origin_properties = origin_properties
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.last_sync_time = last_sync_time
        self.description = description
        self.display_name = display_name
        self._resource_type = resource_type
        self.tags = tags
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ContainerCluster._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_cluster', {
        'cluster_type': type.OptionalType(type.StringType()),
        'external_id': type.OptionalType(type.StringType()),
        'infrastructure': type.OptionalType(type.ReferenceType(__name__, 'ContainerInfrastructureInfo')),
        'network_errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NetworkError'))),
        'network_status': type.OptionalType(type.StringType()),
        'origin_properties': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'KeyValuePair'))),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_last_sync_time': type.OptionalType(type.IntegerType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
    },
    ContainerCluster,
    False,
    None))



class ContainerClusterListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ContainerCluster` or ``None``
        :param results: List of Container Clusters
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ContainerClusterListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_cluster_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ContainerCluster'))),
    },
    ContainerClusterListResult,
    False,
    None))



class ContainerClusterNode(VapiStruct):
    """
    Details of container cluster node i.e. container host.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ContainerClusterNode"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    NETWORK_STATUS_HEALTHY = "HEALTHY"
    """


    """
    NETWORK_STATUS_UNHEALTHY = "UNHEALTHY"
    """


    """



    _canonical_to_pep_names = {
                            'container_cluster_id': 'container_cluster_id',
                            'external_id': 'external_id',
                            'ip_addresses': 'ip_addresses',
                            'network_errors': 'network_errors',
                            'network_status': 'network_status',
                            'origin_properties': 'origin_properties',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_last_sync_time': 'last_sync_time',
                            'description': 'description',
                            'display_name': 'display_name',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            }

    def __init__(self,
                 container_cluster_id=None,
                 external_id=None,
                 ip_addresses=None,
                 network_errors=None,
                 network_status=None,
                 origin_properties=None,
                 links=None,
                 schema=None,
                 self_=None,
                 last_sync_time=None,
                 description=None,
                 display_name=None,
                 resource_type='ContainerClusterNode',
                 tags=None,
                ):
        """
        :type  container_cluster_id: :class:`str` or ``None``
        :param container_cluster_id: External identifier of the container cluster.
        :type  external_id: :class:`str` or ``None``
        :param external_id: External identifier of the container cluster node in K8S/PAS.
        :type  ip_addresses: :class:`list` of :class:`str` or ``None``
        :param ip_addresses: List of IP addresses of container cluster node. format: ip
        :type  network_errors: :class:`list` of :class:`NetworkError` or ``None``
        :param network_errors: List of network errors related to container cluster node.
        :type  network_status: :class:`str` or ``None``
        :param network_status: Possible values are: 
            
            * :attr:`ContainerClusterNode.NETWORK_STATUS_HEALTHY`
            * :attr:`ContainerClusterNode.NETWORK_STATUS_UNHEALTHY`
            
             Network status of container cluster node.
        :type  origin_properties: :class:`list` of :class:`KeyValuePair` or ``None``
        :param origin_properties: Array of additional specific properties of container cluster node
            in key-value format.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  last_sync_time: :class:`long` or ``None``
        :param last_sync_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  resource_type: :class:`str`
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        """
        self.container_cluster_id = container_cluster_id
        self.external_id = external_id
        self.ip_addresses = ip_addresses
        self.network_errors = network_errors
        self.network_status = network_status
        self.origin_properties = origin_properties
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.last_sync_time = last_sync_time
        self.description = description
        self.display_name = display_name
        self._resource_type = resource_type
        self.tags = tags
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ContainerClusterNode._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_cluster_node', {
        'container_cluster_id': type.OptionalType(type.StringType()),
        'external_id': type.OptionalType(type.StringType()),
        'ip_addresses': type.OptionalType(type.ListType(type.StringType())),
        'network_errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NetworkError'))),
        'network_status': type.OptionalType(type.StringType()),
        'origin_properties': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'KeyValuePair'))),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_last_sync_time': type.OptionalType(type.IntegerType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
    },
    ContainerClusterNode,
    False,
    None))



class ContainerClusterNodeListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ContainerClusterNode` or ``None``
        :param results: List of container cluster nodes
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ContainerClusterNodeListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_cluster_node_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ContainerClusterNode'))),
    },
    ContainerClusterNodeListResult,
    False,
    None))



class ContainerClusterStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_UNKNOWN = "UNKNOWN"
    """


    """
    STATUS_HEALTHY = "HEALTHY"
    """


    """
    STATUS_DOWN = "DOWN"
    """


    """
    STATUS_DEGRADED = "DEGRADED"
    """


    """



    _canonical_to_pep_names = {
                            'cluster_id': 'cluster_id',
                            'detail': 'detail',
                            'interval': 'interval',
                            'status': 'status',
                            }

    def __init__(self,
                 cluster_id=None,
                 detail=None,
                 interval=None,
                 status=None,
                ):
        """
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: Identifier of the container cluster.
        :type  detail: :class:`str` or ``None``
        :param detail: Detail information on status.
        :type  interval: :class:`long` or ``None``
        :param interval: Display the cluster check interval in seconds. format: int32
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ContainerClusterStatus.STATUS_UNKNOWN`
            * :attr:`ContainerClusterStatus.STATUS_HEALTHY`
            * :attr:`ContainerClusterStatus.STATUS_DOWN`
            * :attr:`ContainerClusterStatus.STATUS_DEGRADED`
            
             Display the container cluster status.
        """
        self.cluster_id = cluster_id
        self.detail = detail
        self.interval = interval
        self.status = status
        VapiStruct.__init__(self)


ContainerClusterStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_cluster_status', {
        'cluster_id': type.OptionalType(type.StringType()),
        'detail': type.OptionalType(type.StringType()),
        'interval': type.OptionalType(type.IntegerType()),
        'status': type.OptionalType(type.StringType()),
    },
    ContainerClusterStatus,
    False,
    None))



class ContainerClusterStatusList(VapiStruct):
    """
    List of the Container cluster

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ContainerClusterSummary` or ``None``
        :param results: Container cluster list.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ContainerClusterStatusList._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_cluster_status_list', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ContainerClusterSummary'))),
    },
    ContainerClusterStatusList,
    False,
    None))



class ContainerClusterSummary(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_UNKNOWN = "UNKNOWN"
    """


    """
    STATUS_HEALTHY = "HEALTHY"
    """


    """
    STATUS_DOWN = "DOWN"
    """


    """
    STATUS_DEGRADED = "DEGRADED"
    """


    """
    TYPE_PAS = "PAS"
    """


    """
    TYPE_PKS = "PKS"
    """


    """
    TYPE_KUBERNETES = "Kubernetes"
    """


    """
    TYPE_OPENSHIFT = "Openshift"
    """


    """
    TYPE_WCP = "WCP"
    """


    """
    TYPE_OTHER = "Other"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'cluster_id': 'cluster_id',
                            'cluster_name': 'cluster_name',
                            'detail': 'detail',
                            'status': 'status',
                            'type': 'type',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 cluster_id=None,
                 cluster_name=None,
                 detail=None,
                 status=None,
                 type=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: Identifier of the container cluster.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  cluster_name: :class:`str` or ``None``
        :param cluster_name: Display the container cluster name
        :type  detail: :class:`str` or ``None``
        :param detail: Detail information on status.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ContainerClusterSummary.STATUS_UNKNOWN`
            * :attr:`ContainerClusterSummary.STATUS_HEALTHY`
            * :attr:`ContainerClusterSummary.STATUS_DOWN`
            * :attr:`ContainerClusterSummary.STATUS_DEGRADED`
            
             Display the container cluster status.
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ContainerClusterSummary.TYPE_PAS`
            * :attr:`ContainerClusterSummary.TYPE_PKS`
            * :attr:`ContainerClusterSummary.TYPE_KUBERNETES`
            * :attr:`ContainerClusterSummary.TYPE_OPENSHIFT`
            * :attr:`ContainerClusterSummary.TYPE_WCP`
            * :attr:`ContainerClusterSummary.TYPE_OTHER`
            
             Container cluster type.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.cluster_id = cluster_id
        self.cluster_name = cluster_name
        self.detail = detail
        self.status = status
        self.type = type
        VapiStruct.__init__(self)


ContainerClusterSummary._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_cluster_summary', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'cluster_id': type.OptionalType(type.StringType()),
        'cluster_name': type.OptionalType(type.StringType()),
        'detail': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
        'type': type.OptionalType(type.StringType()),
    },
    ContainerClusterSummary,
    False,
    None))



class ContainerConfiguration(VapiStruct):
    """
    Represents a container to group widgets that belong to a common category or
    have a common purpose.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ContainerConfiguration"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'header': 'header',
                            'labels': 'labels',
                            'layout': 'layout',
                            'navigation': 'navigation',
                            'widgets': 'widgets',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'datasources': 'datasources',
                            'default_filter_value': 'default_filter_value',
                            'drilldown_id': 'drilldown_id',
                            'filter': 'filter',
                            'filter_value_required': 'filter_value_required',
                            'footer': 'footer',
                            'icons': 'icons',
                            'is_drilldown': 'is_drilldown',
                            'legend': 'legend',
                            'shared': 'shared',
                            'span': 'span',
                            'weight': 'weight',
                            }

    def __init__(self,
                 header=None,
                 labels=None,
                 layout=None,
                 navigation=None,
                 widgets=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='ContainerConfiguration',
                 tags=None,
                 datasources=None,
                 default_filter_value=None,
                 drilldown_id=None,
                 filter=None,
                 filter_value_required=None,
                 footer=None,
                 icons=None,
                 is_drilldown=None,
                 legend=None,
                 shared=None,
                 span=None,
                 weight=None,
                ):
        """
        :type  header: :class:`Header` or ``None``
        :param header: 
        :type  labels: :class:`list` of :class:`Label` or ``None``
        :param labels: Labels for the container.
        :type  layout: :class:`Layout` or ``None``
        :param layout: Layout of widgets can be either vertical or horizontal. If layout
            is not specified a default horizontal layout is applied.
        :type  navigation: :class:`str` or ``None``
        :param navigation: Hyperlink of the specified UI page that provides details.
        :type  widgets: :class:`list` of :class:`WidgetItem` or ``None``
        :param widgets: If not specified, creates an empty container.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Title of the widget. If display_name is omitted, the widget will be
            shown without a title.
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`WidgetConfiguration.RESOURCE_TYPE_LABELVALUECONFIGURATION`
            * :attr:`WidgetConfiguration.RESOURCE_TYPE_DONUTCONFIGURATION`
            *
              :attr:`WidgetConfiguration.RESOURCE_TYPE_MULTIWIDGETCONFIGURATION`
            * :attr:`WidgetConfiguration.RESOURCE_TYPE_CONTAINERCONFIGURATION`
            * :attr:`WidgetConfiguration.RESOURCE_TYPE_STATSCONFIGURATION`
            * :attr:`WidgetConfiguration.RESOURCE_TYPE_GRIDCONFIGURATION`
            * :attr:`WidgetConfiguration.RESOURCE_TYPE_GRAPHCONFIGURATION`
            *
              :attr:`WidgetConfiguration.RESOURCE_TYPE_CUSTOMWIDGETCONFIGURATION`
            *
              :attr:`WidgetConfiguration.RESOURCE_TYPE_DROPDOWNFILTERWIDGETCONFIGURATION`
            
            Supported visualization types are LabelValueConfiguration,
            DonutConfiguration, GridConfiguration, StatsConfiguration,
            MultiWidgetConfiguration, GraphConfiguration,
            ContainerConfiguration, CustomWidgetConfiguration and
            DropdownFilterWidgetConfiguration.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  datasources: :class:`list` of :class:`Datasource` or ``None``
        :param datasources: The 'datasources' represent the sources from which data will be
            fetched. Currently, only NSX-API is supported as a 'default'
            datasource. An example of specifying 'default' datasource along
            with the urls to fetch data from is given at 'example_request'
            section of 'CreateWidgetConfiguration' API.
        :type  default_filter_value: :class:`list` of :class:`DefaultFilterValue` or ``None``
        :param default_filter_value: Default filter values to be passed to datasources. This will be
            used when the report is requested without filter values.
        :type  drilldown_id: :class:`str` or ``None``
        :param drilldown_id: Id of drilldown widget, if any. Id should be a valid id of an
            existing widget. A widget is considered as drilldown widget when it
            is associated with any other widget and provides more detailed
            information about any data item from the parent widget.
        :type  filter: :class:`str` or ``None``
        :param filter: Id of filter widget for subscription, if any. Id should be a valid
            id of an existing filter widget. Filter widget should be from the
            same view. Datasource URLs should have placeholder values equal to
            filter alias to accept the filter value on filter change.
        :type  filter_value_required: :class:`bool` or ``None``
        :param filter_value_required: Flag to indicate that widget will continue to work without filter
            value. If this flag is set to false then default_filter_value is
            manadatory.
        :type  footer: :class:`Footer` or ``None``
        :param footer: 
        :type  icons: :class:`list` of :class:`Icon` or ``None``
        :param icons: Icons to be applied at dashboard for widgets and UI elements.
        :type  is_drilldown: :class:`bool` or ``None``
        :param is_drilldown: Set to true if this widget should be used as a drilldown.
        :type  legend: :class:`Legend` or ``None``
        :param legend: Legend to be displayed. If legend is not needed, do not include it.
        :type  shared: :class:`bool` or ``None``
        :param shared: Please use the property 'shared' of View instead of this. The
            widgets of a shared view are visible to other users.
        :type  span: :class:`long` or ``None``
        :param span: Represents the horizontal span of the widget / container. format:
            int32
        :type  weight: :class:`long` or ``None``
        :param weight: Specify relavite weight in WidgetItem for placement in a view.
            Please see WidgetItem for details. format: int32
        """
        self.header = header
        self.labels = labels
        self.layout = layout
        self.navigation = navigation
        self.widgets = widgets
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.datasources = datasources
        self.default_filter_value = default_filter_value
        self.drilldown_id = drilldown_id
        self.filter = filter
        self.filter_value_required = filter_value_required
        self.footer = footer
        self.icons = icons
        self.is_drilldown = is_drilldown
        self.legend = legend
        self.shared = shared
        self.span = span
        self.weight = weight
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ContainerConfiguration._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_configuration', {
        'header': type.OptionalType(type.ReferenceType(__name__, 'Header')),
        'labels': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Label'))),
        'layout': type.OptionalType(type.ReferenceType(__name__, 'Layout')),
        'navigation': type.OptionalType(type.StringType()),
        'widgets': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'WidgetItem'))),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'datasources': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Datasource'))),
        'default_filter_value': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'DefaultFilterValue'))),
        'drilldown_id': type.OptionalType(type.StringType()),
        'filter': type.OptionalType(type.StringType()),
        'filter_value_required': type.OptionalType(type.BooleanType()),
        'footer': type.OptionalType(type.ReferenceType(__name__, 'Footer')),
        'icons': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Icon'))),
        'is_drilldown': type.OptionalType(type.BooleanType()),
        'legend': type.OptionalType(type.ReferenceType(__name__, 'Legend')),
        'shared': type.OptionalType(type.BooleanType()),
        'span': type.OptionalType(type.IntegerType()),
        'weight': type.OptionalType(type.IntegerType()),
    },
    ContainerConfiguration,
    False,
    None))



class ContainerInfrastructureInfo(VapiStruct):
    """
    Details of infrastructure hosting the container cluster e.g. vSphere, AWS,
    VMC etc..

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    INFRA_TYPE_VSPHERE = "vSphere"
    """


    """
    INFRA_TYPE_AWS = "AWS"
    """


    """
    INFRA_TYPE_AZURE = "Azure"
    """


    """
    INFRA_TYPE_VMC = "VMC"
    """


    """
    INFRA_TYPE_KVM = "KVM"
    """


    """
    INFRA_TYPE_BAREMETAL = "Baremetal"
    """


    """



    _canonical_to_pep_names = {
                            'infra_type': 'infra_type',
                            }

    def __init__(self,
                 infra_type=None,
                ):
        """
        :type  infra_type: :class:`str` or ``None``
        :param infra_type: Possible values are: 
            
            * :attr:`ContainerInfrastructureInfo.INFRA_TYPE_VSPHERE`
            * :attr:`ContainerInfrastructureInfo.INFRA_TYPE_AWS`
            * :attr:`ContainerInfrastructureInfo.INFRA_TYPE_AZURE`
            * :attr:`ContainerInfrastructureInfo.INFRA_TYPE_VMC`
            * :attr:`ContainerInfrastructureInfo.INFRA_TYPE_KVM`
            * :attr:`ContainerInfrastructureInfo.INFRA_TYPE_BAREMETAL`
            
             Type of the infrastructure.
        """
        self.infra_type = infra_type
        VapiStruct.__init__(self)


ContainerInfrastructureInfo._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_infrastructure_info', {
        'infra_type': type.OptionalType(type.StringType()),
    },
    ContainerInfrastructureInfo,
    False,
    None))



class ContainerIngressPolicy(VapiStruct):
    """
    Details of Container Ingress Policy.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ContainerIngressPolicy"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    NETWORK_STATUS_HEALTHY = "HEALTHY"
    """


    """
    NETWORK_STATUS_UNHEALTHY = "UNHEALTHY"
    """


    """



    _canonical_to_pep_names = {
                            'container_application_ids': 'container_application_ids',
                            'container_cluster_id': 'container_cluster_id',
                            'container_project_id': 'container_project_id',
                            'external_id': 'external_id',
                            'network_errors': 'network_errors',
                            'network_status': 'network_status',
                            'origin_properties': 'origin_properties',
                            'spec': 'spec',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_last_sync_time': 'last_sync_time',
                            'description': 'description',
                            'display_name': 'display_name',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            }

    def __init__(self,
                 container_application_ids=None,
                 container_cluster_id=None,
                 container_project_id=None,
                 external_id=None,
                 network_errors=None,
                 network_status=None,
                 origin_properties=None,
                 spec=None,
                 links=None,
                 schema=None,
                 self_=None,
                 last_sync_time=None,
                 description=None,
                 display_name=None,
                 resource_type='ContainerIngressPolicy',
                 tags=None,
                ):
        """
        :type  container_application_ids: :class:`list` of :class:`str` or ``None``
        :param container_application_ids: List of identifiers of the container application , on which ingress
            policy is applied. e.g. IDs of all services on which the ingress is
            applied in kubernetes.
        :type  container_cluster_id: :class:`str` or ``None``
        :param container_cluster_id: Identifier of the container cluster this ingress policy belongs to.
        :type  container_project_id: :class:`str` or ``None``
        :param container_project_id: Identifier of the project which this container ingress belongs to.
        :type  external_id: :class:`str` or ``None``
        :param external_id: Identifier of the container ingress policy.
        :type  network_errors: :class:`list` of :class:`NetworkError` or ``None``
        :param network_errors: List of network errors related to container ingress.
        :type  network_status: :class:`str` or ``None``
        :param network_status: Possible values are: 
            
            * :attr:`ContainerIngressPolicy.NETWORK_STATUS_HEALTHY`
            * :attr:`ContainerIngressPolicy.NETWORK_STATUS_UNHEALTHY`
            
             Network status of container ingress.
        :type  origin_properties: :class:`list` of :class:`KeyValuePair` or ``None``
        :param origin_properties: Array of additional specific properties of container ingress in
            key-value format.
        :type  spec: :class:`str` or ``None``
        :param spec: Container ingress policy specification.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  last_sync_time: :class:`long` or ``None``
        :param last_sync_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  resource_type: :class:`str`
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        """
        self.container_application_ids = container_application_ids
        self.container_cluster_id = container_cluster_id
        self.container_project_id = container_project_id
        self.external_id = external_id
        self.network_errors = network_errors
        self.network_status = network_status
        self.origin_properties = origin_properties
        self.spec = spec
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.last_sync_time = last_sync_time
        self.description = description
        self.display_name = display_name
        self._resource_type = resource_type
        self.tags = tags
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ContainerIngressPolicy._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_ingress_policy', {
        'container_application_ids': type.OptionalType(type.ListType(type.StringType())),
        'container_cluster_id': type.OptionalType(type.StringType()),
        'container_project_id': type.OptionalType(type.StringType()),
        'external_id': type.OptionalType(type.StringType()),
        'network_errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NetworkError'))),
        'network_status': type.OptionalType(type.StringType()),
        'origin_properties': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'KeyValuePair'))),
        'spec': type.OptionalType(type.StringType()),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_last_sync_time': type.OptionalType(type.IntegerType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
    },
    ContainerIngressPolicy,
    False,
    None))



class ContainerIngressPolicyListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ContainerIngressPolicy` or ``None``
        :param results: List of Container Ingress Policy specs
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ContainerIngressPolicyListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_ingress_policy_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ContainerIngressPolicy'))),
    },
    ContainerIngressPolicyListResult,
    False,
    None))



class ContainerNetworkPolicy(VapiStruct):
    """
    Network policy applied to container.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ContainerNetworkPolicy"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    NETWORK_STATUS_HEALTHY = "HEALTHY"
    """


    """
    NETWORK_STATUS_UNHEALTHY = "UNHEALTHY"
    """


    """
    POLICY_TYPE_NETWORK_POLICY = "NETWORK_POLICY"
    """


    """
    POLICY_TYPE_ASG = "ASG"
    """


    """



    _canonical_to_pep_names = {
                            'container_cluster_id': 'container_cluster_id',
                            'container_project_id': 'container_project_id',
                            'external_id': 'external_id',
                            'network_errors': 'network_errors',
                            'network_status': 'network_status',
                            'origin_properties': 'origin_properties',
                            'policy_type': 'policy_type',
                            'spec': 'spec',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_last_sync_time': 'last_sync_time',
                            'description': 'description',
                            'display_name': 'display_name',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            }

    def __init__(self,
                 container_cluster_id=None,
                 container_project_id=None,
                 external_id=None,
                 network_errors=None,
                 network_status=None,
                 origin_properties=None,
                 policy_type=None,
                 spec=None,
                 links=None,
                 schema=None,
                 self_=None,
                 last_sync_time=None,
                 description=None,
                 display_name=None,
                 resource_type='ContainerNetworkPolicy',
                 tags=None,
                ):
        """
        :type  container_cluster_id: :class:`str` or ``None``
        :param container_cluster_id: Identifier of the container cluster this network policy belongs to.
        :type  container_project_id: :class:`str` or ``None``
        :param container_project_id: Identifier of the project which this network policy belongs to.
        :type  external_id: :class:`str` or ``None``
        :param external_id: Identifier of the container network policy.
        :type  network_errors: :class:`list` of :class:`NetworkError` or ``None``
        :param network_errors: List of network errors related to container network policy.
        :type  network_status: :class:`str` or ``None``
        :param network_status: Possible values are: 
            
            * :attr:`ContainerNetworkPolicy.NETWORK_STATUS_HEALTHY`
            * :attr:`ContainerNetworkPolicy.NETWORK_STATUS_UNHEALTHY`
            
             Network status of container network policy.
        :type  origin_properties: :class:`list` of :class:`KeyValuePair` or ``None``
        :param origin_properties: Array of additional specific properties of container network policy
            in key-value format.
        :type  policy_type: :class:`str` or ``None``
        :param policy_type: Possible values are: 
            
            * :attr:`ContainerNetworkPolicy.POLICY_TYPE_NETWORK_POLICY`
            * :attr:`ContainerNetworkPolicy.POLICY_TYPE_ASG`
            
             Type e.g. Network Policy, ASG.
        :type  spec: :class:`str` or ``None``
        :param spec: Container network policy specification.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  last_sync_time: :class:`long` or ``None``
        :param last_sync_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  resource_type: :class:`str`
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        """
        self.container_cluster_id = container_cluster_id
        self.container_project_id = container_project_id
        self.external_id = external_id
        self.network_errors = network_errors
        self.network_status = network_status
        self.origin_properties = origin_properties
        self.policy_type = policy_type
        self.spec = spec
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.last_sync_time = last_sync_time
        self.description = description
        self.display_name = display_name
        self._resource_type = resource_type
        self.tags = tags
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ContainerNetworkPolicy._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_network_policy', {
        'container_cluster_id': type.OptionalType(type.StringType()),
        'container_project_id': type.OptionalType(type.StringType()),
        'external_id': type.OptionalType(type.StringType()),
        'network_errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NetworkError'))),
        'network_status': type.OptionalType(type.StringType()),
        'origin_properties': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'KeyValuePair'))),
        'policy_type': type.OptionalType(type.StringType()),
        'spec': type.OptionalType(type.StringType()),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_last_sync_time': type.OptionalType(type.IntegerType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
    },
    ContainerNetworkPolicy,
    False,
    None))



class ContainerNetworkPolicyListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ContainerNetworkPolicy` or ``None``
        :param results: List of Container Network Policy specs
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ContainerNetworkPolicyListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_network_policy_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ContainerNetworkPolicy'))),
    },
    ContainerNetworkPolicyListResult,
    False,
    None))



class ContainerProject(VapiStruct):
    """
    Details of org/namespace within a container cluster.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ContainerProject"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    NETWORK_STATUS_HEALTHY = "HEALTHY"
    """


    """
    NETWORK_STATUS_UNHEALTHY = "UNHEALTHY"
    """


    """



    _canonical_to_pep_names = {
                            'container_cluster_id': 'container_cluster_id',
                            'external_id': 'external_id',
                            'network_errors': 'network_errors',
                            'network_status': 'network_status',
                            'origin_properties': 'origin_properties',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_last_sync_time': 'last_sync_time',
                            'description': 'description',
                            'display_name': 'display_name',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            }

    def __init__(self,
                 container_cluster_id=None,
                 external_id=None,
                 network_errors=None,
                 network_status=None,
                 origin_properties=None,
                 links=None,
                 schema=None,
                 self_=None,
                 last_sync_time=None,
                 description=None,
                 display_name=None,
                 resource_type='ContainerProject',
                 tags=None,
                ):
        """
        :type  container_cluster_id: :class:`str` or ``None``
        :param container_cluster_id: Identifier of the container cluster to which this project/namespace
            belongs.
        :type  external_id: :class:`str` or ``None``
        :param external_id: External identifier of the container project.
        :type  network_errors: :class:`list` of :class:`NetworkError` or ``None``
        :param network_errors: List of network errors related to container project.
        :type  network_status: :class:`str` or ``None``
        :param network_status: Possible values are: 
            
            * :attr:`ContainerProject.NETWORK_STATUS_HEALTHY`
            * :attr:`ContainerProject.NETWORK_STATUS_UNHEALTHY`
            
             Network status of container project.
        :type  origin_properties: :class:`list` of :class:`KeyValuePair` or ``None``
        :param origin_properties: Array of additional specific properties of container project in
            key-value format.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  last_sync_time: :class:`long` or ``None``
        :param last_sync_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  resource_type: :class:`str`
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        """
        self.container_cluster_id = container_cluster_id
        self.external_id = external_id
        self.network_errors = network_errors
        self.network_status = network_status
        self.origin_properties = origin_properties
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.last_sync_time = last_sync_time
        self.description = description
        self.display_name = display_name
        self._resource_type = resource_type
        self.tags = tags
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ContainerProject._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_project', {
        'container_cluster_id': type.OptionalType(type.StringType()),
        'external_id': type.OptionalType(type.StringType()),
        'network_errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NetworkError'))),
        'network_status': type.OptionalType(type.StringType()),
        'origin_properties': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'KeyValuePair'))),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_last_sync_time': type.OptionalType(type.IntegerType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
    },
    ContainerProject,
    False,
    None))



class ContainerProjectListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ContainerProject` or ``None``
        :param results: List of projects
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ContainerProjectListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_project_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ContainerProject'))),
    },
    ContainerProjectListResult,
    False,
    None))



class ControlClusterNodeStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    CONTROL_CLUSTER_STATUS_CONNECTED = "CONNECTED"
    """


    """
    CONTROL_CLUSTER_STATUS_DISCONNECTED = "DISCONNECTED"
    """


    """
    CONTROL_CLUSTER_STATUS_UNKNOWN = "UNKNOWN"
    """


    """



    _canonical_to_pep_names = {
                            'control_cluster_status': 'control_cluster_status',
                            'mgmt_connection_status': 'mgmt_connection_status',
                            }

    def __init__(self,
                 control_cluster_status=None,
                 mgmt_connection_status=None,
                ):
        """
        :type  control_cluster_status: :class:`str` or ``None``
        :param control_cluster_status: Possible values are: 
            
            * :attr:`ControlClusterNodeStatus.CONTROL_CLUSTER_STATUS_CONNECTED`
            *
              :attr:`ControlClusterNodeStatus.CONTROL_CLUSTER_STATUS_DISCONNECTED`
            * :attr:`ControlClusterNodeStatus.CONTROL_CLUSTER_STATUS_UNKNOWN`
            
             Status of this node's connection to the control cluster
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  mgmt_connection_status: :class:`MgmtConnStatus` or ``None``
        :param mgmt_connection_status: Status of this node's management plane connection
        """
        self.control_cluster_status = control_cluster_status
        self.mgmt_connection_status = mgmt_connection_status
        VapiStruct.__init__(self)


ControlClusterNodeStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.control_cluster_node_status', {
        'control_cluster_status': type.OptionalType(type.StringType()),
        'mgmt_connection_status': type.OptionalType(type.ReferenceType(__name__, 'MgmtConnStatus')),
    },
    ControlClusterNodeStatus,
    False,
    None))



class ControlClusteringConfig(VapiStruct):
    """
    Config for joining cluster nodes VMs to a control cluster

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ControlClusteringConfig"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'join_to_existing_cluster': 'join_to_existing_cluster',
                            'shared_secret': 'shared_secret',
                            'clustering_type': 'clustering_type',
                            }

    def __init__(self,
                 join_to_existing_cluster=None,
                 shared_secret=None,
                 clustering_type='ControlClusteringConfig',
                ):
        """
        :type  join_to_existing_cluster: :class:`bool` or ``None``
        :param join_to_existing_cluster: Specifies whether or not the cluster node VM should try to join to
            the existing control cluster or initialize a new one. Only required
            in uncertainty case, i.e. when there are manually- deployed
            controllers that are registered but not connected to the cluster
            and no auto-deployed controllers are part of the cluster.
        :type  shared_secret: :class:`str` or ``None``
        :param shared_secret: Shared secret to be used when joining the cluster node VM to a
            control cluster or for initializing a new cluster with the VM. Must
            contain at least 4 unique characters and be at least 6 characters
            long.
        :type  clustering_type: :class:`str`
        :param clustering_type: Possible values are: 
            
            * :attr:`ClusteringConfig.CLUSTERING_TYPE_CONTROLCLUSTERINGCONFIG`
            
             Specifies the type of clustering config to be used.
        """
        self.join_to_existing_cluster = join_to_existing_cluster
        self.shared_secret = shared_secret
        self._clustering_type = clustering_type
        VapiStruct.__init__(self)

    @property
    def clustering_type(self):
        """
        Return the discriminator value
        """
        return self._clustering_type

ControlClusteringConfig._set_binding_type(type.StructType(
    'com.vmware.nsx.model.control_clustering_config', {
        'join_to_existing_cluster': type.OptionalType(type.BooleanType()),
        'shared_secret': type.OptionalType(type.StringType()),
        'clustering_type': type.StringType(),
    },
    ControlClusteringConfig,
    False,
    None))



class ControlConnStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    FAILURE_STATUS_CONNECTION_REFUSED = "CONNECTION_REFUSED"
    """


    """
    FAILURE_STATUS_INCOMPLETE_HOST_CERT = "INCOMPLETE_HOST_CERT"
    """


    """
    FAILURE_STATUS_INCOMPLETE_CONTROLLER_CERT = "INCOMPLETE_CONTROLLER_CERT"
    """


    """
    FAILURE_STATUS_CONTROLLER_REJECTED_HOST_CERT = "CONTROLLER_REJECTED_HOST_CERT"
    """


    """
    FAILURE_STATUS_HOST_REJECTED_CONTROLLER_CERT = "HOST_REJECTED_CONTROLLER_CERT"
    """


    """
    FAILURE_STATUS_KEEP_ALIVE_TIMEOUT = "KEEP_ALIVE_TIMEOUT"
    """


    """
    FAILURE_STATUS_OTHER_SSL_ERROR = "OTHER_SSL_ERROR"
    """


    """
    FAILURE_STATUS_OTHER_ERROR = "OTHER_ERROR"
    """


    """
    STATUS_UP = "UP"
    """


    """
    STATUS_DOWN = "DOWN"
    """


    """



    _canonical_to_pep_names = {
                            'control_node_ip': 'control_node_ip',
                            'failure_status': 'failure_status',
                            'status': 'status',
                            }

    def __init__(self,
                 control_node_ip=None,
                 failure_status=None,
                 status=None,
                ):
        """
        :type  control_node_ip: :class:`str` or ``None``
        :param control_node_ip: IP address of the control Node.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  failure_status: :class:`str` or ``None``
        :param failure_status: Possible values are: 
            
            * :attr:`ControlConnStatus.FAILURE_STATUS_CONNECTION_REFUSED`
            * :attr:`ControlConnStatus.FAILURE_STATUS_INCOMPLETE_HOST_CERT`
            *
              :attr:`ControlConnStatus.FAILURE_STATUS_INCOMPLETE_CONTROLLER_CERT`
            *
              :attr:`ControlConnStatus.FAILURE_STATUS_CONTROLLER_REJECTED_HOST_CERT`
            *
              :attr:`ControlConnStatus.FAILURE_STATUS_HOST_REJECTED_CONTROLLER_CERT`
            * :attr:`ControlConnStatus.FAILURE_STATUS_KEEP_ALIVE_TIMEOUT`
            * :attr:`ControlConnStatus.FAILURE_STATUS_OTHER_SSL_ERROR`
            * :attr:`ControlConnStatus.FAILURE_STATUS_OTHER_ERROR`
            
            Failure status of the control Node for e.g
            CONNECTION_REFUSED,INCOMPLETE_HOST_CERT.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ControlConnStatus.STATUS_UP`
            * :attr:`ControlConnStatus.STATUS_DOWN`
            
             Status of the control Node for e.g UP, DOWN.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.control_node_ip = control_node_ip
        self.failure_status = failure_status
        self.status = status
        VapiStruct.__init__(self)


ControlConnStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.control_conn_status', {
        'control_node_ip': type.OptionalType(type.StringType()),
        'failure_status': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
    },
    ControlConnStatus,
    False,
    None))



class ControllerClusterRoleConfig(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_MANAGEMENTCLUSTERROLECONFIG = "ManagementClusterRoleConfig"
    """


    """
    TYPE_CONTROLLERCLUSTERROLECONFIG = "ControllerClusterRoleConfig"
    """


    """



    _canonical_to_pep_names = {
                            'type': 'type',
                            'control_cluster_listen_addr': 'control_cluster_listen_addr',
                            'control_plane_listen_addr': 'control_plane_listen_addr',
                            'host_msg_client_info': 'host_msg_client_info',
                            'mpa_msg_client_info': 'mpa_msg_client_info',
                            }

    def __init__(self,
                 type=None,
                 control_cluster_listen_addr=None,
                 control_plane_listen_addr=None,
                 host_msg_client_info=None,
                 mpa_msg_client_info=None,
                ):
        """
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            *
              :attr:`ControllerClusterRoleConfig.TYPE_MANAGEMENTCLUSTERROLECONFIG`
            *
              :attr:`ControllerClusterRoleConfig.TYPE_CONTROLLERCLUSTERROLECONFIG`
            
             Type of this role configuration
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  control_cluster_listen_addr: :class:`ServiceEndpoint` or ``None``
        :param control_cluster_listen_addr: The IP and port for the control cluster service on this node
        :type  control_plane_listen_addr: :class:`ServiceEndpoint` or ``None``
        :param control_plane_listen_addr: The IP and port for the control plane service on this node
        :type  host_msg_client_info: :class:`MsgClientInfo` or ``None``
        :param host_msg_client_info: 
        :type  mpa_msg_client_info: :class:`MsgClientInfo` or ``None``
        :param mpa_msg_client_info: 
        """
        self.type = type
        self.control_cluster_listen_addr = control_cluster_listen_addr
        self.control_plane_listen_addr = control_plane_listen_addr
        self.host_msg_client_info = host_msg_client_info
        self.mpa_msg_client_info = mpa_msg_client_info
        VapiStruct.__init__(self)


ControllerClusterRoleConfig._set_binding_type(type.StructType(
    'com.vmware.nsx.model.controller_cluster_role_config', {
        'type': type.OptionalType(type.StringType()),
        'control_cluster_listen_addr': type.OptionalType(type.ReferenceType(__name__, 'ServiceEndpoint')),
        'control_plane_listen_addr': type.OptionalType(type.ReferenceType(__name__, 'ServiceEndpoint')),
        'host_msg_client_info': type.OptionalType(type.ReferenceType(__name__, 'MsgClientInfo')),
        'mpa_msg_client_info': type.OptionalType(type.ReferenceType(__name__, 'MsgClientInfo')),
    },
    ControllerClusterRoleConfig,
    False,
    None))



class ControllerClusterStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_NO_CONTROLLERS = "NO_CONTROLLERS"
    """


    """
    STATUS_UNSTABLE = "UNSTABLE"
    """


    """
    STATUS_DEGRADED = "DEGRADED"
    """


    """
    STATUS_STABLE = "STABLE"
    """


    """
    STATUS_UNKNOWN = "UNKNOWN"
    """


    """



    _canonical_to_pep_names = {
                            'status': 'status',
                            }

    def __init__(self,
                 status=None,
                ):
        """
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ControllerClusterStatus.STATUS_NO_CONTROLLERS`
            * :attr:`ControllerClusterStatus.STATUS_UNSTABLE`
            * :attr:`ControllerClusterStatus.STATUS_DEGRADED`
            * :attr:`ControllerClusterStatus.STATUS_STABLE`
            * :attr:`ControllerClusterStatus.STATUS_UNKNOWN`
            
             The current status of the controller cluster
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.status = status
        VapiStruct.__init__(self)


ControllerClusterStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.controller_cluster_status', {
        'status': type.OptionalType(type.StringType()),
    },
    ControllerClusterStatus,
    False,
    None))



class ControllerNodeAggregateInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'display_name': 'display_name',
                            'id': 'id',
                            'node_interface_properties': 'node_interface_properties',
                            'node_interface_statistics': 'node_interface_statistics',
                            'node_status': 'node_status',
                            'node_status_properties': 'node_status_properties',
                            'role_config': 'role_config',
                            }

    def __init__(self,
                 display_name=None,
                 id=None,
                 node_interface_properties=None,
                 node_interface_statistics=None,
                 node_status=None,
                 node_status_properties=None,
                 role_config=None,
                ):
        """
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_interface_properties: :class:`list` of :class:`NodeInterfaceProperties` or ``None``
        :param node_interface_properties: Array of Node interface statistic properties
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_interface_statistics: :class:`list` of :class:`NodeInterfaceStatisticsProperties` or ``None``
        :param node_interface_statistics: Array of Node network interface statistic properties
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_status: :class:`ClusterNodeStatus` or ``None``
        :param node_status: 
        :type  node_status_properties: :class:`list` of :class:`NodeStatusProperties` or ``None``
        :param node_status_properties: Time series of the node's system properties
        :type  role_config: :class:`ControllerClusterRoleConfig` or ``None``
        :param role_config: 
        """
        self.display_name = display_name
        self.id = id
        self.node_interface_properties = node_interface_properties
        self.node_interface_statistics = node_interface_statistics
        self.node_status = node_status
        self.node_status_properties = node_status_properties
        self.role_config = role_config
        VapiStruct.__init__(self)


ControllerNodeAggregateInfo._set_binding_type(type.StructType(
    'com.vmware.nsx.model.controller_node_aggregate_info', {
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'node_interface_properties': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NodeInterfaceProperties'))),
        'node_interface_statistics': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NodeInterfaceStatisticsProperties'))),
        'node_status': type.OptionalType(type.ReferenceType(__name__, 'ClusterNodeStatus')),
        'node_status_properties': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NodeStatusProperties'))),
        'role_config': type.OptionalType(type.ReferenceType(__name__, 'ControllerClusterRoleConfig')),
    },
    ControllerNodeAggregateInfo,
    False,
    None))



class ControllerProfilerProperties(VapiStruct):
    """
    Controller profiler properties

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'enabled': 'enabled',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 enabled=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  enabled: :class:`bool` or ``None``
        :param enabled: True for enabling controller profiler, False for disabling
            controller profiler.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.enabled = enabled
        VapiStruct.__init__(self)


ControllerProfilerProperties._set_binding_type(type.StructType(
    'com.vmware.nsx.model.controller_profiler_properties', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'enabled': type.OptionalType(type.BooleanType()),
    },
    ControllerProfilerProperties,
    False,
    None))



class CopyFromRemoteFileProperties(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'port': 'port',
                            'server': 'server',
                            'uri': 'uri',
                            'protocol': 'protocol',
                            }

    def __init__(self,
                 port=None,
                 server=None,
                 uri=None,
                 protocol=None,
                ):
        """
        :type  port: :class:`long` or ``None``
        :param port: Server port format: int64
        :type  server: :class:`str` or ``None``
        :param server: Remote server hostname or IP address
        :type  uri: :class:`str` or ``None``
        :param uri: URI of file to copy
        :type  protocol: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param protocol: Protocol to use to copy file
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`Protocol`. When methods return a value of this class as a
            return value, the attribute will contain all the attributes defined
            in :class:`Protocol`.
        """
        self.port = port
        self.server = server
        self.uri = uri
        self.protocol = protocol
        VapiStruct.__init__(self)


CopyFromRemoteFileProperties._set_binding_type(type.StructType(
    'com.vmware.nsx.model.copy_from_remote_file_properties', {
        'port': type.OptionalType(type.IntegerType()),
        'server': type.OptionalType(type.StringType()),
        'uri': type.OptionalType(type.StringType()),
        'protocol': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'Protocol')])),
    },
    CopyFromRemoteFileProperties,
    False,
    None))



class CopyRemoteFileProperties(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'port': 'port',
                            'server': 'server',
                            'uri': 'uri',
                            }

    def __init__(self,
                 port=None,
                 server=None,
                 uri=None,
                ):
        """
        :type  port: :class:`long` or ``None``
        :param port: Server port format: int64
        :type  server: :class:`str` or ``None``
        :param server: Remote server hostname or IP address
        :type  uri: :class:`str` or ``None``
        :param uri: URI of file to copy
        """
        self.port = port
        self.server = server
        self.uri = uri
        VapiStruct.__init__(self)


CopyRemoteFileProperties._set_binding_type(type.StructType(
    'com.vmware.nsx.model.copy_remote_file_properties', {
        'port': type.OptionalType(type.IntegerType()),
        'server': type.OptionalType(type.StringType()),
        'uri': type.OptionalType(type.StringType()),
    },
    CopyRemoteFileProperties,
    False,
    None))



class CopyToRemoteFileProperties(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'port': 'port',
                            'server': 'server',
                            'uri': 'uri',
                            'protocol': 'protocol',
                            }

    def __init__(self,
                 port=None,
                 server=None,
                 uri=None,
                 protocol=None,
                ):
        """
        :type  port: :class:`long` or ``None``
        :param port: Server port format: int64
        :type  server: :class:`str` or ``None``
        :param server: Remote server hostname or IP address
        :type  uri: :class:`str` or ``None``
        :param uri: URI of file to copy
        :type  protocol: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param protocol: Only scp and sftp may be used.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`Protocol`. When methods return a value of this class as a
            return value, the attribute will contain all the attributes defined
            in :class:`Protocol`.
        """
        self.port = port
        self.server = server
        self.uri = uri
        self.protocol = protocol
        VapiStruct.__init__(self)


CopyToRemoteFileProperties._set_binding_type(type.StructType(
    'com.vmware.nsx.model.copy_to_remote_file_properties', {
        'port': type.OptionalType(type.IntegerType()),
        'server': type.OptionalType(type.StringType()),
        'uri': type.OptionalType(type.StringType()),
        'protocol': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'Protocol')])),
    },
    CopyToRemoteFileProperties,
    False,
    None))



class CpuCoreConfigForEnhancedNetworkingStackSwitch(VapiStruct):
    """
    Non Uniform Memory Access (NUMA) nodes and Logical cpu cores (Lcores) per
    NUMA node configuration for Enhanced Networking Stack enabled HostSwitch.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'num_lcores': 'num_lcores',
                            'numa_node_index': 'numa_node_index',
                            }

    def __init__(self,
                 num_lcores=None,
                 numa_node_index=None,
                ):
        """
        :type  num_lcores: :class:`long` or ``None``
        :param num_lcores: Number of Logical cpu cores (Lcores) to be placed on a specified
            NUMA node format: int32
        :type  numa_node_index: :class:`long` or ``None``
        :param numa_node_index: Unique index of the Non Uniform Memory Access (NUMA) node format:
            int32
        """
        self.num_lcores = num_lcores
        self.numa_node_index = numa_node_index
        VapiStruct.__init__(self)


CpuCoreConfigForEnhancedNetworkingStackSwitch._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cpu_core_config_for_enhanced_networking_stack_switch', {
        'num_lcores': type.OptionalType(type.IntegerType()),
        'numa_node_index': type.OptionalType(type.IntegerType()),
    },
    CpuCoreConfigForEnhancedNetworkingStackSwitch,
    False,
    None))



class CpuUsage(VapiStruct):
    """
    CPU usage of DPDK and non-DPDK cores

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'avg_cpu_core_usage_dpdk': 'avg_cpu_core_usage_dpdk',
                            'avg_cpu_core_usage_non_dpdk': 'avg_cpu_core_usage_non_dpdk',
                            'highest_cpu_core_usage_dpdk': 'highest_cpu_core_usage_dpdk',
                            'highest_cpu_core_usage_non_dpdk': 'highest_cpu_core_usage_non_dpdk',
                            }

    def __init__(self,
                 avg_cpu_core_usage_dpdk=None,
                 avg_cpu_core_usage_non_dpdk=None,
                 highest_cpu_core_usage_dpdk=None,
                 highest_cpu_core_usage_non_dpdk=None,
                ):
        """
        :type  avg_cpu_core_usage_dpdk: :class:`float` or ``None``
        :param avg_cpu_core_usage_dpdk: Indicates the average usage of all DPDK cores in percentage.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  avg_cpu_core_usage_non_dpdk: :class:`float` or ``None``
        :param avg_cpu_core_usage_non_dpdk: Indicates the average usage of all non-DPDK cores in percentage.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  highest_cpu_core_usage_dpdk: :class:`float` or ``None``
        :param highest_cpu_core_usage_dpdk: Indicates the highest CPU utilization value among DPDK cores in
            percentage.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  highest_cpu_core_usage_non_dpdk: :class:`float` or ``None``
        :param highest_cpu_core_usage_non_dpdk: Indicates the highest cpu utilization value among non_dpdk cores in
            percentage.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.avg_cpu_core_usage_dpdk = avg_cpu_core_usage_dpdk
        self.avg_cpu_core_usage_non_dpdk = avg_cpu_core_usage_non_dpdk
        self.highest_cpu_core_usage_dpdk = highest_cpu_core_usage_dpdk
        self.highest_cpu_core_usage_non_dpdk = highest_cpu_core_usage_non_dpdk
        VapiStruct.__init__(self)


CpuUsage._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cpu_usage', {
        'avg_cpu_core_usage_dpdk': type.OptionalType(type.DoubleType()),
        'avg_cpu_core_usage_non_dpdk': type.OptionalType(type.DoubleType()),
        'highest_cpu_core_usage_dpdk': type.OptionalType(type.DoubleType()),
        'highest_cpu_core_usage_non_dpdk': type.OptionalType(type.DoubleType()),
    },
    CpuUsage,
    False,
    None))



class CreateRemoteDirectoryProperties(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'port': 'port',
                            'server': 'server',
                            'uri': 'uri',
                            'protocol': 'protocol',
                            }

    def __init__(self,
                 port=None,
                 server=None,
                 uri=None,
                 protocol=None,
                ):
        """
        :type  port: :class:`long` or ``None``
        :param port: Server port format: int64
        :type  server: :class:`str` or ``None``
        :param server: Remote server hostname or IP address
        :type  uri: :class:`str` or ``None``
        :param uri: URI of file to copy
        :type  protocol: :class:`SftpProtocol` or ``None``
        :param protocol: Protocol to use to copy file
        """
        self.port = port
        self.server = server
        self.uri = uri
        self.protocol = protocol
        VapiStruct.__init__(self)


CreateRemoteDirectoryProperties._set_binding_type(type.StructType(
    'com.vmware.nsx.model.create_remote_directory_properties', {
        'port': type.OptionalType(type.IntegerType()),
        'server': type.OptionalType(type.StringType()),
        'uri': type.OptionalType(type.StringType()),
        'protocol': type.OptionalType(type.ReferenceType(__name__, 'SftpProtocol')),
    },
    CreateRemoteDirectoryProperties,
    False,
    None))



class Crl(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'details': 'details',
                            'pem_encoded': 'pem_encoded',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 details=None,
                 pem_encoded=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  details: :class:`X509Crl` or ``None``
        :param details: Details of the X509Crl object.
        :type  pem_encoded: :class:`str` or ``None``
        :param pem_encoded: PEM encoded CRL data.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.details = details
        self.pem_encoded = pem_encoded
        VapiStruct.__init__(self)


Crl._set_binding_type(type.StructType(
    'com.vmware.nsx.model.crl', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'details': type.OptionalType(type.ReferenceType(__name__, 'X509Crl')),
        'pem_encoded': type.OptionalType(type.StringType()),
    },
    Crl,
    False,
    None))



class CrlDistributionPoint(VapiStruct):
    """
    Reference to a CRL Distribution Point where to fetch a CRL

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'cdp_uri': 'cdp_uri',
                            'issuer': 'issuer',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 cdp_uri=None,
                 issuer=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  cdp_uri: :class:`str` or ``None``
        :param cdp_uri: CRL Distribution Point URI where to fetch the CRL.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  issuer: :class:`str` or ``None``
        :param issuer: Issuer of the CRL, referring to the CA.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.cdp_uri = cdp_uri
        self.issuer = issuer
        VapiStruct.__init__(self)


CrlDistributionPoint._set_binding_type(type.StructType(
    'com.vmware.nsx.model.crl_distribution_point', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'cdp_uri': type.OptionalType(type.StringType()),
        'issuer': type.OptionalType(type.StringType()),
    },
    CrlDistributionPoint,
    False,
    None))



class CrlDistributionPointList(VapiStruct):
    """
    CrlDistributionPoint query result

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`CrlDistributionPoint` or ``None``
        :param results: CrlDistributionPoint list.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


CrlDistributionPointList._set_binding_type(type.StructType(
    'com.vmware.nsx.model.crl_distribution_point_list', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CrlDistributionPoint'))),
    },
    CrlDistributionPointList,
    False,
    None))



class CrlDistributionPointStatus(VapiStruct):
    """
    Reference to a CRL Distribution Point where to fetch a CRL

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_NOT_READY = "NOT_READY"
    """


    """
    STATUS_FETCHING = "FETCHING"
    """


    """
    STATUS_READY = "READY"
    """


    """
    STATUS_ERROR = "ERROR"
    """


    """



    _canonical_to_pep_names = {
                            'error_message': 'error_message',
                            'status': 'status',
                            }

    def __init__(self,
                 error_message=None,
                 status=None,
                ):
        """
        :type  error_message: :class:`str` or ``None``
        :param error_message: Error message when fetching the CRL failed.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`CrlDistributionPointStatus.STATUS_NOT_READY`
            * :attr:`CrlDistributionPointStatus.STATUS_FETCHING`
            * :attr:`CrlDistributionPointStatus.STATUS_READY`
            * :attr:`CrlDistributionPointStatus.STATUS_ERROR`
            
             Status of the fetched CRL for this CrlDistributionPoint
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.error_message = error_message
        self.status = status
        VapiStruct.__init__(self)


CrlDistributionPointStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.crl_distribution_point_status', {
        'error_message': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
    },
    CrlDistributionPointStatus,
    False,
    None))



class CrlList(VapiStruct):
    """
    Crl queries result

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`Crl` or ``None``
        :param results: CRL list.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


CrlList._set_binding_type(type.StructType(
    'com.vmware.nsx.model.crl_list', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Crl'))),
    },
    CrlList,
    False,
    None))



class CrlObjectData(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'pem_encoded': 'pem_encoded',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 pem_encoded=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  pem_encoded: :class:`str` or ``None``
        :param pem_encoded: PEM encoded CRL data.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.pem_encoded = pem_encoded
        VapiStruct.__init__(self)


CrlObjectData._set_binding_type(type.StructType(
    'com.vmware.nsx.model.crl_object_data', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'pem_encoded': type.OptionalType(type.StringType()),
    },
    CrlObjectData,
    False,
    None))



class CrlPemRequestType(VapiStruct):
    """
    Request Type to get a CRL's PEM file.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'cdp_uri': 'cdp_uri',
                            }

    def __init__(self,
                 cdp_uri=None,
                ):
        """
        :type  cdp_uri: :class:`str` or ``None``
        :param cdp_uri: CRL Distribution Point URI where to fetch the CRL.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.cdp_uri = cdp_uri
        VapiStruct.__init__(self)


CrlPemRequestType._set_binding_type(type.StructType(
    'com.vmware.nsx.model.crl_pem_request_type', {
        'cdp_uri': type.OptionalType(type.StringType()),
    },
    CrlPemRequestType,
    False,
    None))



class CryptoAlgorithm(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'key_size': 'key_size',
                            'name': 'name',
                            }

    def __init__(self,
                 key_size=None,
                 name=None,
                ):
        """
        :type  key_size: :class:`list` of :class:`long` or ``None``
        :param key_size: Supported key sizes for the algorithm. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  name: :class:`str` or ``None``
        :param name: Crypto algorithm name.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.key_size = key_size
        self.name = name
        VapiStruct.__init__(self)


CryptoAlgorithm._set_binding_type(type.StructType(
    'com.vmware.nsx.model.crypto_algorithm', {
        'key_size': type.OptionalType(type.ListType(type.IntegerType())),
        'name': type.OptionalType(type.StringType()),
    },
    CryptoAlgorithm,
    False,
    None))



class Csr(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ALGORITHM_RSA = "RSA"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'algorithm': 'algorithm',
                            'key_size': 'key_size',
                            'pem_encoded': 'pem_encoded',
                            'subject': 'subject',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 algorithm=None,
                 key_size=None,
                 pem_encoded=None,
                 subject=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  algorithm: :class:`str` or ``None``
        :param algorithm: Possible values are: 
            
            * :attr:`Csr.ALGORITHM_RSA`
            
            Cryptographic algorithm(asymmetric ) used by the public key for
            data encryption.
        :type  key_size: :class:`long` or ``None``
        :param key_size: Size measured in bits of the public key used in a cryptographic
            algorithm. format: int64
        :type  pem_encoded: :class:`str` or ``None``
        :param pem_encoded: PEM encoded certificate data.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  subject: :class:`Principal` or ``None``
        :param subject: The certificate owner's information. (CN, O, OU, C, ST, L)
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.algorithm = algorithm
        self.key_size = key_size
        self.pem_encoded = pem_encoded
        self.subject = subject
        VapiStruct.__init__(self)


Csr._set_binding_type(type.StructType(
    'com.vmware.nsx.model.csr', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'algorithm': type.OptionalType(type.StringType()),
        'key_size': type.OptionalType(type.IntegerType()),
        'pem_encoded': type.OptionalType(type.StringType()),
        'subject': type.OptionalType(type.ReferenceType(__name__, 'Principal')),
    },
    Csr,
    False,
    None))



class CsrList(VapiStruct):
    """
    Csr queries result

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`Csr` or ``None``
        :param results: CSR list.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


CsrList._set_binding_type(type.StructType(
    'com.vmware.nsx.model.csr_list', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Csr'))),
    },
    CsrList,
    False,
    None))



class CsvListResult(VapiStruct):
    """
    Base type for CSV result.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'file_name': 'file_name',
                            }

    def __init__(self,
                 file_name=None,
                ):
        """
        :type  file_name: :class:`str` or ``None``
        :param file_name: File name set by HTTP server if API returns CSV result as a file.
        """
        self.file_name = file_name
        VapiStruct.__init__(self)


CsvListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.csv_list_result', {
        'file_name': type.OptionalType(type.StringType()),
    },
    CsvListResult,
    False,
    None))



class CsvRecord(VapiStruct):
    """
    Base type for CSV records.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                ):
        """
        """
        VapiStruct.__init__(self)


CsvRecord._set_binding_type(type.StructType(
    'com.vmware.nsx.model.csv_record', {
    },
    CsvRecord,
    False,
    None))



class CurrentBackupOperationStatus(VapiStruct):
    """
    Current backup operation status

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    CURRENT_STEP_CLUSTER_BACKUP = "BACKUP_CREATING_CLUSTER_BACKUP"
    """


    """
    CURRENT_STEP_NODE_BACKUP = "BACKUP_CREATING_NODE_BACKUP"
    """


    """
    OPERATION_TYPE_NONE = "NONE"
    """


    """
    OPERATION_TYPE_BACKUP = "BACKUP"
    """


    """



    _canonical_to_pep_names = {
                            'backup_id': 'backup_id',
                            'current_step': 'current_step',
                            'current_step_message': 'current_step_message',
                            'end_time': 'end_time',
                            'operation_type': 'operation_type',
                            'start_time': 'start_time',
                            }

    def __init__(self,
                 backup_id=None,
                 current_step=None,
                 current_step_message=None,
                 end_time=None,
                 operation_type=None,
                 start_time=None,
                ):
        """
        :type  backup_id: :class:`str` or ``None``
        :param backup_id: Unique identifier of current backup
        :type  current_step: :class:`str` or ``None``
        :param current_step: Possible values are: 
            
            * :attr:`CurrentBackupOperationStatus.CURRENT_STEP_CLUSTER_BACKUP`
            * :attr:`CurrentBackupOperationStatus.CURRENT_STEP_NODE_BACKUP`
            
             Current step of operation
        :type  current_step_message: :class:`str` or ``None``
        :param current_step_message: Additional human-readable status information about current step
        :type  end_time: :class:`long` or ``None``
        :param end_time: Time when operation is expected to end format: int64
        :type  operation_type: :class:`str` or ``None``
        :param operation_type: Possible values are: 
            
            * :attr:`CurrentBackupOperationStatus.OPERATION_TYPE_NONE`
            * :attr:`CurrentBackupOperationStatus.OPERATION_TYPE_BACKUP`
            
            Type of operation that is in progress. Returns none if no operation
            is in progress, in which case none of the other fields will be set.
        :type  start_time: :class:`long` or ``None``
        :param start_time: Time when operation was started format: int64
        """
        self.backup_id = backup_id
        self.current_step = current_step
        self.current_step_message = current_step_message
        self.end_time = end_time
        self.operation_type = operation_type
        self.start_time = start_time
        VapiStruct.__init__(self)


CurrentBackupOperationStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.current_backup_operation_status', {
        'backup_id': type.OptionalType(type.StringType()),
        'current_step': type.OptionalType(type.StringType()),
        'current_step_message': type.OptionalType(type.StringType()),
        'end_time': type.OptionalType(type.IntegerType()),
        'operation_type': type.OptionalType(type.StringType()),
        'start_time': type.OptionalType(type.IntegerType()),
    },
    CurrentBackupOperationStatus,
    False,
    None))



class CurrentRealizationStateBarrier(VapiStruct):
    """
    The current global barrier number of the realized state

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'current_barrier_number': 'current_barrier_number',
                            }

    def __init__(self,
                 current_barrier_number=None,
                ):
        """
        :type  current_barrier_number: :class:`long` or ``None``
        :param current_barrier_number: Gives the current global barrier number for NSX format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.current_barrier_number = current_barrier_number
        VapiStruct.__init__(self)


CurrentRealizationStateBarrier._set_binding_type(type.StructType(
    'com.vmware.nsx.model.current_realization_state_barrier', {
        'current_barrier_number': type.OptionalType(type.IntegerType()),
    },
    CurrentRealizationStateBarrier,
    False,
    None))



class CustomWidgetConfiguration(VapiStruct):
    """
    Represents configuration for custom widget. For this widget the data source
    is not applicable. It defines ui identifer to identify UI component and
    render it on dashboard view. This configuration can only be used for system
    owned widgets.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "CustomWidgetConfiguration"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'ui_component_identifier': 'ui_component_identifier',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'datasources': 'datasources',
                            'default_filter_value': 'default_filter_value',
                            'drilldown_id': 'drilldown_id',
                            'filter': 'filter',
                            'filter_value_required': 'filter_value_required',
                            'footer': 'footer',
                            'icons': 'icons',
                            'is_drilldown': 'is_drilldown',
                            'legend': 'legend',
                            'shared': 'shared',
                            'span': 'span',
                            'weight': 'weight',
                            }

    def __init__(self,
                 ui_component_identifier=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='CustomWidgetConfiguration',
                 tags=None,
                 datasources=None,
                 default_filter_value=None,
                 drilldown_id=None,
                 filter=None,
                 filter_value_required=None,
                 footer=None,
                 icons=None,
                 is_drilldown=None,
                 legend=None,
                 shared=None,
                 span=None,
                 weight=None,
                ):
        """
        :type  ui_component_identifier: :class:`str` or ``None``
        :param ui_component_identifier: User defined component selector to be rendered inside
            view/container.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Title of the widget. If display_name is omitted, the widget will be
            shown without a title.
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`WidgetConfiguration.RESOURCE_TYPE_LABELVALUECONFIGURATION`
            * :attr:`WidgetConfiguration.RESOURCE_TYPE_DONUTCONFIGURATION`
            *
              :attr:`WidgetConfiguration.RESOURCE_TYPE_MULTIWIDGETCONFIGURATION`
            * :attr:`WidgetConfiguration.RESOURCE_TYPE_CONTAINERCONFIGURATION`
            * :attr:`WidgetConfiguration.RESOURCE_TYPE_STATSCONFIGURATION`
            * :attr:`WidgetConfiguration.RESOURCE_TYPE_GRIDCONFIGURATION`
            * :attr:`WidgetConfiguration.RESOURCE_TYPE_GRAPHCONFIGURATION`
            *
              :attr:`WidgetConfiguration.RESOURCE_TYPE_CUSTOMWIDGETCONFIGURATION`
            *
              :attr:`WidgetConfiguration.RESOURCE_TYPE_DROPDOWNFILTERWIDGETCONFIGURATION`
            
            Supported visualization types are LabelValueConfiguration,
            DonutConfiguration, GridConfiguration, StatsConfiguration,
            MultiWidgetConfiguration, GraphConfiguration,
            ContainerConfiguration, CustomWidgetConfiguration and
            DropdownFilterWidgetConfiguration.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  datasources: :class:`list` of :class:`Datasource` or ``None``
        :param datasources: The 'datasources' represent the sources from which data will be
            fetched. Currently, only NSX-API is supported as a 'default'
            datasource. An example of specifying 'default' datasource along
            with the urls to fetch data from is given at 'example_request'
            section of 'CreateWidgetConfiguration' API.
        :type  default_filter_value: :class:`list` of :class:`DefaultFilterValue` or ``None``
        :param default_filter_value: Default filter values to be passed to datasources. This will be
            used when the report is requested without filter values.
        :type  drilldown_id: :class:`str` or ``None``
        :param drilldown_id: Id of drilldown widget, if any. Id should be a valid id of an
            existing widget. A widget is considered as drilldown widget when it
            is associated with any other widget and provides more detailed
            information about any data item from the parent widget.
        :type  filter: :class:`str` or ``None``
        :param filter: Id of filter widget for subscription, if any. Id should be a valid
            id of an existing filter widget. Filter widget should be from the
            same view. Datasource URLs should have placeholder values equal to
            filter alias to accept the filter value on filter change.
        :type  filter_value_required: :class:`bool` or ``None``
        :param filter_value_required: Flag to indicate that widget will continue to work without filter
            value. If this flag is set to false then default_filter_value is
            manadatory.
        :type  footer: :class:`Footer` or ``None``
        :param footer: 
        :type  icons: :class:`list` of :class:`Icon` or ``None``
        :param icons: Icons to be applied at dashboard for widgets and UI elements.
        :type  is_drilldown: :class:`bool` or ``None``
        :param is_drilldown: Set to true if this widget should be used as a drilldown.
        :type  legend: :class:`Legend` or ``None``
        :param legend: Legend to be displayed. If legend is not needed, do not include it.
        :type  shared: :class:`bool` or ``None``
        :param shared: Please use the property 'shared' of View instead of this. The
            widgets of a shared view are visible to other users.
        :type  span: :class:`long` or ``None``
        :param span: Represents the horizontal span of the widget / container. format:
            int32
        :type  weight: :class:`long` or ``None``
        :param weight: Specify relavite weight in WidgetItem for placement in a view.
            Please see WidgetItem for details. format: int32
        """
        self.ui_component_identifier = ui_component_identifier
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.datasources = datasources
        self.default_filter_value = default_filter_value
        self.drilldown_id = drilldown_id
        self.filter = filter
        self.filter_value_required = filter_value_required
        self.footer = footer
        self.icons = icons
        self.is_drilldown = is_drilldown
        self.legend = legend
        self.shared = shared
        self.span = span
        self.weight = weight
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

CustomWidgetConfiguration._set_binding_type(type.StructType(
    'com.vmware.nsx.model.custom_widget_configuration', {
        'ui_component_identifier': type.OptionalType(type.StringType()),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'datasources': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Datasource'))),
        'default_filter_value': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'DefaultFilterValue'))),
        'drilldown_id': type.OptionalType(type.StringType()),
        'filter': type.OptionalType(type.StringType()),
        'filter_value_required': type.OptionalType(type.BooleanType()),
        'footer': type.OptionalType(type.ReferenceType(__name__, 'Footer')),
        'icons': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Icon'))),
        'is_drilldown': type.OptionalType(type.BooleanType()),
        'legend': type.OptionalType(type.ReferenceType(__name__, 'Legend')),
        'shared': type.OptionalType(type.BooleanType()),
        'span': type.OptionalType(type.IntegerType()),
        'weight': type.OptionalType(type.IntegerType()),
    },
    CustomWidgetConfiguration,
    False,
    None))



class DADProfile(VapiStruct):
    """
    Duplicate address detection profile.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    DAD_MODE_LOOSE = "LOOSE"
    """


    """
    DAD_MODE_STRICT = "STRICT"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'dad_mode': 'dad_mode',
                            'ns_retries': 'ns_retries',
                            'wait_time': 'wait_time',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 dad_mode=None,
                 ns_retries=None,
                 wait_time=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: Link to this resource
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  dad_mode: :class:`str` or ``None``
        :param dad_mode: Possible values are: 
            
            * :attr:`DADProfile.DAD_MODE_LOOSE`
            * :attr:`DADProfile.DAD_MODE_STRICT`
            
             DAD Mode
        :type  ns_retries: :class:`long` or ``None``
        :param ns_retries: Number of Neighbor solicitation packets generated before completing
            the Duplicate address detection process. format: int64
        :type  wait_time: :class:`long` or ``None``
        :param wait_time: The time duration in seconds, to wait for Neighbor advertisement
            after sending the Neighbor solicitation message. format: int64
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.dad_mode = dad_mode
        self.ns_retries = ns_retries
        self.wait_time = wait_time
        VapiStruct.__init__(self)


DADProfile._set_binding_type(type.StructType(
    'com.vmware.nsx.model.DAD_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type