/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.helper;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;

public final class BufferUtil {
    private BufferUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int indexOf(String needle, ByteBuf haystack) {
        ByteBuf needleBuffer = Unpooled.wrappedBuffer((byte[])needle.getBytes(StandardCharsets.US_ASCII));
        try {
            int n = ByteBufUtil.indexOf((ByteBuf)needleBuffer, (ByteBuf)haystack);
            return n;
        }
        finally {
            needleBuffer.release();
        }
    }

    public static int indexOf(String needle, ByteBuf haystack, int startIndex, int endIndex) {
        ByteBuf wrappedHaystack = Unpooled.wrappedBuffer((ByteBuf)haystack);
        wrappedHaystack.readerIndex(startIndex - haystack.readerIndex());
        wrappedHaystack.writerIndex(endIndex - haystack.readerIndex());
        int result = BufferUtil.indexOf(needle, wrappedHaystack);
        return result < 0 ? result : haystack.readerIndex() + result;
    }
}

