/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import liquibase.util.SqlParser;
import liquibase.util.StringClauses;

public class StringUtils {
    private static final Pattern upperCasePattern = Pattern.compile(".*[A-Z].*");
    private static final Pattern lowerCasePattern = Pattern.compile(".*[a-z].*");
    private static final SecureRandom rnd = new SecureRandom();

    public static String trimToEmpty(String string) {
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    public static String trimToNull(String string) {
        if (string == null) {
            return null;
        }
        String returnString = string.trim();
        if (returnString.isEmpty()) {
            return null;
        }
        return returnString;
    }

    public static String[] processMutliLineSQL(String multiLineSQL, boolean stripComments, boolean splitStatements, String endDelimiter) {
        StringClauses parsed = SqlParser.parse(multiLineSQL, true, !stripComments);
        ArrayList<String> returnArray = new ArrayList<String>();
        StringBuilder currentString = new StringBuilder();
        String previousPiece = null;
        boolean previousDelimiter = false;
        List<Object> parsedArray = Arrays.asList(parsed.toArray(true));
        for (Object piece : StringUtils.mergeTokens(parsedArray, endDelimiter)) {
            if (splitStatements && piece instanceof String && StringUtils.isDelimiter((String)piece, previousPiece, endDelimiter)) {
                String trimmedString = StringUtils.trimToNull(currentString.toString());
                if (trimmedString != null) {
                    returnArray.add(trimmedString);
                }
                currentString = new StringBuilder();
                previousDelimiter = true;
            } else {
                if (!(previousDelimiter && StringUtils.trimToNull((String)piece) == null || currentString.length() <= 0 && StringUtils.trimToNull((String)piece) == null)) {
                    currentString.append(piece);
                }
                previousDelimiter = false;
            }
            previousPiece = (String)piece;
        }
        String trimmedString = StringUtils.trimToNull(currentString.toString());
        if (trimmedString != null) {
            returnArray.add(trimmedString);
        }
        return returnArray.toArray(new String[returnArray.size()]);
    }

    private static List<Object> mergeTokens(List<Object> parsedArray, String endDelimiter) {
        if (endDelimiter == null) {
            return parsedArray;
        }
        ArrayList<Object> returnList = new ArrayList<Object>();
        ArrayList<String> possibleMerge = new ArrayList<String>();
        for (Object obj : parsedArray) {
            if (possibleMerge.size() == 0) {
                if (obj instanceof String && endDelimiter.startsWith((String)obj)) {
                    possibleMerge.add((String)obj);
                    continue;
                }
                returnList.add(obj);
                continue;
            }
            String possibleMergeString = StringUtils.join(possibleMerge, "") + obj.toString();
            if (endDelimiter.equals(possibleMergeString)) {
                returnList.add(possibleMergeString);
                possibleMerge.clear();
                continue;
            }
            if (endDelimiter.startsWith(possibleMergeString)) {
                possibleMerge.add(obj.toString());
                continue;
            }
            returnList.addAll(possibleMerge);
            returnList.add(obj);
            possibleMerge.clear();
        }
        return returnList;
    }

    protected static boolean isDelimiter(String piece, String previousPiece, String endDelimiter) {
        if (endDelimiter == null) {
            return ";".equals(piece) || ("go".equalsIgnoreCase(piece) || "/".equals(piece)) && (previousPiece == null || previousPiece.endsWith("\n"));
        }
        if (endDelimiter.length() == 1) {
            return piece.toLowerCase().equalsIgnoreCase(endDelimiter.toLowerCase());
        }
        return piece.toLowerCase().matches(endDelimiter.toLowerCase()) || (previousPiece + piece).toLowerCase().matches("[\\s\n\r]*" + endDelimiter.toLowerCase());
    }

    public static String[] splitSQL(String multiLineSQL, String endDelimiter) {
        return StringUtils.processMutliLineSQL(multiLineSQL, false, true, endDelimiter);
    }

    public static String stripComments(String multiLineSQL) {
        return SqlParser.parse(multiLineSQL, true, false).toString().trim();
    }

    public static String join(Object[] array, String delimiter, StringUtilsFormatter formatter) {
        if (array == null) {
            return null;
        }
        return StringUtils.join(Arrays.asList(array), delimiter, formatter);
    }

    public static String join(String[] array, String delimiter) {
        return StringUtils.join(Arrays.asList(array), delimiter);
    }

    public static String join(Collection<String> collection, String delimiter) {
        return StringUtils.join(collection, delimiter, (StringUtilsFormatter)new ToStringFormatter());
    }

    public static String join(Collection collection, String delimiter, StringUtilsFormatter formatter) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (Object val : collection) {
            buffer.append(formatter.toString(val)).append(delimiter);
        }
        String returnString = buffer.toString();
        return returnString.substring(0, returnString.length() - delimiter.length());
    }

    public static String join(Collection collection, String delimiter, StringUtilsFormatter formatter, boolean sorted) {
        if (sorted) {
            TreeSet<String> sortedSet = new TreeSet<String>();
            for (Object obj : collection) {
                sortedSet.add(formatter.toString(obj));
            }
            return StringUtils.join(sortedSet, delimiter);
        }
        return StringUtils.join(collection, delimiter, formatter);
    }

    public static String join(Collection<String> collection, String delimiter, boolean sorted) {
        if (sorted) {
            return StringUtils.join(new TreeSet<String>(collection), delimiter);
        }
        return StringUtils.join(collection, delimiter);
    }

    public static String join(Map map, String delimiter) {
        return StringUtils.join(map, delimiter, (StringUtilsFormatter)new ToStringFormatter());
    }

    public static String join(Map map, String delimiter, StringUtilsFormatter formatter) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry entry : map.entrySet()) {
            list.add(entry.getKey().toString() + "=" + formatter.toString(entry.getValue()));
        }
        return StringUtils.join(list, delimiter);
    }

    public static List<String> splitAndTrim(String s2, String regex) {
        if (s2 == null) {
            return null;
        }
        ArrayList<String> returnList = new ArrayList<String>();
        for (String string : s2.split(regex)) {
            returnList.add(string.trim());
        }
        return returnList;
    }

    public static String repeat(String string, int times) {
        String returnString = "";
        for (int i2 = 0; i2 < times; ++i2) {
            returnString = returnString + string;
        }
        return returnString;
    }

    public static String join(Integer[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        int[] ints = new int[array.length];
        for (int i2 = 0; i2 < ints.length; ++i2) {
            ints[i2] = array[i2];
        }
        return StringUtils.join(ints, delimiter);
    }

    public static String join(int[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int val : array) {
            buffer.append(val).append(delimiter);
        }
        String returnString = buffer.toString();
        return returnString.substring(0, returnString.length() - delimiter.length());
    }

    public static String indent(String string) {
        return StringUtils.indent(string, 4);
    }

    public static String indent(String string, int padding) {
        String pad = StringUtils.repeat(" ", padding);
        return pad + string.replaceAll("\n", "\n" + pad);
    }

    public static String lowerCaseFirst(String string) {
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    public static String upperCaseFirst(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static boolean hasUpperCase(String string) {
        return upperCasePattern.matcher(string).matches();
    }

    public static boolean hasLowerCase(String string) {
        return lowerCasePattern.matcher(string).matches();
    }

    public static String standardizeLineEndings(String string) {
        if (string == null) {
            return null;
        }
        return string.replace("\r\n", "\n").replace("\r", "\n");
    }

    public static boolean isAscii(String string) {
        if (string == null) {
            return true;
        }
        for (char c2 : string.toCharArray()) {
            if (StringUtils.isAscii(c2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAscii(char ch2) {
        return ch2 < '\u0080';
    }

    public static String escapeHtml(String str) {
        StringBuilder out = new StringBuilder();
        int len = str.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = str.charAt(i2);
            if (c2 > '\u007f') {
                out.append("&#");
                out.append(Integer.toString(c2, 10));
                out.append(';');
                continue;
            }
            out.append(c2);
        }
        return out.toString();
    }

    public static String pad(String value, int length) {
        if ((value = StringUtils.trimToEmpty(value)).length() >= length) {
            return value;
        }
        return value + StringUtils.repeat(" ", length - value.length());
    }

    public static String leftPad(String value, int length) {
        if ((value = StringUtils.trimToEmpty(value)).length() >= length) {
            return value;
        }
        return StringUtils.repeat(" ", length - value.length()) + value;
    }

    public static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static boolean isNotEmpty(String value) {
        return !StringUtils.isEmpty(value);
    }

    public static boolean startsWith(String value, String startsWith) {
        if (value == null || startsWith == null) {
            return false;
        }
        return value.startsWith(startsWith);
    }

    public static boolean isWhitespace(CharSequence string) {
        if (string == null) {
            return true;
        }
        return StringUtils.trimToNull(string.toString()) == null;
    }

    public static boolean isMinimumVersion(String minimumVersion, int candidateMajor, int candidateMinor, int candidatePatch) {
        int minPatch;
        String[] parts = minimumVersion.split("\\.", 3);
        int minMajor = Integer.parseInt(parts[0]);
        int minMinor = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
        int n2 = minPatch = parts.length > 2 ? Integer.parseInt(parts[2]) : 0;
        if (minMajor > candidateMajor) {
            return false;
        }
        if (minMajor == candidateMajor && minMinor > candidateMinor) {
            return false;
        }
        return minMajor != candidateMajor || minMinor != candidateMinor || minPatch <= candidatePatch;
    }

    public static String limitSize(String string, int maxLength) {
        if (string.length() > maxLength) {
            return string.substring(0, maxLength - 3) + "...";
        }
        return string;
    }

    public static String randomIdentifer(int len) {
        String AB = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        StringBuilder sb = new StringBuilder(len);
        for (int i2 = 0; i2 < len; ++i2) {
            sb.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(rnd.nextInt("ABCDEFGHIJKLMNOPQRSTUVWXYZ".length())));
        }
        return sb.toString();
    }

    public static boolean equalsIgnoreCaseAndEmpty(String s1, String s2) {
        String clean1 = StringUtils.trimToNull(s1);
        String clean2 = StringUtils.trimToNull(s2);
        if (clean1 == null && clean2 == null) {
            return true;
        }
        if (clean1 == null || clean2 == null) {
            return false;
        }
        return clean1.equalsIgnoreCase(clean2);
    }

    public static String trimRight(String string) {
        int i2;
        for (i2 = string.length() - 1; i2 >= 0 && Character.isWhitespace(string.charAt(i2)); --i2) {
        }
        return string.substring(0, i2 + 1);
    }

    public static String getLastBlockComment(String sqlString) {
        if (StringUtils.isEmpty(sqlString) || sqlString.length() < 4) {
            return null;
        }
        StringBuilder reversedSqlStringBuilder = new StringBuilder(sqlString).reverse();
        String reversedString = reversedSqlStringBuilder.toString();
        int idxClosingLastChar = -1;
        int idxOpeningFirstChar = -1;
        for (int i2 = 0; i2 < reversedString.length(); ++i2) {
            char s2;
            char c2;
            if (idxClosingLastChar < 0) {
                c2 = reversedString.charAt(i2);
                if (c2 == '/') {
                    s2 = reversedString.charAt(i2 + 1);
                    if (s2 != '*') continue;
                    idxClosingLastChar = i2;
                    continue;
                }
                if (Character.isWhitespace(c2)) continue;
                return null;
            }
            c2 = reversedString.charAt(i2);
            if (c2 != '/') continue;
            s2 = reversedString.charAt(i2 - 1);
            char e2 = reversedString.charAt(i2 + 1);
            if (s2 != '*' || e2 == '\\') continue;
            idxOpeningFirstChar = i2;
            break;
        }
        int idxOfLastBlockComment = sqlString.length() - (idxOpeningFirstChar + 1);
        return sqlString.substring(idxOfLastBlockComment);
    }

    public static String getLastLineComment(String sqlString) {
        if (StringUtils.isEmpty(sqlString) || sqlString.length() < 2) {
            return null;
        }
        boolean startOfNewLine = false;
        int idxOfDoubleDash = -1;
        for (int i2 = 0; i2 < sqlString.length(); ++i2) {
            char c2 = sqlString.charAt(i2);
            if (c2 == '-') {
                char s2 = sqlString.charAt(i2 + 1);
                if (s2 != '-') continue;
                if (idxOfDoubleDash < 0) {
                    idxOfDoubleDash = i2;
                }
                startOfNewLine = false;
                continue;
            }
            if (!Character.isWhitespace(c2)) {
                if (!startOfNewLine) continue;
                idxOfDoubleDash = -1;
                continue;
            }
            if (c2 != '\r' && c2 != '\n') continue;
            startOfNewLine = true;
        }
        if (idxOfDoubleDash < 0) {
            return null;
        }
        return sqlString.substring(idxOfDoubleDash);
    }

    public static String stripSqlCommentsAndWhitespacesFromTheEnd(String sqlString) {
        if (StringUtils.isEmpty(sqlString)) {
            return sqlString;
        }
        StringBuilder str = new StringBuilder(sqlString);
        boolean strModified = true;
        while (strModified) {
            String lastLineComment;
            strModified = false;
            String lastBlockComment = StringUtils.getLastBlockComment(str.toString());
            if (StringUtils.isNotEmpty(lastBlockComment)) {
                str.setLength(str.length() - lastBlockComment.length());
                strModified = true;
            }
            if (!StringUtils.isNotEmpty(lastLineComment = StringUtils.getLastLineComment(str.toString()))) continue;
            str.setLength(str.length() - lastLineComment.length());
            strModified = true;
        }
        return StringUtils.trimRight(str.toString());
    }

    public static String substring(String str, int start, int end) {
        if (str == null) {
            return null;
        }
        if (end < 0) {
            end = str.length() + end;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return "";
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.substring(start, end);
    }

    public static String escapeXml(CharSequence s2) {
        StringBuilder sb = new StringBuilder();
        int len = s2.length();
        for (int i2 = 0; i2 < len; ++i2) {
            int c2 = s2.charAt(i2);
            if (c2 >= 55296 && c2 <= 56319 && i2 + 1 < len) {
                c2 = c2 - 55232 << 10 | s2.charAt(++i2) & 0x3FF;
            }
            if (c2 < 128) {
                if (c2 < 32 && c2 != 9 && c2 != 13 && c2 != 10) {
                    sb.append("&#xfffd;");
                    continue;
                }
                switch (c2) {
                    case 38: {
                        sb.append("&amp;");
                        break;
                    }
                    case 62: {
                        sb.append("&gt;");
                        break;
                    }
                    case 60: {
                        sb.append("&lt;");
                        break;
                    }
                    default: {
                        sb.append((char)c2);
                        break;
                    }
                }
                continue;
            }
            if (c2 >= 55296 && c2 <= 57343 || c2 == 65534 || c2 == 65535) {
                sb.append("&#xfffd;");
                continue;
            }
            sb.append("&#x");
            sb.append(Integer.toHexString(c2));
            sb.append(';');
        }
        return sb.toString();
    }

    public static class ToStringFormatter
    implements StringUtilsFormatter {
        public String toString(Object obj) {
            if (obj == null) {
                return null;
            }
            return obj.toString();
        }
    }

    public static interface StringUtilsFormatter<Type> {
        public String toString(Type var1);
    }
}

