/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.beans.Introspector;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import javax.sql.DataSource;
import liquibase.Contexts;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.exception.LiquibaseException;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.database.LdapProvider;
import org.traccar.database.QueryBuilder;
import org.traccar.database.QueryExtended;
import org.traccar.database.QueryIgnore;
import org.traccar.model.Attribute;
import org.traccar.model.BaseModel;
import org.traccar.model.Calendar;
import org.traccar.model.Command;
import org.traccar.model.Device;
import org.traccar.model.Driver;
import org.traccar.model.Event;
import org.traccar.model.Geofence;
import org.traccar.model.Group;
import org.traccar.model.Maintenance;
import org.traccar.model.ManagedUser;
import org.traccar.model.Notification;
import org.traccar.model.Permission;
import org.traccar.model.Position;
import org.traccar.model.Server;
import org.traccar.model.Statistics;
import org.traccar.model.User;

public class DataManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataManager.class);
    public static final String ACTION_SELECT_ALL = "selectAll";
    public static final String ACTION_SELECT = "select";
    public static final String ACTION_INSERT = "insert";
    public static final String ACTION_UPDATE = "update";
    public static final String ACTION_DELETE = "delete";
    private final Config config;
    private DataSource dataSource;
    private boolean generateQueries;
    private final boolean forceLdap;

    public DataManager(Config config) throws Exception {
        this.config = config;
        this.forceLdap = config.getBoolean(Keys.LDAP_FORCE);
        this.initDatabase();
        this.initDatabaseSchema();
    }

    private void initDatabase() throws Exception {
        String driver;
        String driverFile = this.config.getString(Keys.DATABASE_DRIVER_FILE);
        if (driverFile != null) {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            try {
                Method method = classLoader.getClass().getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)classLoader, new File(driverFile).toURI().toURL());
            }
            catch (NoSuchMethodException e) {
                Method method = classLoader.getClass().getDeclaredMethod("appendToClassPathForInstrumentation", String.class);
                method.setAccessible(true);
                method.invoke((Object)classLoader, driverFile);
            }
        }
        if ((driver = this.config.getString(Keys.DATABASE_DRIVER)) != null) {
            Class.forName(driver);
        }
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(driver);
        hikariConfig.setJdbcUrl(this.config.getString(Keys.DATABASE_URL));
        hikariConfig.setUsername(this.config.getString(Keys.DATABASE_USER));
        hikariConfig.setPassword(this.config.getString(Keys.DATABASE_PASSWORD));
        hikariConfig.setConnectionInitSql(this.config.getString(Keys.DATABASE_CHECK_CONNECTION));
        hikariConfig.setIdleTimeout(600000L);
        int maxPoolSize = this.config.getInteger(Keys.DATABASE_MAX_POOL_SIZE);
        if (maxPoolSize != 0) {
            hikariConfig.setMaximumPoolSize(maxPoolSize);
        }
        this.generateQueries = this.config.getBoolean(Keys.DATABASE_GENERATE_QUERIES);
        this.dataSource = new HikariDataSource(hikariConfig);
    }

    public static String constructObjectQuery(String action, Class<?> clazz, boolean extended) {
        switch (action) {
            case "insert": 
            case "update": {
                StringBuilder result = new StringBuilder();
                StringBuilder fields = new StringBuilder();
                StringBuilder values = new StringBuilder();
                HashSet<Method> methods = new HashSet<Method>(Arrays.asList(clazz.getMethods()));
                methods.removeAll(Arrays.asList(Object.class.getMethods()));
                methods.removeAll(Arrays.asList(BaseModel.class.getMethods()));
                for (Method method : methods) {
                    boolean skip;
                    if (extended) {
                        skip = !method.isAnnotationPresent(QueryExtended.class);
                    } else {
                        boolean bl = skip = method.isAnnotationPresent(QueryIgnore.class) || method.isAnnotationPresent(QueryExtended.class) && !action.equals(ACTION_INSERT);
                    }
                    if (skip || !method.getName().startsWith("get") || method.getParameterTypes().length != 0) continue;
                    String name = Introspector.decapitalize(method.getName().substring(3));
                    if (action.equals(ACTION_INSERT)) {
                        fields.append(name).append(", ");
                        values.append(":").append(name).append(", ");
                        continue;
                    }
                    fields.append(name).append(" = :").append(name).append(", ");
                }
                fields.setLength(fields.length() - 2);
                if (action.equals(ACTION_INSERT)) {
                    values.setLength(values.length() - 2);
                    result.append("INSERT INTO ").append(DataManager.getObjectsTableName(clazz)).append(" (");
                    result.append((CharSequence)fields).append(") ");
                    result.append("VALUES (").append((CharSequence)values).append(")");
                } else {
                    result.append("UPDATE ").append(DataManager.getObjectsTableName(clazz)).append(" SET ");
                    result.append((CharSequence)fields);
                    result.append(" WHERE id = :id");
                }
                return result.toString();
            }
            case "selectAll": {
                return "SELECT * FROM " + DataManager.getObjectsTableName(clazz);
            }
            case "select": {
                return "SELECT * FROM " + DataManager.getObjectsTableName(clazz) + " WHERE id = :id";
            }
            case "delete": {
                return "DELETE FROM " + DataManager.getObjectsTableName(clazz) + " WHERE id = :id";
            }
        }
        throw new IllegalArgumentException("Unknown action");
    }

    public static String constructPermissionQuery(String action, Class<?> owner, Class<?> property) {
        switch (action) {
            case "selectAll": {
                return "SELECT " + DataManager.makeNameId(owner) + ", " + DataManager.makeNameId(property) + " FROM " + DataManager.getPermissionsTableName(owner, property);
            }
            case "insert": {
                return "INSERT INTO " + DataManager.getPermissionsTableName(owner, property) + " (" + DataManager.makeNameId(owner) + ", " + DataManager.makeNameId(property) + ") VALUES (:" + DataManager.makeNameId(owner) + ", :" + DataManager.makeNameId(property) + ")";
            }
            case "delete": {
                return "DELETE FROM " + DataManager.getPermissionsTableName(owner, property) + " WHERE " + DataManager.makeNameId(owner) + " = :" + DataManager.makeNameId(owner) + " AND " + DataManager.makeNameId(property) + " = :" + DataManager.makeNameId(property);
            }
        }
        throw new IllegalArgumentException("Unknown action");
    }

    private String getQuery(String key) {
        String query = this.config.getString(key);
        if (query == null) {
            LOGGER.info("Query not provided: " + key);
        }
        return query;
    }

    public String getQuery(String action, Class<?> clazz) {
        return this.getQuery(action, clazz, false);
    }

    public String getQuery(String action, Class<?> clazz, boolean extended) {
        String queryName;
        if (action.equals(ACTION_SELECT_ALL)) {
            queryName = "database.select" + clazz.getSimpleName() + "s";
        } else {
            queryName = "database." + action.toLowerCase() + clazz.getSimpleName();
            if (extended) {
                queryName = queryName + "Extended";
            }
        }
        String query = this.config.getString(queryName);
        if (query == null) {
            if (this.generateQueries) {
                query = DataManager.constructObjectQuery(action, clazz, extended);
            } else {
                LOGGER.info("Query not provided: " + queryName);
            }
        }
        return query;
    }

    public String getQuery(String action, Class<?> owner, Class<?> property) {
        String queryName;
        switch (action) {
            case "selectAll": {
                queryName = "database.select" + owner.getSimpleName() + property.getSimpleName() + "s";
                break;
            }
            case "insert": {
                queryName = "database.link" + owner.getSimpleName() + property.getSimpleName();
                break;
            }
            default: {
                queryName = "database.unlink" + owner.getSimpleName() + property.getSimpleName();
            }
        }
        String query = this.config.getString(queryName);
        if (query == null) {
            if (this.generateQueries) {
                query = DataManager.constructPermissionQuery(action, owner, property.equals(User.class) ? ManagedUser.class : property);
            } else {
                LOGGER.info("Query not provided: " + queryName);
            }
        }
        return query;
    }

    private static String getPermissionsTableName(Class<?> owner, Class<?> property) {
        String propertyName = property.getSimpleName();
        if (propertyName.equals("ManagedUser")) {
            propertyName = "User";
        }
        return "tc_" + Introspector.decapitalize(owner.getSimpleName()) + "_" + Introspector.decapitalize(propertyName);
    }

    private static String getObjectsTableName(Class<?> clazz) {
        String result = "tc_" + Introspector.decapitalize(clazz.getSimpleName());
        if (!result.endsWith("s")) {
            result = result + "s";
        }
        return result;
    }

    private void initDatabaseSchema() throws SQLException, LiquibaseException {
        if (this.config.hasKey(Keys.DATABASE_CHANGELOG)) {
            FileSystemResourceAccessor resourceAccessor = new FileSystemResourceAccessor();
            Database database = DatabaseFactory.getInstance().openDatabase(this.config.getString(Keys.DATABASE_URL), this.config.getString(Keys.DATABASE_USER), this.config.getString(Keys.DATABASE_PASSWORD), this.config.getString(Keys.DATABASE_DRIVER), null, null, null, (ResourceAccessor)resourceAccessor);
            Liquibase liquibase = new Liquibase(this.config.getString(Keys.DATABASE_CHANGELOG), (ResourceAccessor)resourceAccessor, database);
            liquibase.clearCheckSums();
            liquibase.update(new Contexts());
        }
    }

    public User login(String email, String password) throws SQLException {
        User user = QueryBuilder.create(this.dataSource, this.getQuery("database.loginUser")).setString("email", email.trim()).executeQuerySingle(User.class);
        LdapProvider ldapProvider = Context.getLdapProvider();
        if (user != null) {
            if (ldapProvider != null && user.getLogin() != null && ldapProvider.login(user.getLogin(), password) || !this.forceLdap && user.isPasswordValid(password)) {
                return user;
            }
        } else if (ldapProvider != null && ldapProvider.login(email, password)) {
            user = ldapProvider.getUser(email);
            Context.getUsersManager().addItem(user);
            return user;
        }
        return null;
    }

    public void updateDeviceStatus(Device device) throws SQLException {
        QueryBuilder.create(this.dataSource, this.getQuery(ACTION_UPDATE, Device.class, true)).setObject(device).executeUpdate();
    }

    public Collection<Position> getPositions(long deviceId, Date from, Date to) throws SQLException {
        return QueryBuilder.create(this.dataSource, this.getQuery("database.selectPositions")).setLong("deviceId", deviceId).setDate("from", from).setDate("to", to).executeQuery(Position.class);
    }

    public void updateLatestPosition(Position position) throws SQLException {
        QueryBuilder.create(this.dataSource, this.getQuery("database.updateLatestPosition")).setDate("now", new Date()).setObject(position).executeUpdate();
    }

    public Collection<Position> getLatestPositions() throws SQLException {
        return QueryBuilder.create(this.dataSource, this.getQuery("database.selectLatestPositions")).executeQuery(Position.class);
    }

    public Server getServer() throws SQLException {
        return QueryBuilder.create(this.dataSource, this.getQuery(ACTION_SELECT_ALL, Server.class)).executeQuerySingle(Server.class);
    }

    public Collection<Event> getEvents(long deviceId, Date from, Date to) throws SQLException {
        return QueryBuilder.create(this.dataSource, this.getQuery("database.selectEvents")).setLong("deviceId", deviceId).setDate("from", from).setDate("to", to).executeQuery(Event.class);
    }

    public Collection<Statistics> getStatistics(Date from, Date to) throws SQLException {
        return QueryBuilder.create(this.dataSource, this.getQuery("database.selectStatistics")).setDate("from", from).setDate("to", to).executeQuery(Statistics.class);
    }

    public static Class<?> getClassByName(String name) throws ClassNotFoundException {
        switch (name.toLowerCase().replace("id", "")) {
            case "device": {
                return Device.class;
            }
            case "group": {
                return Group.class;
            }
            case "user": {
                return User.class;
            }
            case "manageduser": {
                return ManagedUser.class;
            }
            case "geofence": {
                return Geofence.class;
            }
            case "driver": {
                return Driver.class;
            }
            case "attribute": {
                return Attribute.class;
            }
            case "calendar": {
                return Calendar.class;
            }
            case "command": {
                return Command.class;
            }
            case "maintenance": {
                return Maintenance.class;
            }
            case "notification": {
                return Notification.class;
            }
        }
        throw new ClassNotFoundException();
    }

    private static String makeNameId(Class<?> clazz) {
        String name = clazz.getSimpleName();
        return Introspector.decapitalize(name) + (!name.contains("Id") ? "Id" : "");
    }

    public Collection<Permission> getPermissions(Class<? extends BaseModel> owner, Class<? extends BaseModel> property) throws SQLException, ClassNotFoundException {
        return QueryBuilder.create(this.dataSource, this.getQuery(ACTION_SELECT_ALL, owner, property)).executePermissionsQuery();
    }

    public void linkObject(Class<?> owner, long ownerId, Class<?> property, long propertyId, boolean link) throws SQLException {
        QueryBuilder.create(this.dataSource, this.getQuery(link ? ACTION_INSERT : ACTION_DELETE, owner, property)).setLong(DataManager.makeNameId(owner), ownerId).setLong(DataManager.makeNameId(property), propertyId).executeUpdate();
    }

    public <T extends BaseModel> T getObject(Class<T> clazz, long entityId) throws SQLException {
        return (T)((BaseModel)QueryBuilder.create(this.dataSource, this.getQuery(ACTION_SELECT, clazz)).setLong("id", entityId).executeQuerySingle(clazz));
    }

    public <T extends BaseModel> Collection<T> getObjects(Class<T> clazz) throws SQLException {
        return QueryBuilder.create(this.dataSource, this.getQuery(ACTION_SELECT_ALL, clazz)).executeQuery(clazz);
    }

    public void addObject(BaseModel entity) throws SQLException {
        entity.setId(QueryBuilder.create(this.dataSource, this.getQuery(ACTION_INSERT, entity.getClass()), true).setObject(entity).executeUpdate());
    }

    public void updateObject(BaseModel entity) throws SQLException {
        QueryBuilder.create(this.dataSource, this.getQuery(ACTION_UPDATE, entity.getClass())).setObject(entity).executeUpdate();
        if (entity instanceof User && ((User)entity).getHashedPassword() != null) {
            QueryBuilder.create(this.dataSource, this.getQuery(ACTION_UPDATE, User.class, true)).setObject(entity).executeUpdate();
        }
    }

    public void removeObject(Class<? extends BaseModel> clazz, long entityId) throws SQLException {
        QueryBuilder.create(this.dataSource, this.getQuery(ACTION_DELETE, clazz)).setLong("id", entityId).executeUpdate();
    }
}

