/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.model.Position;
import org.traccar.speedlimit.SpeedLimitProvider;

@ChannelHandler.Sharable
public class SpeedLimitHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpeedLimitHandler.class);
    private final SpeedLimitProvider speedLimitProvider;

    public SpeedLimitHandler(SpeedLimitProvider speedLimitProvider) {
        this.speedLimitProvider = speedLimitProvider;
    }

    public void channelRead(final ChannelHandlerContext ctx, Object message) {
        if (message instanceof Position) {
            final Position position = (Position)message;
            this.speedLimitProvider.getSpeedLimit(position.getLatitude(), position.getLongitude(), new SpeedLimitProvider.SpeedLimitProviderCallback(){

                @Override
                public void onSuccess(double speedLimit) {
                    position.set("speedLimit", speedLimit);
                    ctx.fireChannelRead((Object)position);
                }

                @Override
                public void onFailure(Throwable e) {
                    LOGGER.warn("Speed limit provider failed", e);
                    ctx.fireChannelRead((Object)position);
                }
            });
        } else {
            ctx.fireChannelRead(message);
        }
    }
}

