/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class FlespiProtocolDecoder
extends BaseHttpProtocolDecoder {
    public FlespiProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        JsonArray result = Json.createReader((Reader)new StringReader(request.content().toString(StandardCharsets.UTF_8))).readArray();
        LinkedList<Position> positions = new LinkedList<Position>();
        for (int i = 0; i < result.size(); ++i) {
            JsonObject message = result.getJsonObject(i);
            JsonString ident = message.getJsonString("ident");
            if (ident == null) continue;
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, ident.getString());
            if (deviceSession == null) continue;
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setValid(true);
            this.decodePosition(message, position);
            positions.add(position);
        }
        this.sendResponse(channel, HttpResponseStatus.OK);
        return positions;
    }

    private void decodePosition(JsonObject object, Position position) {
        for (Map.Entry param : object.entrySet()) {
            String paramName = (String)param.getKey();
            JsonValue paramValue = (JsonValue)param.getValue();
            int index = -1;
            if (paramName.contains("#")) {
                String[] parts = paramName.split("#");
                paramName = parts[0];
                index = Integer.parseInt(parts[1]);
            }
            if (this.decodeParam(paramName, index, paramValue, position)) continue;
            this.decodeUnknownParam((String)param.getKey(), (JsonValue)param.getValue(), position);
        }
        if (position.getLatitude() == 0.0 && position.getLongitude() == 0.0) {
            this.getLastLocation(position, position.getDeviceTime());
        }
    }

    private boolean decodeParam(String name, int index, JsonValue value, Position position) {
        switch (name) {
            case "timestamp": {
                position.setTime(new Date(((JsonNumber)value).longValue() * 1000L));
                return true;
            }
            case "position.latitude": {
                position.setLatitude(((JsonNumber)value).doubleValue());
                return true;
            }
            case "position.longitude": {
                position.setLongitude(((JsonNumber)value).doubleValue());
                return true;
            }
            case "position.speed": {
                position.setSpeed(UnitsConverter.knotsFromKph(((JsonNumber)value).doubleValue()));
                return true;
            }
            case "position.direction": {
                position.setCourse(((JsonNumber)value).doubleValue());
                return true;
            }
            case "position.altitude": {
                position.setAltitude(((JsonNumber)value).doubleValue());
                return true;
            }
            case "position.satellites": {
                position.set("sat", ((JsonNumber)value).intValue());
                return true;
            }
            case "position.valid": {
                position.setValid(value == JsonValue.TRUE);
                return true;
            }
            case "position.hdop": {
                position.set("hdop", ((JsonNumber)value).doubleValue());
                return true;
            }
            case "position.pdop": {
                position.set("pdop", ((JsonNumber)value).doubleValue());
                return true;
            }
            case "din": 
            case "dout": {
                if (name.equals("din")) {
                    position.set("input", ((JsonNumber)value).intValue());
                } else {
                    position.set("output", ((JsonNumber)value).intValue());
                }
                return true;
            }
            case "gps.vehicle.mileage": {
                position.set("odometer", ((JsonNumber)value).doubleValue());
                return true;
            }
            case "external.powersource.voltage": {
                position.set("power", ((JsonNumber)value).doubleValue());
                return true;
            }
            case "battery.voltage": {
                position.set("battery", ((JsonNumber)value).doubleValue());
                return true;
            }
            case "fuel.level": 
            case "can.fuel.level": {
                position.set("fuel", ((JsonNumber)value).doubleValue());
                return true;
            }
            case "engine.rpm": 
            case "can.engine.rpm": {
                position.set("rpm", ((JsonNumber)value).doubleValue());
                return true;
            }
            case "can.engine.temperature": {
                position.set("temp" + Math.max(index, 0), ((JsonNumber)value).doubleValue());
                return true;
            }
            case "engine.ignition.status": {
                position.set("ignition", value == JsonValue.TRUE);
                return true;
            }
            case "movement.status": {
                position.set("motion", value == JsonValue.TRUE);
                return true;
            }
            case "device.temperature": {
                position.set("deviceTemp", ((JsonNumber)value).doubleValue());
                return true;
            }
            case "ibutton.code": {
                position.set("driverUniqueId", ((JsonString)value).getString());
                return true;
            }
            case "vehicle.vin": {
                position.set("vin", ((JsonString)value).getString());
                return true;
            }
            case "alarm.event.trigger": {
                if (value == JsonValue.TRUE) {
                    position.set("alarm", "general");
                }
                return true;
            }
            case "towing.event.trigger": 
            case "towing.alarm.status": {
                if (value == JsonValue.TRUE) {
                    position.set("alarm", "tow");
                }
                return true;
            }
            case "geofence.event.enter": {
                if (value == JsonValue.TRUE) {
                    position.set("alarm", "geofenceEnter");
                }
                return true;
            }
            case "geofence.event.exit": {
                if (value == JsonValue.TRUE) {
                    position.set("alarm", "geofenceExit");
                }
                return true;
            }
            case "shock.event.trigger": {
                if (value == JsonValue.TRUE) {
                    position.set("alarm", "shock");
                }
                return true;
            }
            case "overspeeding.event.trigger": {
                if (value == JsonValue.TRUE) {
                    position.set("alarm", "overspeed");
                }
                return true;
            }
            case "harsh.acceleration.event.trigger": {
                if (value == JsonValue.TRUE) {
                    position.set("alarm", "hardAcceleration");
                }
                return true;
            }
            case "harsh.braking.event.trigger": {
                if (value == JsonValue.TRUE) {
                    position.set("alarm", "hardBraking");
                }
                return true;
            }
            case "harsh.cornering.event.trigger": {
                if (value == JsonValue.TRUE) {
                    position.set("alarm", "hardCornering");
                }
                return true;
            }
            case "gnss.antenna.cut.status": {
                if (value == JsonValue.TRUE) {
                    position.set("alarm", "gpsAntennaCut");
                }
                return true;
            }
            case "gsm.jamming.event.trigger": {
                if (value == JsonValue.TRUE) {
                    position.set("alarm", "jamming");
                }
                return true;
            }
            case "hood.open.status": {
                if (value == JsonValue.TRUE) {
                    position.set("alarm", "bonnet");
                }
                return true;
            }
        }
        return false;
    }

    private void decodeUnknownParam(String name, JsonValue value, Position position) {
        if (value instanceof JsonNumber) {
            if (((JsonNumber)value).isIntegral()) {
                position.set(name, ((JsonNumber)value).longValue());
            } else {
                position.set(name, ((JsonNumber)value).doubleValue());
            }
            position.set(name, ((JsonNumber)value).doubleValue());
        } else if (value instanceof JsonString) {
            position.set(name, ((JsonString)value).getString());
        } else if (value == JsonValue.TRUE || value == JsonValue.FALSE) {
            position.set(name, value == JsonValue.TRUE);
        }
    }
}

