/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttConnAckMessage;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageBuilders;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class IotmProtocolDecoder
extends BaseProtocolDecoder {
    public IotmProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Object readValue(ByteBuf buf, int sensorType) {
        switch (sensorType) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return buf.readUnsignedByte();
            }
            case 5: {
                return buf.readUnsignedShortLE();
            }
            case 6: {
                return buf.readUnsignedIntLE();
            }
            case 7: 
            case 11: {
                return buf.readLongLE();
            }
            case 8: {
                return buf.readByte();
            }
            case 9: {
                return buf.readShortLE();
            }
            case 10: {
                return buf.readIntLE();
            }
            case 12: {
                return Float.valueOf(buf.readFloatLE());
            }
            case 13: {
                return buf.readDoubleLE();
            }
            case 32: {
                return buf.readCharSequence((int)buf.readUnsignedByte(), StandardCharsets.US_ASCII).toString();
            }
            case 33: {
                return ByteBufUtil.hexDump((ByteBuf)buf.readSlice((int)buf.readUnsignedByte()));
            }
            case 64: {
                return buf.readCharSequence(buf.readUnsignedShortLE(), StandardCharsets.US_ASCII).toString();
            }
            case 65: {
                return ByteBufUtil.hexDump((ByteBuf)buf.readSlice(buf.readUnsignedShortLE()));
            }
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        if (msg instanceof MqttConnectMessage) {
            MqttConnectMessage message = (MqttConnectMessage)msg;
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, message.payload().clientIdentifier());
            MqttConnectReturnCode returnCode = deviceSession != null ? MqttConnectReturnCode.CONNECTION_ACCEPTED : MqttConnectReturnCode.CONNECTION_REFUSED_IDENTIFIER_REJECTED;
            MqttConnAckMessage response = MqttMessageBuilders.connAck().returnCode(returnCode).build();
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
            }
        } else if (msg instanceof MqttSubscribeMessage) {
            MqttSubscribeMessage message = (MqttSubscribeMessage)msg;
            MqttSubAckMessage response = MqttMessageBuilders.subAck().packetId((short)message.variableHeader().messageId()).build();
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
            }
        } else if (msg instanceof MqttPublishMessage) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            LinkedList<Position> positions = new LinkedList<Position>();
            MqttPublishMessage message = (MqttPublishMessage)msg;
            ByteBuf buf = message.payload();
            buf.readUnsignedByte();
            while (buf.readableBytes() > 1) {
                Position position;
                short type = buf.readUnsignedByte();
                int length = buf.readUnsignedShortLE();
                ByteBuf record = buf.readSlice(length);
                if (type == 1) {
                    position = new Position(this.getProtocolName());
                    position.setDeviceId(deviceSession.getDeviceId());
                    position.setTime(new Date(record.readUnsignedIntLE() * 1000L));
                    block16: while (record.readableBytes() > 0) {
                        String key;
                        short sensorType = record.readUnsignedByte();
                        int sensorId = record.readUnsignedShortLE();
                        if (sensorType == 14) {
                            position.setValid(true);
                            position.setLatitude(record.readFloatLE());
                            position.setLongitude(record.readFloatLE());
                            position.setSpeed(UnitsConverter.knotsFromKph(record.readUnsignedShortLE()));
                            position.set("hdop", record.readUnsignedByte());
                            position.set("sat", record.readUnsignedByte());
                            position.setCourse(record.readUnsignedShortLE());
                            position.setAltitude(record.readShortLE());
                            continue;
                        }
                        if (sensorType == 3) continue;
                        switch (sensorId) {
                            case 8: {
                                if (sensorType <= 0) continue block16;
                                position.set("alarm", "jamming");
                                continue block16;
                            }
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: {
                                key = "in" + (sensorId - 16 + 2);
                                position.set(key, sensorType > 0);
                                continue block16;
                            }
                            case 30: {
                                position.set("buttonPresent", sensorType > 0);
                                continue block16;
                            }
                            case 109: {
                                position.set("ignition", sensorType > 0);
                                continue block16;
                            }
                            case 12288: {
                                position.set("power", (double)record.readUnsignedShortLE() * 0.001);
                                continue block16;
                            }
                            case 12289: 
                            case 12290: 
                            case 12291: {
                                key = "adc" + (12291 - sensorId + 3);
                                position.set(key, (double)record.readUnsignedShortLE() * 0.001);
                                continue block16;
                            }
                            case 12292: {
                                position.set("battery", (double)record.readUnsignedShortLE() * 0.001);
                                continue block16;
                            }
                            case 12300: {
                                position.set("rpm", record.readUnsignedShortLE());
                                continue block16;
                            }
                            case 16387: {
                                position.set("odometer", record.readUnsignedIntLE() * 5L);
                                continue block16;
                            }
                            case 20480: {
                                position.set("driverUniqueId", String.valueOf(record.readLongLE()));
                                continue block16;
                            }
                            case 40961: {
                                position.set("acceleration", Float.valueOf(record.readFloatLE()));
                                continue block16;
                            }
                            case 40962: {
                                position.set("cornering", Float.valueOf(record.readFloatLE()));
                                continue block16;
                            }
                            case 40983: {
                                key = "temp" + (sensorId - 40983 + 1);
                                position.set(key, Float.valueOf(record.readFloatLE()));
                                continue block16;
                            }
                        }
                        key = "io" + sensorId;
                        position.getAttributes().put(key, this.readValue(record, sensorType));
                    }
                    positions.add(position);
                    continue;
                }
                if (type != 3) continue;
                position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                this.getLastLocation(position, new Date(record.readUnsignedIntLE() * 1000L));
                record.readUnsignedByte();
                position.set("event", record.readUnsignedByte());
                positions.add(position);
            }
            buf.readUnsignedByte();
            MqttMessage response = MqttMessageBuilders.pubAck().packetId((short)message.variableHeader().packetId()).build();
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
            }
            return positions.isEmpty() ? null : positions;
        }
        return null;
    }
}

