/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import io.netty.channel.ChannelHandler;
import java.util.Collections;
import java.util.Map;
import org.traccar.database.IdentityManager;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.Position;

@ChannelHandler.Sharable
public class IgnitionEventHandler
extends BaseEventHandler {
    private final IdentityManager identityManager;

    public IgnitionEventHandler(IdentityManager identityManager) {
        this.identityManager = identityManager;
    }

    @Override
    protected Map<Event, Position> analyzePosition(Position position) {
        Device device = this.identityManager.getById(position.getDeviceId());
        if (device == null || !this.identityManager.isLatestPosition(position)) {
            return null;
        }
        Map<Event, Position> result = null;
        if (position.getAttributes().containsKey("ignition")) {
            boolean ignition = position.getBoolean("ignition");
            Position lastPosition = this.identityManager.getLastPosition(position.getDeviceId());
            if (lastPosition != null && lastPosition.getAttributes().containsKey("ignition")) {
                boolean oldIgnition = lastPosition.getBoolean("ignition");
                if (ignition && !oldIgnition) {
                    result = Collections.singletonMap(new Event("ignitionOn", position.getDeviceId(), position.getId()), position);
                } else if (!ignition && oldIgnition) {
                    result = Collections.singletonMap(new Event("ignitionOff", position.getDeviceId(), position.getId()), position);
                }
            }
        }
        return result;
    }
}

