/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import java.util.TimeZone;
import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.model.Command;

public class Jt600ProtocolEncoder
extends StringProtocolEncoder {
    public Jt600ProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object encodeCommand(Command command) {
        switch (command.getType()) {
            case "engineStop": {
                return "(S07,0)";
            }
            case "engineResume": {
                return "(S07,1)";
            }
            case "setTimezone": {
                int offset = TimeZone.getTimeZone(command.getString("timezone")).getRawOffset() / 60000;
                return "(S09,1," + offset + ")";
            }
            case "rebootDevice": {
                return "(S17)";
            }
        }
        return null;
    }
}

