/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;

public class Minifinder2ProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_DATA = 1;
    public static final int MSG_RESPONSE = 127;

    public Minifinder2ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(int code) {
        if (BitUtil.check(code, 0)) {
            return "lowBattery";
        }
        if (BitUtil.check(code, 1)) {
            return "overspeed";
        }
        if (BitUtil.check(code, 2)) {
            return "fallDown";
        }
        if (BitUtil.check(code, 8)) {
            return "powerOff";
        }
        if (BitUtil.check(code, 9)) {
            return "powerOn";
        }
        if (BitUtil.check(code, 12)) {
            return "sos";
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedByte();
        short flags = buf.readUnsignedByte();
        buf.readUnsignedShortLE();
        buf.readUnsignedShortLE();
        int index = buf.readUnsignedShortLE();
        short type = buf.readUnsignedByte();
        if (BitUtil.check(flags, 4) && channel != null) {
            ByteBuf content = Unpooled.buffer();
            content.writeByte(127);
            content.writeByte(1);
            content.writeByte(0);
            ByteBuf response = Unpooled.buffer();
            response.writeByte(171);
            response.writeByte(0);
            response.writeShortLE(content.readableBytes());
            response.writeShortLE(Checksum.crc16(Checksum.CRC16_XMODEM, content.nioBuffer()));
            response.writeShortLE(index);
            response.writeBytes(content);
            content.release();
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
        if (type == 1) {
            LinkedList<Position> positions = new LinkedList<Position>();
            HashSet<Integer> keys = new HashSet<Integer>();
            boolean hasLocation = false;
            Position position = new Position(this.getProtocolName());
            DeviceSession deviceSession = null;
            while (buf.isReadable()) {
                int endIndex = buf.readUnsignedByte() + buf.readerIndex();
                short key = buf.readUnsignedByte();
                if (keys.contains(key)) {
                    if (!hasLocation) {
                        this.getLastLocation(position, null);
                    }
                    positions.add(position);
                    keys.clear();
                    hasLocation = false;
                    position = new Position(this.getProtocolName());
                }
                keys.add(Integer.valueOf(key));
                switch (key) {
                    case 1: {
                        deviceSession = this.getDeviceSession(channel, remoteAddress, buf.readCharSequence(15, StandardCharsets.US_ASCII).toString());
                        position.setDeviceId(deviceSession.getDeviceId());
                        break;
                    }
                    case 2: {
                        position.set("alarm", this.decodeAlarm(buf.readIntLE()));
                        break;
                    }
                    case 20: {
                        position.set("batteryLevel", buf.readUnsignedByte());
                        position.set("battery", (double)buf.readUnsignedShortLE() * 0.001);
                        break;
                    }
                    case 32: {
                        hasLocation = true;
                        position.setLatitude((double)buf.readIntLE() * 1.0E-7);
                        position.setLongitude((double)buf.readIntLE() * 1.0E-7);
                        position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedShortLE()));
                        position.setCourse(buf.readUnsignedShortLE());
                        position.setAltitude(buf.readShortLE());
                        position.setValid(buf.readUnsignedShortLE() > 0);
                        position.set("odometer", buf.readUnsignedIntLE());
                        position.set("sat", buf.readUnsignedByte());
                        break;
                    }
                    case 33: {
                        int mcc = buf.readUnsignedShortLE();
                        short mnc = buf.readUnsignedByte();
                        if (position.getNetwork() == null) {
                            position.setNetwork(new Network());
                        }
                        while (buf.readerIndex() < endIndex) {
                            byte rssi = buf.readByte();
                            position.getNetwork().addCellTower(CellTower.from(mcc, mnc, buf.readUnsignedShortLE(), buf.readUnsignedShortLE(), rssi));
                        }
                        break;
                    }
                    case 34: {
                        if (position.getNetwork() == null) {
                            position.setNetwork(new Network());
                        }
                        while (buf.readerIndex() < endIndex) {
                            byte rssi = buf.readByte();
                            String mac = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6)).replaceAll("(..)", "$1:");
                            position.getNetwork().addWifiAccessPoint(WifiAccessPoint.from(mac.substring(0, mac.length() - 1), rssi));
                        }
                        break;
                    }
                    case 35: {
                        position.set("tagId", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6)));
                        position.setLatitude((double)buf.readIntLE() * 1.0E-7);
                        position.setLongitude((double)buf.readIntLE() * 1.0E-7);
                        hasLocation = true;
                        break;
                    }
                    case 36: {
                        position.setTime(new Date(buf.readUnsignedIntLE() * 1000L));
                        long status = buf.readUnsignedIntLE();
                        position.set("batteryLevel", BitUtil.from(status, 24));
                        position.set("status", status);
                        break;
                    }
                    case 40: {
                        short beaconFlags = buf.readUnsignedByte();
                        position.set("tagId", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6)));
                        buf.readUnsignedByte();
                        buf.readUnsignedByte();
                        if (!BitUtil.check(beaconFlags, 7)) break;
                        position.setLatitude((double)buf.readIntLE() * 1.0E-7);
                        position.setLongitude((double)buf.readIntLE() * 1.0E-7);
                        hasLocation = true;
                        break;
                    }
                    case 48: {
                        buf.readUnsignedInt();
                        position.set("steps", buf.readUnsignedInt());
                        break;
                    }
                    case 64: {
                        buf.readUnsignedIntLE();
                        short heartRate = buf.readUnsignedByte();
                        if (heartRate <= 1) break;
                        position.set("heartRate", Integer.valueOf(heartRate));
                        break;
                    }
                }
                buf.readerIndex(endIndex);
            }
            if (!hasLocation) {
                this.getLastLocation(position, null);
            }
            positions.add(position);
            if (deviceSession != null) {
                for (Position p : positions) {
                    p.setDeviceId(deviceSession.getDeviceId());
                }
            } else {
                return null;
            }
            return positions;
        }
        return null;
    }
}

