#!/usr/local/bin/python3.8

from __future__ import print_function
from pathlib import Path
import logging.handlers
import sys
import os
import site
if sys.version_info.major < 3:
    print("RouterSploit supports only Python3. Rerun application in Python3 environment.")
    exit(0)

from routersploit.interpreter import RoutersploitInterpreter

log_handler = logging.handlers.RotatingFileHandler(filename=str(Path.home()) + "/routersploit.log", maxBytes=500000)
log_formatter = logging.Formatter("%(asctime)s %(levelname)s %(name)s       %(message)s")
log_handler.setFormatter(log_formatter)
LOGGER = logging.getLogger()
LOGGER.setLevel(logging.DEBUG)
LOGGER.addHandler(log_handler)


def routersploit():
    rsf = RoutersploitInterpreter()
    rsf.start()


if __name__ == "__main__":
    os.chdir(site.getsitepackages()[0])
    routersploit()
