/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc3;

import java.io.IOException;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import openlink.util.Vector;
import virtuoso.jdbc3.VirtuosoConnection;
import virtuoso.jdbc3.VirtuosoException;
import virtuoso.jdbc3.VirtuosoExplicitString;
import virtuoso.jdbc3.VirtuosoFuture;
import virtuoso.jdbc3.VirtuosoPooledConnection;
import virtuoso.jdbc3.VirtuosoXid;
import virtuoso.jdbc3.XAResourceManager;
import virtuoso.jdbc3.XATransaction;

public class VirtuosoXAResource
implements XAResource {
    private static final int SQL_XA_ENLIST = 246;
    private static final int SQL_XA_PREPARE = 3841;
    private static final int SQL_XA_COMMIT = 3842;
    private static final int SQL_XA_ROLLBACK = 3843;
    private static final int SQL_XA_END = 3844;
    private static final int SQL_XA_JOIN = 3845;
    private static final int SQL_XA_RESUME = 3846;
    private static final int SQL_XA_SUSPEND = 3847;
    private static final int SQL_XA_WAIT = 3840;
    private final String GET_ALL_XIDS = "_2PC.DBA.XA_GET_ALL_XIDS()";
    private VirtuosoPooledConnection vConnection;
    private XAResourceManager manager;
    int txn_timeout = 0;
    private boolean stored_auto_commit;
    private Xid r_currentXid = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VirtuosoXAResource(VirtuosoPooledConnection virtuosoPooledConnection, String string, int n) {
        this.vConnection = virtuosoPooledConnection;
        this.manager = XAResourceManager.getManager(string, n);
        if (VirtuosoFuture.rpc_log != null) {
            PrintStream printStream = VirtuosoFuture.rpc_log;
            synchronized (printStream) {
                VirtuosoFuture.rpc_log.println("new VirtuosoXAResource (+ con=" + virtuosoPooledConnection.hashCode() + ") :" + this.hashCode() + ")");
                VirtuosoFuture.rpc_log.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset_XA() {
        if (VirtuosoFuture.rpc_log != null) {
            PrintStream printStream = VirtuosoFuture.rpc_log;
            synchronized (printStream) {
                VirtuosoFuture.rpc_log.println("VirtuosoXAResource.reset_XA () :" + this.hashCode());
                VirtuosoFuture.rpc_log.flush();
            }
        }
        if (this.vConnection == null) {
            return;
        }
        if (this.r_currentXid != null) {
            try {
                this.end(this.r_currentXid, 0x20000000);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTransactionTimeout() throws XAException {
        if (VirtuosoFuture.rpc_log != null) {
            PrintStream printStream = VirtuosoFuture.rpc_log;
            synchronized (printStream) {
                VirtuosoFuture.rpc_log.println("VirtuosoXAResource.getTransactionTimeout () ret " + this.txn_timeout + " :" + this.hashCode() + ")");
                VirtuosoFuture.rpc_log.flush();
            }
        }
        return this.txn_timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTransactionTimeout(int n) throws XAException {
        Object object;
        if (VirtuosoFuture.rpc_log != null) {
            object = VirtuosoFuture.rpc_log;
            synchronized (object) {
                VirtuosoFuture.rpc_log.println("VirtuosoXAResource.setTransactionTimeout (" + n + ") :" + this.hashCode() + ")");
                VirtuosoFuture.rpc_log.flush();
            }
        }
        if (n < 0) {
            object = new XAException("Invalid number of seconds : " + n);
            ((XAException)object).errorCode = -5;
            throw object;
        }
        if (n == 0) {
            try {
                this.txn_timeout = this.vConnection.getVirtuosoConnection().getTimeout();
            }
            catch (SQLException sQLException) {
                throw new XAException(sQLException.toString());
            }
        } else {
            this.txn_timeout = n;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSameRM(XAResource xAResource) throws XAException {
        boolean bl;
        Object object;
        if (VirtuosoFuture.rpc_log != null) {
            object = VirtuosoFuture.rpc_log;
            synchronized (object) {
                VirtuosoFuture.rpc_log.println("VirtuosoXAResource.isSameRM (res=" + xAResource.hashCode() + ") :" + this.hashCode() + ")");
                VirtuosoFuture.rpc_log.flush();
            }
        }
        if (xAResource == null || !(xAResource instanceof VirtuosoXAResource)) {
            bl = false;
        } else if (xAResource.equals(this)) {
            bl = true;
        } else {
            object = (VirtuosoXAResource)xAResource;
            bl = this.manager == ((VirtuosoXAResource)object).manager;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Xid xid, int n) throws XAException {
        VirtuosoConnection virtuosoConnection;
        int n2;
        Object object;
        if (VirtuosoFuture.rpc_log != null) {
            object = VirtuosoFuture.rpc_log;
            synchronized (object) {
                VirtuosoFuture.rpc_log.println("VirtuosoXAResource.start (xid=" + xid.hashCode() + ", param=" + n + ") :" + this.hashCode() + ")");
                VirtuosoFuture.rpc_log.flush();
            }
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        if (n != 0 && n != 0x200000 && n != 0x8000000) {
            throw new XAException(-5);
        }
        object = null;
        if (n == 0x200000) {
            object = this.manager.getTransaction(xid);
            if (((XATransaction)object).getStatus() != 1 && ((XATransaction)object).getStatus() != 2) {
                throw new XAException(-6);
            }
            n2 = 3845;
        } else if (n == 0) {
            object = this.manager.createTransaction(xid, 1);
            n2 = 246;
        } else if (n == 0x8000000) {
            object = this.manager.getTransaction(xid);
            if (((XATransaction)object).getStatus() != 1) {
                throw new XAException(-6);
            }
            n2 = 3846;
        } else {
            throw new XAException("Unsupported mode");
        }
        try {
            virtuosoConnection = this.vConnection.getVirtuosoConnection();
        }
        catch (SQLException sQLException) {
            throw new XAException(sQLException.toString());
        }
        this.enterGlobalTransaction(virtuosoConnection);
        try {
            this.rpc(virtuosoConnection, n2, ((XATransaction)object).getXid().encode());
        }
        catch (XAException xAException) {
            this.leaveGlobalTransaction(virtuosoConnection);
            throw xAException;
        }
        this.r_currentXid = xid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid, int n) throws XAException {
        VirtuosoConnection virtuosoConnection;
        int n2;
        Object object;
        int n3 = 2;
        if (VirtuosoFuture.rpc_log != null) {
            object = VirtuosoFuture.rpc_log;
            synchronized (object) {
                VirtuosoFuture.rpc_log.println("VirtuosoXAResource.end (xid=" + xid.hashCode() + ", param=" + n + ") :" + this.hashCode() + ")");
                VirtuosoFuture.rpc_log.flush();
            }
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        object = this.manager.getTransaction(xid);
        if ((n & 0x2000000) != 0) {
            n2 = 3847;
            n3 = 1;
        } else if (n == 0x4000000) {
            n2 = 3844;
        } else if (n == 0x20000000) {
            n2 = 3844;
            n3 = 6;
        } else {
            throw new XAException("Invalid flag.");
        }
        ((XATransaction)object).checkNewStatus(n3);
        try {
            virtuosoConnection = this.vConnection.getVirtuosoConnection();
        }
        catch (SQLException sQLException) {
            throw new XAException(sQLException.toString());
        }
        this.rpc(virtuosoConnection, n2, ((XATransaction)object).getXid().encode());
        this.leaveGlobalTransaction(virtuosoConnection);
        ((XATransaction)object).changeStatus(n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        VirtuosoConnection virtuosoConnection;
        Object object;
        if (VirtuosoFuture.rpc_log != null) {
            object = VirtuosoFuture.rpc_log;
            synchronized (object) {
                VirtuosoFuture.rpc_log.println("VirtuosoXAResource.prepare (xid=" + xid.hashCode() + ") :" + this.hashCode() + ")");
                VirtuosoFuture.rpc_log.flush();
            }
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        object = this.manager.getTransaction(xid);
        ((XATransaction)object).checkNewStatus(3);
        try {
            virtuosoConnection = this.vConnection.getVirtuosoConnection();
        }
        catch (SQLException sQLException) {
            throw new XAException(sQLException.toString());
        }
        this.rpc(virtuosoConnection, 3841, ((XATransaction)object).getXid().encode());
        ((XATransaction)object).changeStatus(3);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean bl) throws XAException {
        Object object;
        if (VirtuosoFuture.rpc_log != null) {
            object = VirtuosoFuture.rpc_log;
            synchronized (object) {
                VirtuosoFuture.rpc_log.println("VirtuosoXAResource.commit (xid=" + xid.hashCode() + ", onePhase=" + bl + ") :" + this.hashCode() + ")");
                VirtuosoFuture.rpc_log.flush();
            }
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        object = this.manager.getTransaction(xid);
        ((XATransaction)object).checkNewStatus(4, bl);
        this.transact((XATransaction)object, 3842);
        ((XATransaction)object).changeStatus(4, bl);
        this.manager.removeTransaction(xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        Object object;
        if (VirtuosoFuture.rpc_log != null) {
            object = VirtuosoFuture.rpc_log;
            synchronized (object) {
                VirtuosoFuture.rpc_log.println("VirtuosoXAResource.rollback (xid=" + xid.hashCode() + ") :" + this.hashCode() + ")");
                VirtuosoFuture.rpc_log.flush();
            }
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        object = this.manager.getTransaction(xid);
        ((XATransaction)object).checkNewStatus(5);
        this.transact((XATransaction)object, 3843);
        ((XATransaction)object).changeStatus(5);
        this.manager.removeTransaction(xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid[] recover(int n) throws XAException {
        Xid[] xidArray;
        Object object;
        if (VirtuosoFuture.rpc_log != null) {
            object = VirtuosoFuture.rpc_log;
            synchronized (object) {
                VirtuosoFuture.rpc_log.println("VirtuosoXAResource.recover (param=" + n + ") :" + this.hashCode() + ")");
                VirtuosoFuture.rpc_log.flush();
            }
        }
        if (n != 0x1000000) {
            return new Xid[0];
        }
        object = new java.util.Vector();
        try {
            xidArray = this.vConnection.getVirtuosoConnection();
            Statement statement = xidArray.createStatement();
            ResultSet resultSet = statement.executeQuery("_2PC.DBA.XA_GET_ALL_XIDS()");
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                VirtuosoXid virtuosoXid = VirtuosoXid.decode(string);
                ((java.util.Vector)object).add(virtuosoXid);
                this.manager.createTransaction(virtuosoXid, 3);
            }
        }
        catch (SQLException sQLException) {
            throw new XAException(sQLException.toString());
        }
        xidArray = new Xid[((java.util.Vector)object).size()];
        for (int i = 0; i < xidArray.length; ++i) {
            xidArray[i] = (Xid)((java.util.Vector)object).get(i);
        }
        return xidArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Xid xid) throws XAException {
        if (VirtuosoFuture.rpc_log != null) {
            PrintStream printStream = VirtuosoFuture.rpc_log;
            synchronized (printStream) {
                VirtuosoFuture.rpc_log.println("VirtuosoXAResource.forget (xid=" + xid.hashCode() + ") :" + this.hashCode() + ")");
                VirtuosoFuture.rpc_log.flush();
            }
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        this.manager.removeTransaction(xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enterGlobalTransaction(VirtuosoConnection virtuosoConnection) {
        if (VirtuosoFuture.rpc_log != null) {
            PrintStream printStream = VirtuosoFuture.rpc_log;
            synchronized (printStream) {
                VirtuosoFuture.rpc_log.println("VirtuosoXAResource.enterGlobalTransaction (conn=" + virtuosoConnection.hashCode() + ") :" + this.hashCode() + ")");
                VirtuosoFuture.rpc_log.flush();
            }
        }
        if (virtuosoConnection == null) {
            return;
        }
        try {
            this.stored_auto_commit = virtuosoConnection.getAutoCommit();
            virtuosoConnection.setAutoCommit(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        virtuosoConnection.setGlobalTransaction(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leaveGlobalTransaction(VirtuosoConnection virtuosoConnection) {
        if (VirtuosoFuture.rpc_log != null) {
            PrintStream printStream = VirtuosoFuture.rpc_log;
            synchronized (printStream) {
                VirtuosoFuture.rpc_log.println("VirtuosoXAResource.leaveGlobalTransaction (conn=" + virtuosoConnection.hashCode() + ") :" + this.hashCode() + ")");
                VirtuosoFuture.rpc_log.flush();
            }
        }
        if (virtuosoConnection == null) {
            return;
        }
        virtuosoConnection.setGlobalTransaction(false);
        try {
            virtuosoConnection.setAutoCommit(this.stored_auto_commit);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.r_currentXid = null;
    }

    private void transact(XATransaction xATransaction, int n) throws XAException {
        VirtuosoConnection virtuosoConnection;
        VirtuosoExplicitString virtuosoExplicitString = xATransaction.getXid().encode();
        try {
            virtuosoConnection = this.vConnection.getVirtuosoConnection();
        }
        catch (SQLException sQLException) {
            throw new XAException(sQLException.toString());
        }
        this.rpc(virtuosoConnection, n, virtuosoExplicitString);
        this.rpc(virtuosoConnection, 3840, virtuosoExplicitString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rpc(VirtuosoConnection virtuosoConnection, int n, Object object) throws XAException {
        Object[] objectArray = new Object[]{new Integer(n), object};
        try {
            VirtuosoConnection virtuosoConnection2 = virtuosoConnection;
            synchronized (virtuosoConnection2) {
                Object object2;
                VirtuosoFuture virtuosoFuture = virtuosoConnection.getFuture("TPTRX", objectArray, virtuosoConnection.timeout);
                Vector vector = virtuosoFuture.nextResult();
                Object object3 = object2 = vector == null ? null : vector.firstElement();
                if (object2 instanceof Vector) {
                    throw new XAException();
                }
                virtuosoConnection.removeFuture(virtuosoFuture);
            }
        }
        catch (IOException iOException) {
            throw new XAException(-3);
        }
        catch (VirtuosoException virtuosoException) {
            throw new XAException(virtuosoException.toString());
        }
    }
}

