(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/srfi/144#srfi:flmax__0 (lambda () '-inf.0))
  (define std/srfi/144#srfi:flmax
    (lambda _g4510_
      (let ((_g4509_ (let () (declare (not safe)) (##length _g4510_))))
        (cond ((let () (declare (not safe)) (##fx= _g4509_ 0))
               (apply std/srfi/144#srfi:flmax__0 _g4510_))
              (#t (apply flmax _g4510_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/144#srfi:flmax
                _g4510_))))))
  (define std/srfi/144#srfi:flmin__0 (lambda () '+inf.0))
  (define std/srfi/144#srfi:flmin
    (lambda _g4512_
      (let ((_g4511_ (let () (declare (not safe)) (##length _g4512_))))
        (cond ((let () (declare (not safe)) (##fx= _g4511_ 0))
               (apply std/srfi/144#srfi:flmin__0 _g4512_))
              (#t (apply flmin _g4512_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/144#srfi:flmin
                _g4512_))))))
  (define std/srfi/144#c-functions-are-available '#f)
  (define std/srfi/144#fl-fast-fl+* '#f)
  (define std/srfi/144#fma
    (lambda (_x901_ _y902_ _z903_) (error '"fma not defined")))
  (define std/srfi/144#jn (lambda (_n898_ _x899_) (error '"jn not defined")))
  (define std/srfi/144#yn (lambda (_n895_ _x896_) (error '"yn not defined")))
  (define std/srfi/144#fl-e '2.718281828459045)
  (define std/srfi/144#fl-1/e '.36787944117144233)
  (define std/srfi/144#fl-e-2 '7.38905609893065)
  (define std/srfi/144#fl-e-pi/4 '2.1932800507380152)
  (define std/srfi/144#fl-log2-e '1.4426950408889634)
  (define std/srfi/144#fl-log10-e '.4342944819032518)
  (define std/srfi/144#fl-log-2 '.6931471805599453)
  (define std/srfi/144#fl-1/log-2 '1.4426950408889634)
  (define std/srfi/144#fl-log-3 '1.0986122886681098)
  (define std/srfi/144#fl-log-pi '1.1447298858494002)
  (define std/srfi/144#fl-log-10 '2.302585092994046)
  (define std/srfi/144#fl-1/log-10 '.4342944819032518)
  (define std/srfi/144#fl-pi '3.141592653589793)
  (define std/srfi/144#fl-1/pi '.3183098861837907)
  (define std/srfi/144#fl-2pi '6.283185307179586)
  (define std/srfi/144#fl-pi/2 '1.5707963267948966)
  (define std/srfi/144#fl-2/pi '.6366197723675814)
  (define std/srfi/144#fl-pi/4 '.7853981633974483)
  (define std/srfi/144#fl-2/sqrt-pi '1.1283791670955126)
  (define std/srfi/144#fl-sqrt-pi '1.772453850905516)
  (define std/srfi/144#fl-pi-squared '9.869604401089358)
  (define std/srfi/144#fl-degree '.017453292519943295)
  (define std/srfi/144#fl-gamma-1/2 '1.772453850905516)
  (define std/srfi/144#fl-gamma-1/3 '2.6789385347077475)
  (define std/srfi/144#fl-gamma-2/3 '1.3541179394264005)
  (define std/srfi/144#fl-sqrt-2 '1.4142135623730951)
  (define std/srfi/144#fl-sqrt-3 '1.7320508075688772)
  (define std/srfi/144#fl-sqrt-5 '2.23606797749979)
  (define std/srfi/144#fl-sqrt-10 '3.1622776601683795)
  (define std/srfi/144#fl-cbrt-2 '1.2599210498948732)
  (define std/srfi/144#fl-cbrt-3 '1.4422495703074083)
  (define std/srfi/144#fl-4thrt-2 '1.189207115002721)
  (define std/srfi/144#fl-1/sqrt-2 '.7071067811865476)
  (define std/srfi/144#fl-phi '1.618033988749895)
  (define std/srfi/144#fl-log-phi '.48121182505960347)
  (define std/srfi/144#fl-1/log-phi '2.0780869212350277)
  (define std/srfi/144#fl-euler '.5772156649015329)
  (define std/srfi/144#fl-e-euler '1.781072417990198)
  (define std/srfi/144#fl-sin-1 '.8414709848078965)
  (define std/srfi/144#fl-cos-1 '.5403023058681398)
  (define std/srfi/144#FIXME 'FIXME)
  (define std/srfi/144#precision-bits
    (let _loop890_ ((_bits892_ '0) (_x893_ '1.))
      (if (= _x893_ (+ _x893_ '1.))
          _bits892_
          (_loop890_ (+ _bits892_ '1) (* '2. _x893_)))))
  (define std/srfi/144#check-flonum!
    (lambda (_name887_ _x888_)
      (if (not (flonum? _x888_))
          (error (string-append
                  '"non-flonum argument passed to "
                  (symbol->string _name887_))
                 _x888_)
          '#!void)))
  (define std/srfi/144#flop1
    (lambda (_name880_ _op881_)
      (lambda (_x883_)
        (std/srfi/144#check-flonum! _name880_ _x883_)
        (let ((_result885_ (_op881_ _x883_)))
          (if (not (flonum? _result885_))
              (error (string-append
                      '"non-flonum result from "
                      (symbol->string _name880_))
                     _result885_)
              '#!void)
          _result885_))))
  (define std/srfi/144#flop2
    (lambda (_name872_ _op873_)
      (lambda (_x875_ _y876_)
        (std/srfi/144#check-flonum! _name872_ _x875_)
        (std/srfi/144#check-flonum! _name872_ _y876_)
        (let ((_result878_ (_op873_ _x875_ _y876_)))
          (if (not (flonum? _result878_))
              (error (string-append
                      '"non-flonum result from "
                      (symbol->string _name872_))
                     _result878_)
              '#!void)
          _result878_))))
  (define std/srfi/144#flop3
    (lambda (_name863_ _op864_)
      (lambda (_x866_ _y867_ _z868_)
        (std/srfi/144#check-flonum! _name863_ _x866_)
        (std/srfi/144#check-flonum! _name863_ _y867_)
        (std/srfi/144#check-flonum! _name863_ _z868_)
        (let ((_result870_ (_op864_ _x866_ _y867_ _z868_)))
          (if (not (flonum? _result870_))
              (error (string-append
                      '"non-flonum result from "
                      (symbol->string _name863_))
                     _result870_)
              '#!void)
          _result870_))))
  (define std/srfi/144#polynomial-at
    (lambda (_x860_ _coefs861_)
      (if (null? _coefs861_)
          '0.
          (fl+ (car _coefs861_)
               (fl* _x860_
                    (std/srfi/144#polynomial-at _x860_ (cdr _coefs861_)))))))
  (define std/srfi/144#definite-integral
    (lambda (_lower835_ _upper836_ _f837_ . _rest838_)
      (let* ((_range840_ (fl- _upper836_ _lower835_))
             (_kmax845_
              (if (or (null? _rest838_)
                      (not (and (exact-integer? (car _rest838_))
                                (even? (car _rest838_))
                                (positive? (car _rest838_)))))
                  '1024
                  (car _rest838_)))
             (_n2847_ (inexact _kmax845_))
             (_h849_ (fl/ _range840_ _n2847_)))
        (letrec ((_loop852_
                  (lambda (_k854_ _n855_ _sum856_)
                    (if (= _k854_ '0)
                        (_loop852_ '1 '1. (_f837_ _lower835_))
                        (if (= _k854_ _kmax845_)
                            (fl+ _sum856_ (_f837_ _upper836_))
                            (let ((_fn858_ (_f837_ (+ _lower835_
                                                      (fl/ (fl* _n855_
                                                                _range840_)
                                                           _n2847_)))))
                              (_loop852_
                               (+ _k854_ '1)
                               (fl+ _n855_ '1.)
                               (fl+ _sum856_
                                    (fl* (if (even? _k854_) '2. '4.)
                                         _fn858_)))))))))
          (fl/ (fl* _h849_ (_loop852_ '0 '0. '0.)) '3.)))))
  (define std/srfi/144#interpolate
    (lambda (_x827_ _x0828_ _x1829_ _f0830_ _f1831_)
      (let ((_delta833_ (fl- _x1829_ _x0828_)))
        (fl+ (fl* (fl/ (fl- _x1829_ _x827_) _delta833_) _f0830_)
             (fl* (fl/ (fl- _x827_ _x0828_) _delta833_) _f1831_)))))
  (define std/srfi/144#iota
    (lambda (_n819_)
      (let _$loop821_ ((_n824_ (- _n819_ '1)) (_x825_ '()))
        (if (< _n824_ '0)
            _x825_
            (_$loop821_ (- _n824_ '1) (cons _n824_ _x825_))))))
  (define std/srfi/144#fact
    (lambda (_x817_)
      (if (zero? _x817_) '1 (* _x817_ (std/srfi/144#fact (- _x817_ '1))))))
  (define std/srfi/144#factorial
    (lambda (_x815_)
      (if (flzero? _x815_)
          '1.
          (fl* _x815_ (std/srfi/144#factorial (fl- _x815_ '1.))))))
  (define std/srfi/144#fl-greatest
    (let _loop811_ ((_x813_ (- (expt '2. std/srfi/144#precision-bits) '1.)))
      (if (finite? (* '2. _x813_)) (_loop811_ (* '2. _x813_)) _x813_)))
  (define std/srfi/144#fl-least
    (let _loop807_ ((_x809_ '1.))
      (if (> (/ _x809_ '2.) '0.) (_loop807_ (/ _x809_ '2.)) _x809_)))
  (define std/srfi/144#fl-epsilon
    (let _loop803_ ((_eps805_ '1.))
      (if (= '1. (+ '1. _eps805_))
          (* '2. _eps805_)
          (_loop803_ (/ _eps805_ '2.)))))
  (define std/srfi/144#fl-integer-exponent-zero
    (exact (- (log std/srfi/144#fl-least '2.) '1.)))
  (define std/srfi/144#fl-integer-exponent-nan
    (- std/srfi/144#fl-integer-exponent-zero '1))
  (define std/srfi/144#flonum
    (lambda (_x801_) (if (real? _x801_) (inexact _x801_) '+nan.0)))
  (define std/srfi/144#fladjacent
    (std/srfi/144#flop2
     'fladjacent
     (lambda (_x783_ _y784_)
       (letrec ((_loop786_
                 (lambda (_y796_)
                   (let ((_y3798_ (fl+ (fl* '.999755859375 _x783_)
                                       (fl* '2.44140625e-4 _y796_))))
                     (if (fl< _x783_ _y3798_ _y796_)
                         (_loop786_ _y3798_)
                         (if (fl< _y796_ _y3798_ _x783_)
                             (_loop786_ _y3798_)
                             (_loop2787_ _y796_))))))
                (_loop2787_
                 (lambda (_y789_)
                   (let* ((_y2791_ (fl/ (fl+ _x783_ _y789_) '2.))
                          (_y2793_ (if (flinfinite? _y2791_)
                                       (fl+ (fl* '.5 _x783_) (fl* '.5 _y789_))
                                       _y2791_)))
                     (if (fl= _x783_ _y2793_)
                         _y789_
                         (if (fl= _y789_ _y2793_)
                             _y789_
                             (_loop2787_ _y2793_)))))))
         (if (flinfinite? _x783_)
             (if (fl< _x783_ _y784_)
                 (fl- std/srfi/144#fl-greatest)
                 (if (fl> _x783_ _y784_) std/srfi/144#fl-greatest _x783_))
             (if (fl= _x783_ _y784_)
                 _x783_
                 (if (flzero? _x783_)
                     (if (flpositive? _y784_)
                         std/srfi/144#fl-least
                         (fl- std/srfi/144#fl-least))
                     (if (fl< _x783_ _y784_)
                         (_loop786_
                          (flmin _y784_
                                 std/srfi/144#fl-greatest
                                 (flmax (* '2. _x783_) (* '.5 _x783_))))
                         (if (fl> _x783_ _y784_)
                             (_loop786_
                              (flmax _y784_
                                     (fl- std/srfi/144#fl-greatest)
                                     (flmin (* '2. _x783_) (* '.5 _x783_))))
                             _x783_)))))))))
  (define std/srfi/144#flcopysign
    (std/srfi/144#flop2
     'flcopysign
     (lambda (_x780_ _y781_)
       (if (= (std/srfi/144#flsign-bit _x780_)
              (std/srfi/144#flsign-bit _y781_))
           _x780_
           (fl- _x780_)))))
  (define std/srfi/144#make-flonum
    (lambda (_x772_ _n773_)
      (let ((_y775_ (expt '2. _n773_)))
        (if (or (not (flonum? _x772_)) (not (exact-integer? _n773_)))
            (error '"bad arguments to make-flonum" _x772_ _n773_)
            (if (finite? _y775_)
                (* _x772_ _y775_)
                (inexact (* (exact _x772_) (expt '2 _n773_))))))))
  (define std/srfi/144#flinteger-fraction
    (lambda (_x765_)
      (std/srfi/144#check-flonum! 'flinteger-fraction _x765_)
      (let* ((_result1767_ (fltruncate _x765_))
             (_result2769_ (fl- _x765_ _result1767_)))
        (values _result1767_ _result2769_))))
  (define std/srfi/144#flexponent
    (lambda (_x763_) (floor (std/srfi/144#fllog2 (flabs _x763_)))))
  (define std/srfi/144#flinteger-exponent
    (lambda (_x761_) (exact (std/srfi/144#flexponent _x761_))))
  (define std/srfi/144#flnormalized-fraction-exponent
    (lambda (_x730_)
      (letrec ((_return732_
                (lambda (_result1758_ _result2759_)
                  (if (fl< _result1758_ '.5)
                      (values (fl* '2. _result1758_) (- _result2759_ '1))
                      (if (fl>= _result1758_ '1.)
                          (values (fl* '.5 _result1758_) (+ _result2759_ '1))
                          (values _result1758_ _result2759_))))))
        (std/srfi/144#check-flonum! 'flnormalized-fraction-exponent _x730_)
        (if (flnan? _x730_)
            (values _x730_ '0)
            (if (fl< _x730_ '0.)
                (call-with-values
                 (lambda ()
                   (std/srfi/144#flnormalized-fraction-exponent (fl- _x730_)))
                 (lambda (_y735_ _n736_) (values (fl- _y735_) _n736_)))
                (if (fl= _x730_ '0.)
                    (values '0. '0)
                    (if (flinfinite? _x730_)
                        (values '.5
                                (+ '3
                                   (exact (round (std/srfi/144#fllog2
                                                  std/srfi/144#fl-greatest)))))
                        (if (std/srfi/144#flnormalized? _x730_)
                            (let* ((_result2738_
                                    (exact (flround (std/srfi/144#fllog2
                                                     _x730_))))
                                   (_result2740_
                                    (if (integer? _result2738_)
                                        _result2738_
                                        (round _result2738_)))
                                   (_two^result2742_
                                    (inexact (expt '2. _result2740_))))
                              (if (flinfinite? _two^result2742_)
                                  (call-with-values
                                   (lambda ()
                                     (std/srfi/144#flnormalized-fraction-exponent
                                      (fl/ _x730_ '4.)))
                                   (lambda (_y746_ _n747_)
                                     (values _y746_ (+ _n747_ '2))))
                                  (_return732_
                                   (fl/ _x730_ _two^result2742_)
                                   _result2740_)))
                            (let* ((_k749_ (+ '2 std/srfi/144#precision-bits))
                                   (_two^k751_ (expt '2 _k749_)))
                              (call-with-values
                               (lambda ()
                                 (std/srfi/144#flnormalized-fraction-exponent
                                  (fl* _x730_ (inexact _two^k751_))))
                               (lambda (_y755_ _n756_)
                                 (_return732_
                                  _y755_
                                  (- _n756_ _k749_)))))))))))))
  (define std/srfi/144#flsign-bit
    (lambda (_x728_)
      (std/srfi/144#check-flonum! 'flsign-bit _x728_)
      (if (fl< _x728_ '0.) '1 (if (eqv? _x728_ '-0.) '1 '0))))
  (define std/srfi/144#flunordered?
    (lambda (_x722_ _y723_)
      (let ((_$e725_ (flnan? _x722_))) (if _$e725_ _$e725_ (flnan? _y723_)))))
  (define std/srfi/144#flnormalized?
    (lambda (_x718_)
      (std/srfi/144#check-flonum! 'flnormalized? _x718_)
      (let ((_x720_ (flabs _x718_)))
        (if (flfinite? _x720_)
            (fl< (fl/ std/srfi/144#fl-greatest) _x720_)
            '#f))))
  (define std/srfi/144#fldenormalized?
    (lambda (_x714_)
      (std/srfi/144#check-flonum! 'fldenormalized? _x714_)
      (let ((_x716_ (flabs _x714_)))
        (if (flfinite? _x716_)
            (if (fl< '0. _x716_)
                (fl<= _x716_ (fl/ std/srfi/144#fl-greatest))
                '#f)
            '#f))))
  (define std/srfi/144#fl+*
    (std/srfi/144#flop3
     'fl+*
     (lambda (_x706_ _y707_ _z708_)
       (if std/srfi/144#c-functions-are-available
           (std/srfi/144#fma _x706_ _y707_ _z708_)
           (if (and (flfinite? _x706_) (flfinite? _y707_))
               (if (flfinite? _z708_)
                   (let ((_x710_ (exact _x706_))
                         (_y711_ (exact _y707_))
                         (_z712_ (exact _z708_)))
                     (std/srfi/144#flonum (+ (* _x710_ _y711_) _z712_)))
                   _z708_)
               (fl+ (fl* _x706_ _y707_) _z708_))))))
  (define std/srfi/144#flabsdiff
    (lambda (_x703_ _y704_) (flabs (fl- _x703_ _y704_))))
  (define std/srfi/144#flposdiff
    (lambda (_x698_ _y699_)
      (let ((_diff701_ (fl- _x698_ _y699_)))
        (if (flnegative? _diff701_) '0. _diff701_))))
  (define std/srfi/144#flsgn
    (lambda (_x696_) (std/srfi/144#flcopysign '1. _x696_)))
  (define std/srfi/144#flnumerator
    (std/srfi/144#flop1
     'flnumerator
     (lambda (_x694_)
       (if (flnan? _x694_) _x694_ (std/srfi/144#flnumerator _x694_)))))
  (define std/srfi/144#fldenominator
    (std/srfi/144#flop1
     'fldenominator
     (lambda (_x692_)
       (if (flnan? _x692_) _x692_ (std/srfi/144#fldenominator _x692_)))))
  (define std/srfi/144#flexp2
    (std/srfi/144#flop1 'flexp2 (lambda (_x690_) (flexpt '2. _x690_))))
  (define std/srfi/144#flexp-1
    (std/srfi/144#flop1
     'flexp-1
     (let ((_coefs686_
            (cons '0.
                  (map fl/
                       (map std/srfi/144#factorial
                            '(1.
                              2.
                              3.
                              4.
                              5.
                              6.
                              7.
                              8.
                              9.
                              10.
                              11.
                              12.
                              13.
                              14.
                              15.))))))
       (lambda (_x688_)
         (if (fl< (flabs _x688_) '.5)
             (std/srfi/144#polynomial-at _x688_ _coefs686_)
             (fl- (flexp _x688_) '1.))))))
  (define std/srfi/144#flsquare
    (std/srfi/144#flop1 'flsquare (lambda (_x684_) (fl* _x684_ _x684_))))
  (define std/srfi/144#flcbrt
    (std/srfi/144#flop1
     'flcbrt
     (lambda (_x682_)
       (if (flnegative? _x682_)
           (fl- (std/srfi/144#flcbrt (fl- _x682_)))
           (flexpt _x682_ (fl/ '3.))))))
  (define std/srfi/144#flhypot
    (std/srfi/144#flop2
     'flhypot
     (lambda (_x671_ _y672_)
       (if (flzero? _x671_)
           (flabs _y672_)
           (if (flzero? _y672_)
               (flabs _x671_)
               (if (or (flinfinite? _x671_) (flinfinite? _y672_))
                   '+inf.0
                   (if (flnan? _x671_)
                       _x671_
                       (if (flnan? _y672_)
                           _y672_
                           (if (fl> _y672_ _x671_)
                               (std/srfi/144#flhypot _y672_ _x671_)
                               (let* ((_y/x677_ (fl/ _y672_ _x671_))
                                      (_root679_
                                       (flsqrt (fl+ '1.
                                                    (fl* _y/x677_ _y/x677_)))))
                                 (fl* (flabs _x671_) _root679_)))))))))))
  (define std/srfi/144#fllog1+
    (std/srfi/144#flop1
     'fllog1+
     (lambda (_x667_)
       (let ((_u669_ (fl+ '1. _x667_)))
         (if (fl= _u669_ '1.)
             _x667_
             (if (fl= _u669_ _x667_)
                 (fllog _u669_)
                 (fl* (fllog _u669_) (fl/ _x667_ (fl- _u669_ '1.)))))))))
  (define std/srfi/144#fllog2
    (std/srfi/144#flop1 'fllog2 (lambda (_x665_) (log _x665_ '2.))))
  (define std/srfi/144#fllog10
    (std/srfi/144#flop1 'fllog10 (lambda (_x663_) (log _x663_ '10.))))
  (define std/srfi/144#make-fllog-base
    (lambda (_base659_)
      (std/srfi/144#check-flonum! 'make-fllog-base _base659_)
      (if (fl> _base659_ '1.)
          (std/srfi/144#flop1
           'procedure-created-by-make-fllog-base
           (lambda (_x661_) (log _x661_ _base659_)))
          (error '"argument to make-fllog-base must be greater than 1.0"
                 _base659_))))
  (define std/srfi/144#flsinh
    (std/srfi/144#flop1
     'flsinh
     (lambda (_x657_)
       (if (not (flfinite? _x657_))
           _x657_
           (if (fl< (flabs _x657_) '.75)
               (fl/ (fl- (std/srfi/144#flexp-1 _x657_)
                         (std/srfi/144#flexp-1 (fl- _x657_)))
                    '2.)
               (fl/ (fl- (flexp _x657_) (flexp (fl- _x657_))) '2.))))))
  (define std/srfi/144#flcosh
    (std/srfi/144#flop1
     'flcosh
     (lambda (_x655_)
       (if (not (flfinite? _x655_))
           (flabs _x655_)
           (if (fl< (flabs _x655_) '.75)
               (fl+ '1.
                    (fl/ (fl+ (std/srfi/144#flexp-1 _x655_)
                              (std/srfi/144#flexp-1 (fl- _x655_)))
                         '2.))
               (fl/ (fl+ (flexp _x655_) (flexp (fl- _x655_))) '2.))))))
  (define std/srfi/144#fltanh
    (std/srfi/144#flop1
     'fltanh
     (lambda (_x650_)
       (if (flinfinite? _x650_)
           (std/srfi/144#flcopysign '1. _x650_)
           (if (flnan? _x650_)
               _x650_
               (let ((_a652_ (std/srfi/144#flsinh _x650_))
                     (_b653_ (std/srfi/144#flcosh _x650_)))
                 (if (fl= _a652_ _b653_)
                     '1.
                     (if (fl= _a652_ (fl- _b653_))
                         '-1.
                         (fl/ (std/srfi/144#flsinh _x650_)
                              (std/srfi/144#flcosh _x650_))))))))))
  (define std/srfi/144#flasinh
    (std/srfi/144#flop1
     'flasinh
     (lambda (_x634_)
       (letrec ((_eqn4.6.31636_
                 (lambda (_x^2645_ _c646_ _k647_ _k0648_)
                   (if (> _k647_ '45)
                       _c646_
                       (fl+ _c646_
                            (fl* _x^2645_
                                 (_eqn4.6.31636_
                                  _x^2645_
                                  (fl- (fl/ (fl* _c646_ _k0648_ _k0648_)
                                            (fl* (fl+ _k0648_ '1.)
                                                 (fl+ _k0648_ '2.))))
                                  (+ _k647_ '2)
                                  (fl+ _k0648_ '2.))))))))
         (if (flzero? _x634_)
             _x634_
             (if (not (flfinite? _x634_))
                 _x634_
                 (if (fl< _x634_ '0.)
                     (fl- (std/srfi/144#flasinh (fl- _x634_)))
                     (if (fl< _x634_ '.5)
                         (fl* _x634_
                              (_eqn4.6.31636_ (fl* _x634_ _x634_) '1. '1 '1.))
                         (let* ((_x^2+1638_ (fl+ (fl* _x634_ _x634_) '1.))
                                (_root640_
                                 (if (flfinite? _x^2+1638_)
                                     (flsqrt _x^2+1638_)
                                     _x634_))
                                (_a642_ (fl+ _x634_ _root640_)))
                           (if (flfinite? _a642_)
                               (fllog _a642_)
                               (fl+ std/srfi/144#fl-log-2
                                    (fllog _x634_))))))))))))
  (define std/srfi/144#flacosh
    (std/srfi/144#flop1
     'flacosh
     (lambda (_x625_)
       (if (fl<= _x625_ '.5)
           '+nan.0
           (let* ((_x^2-1627_ (fl- (fl* _x625_ _x625_) '1.))
                  (_root629_
                   (if (flfinite? _x^2-1627_) (flsqrt _x^2-1627_) _x625_))
                  (_a631_ (fl+ _x625_ _root629_)))
             (if (flfinite? _a631_)
                 (fllog _a631_)
                 (fl+ std/srfi/144#fl-log-2 (fllog _x625_))))))))
  (define std/srfi/144#flatanh
    (std/srfi/144#flop1
     'flatanh
     (lambda (_x617_)
       (letrec ((_eqn4.6.33619_
                 (lambda (_x^2621_ _k622_ _k0623_)
                   (if (> _k622_ '50)
                       (fl/ _k0623_)
                       (fl+ (fl/ _k0623_)
                            (fl* _x^2621_
                                 (_eqn4.6.33619_
                                  _x^2621_
                                  (+ _k622_ '2)
                                  (+ _k0623_ '2.))))))))
         (if (flzero? _x617_)
             _x617_
             (if (not (flfinite? _x617_))
                 _x617_
                 (if (fl< _x617_ '0.)
                     (fl- (std/srfi/144#flatanh (fl- _x617_)))
                     (if (fl< _x617_ '.5)
                         (fl* _x617_
                              (_eqn4.6.33619_ (fl* _x617_ _x617_) '1 '1.))
                         (fl* '.5
                              (fllog (fl/ (fl+ '1. _x617_)
                                          (fl- '1. _x617_))))))))))))
  (define std/srfi/144#flquotient
    (std/srfi/144#flop2
     'flquotient
     (lambda (_x614_ _y615_) (fltruncate (fl/ _x614_ _y615_)))))
  (define std/srfi/144#flremainder
    (std/srfi/144#flop2
     'flremainder
     (lambda (_x611_ _y612_)
       (fl- _x611_ (fl* _y612_ (std/srfi/144#flquotient _x611_ _y612_))))))
  (define std/srfi/144#flremquo
    (lambda (_x603_ _y604_)
      (std/srfi/144#check-flonum! 'flremquo _x603_)
      (std/srfi/144#check-flonum! 'flremquo _y604_)
      (let* ((_quo606_ (flround (fl/ _x603_ _y604_)))
             (_rem608_ (fl- _x603_ (fl* _y604_ _quo606_))))
        (values _rem608_ (exact _quo606_)))))
  (define std/srfi/144#flgamma
    (lambda (_x601_)
      (std/srfi/144#check-flonum! 'flgamma _x601_)
      (if (fl>= _x601_ std/srfi/144#flgamma:upper-cutoff)
          '+inf.0
          (if (fl<= _x601_ std/srfi/144#flgamma:lower-cutoff)
              (if (= _x601_ '-inf.0)
                  '+nan.0
                  (if (flinteger? _x601_)
                      '+nan.0
                      (if (flodd? (fltruncate _x601_)) '0. '-0.)))
              (std/srfi/144#Gamma _x601_)))))
  (define std/srfi/144#Gamma
    (lambda (_x595_)
      (if (fl> _x595_ '2.)
          (let ((_x597_ (fl- _x595_ '2.)))
            (fl* _x597_ (fl+ _x597_ '1.) (std/srfi/144#Gamma _x597_)))
          (if (fl= _x595_ '2.)
              '1.
              (if (fl> _x595_ '1.)
                  (let ((_x599_ (fl- _x595_ '1.)))
                    (fl* _x599_ (std/srfi/144#Gamma _x599_)))
                  (if (fl= _x595_ '1.)
                      '1.
                      (if (fl= _x595_ '0.)
                          '+inf.0
                          (if (fl< _x595_ '0.)
                              (if (flinteger? _x595_)
                                  '+nan.0
                                  (fl/ (std/srfi/144#Gamma (fl+ _x595_ '2.))
                                       _x595_
                                       (fl+ _x595_ '1.)))
                              (fl/ (std/srfi/144#polynomial-at
                                    _x595_
                                    std/srfi/144#gamma-coefs))))))))))
  (define std/srfi/144#gamma-coefs
    '(0.
      1.
      .5772156649015329
      -.6558780715202538
      -.0420026350340952
      .1665386113822915
      -.0421977345555443
      -.009621971527877
      .007218943246663
      -.0011651675918591
      -2.152416741149e-4
      1.280502823882e-4
      -2.01348547807e-5
      -1.2504934821e-6
      1.133027232e-6
      -2.056338417e-7
      6.116095e-9
      5.0020075e-9
      -1.1812746e-9
      1.043427e-10
      7.7823e-12
      -3.6968e-12
      5.1e-13
      -2.06e-14
      -5.4e-15
      1.4e-15
      1e-16))
  (define std/srfi/144#flgamma:upper-cutoff
    (let _$loop590_ ((_x593_ '2.))
      (if (flinfinite? (std/srfi/144#Gamma _x593_))
          _x593_
          (_$loop590_ (+ _x593_ '1.)))))
  (define std/srfi/144#flgamma:lower-cutoff
    (let _$loop585_ ((_x588_ '-2.))
      (if (flzero? (std/srfi/144#Gamma (std/srfi/144#fladjacent _x588_ '0.)))
          _x588_
          (_$loop585_ (- _x588_ '1.)))))
  (define std/srfi/144#flloggamma
    (lambda (_x579_)
      (std/srfi/144#check-flonum! 'flloggamma _x579_)
      (if (flinfinite? _x579_)
          (if (flpositive? _x579_)
              (values _x579_ '1.)
              (values '+inf.0 '+nan.0))
          (if (fl>= _x579_ std/srfi/144#flloggamma:upper-threshold)
              (values (std/srfi/144#eqn6.1.48 _x579_) '1.)
              (if (fl> _x579_ '0.)
                  (let ((_g581_ (std/srfi/144#flgamma _x579_)))
                    (values (log _g581_) '1.))
                  (let ((_g583_ (std/srfi/144#flgamma _x579_)))
                    (values (log (flabs _g583_))
                            (std/srfi/144#flcopysign '1. _g583_))))))))
  (define std/srfi/144#eqn6.1.48
    (lambda (_x574_)
      (let ((_+576_ fl+) (_/577_ fl/))
        (_+576_ (fl* (fl- _x574_ '.5) (fllog _x574_))
                (fl- _x574_)
                (fl* '.5 (fllog std/srfi/144#fl-2pi))
                (_/577_ '.08333333333333333
                        (_+576_ _x574_
                                (_/577_ '.03333333333333333
                                        (_+576_ _x574_
                                                (_/577_ '.2523809523809524
                                                        (_+576_ _x574_
                                                                (_/577_ '.5256064690026954
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                                (_+576_ _x574_
                                        (_/577_ '1.0115230681268417
                                                (_+576_ _x574_
                                                        (_/577_ '1.5174736491532874
                                                                (_+576_ _x574_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                                (_/577_ '2.2694889742049598
                                        (_+576_ _x574_))))))))))))))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
  (define std/srfi/144#flloggamma:upper-threshold '20.)
  (define std/srfi/144#flfirst-bessel
    (lambda (_n560_ _x561_)
      (letrec ((_nan-protected563_
                (lambda (_y572_) (if (flfinite? _y572_) _y572_ '0.))))
        (std/srfi/144#check-flonum! 'flfirst-bessel _x561_)
        (if std/srfi/144#c-functions-are-available
            (std/srfi/144#jn _n560_ _x561_)
            (if (< _n560_ '0)
                (let ((_result565_
                       (std/srfi/144#flfirst-bessel (- _n560_) _x561_)))
                  (if (even? _n560_) _result565_ (- _result565_)))
                (if (< _x561_ '0)
                    (let ((_result567_
                           (std/srfi/144#flfirst-bessel _n560_ (- _x561_))))
                      (if (even? _n560_) _result567_ (- _result567_)))
                    (if (= _x561_ '+inf.0)
                        '0.
                        (let ((_$e569_ _n560_))
                          (if (eq? '0 _$e569_)
                              (if (fl< _x561_ '4.5)
                                  (std/srfi/144#eqn9.1.10 _n560_ _x561_)
                                  (if (fl< _x561_ '93.)
                                      (std/srfi/144#eqn9.1.18 _n560_ _x561_)
                                      (std/srfi/144#eqn9.2.5 _n560_ _x561_)))
                              (if (eq? '1 _$e569_)
                                  (if (fl< _x561_ '11.)
                                      (std/srfi/144#eqn9.1.10-fast
                                       _n560_
                                       _x561_)
                                      (if (fl< _x561_ '300.)
                                          (std/srfi/144#eqn9.1.75
                                           _n560_
                                           _x561_)
                                          (if (fl< _x561_ '1e12)
                                              (std/srfi/144#eqn9.2.5
                                               _n560_
                                               _x561_)
                                              (std/srfi/144#eqn9.2.1
                                               _n560_
                                               _x561_))))
                                  (if (eq? '2 _$e569_)
                                      (if (fl< _x561_ '10.)
                                          (std/srfi/144#eqn9.1.10-fast
                                           _n560_
                                           _x561_)
                                          (if (fl< _x561_ '1e19)
                                              (std/srfi/144#eqn9.1.27-first-bessel
                                               _n560_
                                               _x561_)
                                              '0.))
                                      (if (eq? '3 _$e569_)
                                          (if (fl< _x561_ '10.)
                                              (std/srfi/144#eqn9.1.10-fast
                                               _n560_
                                               _x561_)
                                              (if (fl< _x561_ '1000000.)
                                                  (std/srfi/144#eqn9.1.27-first-bessel
                                                   _n560_
                                                   _x561_)
                                                  (_nan-protected563_
                                                   (std/srfi/144#eqn9.2.5
                                                    _n560_
                                                    _x561_))))
                                          (if (fl< _x561_ '12.)
                                              (_nan-protected563_
                                               (std/srfi/144#eqn9.1.10-fast
                                                _n560_
                                                _x561_))
                                              (if (fl< _x561_ '150.)
                                                  (_nan-protected563_
                                                   (if (fl> (inexact _n560_)
                                                            _x561_)
                                                       (std/srfi/144#method9.12ex1
                                                        _n560_
                                                        _x561_)
                                                       (std/srfi/144#eqn9.1.75
                                                        _n560_
                                                        _x561_)))
                                                  (if (fl< _x561_ '1e18)
                                                      (_nan-protected563_
                                                       (std/srfi/144#eqn9.1.27-first-bessel
                                                        _n560_
                                                        _x561_))
                                                      '0.)))))))))))))))
  (define std/srfi/144#flsecond-bessel
    (lambda (_n547_ _x548_)
      (std/srfi/144#check-flonum! 'flsecond-bessel _x548_)
      (if std/srfi/144#c-functions-are-available
          (std/srfi/144#yn _n547_ _x548_)
          (if (< _n547_ '0)
              (let ((_result550_
                     (std/srfi/144#flsecond-bessel (- _n547_) _x548_)))
                (if (even? _n547_) _result550_ (- _result550_)))
              (if (fl< _x548_ '0.)
                  '+nan.0
                  (if (fl= _x548_ '0.)
                      '-inf.0
                      (if (fl= _x548_ '+inf.0)
                          '0.
                          (let ((_$e552_ _n547_))
                            (if (eq? '0 _$e552_)
                                (if (fl< _x548_ '14.5)
                                    (std/srfi/144#eqn9.1.13 '0 _x548_)
                                    (std/srfi/144#eqn9.2.6 '0 _x548_))
                                (if (eq? '1 _$e552_)
                                    (if (fl< _x548_ '1e12)
                                        (std/srfi/144#eqn9.1.16 _n547_ _x548_)
                                        (std/srfi/144#eqn9.2.6 _n547_ _x548_))
                                    (if (or (eq? '2 _$e552_) (eq? '3 _$e552_))
                                        (std/srfi/144#eqn9.1.27-second-bessel
                                         _n547_
                                         _x548_)
                                        (let ((_ynx558_
                                               (std/srfi/144#eqn9.1.27-second-bessel
                                                _n547_
                                                _x548_)))
                                          (if (flnan? _ynx558_)
                                              '-inf.0
                                              _ynx558_)))))))))))))
  (define std/srfi/144#eqn9.1.10
    (lambda (_n544_ _x545_)
      (fl* (inexact (expt (* '.5 _x545_) _n544_))
           (std/srfi/144#polynomial-at
            (std/srfi/144#flsquare _x545_)
            (if (= _n544_ '0)
                std/srfi/144#eqn9.1.10-coefficients-0
                (if (= _n544_ '1)
                    std/srfi/144#eqn9.1.10-coefficients-1
                    (std/srfi/144#eqn9.1.10-coefficients _n544_)))))))
  (define std/srfi/144#eqn9.1.10-coefficients
    (lambda (_n533_)
      (letrec ((_loop535_
                (lambda (_k539_ _prev540_)
                  (if (flzero? (inexact _prev540_))
                      '()
                      (let ((_c542_ (/ (* '-1/4 _prev540_)
                                       _k539_
                                       (+ _n533_ _k539_))))
                        (cons _c542_ (_loop535_ (+ _k539_ '1) _c542_)))))))
        (let ((_c537_ (/ (std/srfi/144#fact _n533_))))
          (map inexact (cons _c537_ (_loop535_ '1 _c537_)))))))
  (define std/srfi/144#eqn9.1.10-coefficients-0
    (std/srfi/144#eqn9.1.10-coefficients '0))
  (define std/srfi/144#eqn9.1.10-coefficients-1
    (std/srfi/144#eqn9.1.10-coefficients '1))
  (define std/srfi/144#eqn9.1.10-fast
    (lambda (_n518_ _x519_)
      (let* ((_y521_ (fl* '.5 _x519_))
             (_y2523_ (fl- (fl* _y521_ _y521_)))
             (_bound525_ (+ '25. (inexact _n518_))))
        (letrec ((_loop528_
                  (lambda (_k530_ _n+k531_)
                    (if (fl> _n+k531_ _bound525_)
                        '1.
                        (fl+ '1.
                             (fl* (fl/ _y2523_ (fl* _k530_ _n+k531_))
                                  (_loop528_
                                   (fl+ '1. _k530_)
                                   (fl+ '1. _n+k531_))))))))
          (fl/ (fl* (inexact (expt _y521_ _n518_))
                    (_loop528_ '1. (fl+ '1. (inexact _n518_))))
               (std/srfi/144#factorial (inexact _n518_)))))))
  (define std/srfi/144#eqn9.1.13
    (lambda (_n515_ _x516_)
      (if (not (= _n515_ '0)) (error '"eqn9.1.13 requires n=0") '#!void)
      (fl* '2.
           std/srfi/144#fl-1/pi
           (fl+ (fl* (fl+ (fllog (fl/ _x516_ '2.)) std/srfi/144#fl-euler)
                     (std/srfi/144#flfirst-bessel '0 _x516_))
                (std/srfi/144#polynomial-at
                 (fl* '.25 _x516_ _x516_)
                 std/srfi/144#eqn9.1.13-coefficients)))))
  (define std/srfi/144#eqn9.1.13-coefficients
    (map (lambda (_k509_)
           (if (= _k509_ '0)
               '0.
               (if (= _k509_ '1)
                   '1.
                   (let ((_c513_ (/ (apply +
                                           (map /
                                                (cdr (std/srfi/144#iota
                                                      (+ _k509_ '1)))))
                                    (let ((_k!511_ (std/srfi/144#fact _k509_)))
                                      (* _k!511_ _k!511_)))))
                     (inexact (if (even? _k509_) (- _c513_) _c513_))))))
         (std/srfi/144#iota '25)))
  (define std/srfi/144#eqn9.1.16
    (lambda (_n+1504_ _x505_)
      (if (= '0 _n+1504_)
          (std/srfi/144#flsecond-bessel '0 _x505_)
          (let ((_n507_ (- _n+1504_ '1)))
            (fl/ (fl- (fl* (std/srfi/144#flfirst-bessel _n+1504_ _x505_)
                           (std/srfi/144#flsecond-bessel _n507_ _x505_))
                      (fl/ '2. (fl* std/srfi/144#fl-pi _x505_)))
                 (std/srfi/144#flfirst-bessel _n507_ _x505_))))))
  (define std/srfi/144#eqn9.1.18
    (lambda (_n499_ _x500_)
      (if (> _n499_ '0)
          (std/srfi/144#flfirst-bessel _n499_ _x500_)
          (fl* std/srfi/144#fl-1/pi
               (std/srfi/144#definite-integral
                '0.
                std/srfi/144#fl-pi
                (lambda (_theta502_) (flcos (fl* _x500_ (flsin _theta502_))))
                '128)))))
  (define std/srfi/144#eqn9.1.27-first-bessel
    (lambda (_n496_ _x497_)
      (std/srfi/144#eqn9.1.27 std/srfi/144#flfirst-bessel _n496_ _x497_)))
  (define std/srfi/144#eqn9.1.27-second-bessel
    (lambda (_n493_ _x494_)
      (std/srfi/144#eqn9.1.27 std/srfi/144#flsecond-bessel _n493_ _x494_)))
  (define std/srfi/144#eqn9.1.27
    (lambda (_f483_ _n0484_ _x485_)
      (letrec ((_loop487_
                (lambda (_n489_ _jn490_ _jn-1491_)
                  (if (= _n489_ _n0484_)
                      _jn490_
                      (_loop487_
                       (+ _n489_ '1)
                       (fl- (fl* (fl/ (inexact (+ _n489_ _n489_)) _x485_)
                                 _jn490_)
                            _jn-1491_)
                       _jn490_)))))
        (if (<= _n0484_ '1)
            (_f483_ _n0484_ _x485_)
            (_loop487_ '1 (_f483_ '1 _x485_) (_f483_ '0 _x485_))))))
  (define std/srfi/144#method9.12ex1
    (lambda (_n0463_ _x464_)
      (letrec ((_loop466_
                (lambda (_n475_ _jn476_ _jn+1477_ _jn0478_ _sumEvens479_)
                  (if (= _n475_ '0)
                      (fl/ _jn0478_ (+ _jn476_ _sumEvens479_ _sumEvens479_))
                      (let ((_jn-1481_
                             (fl- (fl/ (fl* '2. (inexact _n475_) _jn476_)
                                       _x464_)
                                  _jn+1477_)))
                        (_loop466_
                         (- _n475_ '1)
                         _jn-1481_
                         _jn476_
                         (if (= _n475_ _n0463_) _jn476_ _jn0478_)
                         (if (even? _n475_)
                             (fl+ _jn476_ _sumEvens479_)
                             _sumEvens479_)))))))
        (let* ((_n468_ (min '200 (+ _n0463_ '20)))
               (_jn+1470_ (fl/ _x464_ (fl* '2. (inexact _n468_))))
               (_jn472_ '1.))
          (_loop466_ (- _n468_ '1) _jn472_ _jn+1470_ '0. '0.)))))
  (define std/srfi/144#eqn9.1.75
    (lambda (_n453_ _x454_)
      (letrec* ((_k456_ (max '10 (* '2 (exact (flceiling _x454_)))))
                (_loop457_
                 (lambda (_x2459_ _m460_ _i461_)
                   (if (> _i461_ _k456_)
                       (fl/ '1. (fl* _m460_ _x2459_))
                       (fl/ '1.
                            (fl- (fl* _m460_ _x2459_)
                                 (_loop457_
                                  _x2459_
                                  (+ _m460_ '1.)
                                  (+ _i461_ '1))))))))
        (if (and (> _n453_ '0) (flpositive? _x454_) (fl< _x454_ '1000.))
            (fl* (std/srfi/144#eqn9.1.75 (- _n453_ '1) _x454_)
                 (_loop457_ (fl/ '2. _x454_) (inexact _n453_) '0))
            (std/srfi/144#flfirst-bessel _n453_ _x454_)))))
  (define std/srfi/144#eqn9.2.1
    (lambda (_n450_ _x451_)
      (fl* (flsqrt (/ '2. (fl* std/srfi/144#fl-pi _x451_)))
           (flcos (fl- _x451_
                       (fl* std/srfi/144#fl-pi
                            (fl+ (fl* '.5 (inexact _n450_)) '.25)))))))
  (define std/srfi/144#eqn9.2.5
    (lambda (_n445_ _x446_)
      (let ((_theta448_
             (fl- _x446_ (fl* (fl+ (/ _n445_ '2.) '.25) std/srfi/144#fl-pi))))
        (fl* (flsqrt (fl/ '2. (fl* std/srfi/144#fl-pi _x446_)))
             (fl- (fl* (std/srfi/144#eqn9.2.9 _n445_ _x446_)
                       (flcos _theta448_))
                  (fl* (std/srfi/144#eqn9.2.10 _n445_ _x446_)
                       (flsin _theta448_)))))))
  (define std/srfi/144#eqn9.2.6
    (lambda (_n440_ _x441_)
      (let ((_theta443_
             (fl- _x441_ (fl* (fl+ (/ _n440_ '2.) '.25) std/srfi/144#fl-pi))))
        (fl* (flsqrt (fl/ '2. (fl* std/srfi/144#fl-pi _x441_)))
             (fl+ (fl* (std/srfi/144#eqn9.2.9 _n440_ _x441_)
                       (flsin _theta443_))
                  (fl* (std/srfi/144#eqn9.2.10 _n440_ _x441_)
                       (flcos _theta443_)))))))
  (define std/srfi/144#eqn9.2.9
    (lambda (_n428_ _x429_)
      (letrec* ((_mu431_ (fl* '4. (std/srfi/144#flsquare (inexact _n428_))))
                (_coefficients432_
                 (lambda (_k2434_ _p435_ _fact2k436_)
                   (let ((_c438_ (fl/ _p435_ _fact2k436_)))
                     (if (fl> _k2434_ '20.)
                         (list _c438_)
                         (cons _c438_
                               (_coefficients432_
                                (fl+ _k2434_ '2.)
                                (fl* _p435_
                                     (fl- _mu431_
                                          (std/srfi/144#flsquare
                                           (fl+ _k2434_ '1.)))
                                     (fl- _mu431_
                                          (std/srfi/144#flsquare
                                           (fl+ _k2434_ '3.))))
                                (fl* _fact2k436_
                                     (fl+ _k2434_ '1.)
                                     (fl+ _k2434_ '2.)))))))))
        (std/srfi/144#polynomial-at
         (fl- (fl/ (std/srfi/144#flsquare (fl* '8. _x429_))))
         (_coefficients432_ '0. '1. '1.)))))
  (define std/srfi/144#eqn9.2.10
    (lambda (_n416_ _x417_)
      (letrec* ((_mu419_ (fl* '4. (std/srfi/144#flsquare (inexact _n416_))))
                (_coefficients420_
                 (lambda (_k2+1422_ _p423_ _fact2k+1424_)
                   (let ((_c426_ (fl/ _p423_ _fact2k+1424_)))
                     (if (fl> _k2+1422_ '20.)
                         (list _c426_)
                         (cons _c426_
                               (_coefficients420_
                                (fl+ _k2+1422_ '2.)
                                (fl* _p423_
                                     (fl- _mu419_
                                          (std/srfi/144#flsquare
                                           (fl+ _k2+1422_ '2.)))
                                     (fl- _mu419_
                                          (std/srfi/144#flsquare
                                           (fl+ _k2+1422_ '4.))))
                                (fl* _fact2k+1424_
                                     (fl+ _k2+1422_ '1.)
                                     (fl+ _k2+1422_ '2.)))))))))
        (fl* (fl/ (fl* '8. _x417_))
             (std/srfi/144#polynomial-at
              (fl- (fl/ (std/srfi/144#flsquare (fl* '8. _x417_))))
              (_coefficients420_ '1. (fl- _mu419_ '1.) '1.))))))
  (define std/srfi/144#flerf
    (lambda (_x414_)
      (std/srfi/144#check-flonum! 'flerf _x414_)
      (if (flnegative? _x414_)
          (fl- (std/srfi/144#flerf (fl- _x414_)))
          (if (fl< _x414_ '2.)
              (std/srfi/144#eqn7.1.6 _x414_)
              (if (fl< _x414_ '+inf.0)
                  (- '1. (std/srfi/144#eqn7.1.14 _x414_))
                  (if (fl= _x414_ '+inf.0) '1. _x414_))))))
  (define std/srfi/144#flerfc
    (lambda (_x412_)
      (std/srfi/144#check-flonum! 'flerfc _x412_)
      (if (flnegative? _x412_)
          (fl- '2. (std/srfi/144#flerfc (fl- _x412_)))
          (if (fl< _x412_ '2.)
              (std/srfi/144#eqn7.1.2 _x412_)
              (if (fl< _x412_ '+inf.0)
                  (std/srfi/144#eqn7.1.14 _x412_)
                  (if (fl= _x412_ '+inf.0) '0. _x412_))))))
  (define std/srfi/144#eqn7.1.2
    (lambda (_x410_) (fl- '1. (std/srfi/144#flerf _x410_))))
  (define std/srfi/144#eqn7.1.6
    (lambda (_x406_)
      (let ((_x^2408_ (std/srfi/144#flsquare _x406_)))
        (fl* std/srfi/144#fl-2/sqrt-pi
             (flexp (fl- _x^2408_))
             _x406_
             (std/srfi/144#polynomial-at
              _x^2408_
              std/srfi/144#eqn7.1.6-coefficients)))))
  (define std/srfi/144#eqn7.1.6-coefficients
    (let ()
      (letrec ((_loop399_
                (lambda (_n401_ _p402_)
                  (if (> _n401_ '32)
                      '()
                      (let ((_p404_ (fl* _p402_
                                         (inexact (+ (* '2 _n401_) '1)))))
                        (cons (fl/ (inexact (expt '2. _n401_)) _p404_)
                              (_loop399_ (+ _n401_ '1) _p404_)))))))
        (_loop399_ '0 '1.))))
  (define std/srfi/144#eqn7.1.14
    (lambda (_x388_)
      (letrec ((_continued-fraction390_
                (lambda (_x396_) (fl/ '1. (fl+ _x396_ (_loop391_ '1 '.5)))))
               (_loop391_
                (lambda (_k393_ _frac394_)
                  (if (> _k393_ '70)
                      '1.
                      (fl/ _frac394_
                           (fl+ _x388_
                                (_loop391_
                                 (+ _k393_ '1)
                                 (fl+ _frac394_ '.5))))))))
        (fl/ (_continued-fraction390_ _x388_)
             (fl* (flsqrt std/srfi/144#fl-pi)
                  (flexp (std/srfi/144#flsquare _x388_))))))))
