/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.BOB;

import net.i2p.util.Log;

public class Logger {
    public Log log;
    private boolean logToStdout;

    public Logger(Log log, boolean logToStdout) {
        this.log = log;
        this.logToStdout = logToStdout;
    }

    public void info(String msg) {
        if (this.logToStdout) {
            System.out.println("INFO: " + msg);
        }
        if (this.log.shouldLog(20)) {
            this.log.info(msg);
        }
    }

    public void warn(String msg) {
        this.warn(msg, null);
    }

    public void warn(String msg, Throwable e) {
        if (this.logToStdout) {
            System.out.println("WARNING: " + msg);
            if (e != null) {
                e.printStackTrace();
            }
        }
        if (this.log.shouldLog(30)) {
            this.log.warn(msg, e);
        }
    }

    public void error(String msg, Throwable e) {
        if (this.logToStdout) {
            System.out.println("ERROR: " + msg);
            if (e != null) {
                e.printStackTrace();
            }
        }
        if (this.log.shouldLog(40)) {
            this.log.error(msg, e);
        }
    }
}

