"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var __1 = require("../../..");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var get_tooltip_values_highlighted_geoms_1 = require("./get_tooltip_values_highlighted_geoms");
function isOutElement(prevProps, nextProps) {
    if (!nextProps || !prevProps) {
        return false;
    }
    if (!nextProps.settings || !nextProps.settings.onElementOut) {
        return false;
    }
    if (prevProps.highlightedGeometries.length > 0 && nextProps.highlightedGeometries.length === 0) {
        return true;
    }
    return false;
}
function createOnElementOutCaller() {
    var prevProps = null;
    var selector = null;
    return function (state) {
        if (selector === null && state.chartType === __1.ChartTypes.XYAxis) {
            selector = re_reselect_1.default([get_tooltip_values_highlighted_geoms_1.getTooltipInfoAndGeometriesSelector, get_settings_specs_1.getSettingsSpecSelector], function (_a, settings) {
                var highlightedGeometries = _a.highlightedGeometries;
                var nextProps = {
                    settings: settings,
                    highlightedGeometries: highlightedGeometries,
                };
                if (isOutElement(prevProps, nextProps) && settings.onElementOut) {
                    settings.onElementOut();
                }
                prevProps = nextProps;
            })({
                keySelector: get_chart_id_1.getChartIdSelector,
            });
        }
        if (selector) {
            selector(state);
        }
    };
}
exports.createOnElementOutCaller = createOnElementOutCaller;
//# sourceMappingURL=on_element_out_caller.js.map