/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXCursor
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int KIND;
    public static final int XDATA;
    public static final int DATA;

    public CXCursor(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXCursor.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="enum CXCursorKind")
    public int kind() {
        return CXCursor.nkind(this.address());
    }

    public int xdata() {
        return CXCursor.nxdata(this.address());
    }

    @NativeType(value="void const *[3]")
    public PointerBuffer data() {
        return CXCursor.ndata(this.address());
    }

    @NativeType(value="void const *")
    public long data(int index) {
        return CXCursor.ndata(this.address(), index);
    }

    public static CXCursor malloc() {
        return (CXCursor)CXCursor.wrap(CXCursor.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CXCursor calloc() {
        return (CXCursor)CXCursor.wrap(CXCursor.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CXCursor create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CXCursor)CXCursor.wrap(CXCursor.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CXCursor create(long address) {
        return (CXCursor)CXCursor.wrap(CXCursor.class, (long)address);
    }

    @Nullable
    public static CXCursor createSafe(long address) {
        return address == 0L ? null : (CXCursor)CXCursor.wrap(CXCursor.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CXCursor.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CXCursor.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CXCursor.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXCursor.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CXCursor.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CXCursor.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CXCursor.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CXCursor mallocStack() {
        return CXCursor.mallocStack(MemoryStack.stackGet());
    }

    public static CXCursor callocStack() {
        return CXCursor.callocStack(MemoryStack.stackGet());
    }

    public static CXCursor mallocStack(MemoryStack stack) {
        return (CXCursor)CXCursor.wrap(CXCursor.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXCursor callocStack(MemoryStack stack) {
        return (CXCursor)CXCursor.wrap(CXCursor.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CXCursor.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CXCursor.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)CXCursor.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)CXCursor.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nkind(long struct) {
        return UNSAFE.getInt(null, struct + (long)KIND);
    }

    public static int nxdata(long struct) {
        return UNSAFE.getInt(null, struct + (long)XDATA);
    }

    public static PointerBuffer ndata(long struct) {
        return MemoryUtil.memPointerBuffer((long)(struct + (long)DATA), (int)3);
    }

    public static long ndata(long struct, int index) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DATA + Checks.check((int)index, (int)3) * (long)POINTER_SIZE));
    }

    static {
        Struct.Layout layout = CXCursor.__struct((Struct.Member[])new Struct.Member[]{CXCursor.__member((int)4), CXCursor.__member((int)4), CXCursor.__array((int)POINTER_SIZE, (int)3)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        KIND = layout.offsetof(0);
        XDATA = layout.offsetof(1);
        DATA = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CXCursor, Buffer>
    implements NativeResource {
        private static final CXCursor ELEMENT_FACTORY = CXCursor.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CXCursor getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="enum CXCursorKind")
        public int kind() {
            return CXCursor.nkind(this.address());
        }

        public int xdata() {
            return CXCursor.nxdata(this.address());
        }

        @NativeType(value="void const *[3]")
        public PointerBuffer data() {
            return CXCursor.ndata(this.address());
        }

        @NativeType(value="void const *")
        public long data(int index) {
            return CXCursor.ndata(this.address(), index);
        }
    }
}

