/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_transform_t")
public class BGFXTransform
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;
    public static final int NUM;

    public BGFXTransform(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXTransform.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float *")
    public FloatBuffer data() {
        return BGFXTransform.ndata(this.address());
    }

    @NativeType(value="uint16_t")
    public short num() {
        return BGFXTransform.nnum(this.address());
    }

    public static BGFXTransform malloc() {
        return (BGFXTransform)BGFXTransform.wrap(BGFXTransform.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static BGFXTransform calloc() {
        return (BGFXTransform)BGFXTransform.wrap(BGFXTransform.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static BGFXTransform create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (BGFXTransform)BGFXTransform.wrap(BGFXTransform.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static BGFXTransform create(long address) {
        return (BGFXTransform)BGFXTransform.wrap(BGFXTransform.class, (long)address);
    }

    @Nullable
    public static BGFXTransform createSafe(long address) {
        return address == 0L ? null : (BGFXTransform)BGFXTransform.wrap(BGFXTransform.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)BGFXTransform.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)BGFXTransform.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)BGFXTransform.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = BGFXTransform.__create((int)capacity, (int)SIZEOF);
        return (Buffer)BGFXTransform.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)BGFXTransform.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)BGFXTransform.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static BGFXTransform mallocStack() {
        return BGFXTransform.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXTransform callocStack() {
        return BGFXTransform.callocStack(MemoryStack.stackGet());
    }

    public static BGFXTransform mallocStack(MemoryStack stack) {
        return (BGFXTransform)BGFXTransform.wrap(BGFXTransform.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXTransform callocStack(MemoryStack stack) {
        return (BGFXTransform)BGFXTransform.wrap(BGFXTransform.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return BGFXTransform.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return BGFXTransform.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)BGFXTransform.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)BGFXTransform.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static FloatBuffer ndata(long struct) {
        return MemoryUtil.memFloatBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)), (int)(Short.toUnsignedInt(BGFXTransform.nnum(struct)) << 4));
    }

    public static short nnum(long struct) {
        return UNSAFE.getShort(null, struct + (long)NUM);
    }

    static {
        Struct.Layout layout = BGFXTransform.__struct((Struct.Member[])new Struct.Member[]{BGFXTransform.__member((int)POINTER_SIZE), BGFXTransform.__member((int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
        NUM = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<BGFXTransform, Buffer>
    implements NativeResource {
        private static final BGFXTransform ELEMENT_FACTORY = BGFXTransform.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected BGFXTransform getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float *")
        public FloatBuffer data() {
            return BGFXTransform.ndata(this.address());
        }

        @NativeType(value="uint16_t")
        public short num() {
            return BGFXTransform.nnum(this.address());
        }
    }
}

