/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkCheckpointDataNV;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkQueue;

public class NVDeviceDiagnosticCheckpoints {
    public static final int VK_NV_DEVICE_DIAGNOSTIC_CHECKPOINTS_SPEC_VERSION = 2;
    public static final String VK_NV_DEVICE_DIAGNOSTIC_CHECKPOINTS_EXTENSION_NAME = "VK_NV_device_diagnostic_checkpoints";
    public static final int VK_STRUCTURE_TYPE_CHECKPOINT_DATA_NV = 1000206000;
    public static final int VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV = 1000206001;

    protected NVDeviceDiagnosticCheckpoints() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsDevice(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_NV_DEVICE_DIAGNOSTIC_CHECKPOINTS_EXTENSION_NAME) && VK.checkExtension(VK_NV_DEVICE_DIAGNOSTIC_CHECKPOINTS_EXTENSION_NAME, VK.isSupported(provider, "vkCmdSetCheckpointNV", caps) && VK.isSupported(provider, "vkGetQueueCheckpointDataNV", caps));
    }

    public static void vkCmdSetCheckpointNV(VkCommandBuffer commandBuffer, @NativeType(value="void const *") long pCheckpointMarker) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetCheckpointNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)pCheckpointMarker);
        }
        JNI.callPPV((long)commandBuffer.address(), (long)pCheckpointMarker, (long)__functionAddress);
    }

    public static void nvkGetQueueCheckpointDataNV(VkQueue queue, long pCheckpointDataCount, long pCheckpointData) {
        long __functionAddress = queue.getCapabilities().vkGetQueueCheckpointDataNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPPV((long)queue.address(), (long)pCheckpointDataCount, (long)pCheckpointData, (long)__functionAddress);
    }

    public static void vkGetQueueCheckpointDataNV(VkQueue queue, @NativeType(value="uint32_t *") IntBuffer pCheckpointDataCount, @Nullable @NativeType(value="VkCheckpointDataNV *") VkCheckpointDataNV.Buffer pCheckpointData) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pCheckpointDataCount, (int)1);
            Checks.checkSafe((CustomBuffer)pCheckpointData, (int)pCheckpointDataCount.get(pCheckpointDataCount.position()));
        }
        NVDeviceDiagnosticCheckpoints.nvkGetQueueCheckpointDataNV(queue, MemoryUtil.memAddress((IntBuffer)pCheckpointDataCount), MemoryUtil.memAddressSafe((Pointer)pCheckpointData));
    }

    public static void vkGetQueueCheckpointDataNV(VkQueue queue, @NativeType(value="uint32_t *") int[] pCheckpointDataCount, @Nullable @NativeType(value="VkCheckpointDataNV *") VkCheckpointDataNV.Buffer pCheckpointData) {
        long __functionAddress = queue.getCapabilities().vkGetQueueCheckpointDataNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])pCheckpointDataCount, (int)1);
            Checks.checkSafe((CustomBuffer)pCheckpointData, (int)pCheckpointDataCount[0]);
        }
        JNI.callPPPV((long)queue.address(), (int[])pCheckpointDataCount, (long)MemoryUtil.memAddressSafe((Pointer)pCheckpointData), (long)__functionAddress);
    }
}

