/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBufferCopy
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SRCOFFSET;
    public static final int DSTOFFSET;
    public static final int SIZE;

    public VkBufferCopy(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkBufferCopy.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long srcOffset() {
        return VkBufferCopy.nsrcOffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long dstOffset() {
        return VkBufferCopy.ndstOffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkBufferCopy.nsize(this.address());
    }

    public VkBufferCopy srcOffset(@NativeType(value="VkDeviceSize") long value) {
        VkBufferCopy.nsrcOffset(this.address(), value);
        return this;
    }

    public VkBufferCopy dstOffset(@NativeType(value="VkDeviceSize") long value) {
        VkBufferCopy.ndstOffset(this.address(), value);
        return this;
    }

    public VkBufferCopy size(@NativeType(value="VkDeviceSize") long value) {
        VkBufferCopy.nsize(this.address(), value);
        return this;
    }

    public VkBufferCopy set(long srcOffset, long dstOffset, long size) {
        this.srcOffset(srcOffset);
        this.dstOffset(dstOffset);
        this.size(size);
        return this;
    }

    public VkBufferCopy set(VkBufferCopy src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBufferCopy malloc() {
        return (VkBufferCopy)VkBufferCopy.wrap(VkBufferCopy.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkBufferCopy calloc() {
        return (VkBufferCopy)VkBufferCopy.wrap(VkBufferCopy.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkBufferCopy create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkBufferCopy)VkBufferCopy.wrap(VkBufferCopy.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkBufferCopy create(long address) {
        return (VkBufferCopy)VkBufferCopy.wrap(VkBufferCopy.class, (long)address);
    }

    @Nullable
    public static VkBufferCopy createSafe(long address) {
        return address == 0L ? null : (VkBufferCopy)VkBufferCopy.wrap(VkBufferCopy.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkBufferCopy.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkBufferCopy.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkBufferCopy.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferCopy.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkBufferCopy.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkBufferCopy.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkBufferCopy.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkBufferCopy mallocStack() {
        return VkBufferCopy.mallocStack(MemoryStack.stackGet());
    }

    public static VkBufferCopy callocStack() {
        return VkBufferCopy.callocStack(MemoryStack.stackGet());
    }

    public static VkBufferCopy mallocStack(MemoryStack stack) {
        return (VkBufferCopy)VkBufferCopy.wrap(VkBufferCopy.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBufferCopy callocStack(MemoryStack stack) {
        return (VkBufferCopy)VkBufferCopy.wrap(VkBufferCopy.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBufferCopy.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBufferCopy.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkBufferCopy.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkBufferCopy.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nsrcOffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)SRCOFFSET);
    }

    public static long ndstOffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)DSTOFFSET);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static void nsrcOffset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SRCOFFSET, value);
    }

    public static void ndstOffset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DSTOFFSET, value);
    }

    public static void nsize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = VkBufferCopy.__struct((Struct.Member[])new Struct.Member[]{VkBufferCopy.__member((int)8), VkBufferCopy.__member((int)8), VkBufferCopy.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SRCOFFSET = layout.offsetof(0);
        DSTOFFSET = layout.offsetof(1);
        SIZE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkBufferCopy, Buffer>
    implements NativeResource {
        private static final VkBufferCopy ELEMENT_FACTORY = VkBufferCopy.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkBufferCopy getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long srcOffset() {
            return VkBufferCopy.nsrcOffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long dstOffset() {
            return VkBufferCopy.ndstOffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkBufferCopy.nsize(this.address());
        }

        public Buffer srcOffset(@NativeType(value="VkDeviceSize") long value) {
            VkBufferCopy.nsrcOffset(this.address(), value);
            return this;
        }

        public Buffer dstOffset(@NativeType(value="VkDeviceSize") long value) {
            VkBufferCopy.ndstOffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkBufferCopy.nsize(this.address(), value);
            return this;
        }
    }
}

