/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkInputAttachmentAspectReference;

public class VkInputAttachmentAspectReferenceKHR
extends VkInputAttachmentAspectReference {
    public VkInputAttachmentAspectReferenceKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkInputAttachmentAspectReferenceKHR subpass(@NativeType(value="uint32_t") int value) {
        VkInputAttachmentAspectReferenceKHR.nsubpass(this.address(), value);
        return this;
    }

    @Override
    public VkInputAttachmentAspectReferenceKHR inputAttachmentIndex(@NativeType(value="uint32_t") int value) {
        VkInputAttachmentAspectReferenceKHR.ninputAttachmentIndex(this.address(), value);
        return this;
    }

    @Override
    public VkInputAttachmentAspectReferenceKHR aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
        VkInputAttachmentAspectReferenceKHR.naspectMask(this.address(), value);
        return this;
    }

    @Override
    public VkInputAttachmentAspectReferenceKHR set(int subpass, int inputAttachmentIndex, int aspectMask) {
        this.subpass(subpass);
        this.inputAttachmentIndex(inputAttachmentIndex);
        this.aspectMask(aspectMask);
        return this;
    }

    public VkInputAttachmentAspectReferenceKHR set(VkInputAttachmentAspectReferenceKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkInputAttachmentAspectReferenceKHR malloc() {
        return (VkInputAttachmentAspectReferenceKHR)VkInputAttachmentAspectReferenceKHR.wrap(VkInputAttachmentAspectReferenceKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkInputAttachmentAspectReferenceKHR calloc() {
        return (VkInputAttachmentAspectReferenceKHR)VkInputAttachmentAspectReferenceKHR.wrap(VkInputAttachmentAspectReferenceKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkInputAttachmentAspectReferenceKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkInputAttachmentAspectReferenceKHR)VkInputAttachmentAspectReferenceKHR.wrap(VkInputAttachmentAspectReferenceKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkInputAttachmentAspectReferenceKHR create(long address) {
        return (VkInputAttachmentAspectReferenceKHR)VkInputAttachmentAspectReferenceKHR.wrap(VkInputAttachmentAspectReferenceKHR.class, (long)address);
    }

    @Nullable
    public static VkInputAttachmentAspectReferenceKHR createSafe(long address) {
        return address == 0L ? null : (VkInputAttachmentAspectReferenceKHR)VkInputAttachmentAspectReferenceKHR.wrap(VkInputAttachmentAspectReferenceKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkInputAttachmentAspectReferenceKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkInputAttachmentAspectReferenceKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkInputAttachmentAspectReferenceKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkInputAttachmentAspectReferenceKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkInputAttachmentAspectReferenceKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkInputAttachmentAspectReferenceKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkInputAttachmentAspectReferenceKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkInputAttachmentAspectReferenceKHR mallocStack() {
        return VkInputAttachmentAspectReferenceKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkInputAttachmentAspectReferenceKHR callocStack() {
        return VkInputAttachmentAspectReferenceKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkInputAttachmentAspectReferenceKHR mallocStack(MemoryStack stack) {
        return (VkInputAttachmentAspectReferenceKHR)VkInputAttachmentAspectReferenceKHR.wrap(VkInputAttachmentAspectReferenceKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkInputAttachmentAspectReferenceKHR callocStack(MemoryStack stack) {
        return (VkInputAttachmentAspectReferenceKHR)VkInputAttachmentAspectReferenceKHR.wrap(VkInputAttachmentAspectReferenceKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkInputAttachmentAspectReferenceKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkInputAttachmentAspectReferenceKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkInputAttachmentAspectReferenceKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkInputAttachmentAspectReferenceKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static class Buffer
    extends VkInputAttachmentAspectReference.Buffer {
        private static final VkInputAttachmentAspectReferenceKHR ELEMENT_FACTORY = VkInputAttachmentAspectReferenceKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkInputAttachmentAspectReferenceKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer subpass(@NativeType(value="uint32_t") int value) {
            VkInputAttachmentAspectReferenceKHR.nsubpass(this.address(), value);
            return this;
        }

        @Override
        public Buffer inputAttachmentIndex(@NativeType(value="uint32_t") int value) {
            VkInputAttachmentAspectReferenceKHR.ninputAttachmentIndex(this.address(), value);
            return this;
        }

        @Override
        public Buffer aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
            VkInputAttachmentAspectReferenceKHR.naspectMask(this.address(), value);
            return this;
        }
    }
}

