/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;

public class VkSparseImageFormatProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ASPECTMASK;
    public static final int IMAGEGRANULARITY;
    public static final int FLAGS;

    public VkSparseImageFormatProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkSparseImageFormatProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkImageAspectFlags")
    public int aspectMask() {
        return VkSparseImageFormatProperties.naspectMask(this.address());
    }

    public VkExtent3D imageGranularity() {
        return VkSparseImageFormatProperties.nimageGranularity(this.address());
    }

    @NativeType(value="VkSparseImageFormatFlags")
    public int flags() {
        return VkSparseImageFormatProperties.nflags(this.address());
    }

    public static VkSparseImageFormatProperties malloc() {
        return (VkSparseImageFormatProperties)VkSparseImageFormatProperties.wrap(VkSparseImageFormatProperties.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkSparseImageFormatProperties calloc() {
        return (VkSparseImageFormatProperties)VkSparseImageFormatProperties.wrap(VkSparseImageFormatProperties.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkSparseImageFormatProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkSparseImageFormatProperties)VkSparseImageFormatProperties.wrap(VkSparseImageFormatProperties.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkSparseImageFormatProperties create(long address) {
        return (VkSparseImageFormatProperties)VkSparseImageFormatProperties.wrap(VkSparseImageFormatProperties.class, (long)address);
    }

    @Nullable
    public static VkSparseImageFormatProperties createSafe(long address) {
        return address == 0L ? null : (VkSparseImageFormatProperties)VkSparseImageFormatProperties.wrap(VkSparseImageFormatProperties.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkSparseImageFormatProperties.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkSparseImageFormatProperties.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkSparseImageFormatProperties.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSparseImageFormatProperties.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkSparseImageFormatProperties.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkSparseImageFormatProperties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkSparseImageFormatProperties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkSparseImageFormatProperties mallocStack() {
        return VkSparseImageFormatProperties.mallocStack(MemoryStack.stackGet());
    }

    public static VkSparseImageFormatProperties callocStack() {
        return VkSparseImageFormatProperties.callocStack(MemoryStack.stackGet());
    }

    public static VkSparseImageFormatProperties mallocStack(MemoryStack stack) {
        return (VkSparseImageFormatProperties)VkSparseImageFormatProperties.wrap(VkSparseImageFormatProperties.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSparseImageFormatProperties callocStack(MemoryStack stack) {
        return (VkSparseImageFormatProperties)VkSparseImageFormatProperties.wrap(VkSparseImageFormatProperties.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSparseImageFormatProperties.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSparseImageFormatProperties.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSparseImageFormatProperties.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSparseImageFormatProperties.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int naspectMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)ASPECTMASK);
    }

    public static VkExtent3D nimageGranularity(long struct) {
        return VkExtent3D.create(struct + (long)IMAGEGRANULARITY);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    static {
        Struct.Layout layout = VkSparseImageFormatProperties.__struct((Struct.Member[])new Struct.Member[]{VkSparseImageFormatProperties.__member((int)4), VkSparseImageFormatProperties.__member((int)VkExtent3D.SIZEOF, (int)VkExtent3D.ALIGNOF), VkSparseImageFormatProperties.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ASPECTMASK = layout.offsetof(0);
        IMAGEGRANULARITY = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkSparseImageFormatProperties, Buffer>
    implements NativeResource {
        private static final VkSparseImageFormatProperties ELEMENT_FACTORY = VkSparseImageFormatProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkSparseImageFormatProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkImageAspectFlags")
        public int aspectMask() {
            return VkSparseImageFormatProperties.naspectMask(this.address());
        }

        public VkExtent3D imageGranularity() {
            return VkSparseImageFormatProperties.nimageGranularity(this.address());
        }

        @NativeType(value="VkSparseImageFormatFlags")
        public int flags() {
            return VkSparseImageFormatProperties.nflags(this.address());
        }
    }
}

