# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2021 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.esx.settings.clusters.configuration.
#---------------------------------------------------------------------------

"""
The ``com.vmware.esx.settings.clusters.configuration_client`` module provides
classes to manage the configuration of an ESX cluster. The
``com.vmware.esx.settings.clusters.configuration.reports_client`` module
provides classes for accessing reports regarding the configuration state of the
cluster.

"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata

class ComplianceValueType(Enum):
    """
    The ``ComplianceValueType`` class represents the type of configuration in
    drift.

    .. note::
        This class represents an enumerated type in the interface language
        definition. The class contains class attributes which represent the
        values in the current version of the enumerated type. Newer versions of
        the enumerated type may contain new values. To use new values of the
        enumerated type in communication with a server that supports the newer
        version of the API, you instantiate this class. See :ref:`enumerated
        type description page <enumeration_description>`.
    """
    BINARY = None
    """
    Indicates the value is a binary.

    """
    BOOLEAN = None
    """
    Indicates the value is a boolean.

    """
    DOUBLE = None
    """
    Indicates the value is a float/double.

    """
    LONG = None
    """
    Indicates the value is a integer(16 or 32 or 64 bit).

    """
    STRING = None
    """
    Indicates the value is a string.

    """
    SECRET = None
    """
    Indicates the value is a Secret type.

    """
    USER_DATA = None
    """
    Indicates that the value is a dynamic user defined structure.

    """

    def __init__(self, string):
        """
        :type  string: :class:`str`
        :param string: String value for the :class:`ComplianceValueType` instance.
        """
        Enum.__init__(string)

ComplianceValueType._set_values([
    ComplianceValueType('BINARY'),
    ComplianceValueType('BOOLEAN'),
    ComplianceValueType('DOUBLE'),
    ComplianceValueType('LONG'),
    ComplianceValueType('STRING'),
    ComplianceValueType('SECRET'),
    ComplianceValueType('USER_DATA'),
])
ComplianceValueType._set_binding_type(type.EnumType(
    'com.vmware.esx.settings.clusters.configuration.compliance_value_type',
    ComplianceValueType))



class ImpactType(Enum):
    """
    The ``ImpactType`` class contains information about the impact of applying
    desired configuration on the ESXi host.

    .. note::
        This class represents an enumerated type in the interface language
        definition. The class contains class attributes which represent the
        values in the current version of the enumerated type. Newer versions of
        the enumerated type may contain new values. To use new values of the
        enumerated type in communication with a server that supports the newer
        version of the API, you instantiate this class. See :ref:`enumerated
        type description page <enumeration_description>`.
    """
    NO_IMPACT = None
    """
    Host has no impact.

    """
    MAINTENANCE_MODE_REQUIRED = None
    """
    Host requires maintenance mode to reach the desired state.

    """
    REBOOT_REQUIRED = None
    """
    Host requires reboot to reach the desired state.

    """

    def __init__(self, string):
        """
        :type  string: :class:`str`
        :param string: String value for the :class:`ImpactType` instance.
        """
        Enum.__init__(string)

ImpactType._set_values([
    ImpactType('NO_IMPACT'),
    ImpactType('MAINTENANCE_MODE_REQUIRED'),
    ImpactType('REBOOT_REQUIRED'),
])
ImpactType._set_binding_type(type.EnumType(
    'com.vmware.esx.settings.clusters.configuration.impact_type',
    ImpactType))




class HostStatus(VapiStruct):
    """
    The ``HostStatus`` class contains attributes that describe the status of an
    method.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 status=None,
                 start_time=None,
                 end_time=None,
                 notifications=None,
                ):
        """
        :type  status: :class:`HostStatus.Status`
        :param status: The status of the method.
        :type  start_time: :class:`datetime.datetime`
        :param start_time: Time when the method started.
        :type  end_time: :class:`datetime.datetime`
        :param end_time: Time when the method completed.
        :type  notifications: :class:`com.vmware.esx.settings_client.Notifications`
        :param notifications: Notifications providing additional information about the status of
            the method.
        """
        self.status = status
        self.start_time = start_time
        self.end_time = end_time
        self.notifications = notifications
        VapiStruct.__init__(self)


    class Status(Enum):
        """
        The ``HostStatus.Status`` class contains the possible different status
        codes that can be returned while trying to perform an operation on the
        hosts within the cluster.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        OK = None
        """
        The method completed successfully.

        """
        SKIPPED = None
        """
        The method was skipped.

        """
        TIMED_OUT = None
        """
        The method timed out.

        """
        ERROR = None
        """
        The method encountered an unspecified error.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`Status` instance.
            """
            Enum.__init__(string)

    Status._set_values([
        Status('OK'),
        Status('SKIPPED'),
        Status('TIMED_OUT'),
        Status('ERROR'),
    ])
    Status._set_binding_type(type.EnumType(
        'com.vmware.esx.settings.clusters.configuration.host_status.status',
        Status))

HostStatus._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.host_status', {
        'status': type.ReferenceType(__name__, 'HostStatus.Status'),
        'start_time': type.DateTimeType(),
        'end_time': type.DateTimeType(),
        'notifications': type.ReferenceType('com.vmware.esx.settings_client', 'Notifications'),
    },
    HostStatus,
    False,
    None))



class BooleanComplianceValue(VapiStruct):
    """
    The ``BooleanComplianceValue`` class contains attributes that describe a
    boolean value in drift. This struture captures the desired value and the
    host value for the drift.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 host_value=None,
                 desired_value=None,
                ):
        """
        :type  host_value: :class:`bool` or ``None``
        :param host_value: Boolean value on ESXi host.
        :type  desired_value: :class:`bool` or ``None``
        :param desired_value: Boolean value in desired document.
        """
        self.host_value = host_value
        self.desired_value = desired_value
        VapiStruct.__init__(self)


BooleanComplianceValue._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.boolean_compliance_value', {
        'host_value': type.OptionalType(type.BooleanType()),
        'desired_value': type.OptionalType(type.BooleanType()),
    },
    BooleanComplianceValue,
    False,
    None))



class LongComplianceValue(VapiStruct):
    """
    The ``LongComplianceValue`` class contains attributes that describe a long
    value in drift. This struture captures the desired value and the host value
    for the drift.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 host_value=None,
                 desired_value=None,
                ):
        """
        :type  host_value: :class:`long` or ``None``
        :param host_value: Long value on ESXi host.
        :type  desired_value: :class:`long` or ``None``
        :param desired_value: Long value in desired document.
        """
        self.host_value = host_value
        self.desired_value = desired_value
        VapiStruct.__init__(self)


LongComplianceValue._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.long_compliance_value', {
        'host_value': type.OptionalType(type.IntegerType()),
        'desired_value': type.OptionalType(type.IntegerType()),
    },
    LongComplianceValue,
    False,
    None))



class DoubleComplianceValue(VapiStruct):
    """
    The ``DoubleComplianceValue`` class contains attributes that describe a
    double value in drift. This struture captures the desired value and the
    host value for the drift.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 host_value=None,
                 desired_value=None,
                ):
        """
        :type  host_value: :class:`float` or ``None``
        :param host_value: Double value on ESXi host.
        :type  desired_value: :class:`float` or ``None``
        :param desired_value: Double value in desired document.
        """
        self.host_value = host_value
        self.desired_value = desired_value
        VapiStruct.__init__(self)


DoubleComplianceValue._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.double_compliance_value', {
        'host_value': type.OptionalType(type.DoubleType()),
        'desired_value': type.OptionalType(type.DoubleType()),
    },
    DoubleComplianceValue,
    False,
    None))



class StringComplianceValue(VapiStruct):
    """
    The ``StringComplianceValue`` class contains attributes that describe a
    string value in drift. This struture captures the desired value and the
    host value for the drift.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 host_value=None,
                 desired_value=None,
                ):
        """
        :type  host_value: :class:`str` or ``None``
        :param host_value: String value on ESXi host.
        :type  desired_value: :class:`str` or ``None``
        :param desired_value: String value in desired document.
        """
        self.host_value = host_value
        self.desired_value = desired_value
        VapiStruct.__init__(self)


StringComplianceValue._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.string_compliance_value', {
        'host_value': type.OptionalType(type.StringType()),
        'desired_value': type.OptionalType(type.StringType()),
    },
    StringComplianceValue,
    False,
    None))



class BooleanComplianceValueArray(VapiStruct):
    """
    The ``BooleanComplianceValueArray`` class contains attributes that describe
    an boolean array in drift. This struture captures the desired values and
    the host values for the drift.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 host_arr=None,
                 desired_arr=None,
                ):
        """
        :type  host_arr: :class:`list` of :class:`bool` or ``None``
        :param host_arr: Boolean array on ESXi host.
        :type  desired_arr: :class:`list` of :class:`bool` or ``None``
        :param desired_arr: Boolean array in desired document.
        """
        self.host_arr = host_arr
        self.desired_arr = desired_arr
        VapiStruct.__init__(self)


BooleanComplianceValueArray._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.boolean_compliance_value_array', {
        'host_arr': type.OptionalType(type.ListType(type.BooleanType())),
        'desired_arr': type.OptionalType(type.ListType(type.BooleanType())),
    },
    BooleanComplianceValueArray,
    False,
    None))



class LongComplianceValueArray(VapiStruct):
    """
    The ``LongComplianceValueArray`` class contains attributes that describe a
    long array in drift. This struture captures the desired values and the host
    values for the drift.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 host_arr=None,
                 desired_arr=None,
                ):
        """
        :type  host_arr: :class:`list` of :class:`long` or ``None``
        :param host_arr: Long array on ESXi host.
        :type  desired_arr: :class:`list` of :class:`long` or ``None``
        :param desired_arr: Long array in desired document.
        """
        self.host_arr = host_arr
        self.desired_arr = desired_arr
        VapiStruct.__init__(self)


LongComplianceValueArray._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.long_compliance_value_array', {
        'host_arr': type.OptionalType(type.ListType(type.IntegerType())),
        'desired_arr': type.OptionalType(type.ListType(type.IntegerType())),
    },
    LongComplianceValueArray,
    False,
    None))



class DoubleComplianceValueArray(VapiStruct):
    """
    The ``DoubleComplianceValueArray`` class contains attributes that describe
    a double array in drift. This struture captures the desired values and the
    host values for the drift.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 host_arr=None,
                 desired_arr=None,
                ):
        """
        :type  host_arr: :class:`list` of :class:`float` or ``None``
        :param host_arr: Double array on ESXi host.
        :type  desired_arr: :class:`list` of :class:`float` or ``None``
        :param desired_arr: Double array in desired document.
        """
        self.host_arr = host_arr
        self.desired_arr = desired_arr
        VapiStruct.__init__(self)


DoubleComplianceValueArray._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.double_compliance_value_array', {
        'host_arr': type.OptionalType(type.ListType(type.DoubleType())),
        'desired_arr': type.OptionalType(type.ListType(type.DoubleType())),
    },
    DoubleComplianceValueArray,
    False,
    None))



class StringComplianceValueArray(VapiStruct):
    """
    The ``StringComplianceValueArray`` class contains attributes that describe
    an boolean array in drift. This struture captures the desired values and
    the host values for the drift.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 host_arr=None,
                 desired_arr=None,
                ):
        """
        :type  host_arr: :class:`list` of :class:`str` or ``None``
        :param host_arr: String array on ESXi host.
        :type  desired_arr: :class:`list` of :class:`str` or ``None``
        :param desired_arr: String array in desired document.
        """
        self.host_arr = host_arr
        self.desired_arr = desired_arr
        VapiStruct.__init__(self)


StringComplianceValueArray._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.string_compliance_value_array', {
        'host_arr': type.OptionalType(type.ListType(type.StringType())),
        'desired_arr': type.OptionalType(type.ListType(type.StringType())),
    },
    StringComplianceValueArray,
    False,
    None))



class PrimitiveComplianceValue(VapiStruct):
    """
    The ``PrimitiveComplianceValue`` class contains attributes that describe
    the drift in a primitive data type value. Depending on the primitive data
    type of the configuration only one of the members in this structure is
    populated.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """

    _validator_list = [
        UnionValidator(
            'type',
            {
                'BOOLEAN' : [('bool_value', False)],
                'LONG' : [('long_value', False)],
                'DOUBLE' : [('double_value', False)],
                'STRING' : [('str_value', False)],
                'SECRET' : [('str_value', False)],
                'BINARY' : [],
                'USER_DATA' : [],
            }
        ),
    ]



    def __init__(self,
                 type=None,
                 bool_value=None,
                 long_value=None,
                 double_value=None,
                 str_value=None,
                ):
        """
        :type  type: :class:`ComplianceValueType`
        :param type: Type of the configuration in drift.
        :type  bool_value: :class:`BooleanComplianceValue` or ``None``
        :param bool_value: Describes the drift in a boolean configuration value.
            This field is None if the type is not BOOLEAN.
        :type  long_value: :class:`LongComplianceValue` or ``None``
        :param long_value: Describes the drift in an integer(16 bit or 32 bit or 64 bit)
            configuration value.
            This field is None if the type is not Long.
        :type  double_value: :class:`DoubleComplianceValue` or ``None``
        :param double_value: Describes the drift in a floating point(float or double)
            configuration value.
            This field is None if the type is not DOUBLE.
        :type  str_value: :class:`StringComplianceValue` or ``None``
        :param str_value: Describes the drift in a string configuration value.
            This field is None if the type is neither STRING nor SECRET.
        """
        self.type = type
        self.bool_value = bool_value
        self.long_value = long_value
        self.double_value = double_value
        self.str_value = str_value
        VapiStruct.__init__(self)


PrimitiveComplianceValue._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.primitive_compliance_value', {
        'type': type.ReferenceType(__name__, 'ComplianceValueType'),
        'bool_value': type.OptionalType(type.ReferenceType(__name__, 'BooleanComplianceValue')),
        'long_value': type.OptionalType(type.ReferenceType(__name__, 'LongComplianceValue')),
        'double_value': type.OptionalType(type.ReferenceType(__name__, 'DoubleComplianceValue')),
        'str_value': type.OptionalType(type.ReferenceType(__name__, 'StringComplianceValue')),
    },
    PrimitiveComplianceValue,
    False,
    None))



class ArrayComplianceValue(VapiStruct):
    """
    The ``ArrayComplianceValue`` class contains attributes that describe the
    drift in an array of primitive data type values. Depending on the primitive
    data type of the configuration only one of the members in this structure is
    populated.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """

    _validator_list = [
        UnionValidator(
            'type',
            {
                'BOOLEAN' : [('bool_arr', False)],
                'LONG' : [('long_arr', False)],
                'DOUBLE' : [('double_arr', False)],
                'STRING' : [('str_arr', False)],
                'SECRET' : [('str_arr', False)],
                'BINARY' : [],
                'USER_DATA' : [],
            }
        ),
    ]



    def __init__(self,
                 type=None,
                 bool_arr=None,
                 long_arr=None,
                 double_arr=None,
                 str_arr=None,
                ):
        """
        :type  type: :class:`ComplianceValueType`
        :param type: Type of the configuration in drift.
        :type  bool_arr: :class:`BooleanComplianceValueArray` or ``None``
        :param bool_arr: Describes the drift in a boolean array of configuration values.
            This field is None if the type is not BOOLEAN.
        :type  long_arr: :class:`LongComplianceValueArray` or ``None``
        :param long_arr: Describes the drift in an integer(16 bit or 32 bit or 64 bit) array
            of configuration values.
            This field is None if the type is not Long.
        :type  double_arr: :class:`DoubleComplianceValueArray` or ``None``
        :param double_arr: Describes the drift in a floating point(float or double) array of
            configuration values.
            This field is None if the type is not DOUBLE.
        :type  str_arr: :class:`StringComplianceValueArray` or ``None``
        :param str_arr: Describes the drift in a strings array of configuration values.
            This field is None if the type is neither STRING nor SECRET.
        """
        self.type = type
        self.bool_arr = bool_arr
        self.long_arr = long_arr
        self.double_arr = double_arr
        self.str_arr = str_arr
        VapiStruct.__init__(self)


ArrayComplianceValue._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.array_compliance_value', {
        'type': type.ReferenceType(__name__, 'ComplianceValueType'),
        'bool_arr': type.OptionalType(type.ReferenceType(__name__, 'BooleanComplianceValueArray')),
        'long_arr': type.OptionalType(type.ReferenceType(__name__, 'LongComplianceValueArray')),
        'double_arr': type.OptionalType(type.ReferenceType(__name__, 'DoubleComplianceValueArray')),
        'str_arr': type.OptionalType(type.ReferenceType(__name__, 'StringComplianceValueArray')),
    },
    ArrayComplianceValue,
    False,
    None))



class ComplianceValue(VapiStruct):
    """
    The ``ComplianceValue`` class contains attributes that describes the drift
    in an ESXi host configuration from desired value. This structure is used to
    describe either a change in configuration value(set) or addition of
    configuration or deletion of a configuration. When used to describe
    addition or deletion of a configuration, only the path, type and isArray
    fields are set, and type is always expected to be USER_DATA. When used to
    describe a set operation, hostValue and desiredValue would only be set if
    drift is in a property that is of primitive type.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 path=None,
                 is_array=None,
                 value=None,
                 array_value=None,
                ):
        """
        :type  path: :class:`str`
        :param path: Full path to the configuration at drift within the desired
            document.
        :type  is_array: :class:`bool`
        :param is_array: Indicates if the configuration in drift is an array.
        :type  value: :class:`PrimitiveComplianceValue` or ``None``
        :param value: Describes the drift in a primitive data type value.
            This field is None if :attr:`ComplianceValue.is_array` is true.
        :type  array_value: :class:`ArrayComplianceValue` or ``None``
        :param array_value: Describes the drift in a array of primitive type values.
            This field is None if :attr:`ComplianceValue.is_array` is false.
        """
        self.path = path
        self.is_array = is_array
        self.value = value
        self.array_value = array_value
        VapiStruct.__init__(self)


ComplianceValue._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.compliance_value', {
        'path': type.URIType(),
        'is_array': type.BooleanType(),
        'value': type.OptionalType(type.ReferenceType(__name__, 'PrimitiveComplianceValue')),
        'array_value': type.OptionalType(type.ReferenceType(__name__, 'ArrayComplianceValue')),
    },
    ComplianceValue,
    False,
    None))



class HostCheckComplianceResult(VapiStruct):
    """
    This ``CheckComplianceResult`` class contains attributes that describe the
    compliance of an individual host with the desired configuration.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 compliant=None,
                 sets=None,
                 adds=None,
                 deletes=None,
                ):
        """
        :type  compliant: :class:`bool`
        :param compliant: This boolean flag indicates whether the ESXi host is in compliance
            with desired configuration.
        :type  sets: :class:`list` of :class:`ComplianceValue` or ``None``
        :param sets: List of configuration drifts represented by
            :class:`ComplianceValue`. Each describing a configuration whose
            value on ESXi host is different to that in the desired document.
            This field is None if the
            :attr:`HostCheckComplianceResult.compliant` is set to true.
        :type  adds: :class:`list` of :class:`ComplianceValue` or ``None``
        :param adds: List of configuration drifts represented by
            :class:`ComplianceValue`. Each describing a configuration that is
            present in the desired document but absent on the ESXi host.
            This field is None if the
            :attr:`HostCheckComplianceResult.compliant` is set to true or if
            there are no additions required to make the ESXi host compliant.
        :type  deletes: :class:`list` of :class:`ComplianceValue` or ``None``
        :param deletes: List of configuration drifts represented by
            :class:`ComplianceValue`. Each describing a configuration that is
            present on the ESXi host but absent in the desired document.
            This field is None if the
            :attr:`HostCheckComplianceResult.compliant` is set to true or if
            there are no deletions required to make the ESXi host compliant.
        """
        self.compliant = compliant
        self.sets = sets
        self.adds = adds
        self.deletes = deletes
        VapiStruct.__init__(self)


HostCheckComplianceResult._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.host_check_compliance_result', {
        'compliant': type.BooleanType(),
        'sets': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ComplianceValue'))),
        'adds': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ComplianceValue'))),
        'deletes': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ComplianceValue'))),
    },
    HostCheckComplianceResult,
    False,
    None))



class CheckComplianceResult(VapiStruct):
    """
    This ``CheckComplianceResult`` class contains attributes that describe the
    compliance results for a group of hosts.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 host_results=None,
                 host_status=None,
                ):
        """
        :type  host_results: :class:`dict` of :class:`str` and :class:`HostCheckComplianceResult`
        :param host_results: Map of host IDs to their compliance results.
            When clients pass a value of this class as a parameter, the key in
            the attribute :class:`dict` must be an identifier for the resource
            type: ``HostSystem``. When methods return a value of this class as
            a return value, the key in the attribute :class:`dict` will be an
            identifier for the resource type: ``HostSystem``.
        :type  host_status: :class:`dict` of :class:`str` and :class:`HostStatus`
        :param host_status: Map of host IDs to their status.
            When clients pass a value of this class as a parameter, the key in
            the attribute :class:`dict` must be an identifier for the resource
            type: ``HostSystem``. When methods return a value of this class as
            a return value, the key in the attribute :class:`dict` will be an
            identifier for the resource type: ``HostSystem``.
        """
        self.host_results = host_results
        self.host_status = host_status
        VapiStruct.__init__(self)


CheckComplianceResult._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.check_compliance_result', {
        'host_results': type.MapType(type.IdType(), type.ReferenceType(__name__, 'HostCheckComplianceResult')),
        'host_status': type.MapType(type.IdType(), type.ReferenceType(__name__, 'HostStatus')),
    },
    CheckComplianceResult,
    False,
    None))



class ValidationError(VapiStruct):
    """
    The ``ValidationError`` class contains attributes that describes a
    validation error in the configuration.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 path=None,
                 messages=None,
                ):
        """
        :type  path: :class:`str`
        :param path: Full path to the configuration or the property within the
            configuration which was found to be invalid.
        :type  messages: :class:`list` of :class:`com.vmware.vapi.std_client.LocalizableMessage`
        :param messages: Localized error message describing the validation error.
        """
        self.path = path
        self.messages = messages
        VapiStruct.__init__(self)


ValidationError._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.validation_error', {
        'path': type.StringType(),
        'messages': type.ListType(type.ReferenceType('com.vmware.vapi.std_client', 'LocalizableMessage')),
    },
    ValidationError,
    False,
    None))



class ValidationResult(VapiStruct):
    """
    This ``ValidationResult`` class contains attributes that describe the
    result of validating a configuration document.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 valid=None,
                 errors=None,
                ):
        """
        :type  valid: :class:`bool`
        :param valid: This boolean flag indicates whether the configuration document
            validated successfully with no validation errors.
        :type  errors: :class:`list` of :class:`ValidationError` or ``None``
        :param errors: Lists all validation errors identified in the configuration
            document.
            This is set when :attr:`ValidationResult.valid` is false.
        """
        self.valid = valid
        self.errors = errors
        VapiStruct.__init__(self)


ValidationResult._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.validation_result', {
        'valid': type.BooleanType(),
        'errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ValidationError'))),
    },
    ValidationResult,
    False,
    None))



class ImpactInfo(VapiStruct):
    """
    The ``ImpactInfo`` struture contains attributes that provide localized
    message about configuration impact on applying desired configuration on the
    ESXi host.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 message=None,
                ):
        """
        :type  message: :class:`com.vmware.vapi.std_client.LocalizableMessage`
        :param message: string describing the configuration changes.
        """
        self.message = message
        VapiStruct.__init__(self)


ImpactInfo._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.impact_info', {
        'message': type.ReferenceType('com.vmware.vapi.std_client', 'LocalizableMessage'),
    },
    ImpactInfo,
    False,
    None))



class HostImpactResult(VapiStruct):
    """
    This ``HostImpactResult`` class contains attributes that describe the
    result of the Impact API on the host.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 compliant=None,
                 impact=None,
                 info=None,
                ):
        """
        :type  compliant: :class:`bool`
        :param compliant: This boolean flag indicates whether the ESXi host is in compliance
            with desired configuration.
        :type  impact: :class:`ImpactType` or ``None``
        :param impact: This field indicates the ESXi host impact on applying the desired
            configuration.
            This field is None if :attr:`HostImpactResult.compliant` is set to
            true.
        :type  info: :class:`list` of :class:`ImpactInfo` or ``None``
        :param info: This field represents the list of impact information describing the
            configuration changes needed on the host to reach the desired
            state.
            This field is None if :attr:`HostImpactResult.compliant` is set to
            true.
        """
        self.compliant = compliant
        self.impact = impact
        self.info = info
        VapiStruct.__init__(self)


HostImpactResult._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.host_impact_result', {
        'compliant': type.BooleanType(),
        'impact': type.OptionalType(type.ReferenceType(__name__, 'ImpactType')),
        'info': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ImpactInfo'))),
    },
    HostImpactResult,
    False,
    None))



class HostImpactInfo(VapiStruct):
    """
    The impact status/result for an individual host.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 status=None,
                 impact=None,
                ):
        """
        :type  status: :class:`HostStatus`
        :param status: The status of the impact request for this host.
        :type  impact: :class:`HostImpactResult` or ``None``
        :param impact: If the operation was successfully executed on the host, the results
            are stored in this field.
            This field is None if the host could not be contacted successfully.
        """
        self.status = status
        self.impact = impact
        VapiStruct.__init__(self)


HostImpactInfo._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.host_impact_info', {
        'status': type.ReferenceType(__name__, 'HostStatus'),
        'impact': type.OptionalType(type.ReferenceType(__name__, 'HostImpactResult')),
    },
    HostImpactInfo,
    False,
    None))



class ImpactResult(VapiStruct):
    """
    The ``ImpactResult`` class contains attributes that describe the impact of
    applying the desired document to a group of hosts.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 impact=None,
                ):
        """
        :type  impact: :class:`dict` of :class:`str` and :class:`HostImpactInfo`
        :param impact: Map of host IDs to their impact results.
            When clients pass a value of this class as a parameter, the key in
            the attribute :class:`dict` must be an identifier for the resource
            type: ``HostSystem``. When methods return a value of this class as
            a return value, the key in the attribute :class:`dict` will be an
            identifier for the resource type: ``HostSystem``.
        """
        self.impact = impact
        VapiStruct.__init__(self)


ImpactResult._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.impact_result', {
        'impact': type.MapType(type.IdType(), type.ReferenceType(__name__, 'HostImpactInfo')),
    },
    ImpactResult,
    False,
    None))




class StubFactory(StubFactoryBase):
    _attrs = {
    }

