/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.util.ReuseFactory;

public final class FormatableBitSet
implements Formatable,
Cloneable {
    private byte[] value;
    private byte bitsInLastByte;
    private transient int lengthAsBits;

    private final void checkPosition(int n) {
        if (n < 0 || this.lengthAsBits <= n) {
            throw new IllegalArgumentException("Bit position " + n + " is outside the legal range");
        }
    }

    private static int udiv8(int n) {
        return n >> 3;
    }

    private static byte umod8(int n) {
        return (byte)(n & 7);
    }

    private static int umul8(int n) {
        return n << 3;
    }

    public FormatableBitSet() {
        this.value = ReuseFactory.getZeroLenByteArray();
    }

    public FormatableBitSet(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Bit set size " + n + " is not allowed");
        }
        this.initializeBits(n);
    }

    private void initializeBits(int n) {
        int n2 = FormatableBitSet.numBytesFromBits(n);
        this.value = new byte[n2];
        this.bitsInLastByte = FormatableBitSet.numBitsInLastByte(n);
        this.lengthAsBits = n;
    }

    public FormatableBitSet(byte[] byArray) {
        this.value = byArray;
        this.bitsInLastByte = (byte)8;
        this.lengthAsBits = this.calculateLength(byArray.length);
    }

    public FormatableBitSet(FormatableBitSet formatableBitSet) {
        this.bitsInLastByte = formatableBitSet.bitsInLastByte;
        this.lengthAsBits = formatableBitSet.lengthAsBits;
        int n = FormatableBitSet.numBytesFromBits(formatableBitSet.lengthAsBits);
        this.value = new byte[n];
        if (n > 0) {
            System.arraycopy(formatableBitSet.value, 0, this.value, 0, n);
        }
    }

    public Object clone() {
        return new FormatableBitSet(this);
    }

    public boolean invariantHolds() {
        int n = this.value.length * 8;
        if (this.lengthAsBits > n) {
            return false;
        }
        int n2 = (this.lengthAsBits - 1) / 8;
        if (this.bitsInLastByte != this.lengthAsBits - 8 * n2) {
            return false;
        }
        if (this.value.length == 0) {
            return true;
        }
        byte by = this.value[n2];
        by = (byte)(by << this.bitsInLastByte);
        for (int i = n2 + 1; i < this.value.length; ++i) {
            by = (byte)(by | this.value[i]);
        }
        return by == 0;
    }

    public int getLengthInBytes() {
        return FormatableBitSet.numBytesFromBits(this.lengthAsBits);
    }

    public int getLength() {
        return this.lengthAsBits;
    }

    private int calculateLength(int n) {
        if (n == 0) {
            return 0;
        }
        return (n - 1) * 8 + this.bitsInLastByte;
    }

    public int size() {
        return this.getLength();
    }

    public byte[] getByteArray() {
        int n = this.getLengthInBytes();
        if (this.value.length != n) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.value, 0, byArray, 0, n);
            this.value = byArray;
        }
        return this.value;
    }

    public void grow(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Bit set cannot grow from " + this.lengthAsBits + " to " + n + " bits");
        }
        if (n <= this.lengthAsBits) {
            return;
        }
        int n2 = FormatableBitSet.numBytesFromBits(n);
        if (n2 > this.value.length) {
            byte[] byArray = new byte[n2];
            int n3 = this.getLengthInBytes();
            System.arraycopy(this.value, 0, byArray, 0, n3);
            this.value = byArray;
        }
        this.bitsInLastByte = FormatableBitSet.numBitsInLastByte(n);
        this.lengthAsBits = n;
    }

    public void shrink(int n) {
        if (n < 0 || n > this.lengthAsBits) {
            throw new IllegalArgumentException("Bit set cannot shrink from " + this.lengthAsBits + " to " + n + " bits");
        }
        int n2 = FormatableBitSet.numBytesFromBits(n);
        this.bitsInLastByte = FormatableBitSet.numBitsInLastByte(n);
        this.lengthAsBits = n;
        for (int i = n2; i < this.value.length; ++i) {
            this.value[i] = 0;
        }
        if (n2 > 0) {
            int n3 = n2 - 1;
            this.value[n3] = (byte)(this.value[n3] & 65280 >> this.bitsInLastByte);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof FormatableBitSet) {
            FormatableBitSet formatableBitSet = (FormatableBitSet)object;
            if (this.getLength() != formatableBitSet.getLength()) {
                return false;
            }
            return this.compare(formatableBitSet) == 0;
        }
        return false;
    }

    public int compare(FormatableBitSet formatableBitSet) {
        int n;
        byte[] byArray = formatableBitSet.value;
        int n2 = formatableBitSet.getLengthInBytes();
        int n3 = this.getLengthInBytes();
        int n4 = 0;
        for (n = 0; n4 < n2 && n < n3 && byArray[n4] == this.value[n]; ++n4, ++n) {
        }
        if (n4 == n2 && n == n3) {
            if (this.getLength() == formatableBitSet.getLength()) {
                return 0;
            }
            return formatableBitSet.getLength() < this.getLength() ? 1 : -1;
        }
        if (n4 == n2) {
            return 1;
        }
        if (n == n3) {
            return -1;
        }
        int n5 = byArray[n4];
        int n6 = this.value[n];
        return (n6 &= 0xFF) > (n5 &= 0xFF) ? 1 : -1;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        int n3 = this.getLengthInBytes();
        for (int i = 0; i < n3; ++i) {
            n ^= (this.value[i] & 0xFF) << n2;
            if (32 > (n2 += 8)) continue;
            n2 = 0;
        }
        return n;
    }

    public final boolean isSet(int n) {
        this.checkPosition(n);
        int n2 = FormatableBitSet.udiv8(n);
        byte by = FormatableBitSet.umod8(n);
        return (this.value[n2] & 128 >> by) != 0;
    }

    public final boolean get(int n) {
        return this.isSet(n);
    }

    public void set(int n) {
        this.checkPosition(n);
        int n2 = FormatableBitSet.udiv8(n);
        byte by = FormatableBitSet.umod8(n);
        int n3 = n2;
        this.value[n3] = (byte)(this.value[n3] | 128 >> by);
    }

    public void clear(int n) {
        this.checkPosition(n);
        int n2 = FormatableBitSet.udiv8(n);
        byte by = FormatableBitSet.umod8(n);
        int n3 = n2;
        this.value[n3] = (byte)(this.value[n3] & ~(128 >> by));
    }

    public void clear() {
        int n = this.getLengthInBytes();
        for (int i = 0; i < n; ++i) {
            this.value[i] = 0;
        }
    }

    private static int numBytesFromBits(int n) {
        return n + 7 >> 3;
    }

    private static byte numBitsInLastByte(int n) {
        if (n == 0) {
            return 0;
        }
        byte by = FormatableBitSet.umod8(n);
        return by != 0 ? by : (byte)8;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getLength() * 8 * 3);
        stringBuffer.append("{");
        boolean bl = true;
        for (int i = 0; i < this.getLength(); ++i) {
            if (!this.isSet(i)) continue;
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            stringBuffer.append(i);
        }
        stringBuffer.append("}");
        return new String(stringBuffer);
    }

    public static int maxBitsForSpace(int n) {
        return (n - 4) * 8;
    }

    private static byte firstSet(byte by) {
        if ((by & 0x80) != 0) {
            return 0;
        }
        if ((by & 0x40) != 0) {
            return 1;
        }
        if ((by & 0x20) != 0) {
            return 2;
        }
        if ((by & 0x10) != 0) {
            return 3;
        }
        if ((by & 8) != 0) {
            return 4;
        }
        if ((by & 4) != 0) {
            return 5;
        }
        if ((by & 2) != 0) {
            return 6;
        }
        return 7;
    }

    public int anySetBit() {
        int n = this.getLengthInBytes();
        for (int i = 0; i < n; ++i) {
            byte by = this.value[i];
            if (by == 0) continue;
            return FormatableBitSet.umul8(i) + FormatableBitSet.firstSet(by);
        }
        return -1;
    }

    public int anySetBit(int n) {
        if (++n >= this.lengthAsBits) {
            return -1;
        }
        int n2 = FormatableBitSet.udiv8(n);
        byte by = (byte)(this.value[n2] << FormatableBitSet.umod8(n));
        if (by != 0) {
            return n + FormatableBitSet.firstSet(by);
        }
        int n3 = this.getLengthInBytes();
        ++n2;
        while (n2 < n3) {
            by = this.value[n2];
            if (by != 0) {
                return FormatableBitSet.umul8(n2) + FormatableBitSet.firstSet(by);
            }
            ++n2;
        }
        return -1;
    }

    public void or(FormatableBitSet formatableBitSet) {
        if (formatableBitSet == null) {
            return;
        }
        int n = formatableBitSet.getLength();
        if (n > this.getLength()) {
            this.grow(n);
        }
        int n2 = formatableBitSet.getLengthInBytes();
        for (int i = 0; i < n2; ++i) {
            int n3 = i;
            this.value[n3] = (byte)(this.value[n3] | formatableBitSet.value[i]);
        }
    }

    public void and(FormatableBitSet formatableBitSet) {
        int n;
        if (formatableBitSet == null) {
            this.clear();
            return;
        }
        int n2 = formatableBitSet.getLength();
        if (n2 > this.getLength()) {
            this.grow(n2);
        }
        int n3 = formatableBitSet.getLengthInBytes();
        for (n = 0; n < n3; ++n) {
            int n4 = n;
            this.value[n4] = (byte)(this.value[n4] & formatableBitSet.value[n]);
        }
        n3 = this.getLengthInBytes();
        while (n < n3) {
            this.value[n] = 0;
            ++n;
        }
    }

    public void xor(FormatableBitSet formatableBitSet) {
        if (formatableBitSet == null) {
            return;
        }
        int n = formatableBitSet.getLength();
        if (n > this.getLength()) {
            this.grow(n);
        }
        int n2 = formatableBitSet.getLengthInBytes();
        for (int i = 0; i < n2; ++i) {
            int n3 = i;
            this.value[n3] = (byte)(this.value[n3] ^ formatableBitSet.value[i]);
        }
    }

    public int getNumBitsSet() {
        int n = 0;
        int n2 = this.getLengthInBytes();
        for (int i = 0; i < n2; ++i) {
            byte by = this.value[i];
            by = (byte)(by - (by >> 1 & 0x55));
            by = (byte)((by & 0x33) + (by >> 2 & 0x33));
            by = (byte)((by & 7) + (by >> 4));
            n += by;
        }
        return n;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.getLength());
        int n = this.getLengthInBytes();
        if (n > 0) {
            objectOutput.write(this.value, 0, n);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        int n2 = FormatableBitSet.numBytesFromBits(n);
        this.value = new byte[n2];
        objectInput.readFully(this.value);
        this.bitsInLastByte = FormatableBitSet.numBitsInLastByte(n);
        this.lengthAsBits = n;
    }

    public int getTypeFormatId() {
        return 269;
    }
}

