/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import java.sql.SQLException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.traccar.Context;
import org.traccar.api.ExtendedObjectResource;
import org.traccar.handler.ComputedAttributesHandler;
import org.traccar.model.Attribute;
import org.traccar.model.Position;

@Path(value="attributes/computed")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class AttributeResource
extends ExtendedObjectResource<Attribute> {
    public AttributeResource() {
        super(Attribute.class);
    }

    @POST
    @Path(value="test")
    public Response test(@QueryParam(value="deviceId") long deviceId, Attribute entity) {
        Context.getPermissionsManager().checkAdmin(this.getUserId());
        Context.getPermissionsManager().checkDevice(this.getUserId(), deviceId);
        Position last = Context.getIdentityManager().getLastPosition(deviceId);
        if (last != null) {
            Object result = new ComputedAttributesHandler(Context.getConfig(), Context.getIdentityManager(), Context.getAttributesManager()).computeAttribute(entity, last);
            if (result != null) {
                switch (entity.getType()) {
                    case "number": {
                        Number numberValue = (Number)result;
                        return Response.ok((Object)numberValue).build();
                    }
                    case "boolean": {
                        Boolean booleanValue = (Boolean)result;
                        return Response.ok((Object)booleanValue).build();
                    }
                }
                return Response.ok((Object)result.toString()).build();
            }
            return Response.noContent().build();
        }
        throw new IllegalArgumentException("Device has no last position");
    }

    @Override
    @POST
    public Response add(Attribute entity) throws SQLException {
        Context.getPermissionsManager().checkAdmin(this.getUserId());
        return super.add(entity);
    }

    @Override
    @Path(value="{id}")
    @PUT
    public Response update(Attribute entity) throws SQLException {
        Context.getPermissionsManager().checkAdmin(this.getUserId());
        return super.update(entity);
    }

    @Override
    @Path(value="{id}")
    @DELETE
    public Response remove(@PathParam(value="id") long id) throws SQLException {
        Context.getPermissionsManager().checkAdmin(this.getUserId());
        return super.remove(id);
    }
}

