/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.intl.chardet;

import org.mozilla.intl.chardet.Big5Statistics;
import org.mozilla.intl.chardet.EUCJPStatistics;
import org.mozilla.intl.chardet.EUCKRStatistics;
import org.mozilla.intl.chardet.EUCTWStatistics;
import org.mozilla.intl.chardet.GB2312Statistics;
import org.mozilla.intl.chardet.nsBIG5Verifier;
import org.mozilla.intl.chardet.nsCP1252Verifier;
import org.mozilla.intl.chardet.nsEUCJPVerifier;
import org.mozilla.intl.chardet.nsEUCKRVerifier;
import org.mozilla.intl.chardet.nsEUCSampler;
import org.mozilla.intl.chardet.nsEUCStatistics;
import org.mozilla.intl.chardet.nsEUCTWVerifier;
import org.mozilla.intl.chardet.nsGB18030Verifier;
import org.mozilla.intl.chardet.nsGB2312Verifier;
import org.mozilla.intl.chardet.nsHZVerifier;
import org.mozilla.intl.chardet.nsISO2022CNVerifier;
import org.mozilla.intl.chardet.nsISO2022JPVerifier;
import org.mozilla.intl.chardet.nsISO2022KRVerifier;
import org.mozilla.intl.chardet.nsSJISVerifier;
import org.mozilla.intl.chardet.nsUCS2BEVerifier;
import org.mozilla.intl.chardet.nsUCS2LEVerifier;
import org.mozilla.intl.chardet.nsUTF8Verifier;
import org.mozilla.intl.chardet.nsVerifier;

public abstract class nsPSMDetector {
    public static final int ALL = 0;
    public static final int JAPANESE = 1;
    public static final int CHINESE = 2;
    public static final int SIMPLIFIED_CHINESE = 3;
    public static final int TRADITIONAL_CHINESE = 4;
    public static final int KOREAN = 5;
    public static final int NO_OF_LANGUAGES = 6;
    public static final int MAX_VERIFIERS = 16;
    nsVerifier[] mVerifier;
    nsEUCStatistics[] mStatisticsData;
    nsEUCSampler mSampler = new nsEUCSampler();
    byte[] mState = new byte[16];
    int[] mItemIdx = new int[16];
    int mItems;
    int mClassItems;
    boolean mDone;
    boolean mRunSampler;
    boolean mClassRunSampler;

    public nsPSMDetector() {
        this.initVerifiers(0);
        this.Reset();
    }

    public nsPSMDetector(int n) {
        this.initVerifiers(n);
        this.Reset();
    }

    public nsPSMDetector(int n, nsVerifier[] nsVerifierArray, nsEUCStatistics[] nsEUCStatisticsArray) {
        this.mClassRunSampler = nsEUCStatisticsArray != null;
        this.mStatisticsData = nsEUCStatisticsArray;
        this.mVerifier = nsVerifierArray;
        this.mClassItems = n;
        this.Reset();
    }

    public void Reset() {
        this.mRunSampler = this.mClassRunSampler;
        this.mDone = false;
        this.mItems = this.mClassItems;
        int n = 0;
        while (n < this.mItems) {
            this.mState[n] = 0;
            this.mItemIdx[n] = n;
            ++n;
        }
        this.mSampler.Reset();
    }

    protected void initVerifiers(int n) {
        boolean bl = false;
        int n2 = n >= 0 && n < 6 ? n : 0;
        this.mVerifier = null;
        this.mStatisticsData = null;
        if (n2 == 4) {
            this.mVerifier = new nsVerifier[]{new nsUTF8Verifier(), new nsBIG5Verifier(), new nsISO2022CNVerifier(), new nsEUCTWVerifier(), new nsCP1252Verifier(), new nsUCS2BEVerifier(), new nsUCS2LEVerifier()};
            this.mStatisticsData = new nsEUCStatistics[]{null, new Big5Statistics(), null, new EUCTWStatistics(), null, null, null};
        } else if (n2 == 5) {
            this.mVerifier = new nsVerifier[]{new nsUTF8Verifier(), new nsEUCKRVerifier(), new nsISO2022KRVerifier(), new nsCP1252Verifier(), new nsUCS2BEVerifier(), new nsUCS2LEVerifier()};
        } else if (n2 == 3) {
            this.mVerifier = new nsVerifier[]{new nsUTF8Verifier(), new nsGB2312Verifier(), new nsGB18030Verifier(), new nsISO2022CNVerifier(), new nsHZVerifier(), new nsCP1252Verifier(), new nsUCS2BEVerifier(), new nsUCS2LEVerifier()};
        } else if (n2 == 1) {
            this.mVerifier = new nsVerifier[]{new nsUTF8Verifier(), new nsSJISVerifier(), new nsEUCJPVerifier(), new nsISO2022JPVerifier(), new nsCP1252Verifier(), new nsUCS2BEVerifier(), new nsUCS2LEVerifier()};
        } else if (n2 == 2) {
            this.mVerifier = new nsVerifier[]{new nsUTF8Verifier(), new nsGB2312Verifier(), new nsGB18030Verifier(), new nsBIG5Verifier(), new nsISO2022CNVerifier(), new nsHZVerifier(), new nsEUCTWVerifier(), new nsCP1252Verifier(), new nsUCS2BEVerifier(), new nsUCS2LEVerifier()};
            this.mStatisticsData = new nsEUCStatistics[]{null, new GB2312Statistics(), null, new Big5Statistics(), null, null, new EUCTWStatistics(), null, null, null};
        } else if (n2 == 0) {
            this.mVerifier = new nsVerifier[]{new nsUTF8Verifier(), new nsSJISVerifier(), new nsEUCJPVerifier(), new nsISO2022JPVerifier(), new nsEUCKRVerifier(), new nsISO2022KRVerifier(), new nsBIG5Verifier(), new nsEUCTWVerifier(), new nsGB2312Verifier(), new nsGB18030Verifier(), new nsISO2022CNVerifier(), new nsHZVerifier(), new nsCP1252Verifier(), new nsUCS2BEVerifier(), new nsUCS2LEVerifier()};
            this.mStatisticsData = new nsEUCStatistics[]{null, null, new EUCJPStatistics(), null, new EUCKRStatistics(), null, new Big5Statistics(), new EUCTWStatistics(), new GB2312Statistics(), null, null, null, null, null, null};
        }
        this.mClassRunSampler = this.mStatisticsData != null;
        this.mClassItems = this.mVerifier.length;
    }

    public abstract void Report(String var1);

    public boolean HandleData(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray[n2];
            int n3 = 0;
            while (n3 < this.mItems) {
                byte by2 = nsVerifier.getNextState(this.mVerifier[this.mItemIdx[n3]], by, this.mState[n3]);
                if (by2 == 2) {
                    this.Report(this.mVerifier[this.mItemIdx[n3]].charset());
                    this.mDone = true;
                    return this.mDone;
                }
                if (by2 == 1) {
                    --this.mItems;
                    if (n3 >= this.mItems) continue;
                    this.mItemIdx[n3] = this.mItemIdx[this.mItems];
                    this.mState[n3] = this.mState[this.mItems];
                    continue;
                }
                this.mState[n3++] = by2;
            }
            if (this.mItems <= 1) {
                if (1 == this.mItems) {
                    this.Report(this.mVerifier[this.mItemIdx[0]].charset());
                }
                this.mDone = true;
                return this.mDone;
            }
            int n4 = 0;
            int n5 = 0;
            n3 = 0;
            while (n3 < this.mItems) {
                if (!this.mVerifier[this.mItemIdx[n3]].isUCS2() && !this.mVerifier[this.mItemIdx[n3]].isUCS2()) {
                    ++n4;
                    n5 = n3;
                }
                ++n3;
            }
            if (1 == n4) {
                this.Report(this.mVerifier[this.mItemIdx[n5]].charset());
                this.mDone = true;
                return this.mDone;
            }
            ++n2;
        }
        if (this.mRunSampler) {
            this.Sample(byArray, n);
        }
        return this.mDone;
    }

    public void DataEnd() {
        if (this.mDone) {
            return;
        }
        if (this.mItems == 2) {
            if (this.mVerifier[this.mItemIdx[0]].charset().equals("GB18030")) {
                this.Report(this.mVerifier[this.mItemIdx[1]].charset());
                this.mDone = true;
            } else if (this.mVerifier[this.mItemIdx[1]].charset().equals("GB18030")) {
                this.Report(this.mVerifier[this.mItemIdx[0]].charset());
                this.mDone = true;
            }
        }
        if (this.mRunSampler) {
            this.Sample(null, 0, true);
        }
    }

    public void Sample(byte[] byArray, int n) {
        this.Sample(byArray, n, false);
    }

    public void Sample(byte[] byArray, int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.mItems) {
            if (null != this.mStatisticsData[this.mItemIdx[n4]]) {
                ++n3;
            }
            if (!this.mVerifier[this.mItemIdx[n4]].isUCS2() && !this.mVerifier[this.mItemIdx[n4]].charset().equals("GB18030")) {
                ++n2;
            }
            ++n4;
        }
        boolean bl2 = this.mRunSampler = n3 > 1;
        if (this.mRunSampler) {
            this.mRunSampler = this.mSampler.Sample(byArray, n);
            if ((bl && this.mSampler.GetSomeData() || this.mSampler.EnoughData()) && n3 == n2) {
                this.mSampler.CalFreq();
                int n5 = -1;
                int n6 = 0;
                float f = 0.0f;
                n4 = 0;
                while (n4 < this.mItems) {
                    if (null != this.mStatisticsData[this.mItemIdx[n4]] && !this.mVerifier[this.mItemIdx[n4]].charset().equals("Big5")) {
                        float f2 = this.mSampler.GetScore(this.mStatisticsData[this.mItemIdx[n4]].mFirstByteFreq(), this.mStatisticsData[this.mItemIdx[n4]].mFirstByteWeight(), this.mStatisticsData[this.mItemIdx[n4]].mSecondByteFreq(), this.mStatisticsData[this.mItemIdx[n4]].mSecondByteWeight());
                        if (0 == n6++ || f > f2) {
                            f = f2;
                            n5 = n4;
                        }
                    }
                    ++n4;
                }
                if (n5 >= 0) {
                    this.Report(this.mVerifier[this.mItemIdx[n5]].charset());
                    this.mDone = true;
                }
            }
        }
    }

    public String[] getProbableCharsets() {
        if (this.mItems <= 0) {
            String[] stringArray = new String[]{"nomatch"};
            return stringArray;
        }
        String[] stringArray = new String[this.mItems];
        int n = 0;
        while (n < this.mItems) {
            stringArray[n] = this.mVerifier[this.mItemIdx[n]].charset();
            ++n;
        }
        return stringArray;
    }
}

