/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.AttrNSImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.NamedNodeMapImpl;
import org.apache.xerces.dom.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class AttributeMap
extends NamedNodeMapImpl {
    protected AttributeMap(ElementImpl elementImpl, NamedNodeMapImpl namedNodeMapImpl) {
        super(elementImpl);
        if (namedNodeMapImpl != null) {
            this.cloneContent(namedNodeMapImpl);
            if (this.nodes != null) {
                this.hasDefaults(true);
            }
        }
    }

    protected void cloneContent(NamedNodeMapImpl namedNodeMapImpl) {
        if (namedNodeMapImpl.nodes != null) {
            if (this.nodes == null) {
                this.nodes = new Vector(namedNodeMapImpl.nodes.size());
            } else {
                this.nodes.setSize(namedNodeMapImpl.nodes.size());
            }
            int n = 0;
            while (n < namedNodeMapImpl.nodes.size()) {
                NodeImpl nodeImpl = (NodeImpl)namedNodeMapImpl.nodes.elementAt(n);
                NodeImpl nodeImpl2 = (NodeImpl)nodeImpl.cloneNode(true);
                nodeImpl2.isSpecified(nodeImpl.isSpecified());
                this.nodes.insertElementAt(nodeImpl2, n);
                nodeImpl2.ownerNode = this.ownerNode;
                nodeImpl2.isOwned(true);
                ++n;
            }
        }
    }

    public NamedNodeMapImpl cloneMap(NodeImpl nodeImpl) {
        AttributeMap attributeMap = new AttributeMap((ElementImpl)nodeImpl, null);
        attributeMap.hasDefaults(this.hasDefaults());
        attributeMap.cloneContent(this);
        return attributeMap;
    }

    protected final Node internalRemoveNamedItem(String string, boolean bl) {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        int n = this.findNamePoint(string, 0);
        if (n < 0) {
            if (bl) {
                throw new DOMException(8, "DOM008 Not found");
            }
            return null;
        }
        AttrImpl attrImpl = (AttrImpl)this.nodes.elementAt(n);
        CoreDocumentImpl coreDocumentImpl = this.ownerNode.ownerDocument();
        if (this.hasDefaults()) {
            Node node;
            NamedNodeMapImpl namedNodeMapImpl = ((ElementImpl)this.ownerNode).getDefaultAttributes();
            if (namedNodeMapImpl != null && (node = namedNodeMapImpl.getNamedItem(string)) != null && this.findNamePoint(string, n + 1) < 0) {
                NodeImpl nodeImpl = (NodeImpl)node.cloneNode(true);
                nodeImpl.ownerNode = this.ownerNode;
                nodeImpl.isOwned(true);
                nodeImpl.isSpecified(false);
                this.nodes.setElementAt(nodeImpl, n);
            } else {
                this.nodes.removeElementAt(n);
            }
        } else {
            this.nodes.removeElementAt(n);
        }
        attrImpl.ownerNode = coreDocumentImpl;
        attrImpl.isOwned(false);
        attrImpl.isSpecified(true);
        coreDocumentImpl.removedAttrNode(attrImpl, this.ownerNode, string);
        return attrImpl;
    }

    protected final Node internalRemoveNamedItemNS(String string, String string2, boolean bl) {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        int n = this.findNamePoint(string, string2);
        if (n < 0) {
            if (bl) {
                throw new DOMException(8, "DOM008 Not found");
            }
            return null;
        }
        AttrImpl attrImpl = (AttrImpl)this.nodes.elementAt(n);
        CoreDocumentImpl coreDocumentImpl = this.ownerNode.ownerDocument();
        String string3 = attrImpl.getNodeName();
        if (this.hasDefaults()) {
            Node node;
            NamedNodeMapImpl namedNodeMapImpl = ((ElementImpl)this.ownerNode).getDefaultAttributes();
            if (namedNodeMapImpl != null && (node = namedNodeMapImpl.getNamedItem(string3)) != null) {
                int n2 = this.findNamePoint(string3, 0);
                if (n2 >= 0 && this.findNamePoint(string3, n2 + 1) < 0) {
                    NodeImpl nodeImpl = (NodeImpl)node.cloneNode(true);
                    nodeImpl.ownerNode = this.ownerNode;
                    if (nodeImpl instanceof AttrNSImpl) {
                        ((AttrNSImpl)nodeImpl).namespaceURI = string;
                    }
                    nodeImpl.isOwned(true);
                    nodeImpl.isSpecified(false);
                    this.nodes.setElementAt(nodeImpl, n);
                } else {
                    this.nodes.removeElementAt(n);
                }
            } else {
                this.nodes.removeElementAt(n);
            }
        } else {
            this.nodes.removeElementAt(n);
        }
        attrImpl.ownerNode = coreDocumentImpl;
        attrImpl.isOwned(false);
        attrImpl.isSpecified(true);
        coreDocumentImpl.removedAttrNode(attrImpl, this.ownerNode, string2);
        return attrImpl;
    }

    protected void reconcileDefaults(NamedNodeMapImpl namedNodeMapImpl) {
        int n = this.nodes != null ? this.nodes.size() : 0;
        int n2 = n - 1;
        while (n2 >= 0) {
            AttrImpl attrImpl = (AttrImpl)this.nodes.elementAt(n2);
            if (!attrImpl.isSpecified()) {
                attrImpl.ownerNode = this.ownerNode.ownerDocument();
                attrImpl.isOwned(false);
                attrImpl.isSpecified(true);
                this.nodes.removeElementAt(n2);
            }
            --n2;
        }
        if (namedNodeMapImpl == null) {
            return;
        }
        if (this.nodes == null || this.nodes.size() == 0) {
            this.cloneContent(namedNodeMapImpl);
        } else {
            int n3 = namedNodeMapImpl.nodes.size();
            int n4 = 0;
            while (n4 < n3) {
                AttrImpl attrImpl = (AttrImpl)namedNodeMapImpl.nodes.elementAt(n4);
                int n5 = this.findNamePoint(attrImpl.getNodeName(), 0);
                if (n5 < 0) {
                    NodeImpl nodeImpl = (NodeImpl)attrImpl.cloneNode(true);
                    nodeImpl.ownerNode = this.ownerNode;
                    nodeImpl.isOwned(true);
                    nodeImpl.isSpecified(false);
                    this.nodes.setElementAt(nodeImpl, n5);
                }
                ++n4;
            }
        }
    }

    public Node removeNamedItem(String string) throws DOMException {
        return this.internalRemoveNamedItem(string, true);
    }

    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        return this.internalRemoveNamedItemNS(string, string2, true);
    }

    Node safeRemoveNamedItem(String string) {
        return this.internalRemoveNamedItem(string, false);
    }

    Node safeRemoveNamedItemNS(String string, String string2) {
        return this.internalRemoveNamedItemNS(string, string2, false);
    }

    public Node setNamedItem(Node node) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        if (node.getOwnerDocument() != this.ownerNode.ownerDocument()) {
            throw new DOMException(4, "DOM005 Wrong document");
        }
        if (node.getNodeType() != 2) {
            throw new DOMException(3, "DOM006 Hierarchy request error");
        }
        AttrImpl attrImpl = (AttrImpl)node;
        if (attrImpl.isOwned()) {
            throw new DOMException(10, "DOM009 Attribute already in use");
        }
        attrImpl.ownerNode = this.ownerNode;
        attrImpl.isOwned(true);
        int n = this.findNamePoint(node.getNodeName(), 0);
        AttrImpl attrImpl2 = null;
        if (n >= 0) {
            attrImpl2 = (AttrImpl)this.nodes.elementAt(n);
            this.nodes.setElementAt(node, n);
            attrImpl2.ownerNode = this.ownerNode.ownerDocument();
            attrImpl2.isOwned(false);
            attrImpl2.isSpecified(true);
        } else {
            n = -1 - n;
            if (this.nodes == null) {
                this.nodes = new Vector(5, 10);
            }
            this.nodes.insertElementAt(node, n);
        }
        this.ownerNode.ownerDocument().setAttrNode(attrImpl, attrImpl2);
        if (!attrImpl.isNormalized()) {
            this.ownerNode.isNormalized(false);
        }
        return attrImpl2;
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        if (node.getOwnerDocument() != this.ownerNode.ownerDocument()) {
            throw new DOMException(4, "DOM005 Wrong document");
        }
        if (node.getNodeType() != 2) {
            throw new DOMException(3, "DOM006 Hierarchy request error");
        }
        AttrImpl attrImpl = (AttrImpl)node;
        if (attrImpl.isOwned()) {
            throw new DOMException(10, "DOM009 Attribute already in use");
        }
        attrImpl.ownerNode = this.ownerNode;
        attrImpl.isOwned(true);
        int n = this.findNamePoint(attrImpl.getNamespaceURI(), attrImpl.getLocalName());
        AttrImpl attrImpl2 = null;
        if (n >= 0) {
            attrImpl2 = (AttrImpl)this.nodes.elementAt(n);
            this.nodes.setElementAt(node, n);
            attrImpl2.ownerNode = this.ownerNode.ownerDocument();
            attrImpl2.isOwned(false);
            attrImpl2.isSpecified(true);
        } else {
            n = this.findNamePoint(node.getNodeName(), 0);
            if (n >= 0) {
                attrImpl2 = (AttrImpl)this.nodes.elementAt(n);
                this.nodes.insertElementAt(node, n);
            } else {
                n = -1 - n;
                if (this.nodes == null) {
                    this.nodes = new Vector(5, 10);
                }
                this.nodes.insertElementAt(node, n);
            }
        }
        this.ownerNode.ownerDocument().setAttrNode(attrImpl, attrImpl2);
        if (!attrImpl.isNormalized()) {
            this.ownerNode.isNormalized(false);
        }
        return attrImpl2;
    }
}

