/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.Hash;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

public class Banlist {
    private final Log _log;
    private final RouterContext _context;
    private final Map<Hash, Entry> _entries;
    public static final long BANLIST_DURATION_MS = 420000L;
    public static final long BANLIST_DURATION_MAX = 1800000L;
    public static final long BANLIST_DURATION_PARTIAL = 600000L;
    public static final long BANLIST_DURATION_FOREVER = 15638400000L;
    public static final long BANLIST_CLEANER_START_DELAY = 600000L;

    public Banlist(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(Banlist.class);
        this._entries = new ConcurrentHashMap<Hash, Entry>(16);
        this._context.jobQueue().addJob(new Cleanup(this._context));
        this.banlistRouterForever(Hash.FAKE_HASH, "Invalid Hash");
    }

    public int getRouterCount() {
        return this._entries.size();
    }

    public Map<Hash, Entry> getEntries() {
        return Collections.unmodifiableMap(this._entries);
    }

    public boolean banlistRouter(Hash peer) {
        return this.banlistRouter(peer, null);
    }

    public boolean banlistRouter(Hash peer, String reason) {
        return this.banlistRouter(peer, reason, null);
    }

    public boolean banlistRouter(String reasonCode, Hash peer, String reason) {
        return this.banlistRouter(peer, reason, reasonCode, null, false);
    }

    public boolean banlistRouter(Hash peer, String reason, String transport) {
        return this.banlistRouter(peer, reason, transport, false);
    }

    public boolean banlistRouterForever(Hash peer, String reason) {
        return this.banlistRouter(peer, reason, null, true);
    }

    public boolean banlistRouterForever(Hash peer, String reason, String reasonCode) {
        return this.banlistRouter(peer, reason, reasonCode, null, true);
    }

    public boolean banlistRouter(Hash peer, String reason, String transport, boolean forever) {
        return this.banlistRouter(peer, reason, null, transport, forever);
    }

    private boolean banlistRouter(Hash peer, String reason, String reasonCode, String transport, boolean forever) {
        long expireOn;
        if (forever) {
            expireOn = this._context.clock().now() + 15638400000L;
        } else if (transport != null) {
            expireOn = this._context.clock().now() + 600000L;
        } else {
            long period = 420000L + this._context.random().nextLong(105000L);
            if (period > 1800000L) {
                period = 1800000L;
            }
            expireOn = this._context.clock().now() + period;
        }
        return this.banlistRouter(peer, reason, reasonCode, transport, expireOn);
    }

    public boolean banlistRouter(Hash peer, String reason, String reasonCode, String transport, long expireOn) {
        Entry old;
        if (peer == null) {
            this._log.error("ban null?", new Exception());
            return false;
        }
        if (peer.equals(this._context.routerHash())) {
            if (this._log.shouldWarn()) {
                this._log.warn("not banning us", new Exception());
            }
            return false;
        }
        boolean wasAlready = false;
        if (this._log.shouldLog(20)) {
            this._log.info("Banlist " + peer.toBase64() + (transport != null ? " on transport " + transport : ""), new Exception("Banlist cause: " + reason));
        }
        Entry e = new Entry();
        e.expireOn = expireOn;
        e.cause = reason;
        e.causeCode = reasonCode;
        e.transports = null;
        if (transport != null) {
            e.transports = new ConcurrentHashSet<String>(2);
            e.transports.add(transport);
        }
        if ((old = this._entries.get(peer)) != null) {
            wasAlready = true;
            if (old.expireOn > e.expireOn) {
                e.expireOn = old.expireOn;
                e.cause = old.cause;
                e.causeCode = old.causeCode;
            }
            if (e.transports != null) {
                if (old.transports != null) {
                    e.transports.addAll(old.transports);
                } else {
                    e.transports = null;
                    e.cause = reason;
                    e.causeCode = reasonCode;
                }
            }
        }
        this._entries.put(peer, e);
        if (transport == null) {
            this._context.netDb().fail(peer);
            this._context.tunnelManager().fail(peer);
        }
        if (!wasAlready) {
            this._context.messageHistory().banlist(peer, reason);
        }
        return wasAlready;
    }

    public void unbanlistRouter(Hash peer) {
        this.unbanlistRouter(peer, true);
    }

    private void unbanlistRouter(Hash peer, boolean realUnbanlist) {
        this.unbanlistRouter(peer, realUnbanlist, null);
    }

    public void unbanlistRouter(Hash peer, String transport) {
        this.unbanlistRouter(peer, true, transport);
    }

    private void unbanlistRouter(Hash peer, boolean realUnbanlist, String transport) {
        if (peer == null) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("unbanlist " + peer.toBase64() + (transport != null ? "/" + transport : ""));
        }
        boolean fully = false;
        Entry e = this._entries.remove(peer);
        if (e == null || e.transports == null || transport == null || e.transports.size() <= 1) {
            fully = true;
        } else {
            e.transports.remove(transport);
            if (e.transports.isEmpty()) {
                fully = true;
            } else {
                this._entries.put(peer, e);
            }
        }
        if (fully) {
            this._context.messageHistory().unbanlist(peer);
            if (this._log.shouldLog(20) && e != null) {
                this._log.info("Unbanlisting router " + peer.toBase64() + (transport != null ? "/" + transport : ""));
            }
        }
    }

    public boolean isBanlisted(Hash peer) {
        return this.isBanlisted(peer, null);
    }

    public boolean isBanlisted(Hash peer, String transport) {
        boolean rv = false;
        boolean unbanlist = false;
        Entry entry = this._entries.get(peer);
        if (entry == null) {
            rv = false;
        } else if (entry.expireOn <= this._context.clock().now()) {
            this._entries.remove(peer);
            unbanlist = true;
            rv = false;
        } else {
            rv = entry.transports == null ? true : entry.transports.contains(transport);
        }
        if (unbanlist) {
            this._context.messageHistory().unbanlist(peer);
            if (this._log.shouldLog(20)) {
                this._log.info("Unbanlisting (expired) " + peer.toBase64());
            }
        }
        return rv;
    }

    public boolean isBanlistedForever(Hash peer) {
        Entry entry = this._entries.get(peer);
        return entry != null && entry.expireOn > this._context.clock().now() + 172800000L;
    }

    @Deprecated
    public void renderStatusHTML(Writer out) throws IOException {
    }

    private class Cleanup
    extends JobImpl {
        private List<Hash> _toUnbanlist;

        public Cleanup(RouterContext ctx) {
            super(ctx);
            this._toUnbanlist = new ArrayList<Hash>(4);
            this.getTiming().setStartAfter(ctx.clock().now() + 600000L);
        }

        @Override
        public String getName() {
            return "Expire banned peers";
        }

        @Override
        public void runJob() {
            this._toUnbanlist.clear();
            long now = this.getContext().clock().now();
            try {
                Iterator iter = Banlist.this._entries.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry e = iter.next();
                    if (((Entry)e.getValue()).expireOn > now) continue;
                    iter.remove();
                    this._toUnbanlist.add((Hash)e.getKey());
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            for (Hash peer : this._toUnbanlist) {
                Banlist.this._context.messageHistory().unbanlist(peer);
                if (!Banlist.this._log.shouldLog(20)) continue;
                Banlist.this._log.info("Unbanlisting router (expired) " + peer.toBase64());
            }
            this.requeue(30000L);
        }
    }

    public static class Entry {
        public long expireOn;
        public String cause;
        public String causeCode;
        public Set<String> transports;
    }
}

